/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.MappedRandomAccessFile;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class RandomAccessFileOrArray
implements DataInput {
    MappedRandomAccessFile rf;
    RandomAccessFile trf;
    boolean plainRandomAccess;
    String filename;
    byte[] arrayIn;
    int arrayInPtr;
    byte back;
    boolean isBack;
    private int startOffset;

    public RandomAccessFileOrArray(String string) throws IOException {
        this(string, false, Document.plainRandomAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessFileOrArray(String string, boolean bl, boolean bl2) throws IOException {
        block27: {
            this.isBack = false;
            this.startOffset = 0;
            this.plainRandomAccess = bl2;
            File file = new File(string);
            if (!file.canRead()) {
                if (string.startsWith("file:/") || string.startsWith("http://") || string.startsWith("https://") || string.startsWith("jar:")) {
                    InputStream inputStream = new URL(string).openStream();
                    try {
                        this.arrayIn = RandomAccessFileOrArray.InputStreamToArray(inputStream);
                        return;
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                InputStream inputStream = BaseFont.getResourceStream(string);
                if (inputStream == null) {
                    throw new IOException(string + " not found as file or resource.");
                }
                try {
                    this.arrayIn = RandomAccessFileOrArray.InputStreamToArray(inputStream);
                    return;
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (!bl) break block27;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                this.arrayIn = RandomAccessFileOrArray.InputStreamToArray(fileInputStream);
                Object var12_14 = null;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                try {
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (Exception exception) {}
            return;
        }
        this.filename = string;
        if (bl2) {
            this.trf = new RandomAccessFile(string, "r");
        } else {
            this.rf = new MappedRandomAccessFile(string, "r");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessFileOrArray(URL uRL) throws IOException {
        this.isBack = false;
        this.startOffset = 0;
        InputStream inputStream = uRL.openStream();
        try {
            this.arrayIn = RandomAccessFileOrArray.InputStreamToArray(inputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public RandomAccessFileOrArray(InputStream inputStream) throws IOException {
        this.isBack = false;
        this.startOffset = 0;
        this.arrayIn = RandomAccessFileOrArray.InputStreamToArray(inputStream);
    }

    public static byte[] InputStreamToArray(InputStream inputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n2 = inputStream.read(byArray)) >= 1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public RandomAccessFileOrArray(byte[] byArray) {
        this.isBack = false;
        this.startOffset = 0;
        this.arrayIn = byArray;
    }

    public RandomAccessFileOrArray(RandomAccessFileOrArray randomAccessFileOrArray) {
        this.isBack = false;
        this.startOffset = 0;
        this.filename = randomAccessFileOrArray.filename;
        this.arrayIn = randomAccessFileOrArray.arrayIn;
        this.startOffset = randomAccessFileOrArray.startOffset;
        this.plainRandomAccess = randomAccessFileOrArray.plainRandomAccess;
    }

    public void pushBack(byte by) {
        this.back = by;
        this.isBack = true;
    }

    public int read() throws IOException {
        if (this.isBack) {
            this.isBack = false;
            return this.back & 0xFF;
        }
        if (this.arrayIn == null) {
            return this.plainRandomAccess ? this.trf.read() : this.rf.read();
        }
        if (this.arrayInPtr >= this.arrayIn.length) {
            return -1;
        }
        return this.arrayIn[this.arrayInPtr++] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return 0;
        }
        int n4 = 0;
        if (this.isBack) {
            this.isBack = false;
            if (n3 == 1) {
                byArray[n2] = this.back;
                return 1;
            }
            n4 = 1;
            byArray[n2++] = this.back;
            --n3;
        }
        if (this.arrayIn == null) {
            return (this.plainRandomAccess ? this.trf.read(byArray, n2, n3) : this.rf.read(byArray, n2, n3)) + n4;
        }
        if (this.arrayInPtr >= this.arrayIn.length) {
            return -1;
        }
        if (this.arrayInPtr + n3 > this.arrayIn.length) {
            n3 = this.arrayIn.length - this.arrayInPtr;
        }
        System.arraycopy(this.arrayIn, this.arrayInPtr, byArray, n2, n3);
        this.arrayInPtr += n3;
        return n3 + n4;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = 0;
        do {
            if ((n4 = this.read(byArray, n2 + n5, n3 - n5)) >= 0) continue;
            throw new EOFException();
        } while ((n5 += n4) < n3);
    }

    public long skip(long l2) throws IOException {
        return this.skipBytes((int)l2);
    }

    public int skipBytes(int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        if (n2 <= 0) {
            return 0;
        }
        int n6 = 0;
        if (this.isBack) {
            this.isBack = false;
            if (n2 == 1) {
                return 1;
            }
            --n2;
            n6 = 1;
        }
        if ((n5 = (n4 = this.getFilePointer()) + n2) > (n3 = this.length())) {
            n5 = n3;
        }
        this.seek(n5);
        return n5 - n4 + n6;
    }

    public void reOpen() throws IOException {
        if (this.filename != null && this.rf == null && this.trf == null) {
            if (this.plainRandomAccess) {
                this.trf = new RandomAccessFile(this.filename, "r");
            } else {
                this.rf = new MappedRandomAccessFile(this.filename, "r");
            }
        }
        this.seek(0);
    }

    protected void insureOpen() throws IOException {
        if (this.filename != null && this.rf == null && this.trf == null) {
            this.reOpen();
        }
    }

    public boolean isOpen() {
        return this.filename == null || this.rf != null || this.trf != null;
    }

    public void close() throws IOException {
        this.isBack = false;
        if (this.rf != null) {
            this.rf.close();
            this.rf = null;
            this.plainRandomAccess = true;
        } else if (this.trf != null) {
            this.trf.close();
            this.trf = null;
        }
    }

    public int length() throws IOException {
        if (this.arrayIn == null) {
            this.insureOpen();
            return (int)(this.plainRandomAccess ? this.trf.length() : this.rf.length()) - this.startOffset;
        }
        return this.arrayIn.length - this.startOffset;
    }

    public void seek(int n2) throws IOException {
        n2 += this.startOffset;
        this.isBack = false;
        if (this.arrayIn == null) {
            this.insureOpen();
            if (this.plainRandomAccess) {
                this.trf.seek(n2);
            } else {
                this.rf.seek(n2);
            }
        } else {
            this.arrayInPtr = n2;
        }
    }

    public void seek(long l2) throws IOException {
        this.seek((int)l2);
    }

    public int getFilePointer() throws IOException {
        int n2;
        this.insureOpen();
        int n3 = n2 = this.isBack ? 1 : 0;
        if (this.arrayIn == null) {
            return (int)(this.plainRandomAccess ? this.trf.getFilePointer() : this.rf.getFilePointer()) - n2 - this.startOffset;
        }
        return this.arrayInPtr - n2 - this.startOffset;
    }

    public boolean readBoolean() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2 != 0;
    }

    public byte readByte() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (byte)n2;
    }

    public int readUnsignedByte() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    public short readShort() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n3 << 8) + n2);
    }

    public final short readShortLE() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n3 << 0));
    }

    public int readUnsignedShort() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (n3 << 8) + n2;
    }

    public final int readUnsignedShortLE() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n3 << 0);
    }

    public char readChar() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n3 << 8) + n2);
    }

    public final char readCharLE() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n3 << 0));
    }

    public int readInt() throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = this.read();
        if ((n5 | (n4 = this.read()) | (n3 = this.read()) | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (n5 << 24) + (n4 << 16) + (n3 << 8) + n2;
    }

    public final int readIntLE() throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = this.read();
        if ((n5 | (n4 = this.read()) | (n3 = this.read()) | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
    }

    public final long readUnsignedInt() throws IOException {
        long l2;
        long l3;
        long l4;
        long l5 = this.read();
        if ((l5 | (l4 = (long)this.read()) | (l3 = (long)this.read()) | (l2 = (long)this.read())) < 0L) {
            throw new EOFException();
        }
        return (l5 << 24) + (l4 << 16) + (l3 << 8) + (l2 << 0);
    }

    public final long readUnsignedIntLE() throws IOException {
        long l2;
        long l3;
        long l4;
        long l5 = this.read();
        if ((l5 | (l4 = (long)this.read()) | (l3 = (long)this.read()) | (l2 = (long)this.read())) < 0L) {
            throw new EOFException();
        }
        return (l2 << 24) + (l3 << 16) + (l4 << 8) + (l5 << 0);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final long readLongLE() throws IOException {
        int n2 = this.readIntLE();
        int n3 = this.readIntLE();
        return ((long)n3 << 32) + ((long)n2 & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final float readFloatLE() throws IOException {
        return Float.intBitsToFloat(this.readIntLE());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final double readDoubleLE() throws IOException {
        return Double.longBitsToDouble(this.readLongLE());
    }

    public String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = -1;
        boolean bl = false;
        block4: while (!bl) {
            n2 = this.read();
            switch (n2) {
                case -1: 
                case 10: {
                    bl = true;
                    continue block4;
                }
                case 13: {
                    bl = true;
                    int n3 = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(n3);
                    continue block4;
                }
            }
            stringBuffer.append((char)n2);
        }
        if (n2 == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int n2) {
        this.startOffset = n2;
    }

    public ByteBuffer getNioByteBuffer() throws IOException {
        if (this.filename != null) {
            FileChannel fileChannel = this.plainRandomAccess ? this.trf.getChannel() : this.rf.getChannel();
            return fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
        }
        return ByteBuffer.wrap(this.arrayIn);
    }
}

