/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRBaseScriptlet
implements JRScriptlet,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_DESCRIPTION = "description";
    protected String name;
    protected String description;
    protected String valueClassName = String.class.getName();
    protected String valueClassRealName;
    protected transient Class<?> valueClass;
    protected JRPropertiesMap propertiesMap;
    private transient JRPropertyChangeSupport eventSupport;

    protected JRBaseScriptlet() {
        this.propertiesMap = new JRPropertiesMap();
    }

    protected JRBaseScriptlet(JRScriptlet scriptlet, JRBaseObjectFactory factory) {
        factory.put(scriptlet, this);
        this.name = scriptlet.getName();
        this.description = scriptlet.getDescription();
        this.valueClassName = scriptlet.getValueClassName();
        this.propertiesMap = scriptlet.getPropertiesMap().cloneProperties();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        String old = this.description;
        this.description = description;
        this.getEventSupport().firePropertyChange(PROPERTY_DESCRIPTION, old, this.description);
    }

    @Override
    public Class<?> getValueClass() {
        String className;
        if (this.valueClass == null && (className = this.getValueClassRealName()) != null) {
            try {
                this.valueClass = JRClassLoader.loadClassForName(className);
            }
            catch (ClassNotFoundException e2) {
                throw new JRRuntimeException(e2);
            }
        }
        return this.valueClass;
    }

    @Override
    public String getValueClassName() {
        return this.valueClassName;
    }

    private String getValueClassRealName() {
        if (this.valueClassRealName == null) {
            this.valueClassRealName = JRClassLoader.getClassRealName(this.valueClassName);
        }
        return this.valueClassRealName;
    }

    @Override
    public boolean hasProperties() {
        return this.propertiesMap != null && this.propertiesMap.hasProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        return this.propertiesMap;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    @Override
    public Object clone() {
        JRBaseScriptlet clone = null;
        try {
            clone = (JRBaseScriptlet)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new JRRuntimeException(e2);
        }
        if (this.propertiesMap != null) {
            clone.propertiesMap = (JRPropertiesMap)this.propertiesMap.clone();
        }
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseScriptlet jRBaseScriptlet = this;
        synchronized (jRBaseScriptlet) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

