/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.base.JRBaseCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.fill.JRCrosstabExpressionEvaluator;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabCell;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabGroup;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabMeasure;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabObjectFactory;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabParameter;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketDefinition;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingService;
import net.sf.jasperreports.crosstabs.fill.calculation.CrosstabCell;
import net.sf.jasperreports.crosstabs.fill.calculation.HeaderCell;
import net.sf.jasperreports.crosstabs.fill.calculation.MeasureDefinition;
import net.sf.jasperreports.crosstabs.type.CrosstabColumnPositionEnum;
import net.sf.jasperreports.crosstabs.type.CrosstabPercentageEnum;
import net.sf.jasperreports.crosstabs.type.CrosstabRowPositionEnum;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillCellContents;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JROriginProvider;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.fill.JRYXComparator;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import org.jfree.data.general.Dataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRFillCrosstab
extends JRFillElement
implements JRCrosstab,
JROriginProvider {
    protected final JRCrosstab parentCrosstab;
    protected JRFillCrosstabDataset dataset;
    protected JRFillCrosstabRowGroup[] rowGroups;
    protected Map<String, Integer> rowGroupsMap;
    protected JRFillCrosstabColumnGroup[] columnGroups;
    protected Map<String, Integer> columnGroupsMap;
    protected JRFillCrosstabMeasure[] measures;
    protected BucketingService bucketingService;
    protected JRFillVariable[] variables;
    protected Map<String, JRFillVariable> variablesMap;
    protected JRFillVariable[][][] totalVariables;
    protected boolean[][] retrieveTotal;
    protected JRFillCrosstabParameter[] parameters;
    protected Map<String, JRFillParameter> parametersMap;
    protected boolean ignoreWidth;
    protected JRCrosstabExpressionEvaluator crosstabEvaluator;
    protected JRFillCrosstabCell[][] crossCells;
    protected JRFillCellContents headerCell;
    protected JRFillCellContents whenNoDataCell;
    protected boolean hasData;
    protected HeaderCell[][] columnHeadersData;
    protected HeaderCell[][] rowHeadersData;
    protected CrosstabCell[][] cellData;
    protected MeasureDefinition.MeasureValue[] grandTotals;
    private boolean percentage;
    private CrosstabFiller crosstabFiller;
    private int overflowStartPage;
    private List<JRTemplatePrintFrame> printFrames;

    public JRFillCrosstab(JRBaseFiller filler, JRCrosstab crosstab, JRFillObjectFactory factory) {
        super(filler, crosstab, factory);
        this.parentCrosstab = crosstab;
        this.loadEvaluator(filler.getJasperReport());
        JRFillCrosstabObjectFactory crosstabFactory = new JRFillCrosstabObjectFactory(factory, (JRFillExpressionEvaluator)this.crosstabEvaluator);
        crosstabFactory.setParentOriginProvider(this);
        this.headerCell = crosstabFactory.getCell(crosstab.getHeaderCell(), "CrosstabHeader");
        this.copyRowGroups(crosstab, crosstabFactory);
        this.copyColumnGroups(crosstab, crosstabFactory);
        this.copyMeasures(crosstab, crosstabFactory);
        this.copyCells(crosstab, crosstabFactory);
        this.whenNoDataCell = crosstabFactory.getCell(crosstab.getWhenNoDataCell(), "NoDataCell");
        this.dataset = factory.getCrosstabDataset(crosstab.getDataset(), this);
        this.crosstabEvaluator.setFillDataset(this.dataset.getFillDataset());
        this.copyParameters(crosstab, factory);
        this.copyVariables(crosstab, crosstabFactory);
        this.crosstabFiller = new CrosstabFiller();
    }

    private boolean isIgnoreWidth(JRBaseFiller filler, JRCrosstab crosstab) {
        Boolean crosstabIgnoreWidth = crosstab.getIgnoreWidth();
        if (crosstabIgnoreWidth != null) {
            return crosstabIgnoreWidth;
        }
        String reportProperty = filler.jasperReport.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.ignore.width");
        if (reportProperty != null) {
            return JRProperties.asBoolean(reportProperty);
        }
        Boolean ignorePaginationParam = (Boolean)filler.getMasterFiller().getParameterValue("IS_IGNORE_PAGINATION");
        if (ignorePaginationParam != null && ignorePaginationParam.booleanValue()) {
            return ignorePaginationParam;
        }
        return JRProperties.getBooleanProperty("net.sf.jasperreports.crosstab.ignore.width");
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    private void copyRowGroups(JRCrosstab crosstab, JRFillCrosstabObjectFactory factory) {
        JRCrosstabRowGroup[] groups = crosstab.getRowGroups();
        this.rowGroups = new JRFillCrosstabRowGroup[groups.length];
        this.rowGroupsMap = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < groups.length; ++i2) {
            JRFillCrosstabRowGroup group = factory.getCrosstabRowGroup(groups[i2]);
            group.getFillHeader().setVerticalPositionType(groups[i2].getPositionValue());
            this.rowGroups[i2] = group;
            this.rowGroupsMap.put(group.getName(), i2);
        }
    }

    private void copyColumnGroups(JRCrosstab crosstab, JRFillCrosstabObjectFactory factory) {
        JRCrosstabColumnGroup[] groups = crosstab.getColumnGroups();
        this.columnGroups = new JRFillCrosstabColumnGroup[groups.length];
        this.columnGroupsMap = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < groups.length; ++i2) {
            JRFillCrosstabColumnGroup group;
            this.columnGroups[i2] = group = factory.getCrosstabColumnGroup(groups[i2]);
            this.columnGroupsMap.put(group.getName(), i2);
        }
    }

    private void copyMeasures(JRCrosstab crosstab, JRFillCrosstabObjectFactory factory) {
        JRCrosstabMeasure[] crossMeasures = crosstab.getMeasures();
        this.measures = new JRFillCrosstabMeasure[crossMeasures.length];
        for (int i2 = 0; i2 < crossMeasures.length; ++i2) {
            this.measures[i2] = factory.getCrosstabMeasure(crossMeasures[i2]);
        }
    }

    private void copyParameters(JRCrosstab crosstab, JRFillObjectFactory factory) {
        JRCrosstabParameter[] crossParams = crosstab.getParameters();
        this.parameters = new JRFillCrosstabParameter[crossParams.length];
        this.parametersMap = new HashMap<String, JRFillParameter>();
        for (int i2 = 0; i2 < crossParams.length; ++i2) {
            this.parameters[i2] = factory.getCrosstabParameter(crossParams[i2]);
            this.parametersMap.put(this.parameters[i2].getName(), this.parameters[i2]);
        }
    }

    private void copyCells(JRCrosstab crosstab, JRFillCrosstabObjectFactory factory) {
        JRCrosstabCell[][] crosstabCells = crosstab.getCells();
        this.crossCells = new JRFillCrosstabCell[this.rowGroups.length + 1][this.columnGroups.length + 1];
        for (int i2 = 0; i2 <= this.rowGroups.length; ++i2) {
            for (int j2 = 0; j2 <= this.columnGroups.length; ++j2) {
                if (crosstabCells[i2][j2] == null) continue;
                this.crossCells[i2][j2] = factory.getCrosstabCell(crosstabCells[i2][j2]);
            }
        }
    }

    private void copyVariables(JRCrosstab crosstab, JRFillObjectFactory factory) {
        JRVariable[] vars = crosstab.getVariables();
        this.variables = new JRFillVariable[vars.length];
        this.variablesMap = new HashMap<String, JRFillVariable>();
        for (int i2 = 0; i2 < this.variables.length; ++i2) {
            this.variables[i2] = factory.getVariable(vars[i2]);
            this.variablesMap.put(this.variables[i2].getName(), this.variables[i2]);
        }
        HashMap<String, int[]> totalVarPos = new HashMap<String, int[]>();
        this.totalVariables = new JRFillVariable[this.rowGroups.length + 1][this.columnGroups.length + 1][this.measures.length];
        for (int row = 0; row <= this.rowGroups.length; ++row) {
            JRFillCrosstabRowGroup rowGroup = row == this.rowGroups.length ? null : this.rowGroups[row];
            for (int col = 0; col <= this.columnGroups.length; ++col) {
                JRFillCrosstabColumnGroup colGroup;
                JRFillCrosstabColumnGroup jRFillCrosstabColumnGroup = colGroup = col == this.columnGroups.length ? null : this.columnGroups[col];
                if (row >= this.rowGroups.length && col >= this.columnGroups.length) continue;
                for (int m2 = 0; m2 < this.measures.length; ++m2) {
                    String totalVariableName = JRDesignCrosstab.getTotalVariableName(this.measures[m2], rowGroup, colGroup);
                    this.totalVariables[row][col][m2] = this.variablesMap.get(totalVariableName);
                    totalVarPos.put(totalVariableName, new int[]{row, col});
                }
            }
        }
        HashSet<String> measureVars = new HashSet<String>();
        for (JRFillCrosstabMeasure measure : this.measures) {
            measureVars.add(measure.getFillVariable().getName());
        }
        this.retrieveTotal = new boolean[this.rowGroups.length + 1][this.columnGroups.length + 1];
        JRExpressionCollector collector = JRExpressionCollector.collector(this.filler.getJasperReport(), crosstab);
        List<JRExpression> expressions = collector.getExpressions(crosstab);
        for (JRExpression expression : expressions) {
            Object expressionContext = collector.getExpressionContext(expression);
            boolean groupHeaderExpression = expressionContext instanceof JRCrosstabGroup;
            JRExpressionChunk[] chunks = expression.getChunks();
            if (chunks == null) continue;
            for (int i3 = 0; i3 < chunks.length; ++i3) {
                JRExpressionChunk chunk = chunks[i3];
                if (chunk.getType() != 4) continue;
                String varName = chunk.getText();
                int[] pos = (int[])totalVarPos.get(varName);
                if (pos != null) {
                    this.retrieveTotal[pos[0]][pos[1]] = true;
                }
                if (!groupHeaderExpression || pos == null && !measureVars.contains(varName)) continue;
                this.retrieveTotal[0][0] = true;
            }
        }
    }

    protected void loadEvaluator(JasperReport jasperReport) {
        try {
            JREvaluator evaluator = JasperCompileManager.loadEvaluator(jasperReport, this.parentCrosstab);
            this.crosstabEvaluator = new JRCrosstabExpressionEvaluator(evaluator);
        }
        catch (JRException e2) {
            throw new JRRuntimeException("Could not load evaluator for crosstab.", e2);
        }
    }

    private BucketingService createService(byte evaluation) throws JRException {
        boolean hasOrderByExpression = false;
        ArrayList<BucketDefinition> rowBuckets = new ArrayList<BucketDefinition>(this.rowGroups.length);
        for (int i2 = 0; i2 < this.rowGroups.length; ++i2) {
            JRFillCrosstabRowGroup group = this.rowGroups[i2];
            rowBuckets.add(this.createServiceBucket(group, evaluation));
            hasOrderByExpression |= group.getBucket().getOrderByExpression() != null;
        }
        ArrayList<BucketDefinition> colBuckets = new ArrayList<BucketDefinition>(this.columnGroups.length);
        for (int i3 = 0; i3 < this.columnGroups.length; ++i3) {
            JRFillCrosstabColumnGroup group = this.columnGroups[i3];
            colBuckets.add(this.createServiceBucket(group, evaluation));
            hasOrderByExpression |= group.getBucket().getOrderByExpression() != null;
        }
        this.percentage = false;
        ArrayList<MeasureDefinition> measureList = new ArrayList<MeasureDefinition>(this.measures.length);
        for (int i4 = 0; i4 < this.measures.length; ++i4) {
            measureList.add(this.createServiceMeasure(this.measures[i4]));
            this.percentage |= this.measures[i4].getPercentageType() == CrosstabPercentageEnum.GRAND_TOTAL;
        }
        if (this.percentage || hasOrderByExpression) {
            ((BucketDefinition)rowBuckets.get(0)).setComputeTotal();
            ((BucketDefinition)colBuckets.get(0)).setComputeTotal();
        }
        return new BucketingService(this, rowBuckets, colBuckets, measureList, this.dataset.isDataPreSorted(), this.retrieveTotal);
    }

    private BucketDefinition createServiceBucket(JRCrosstabGroup group, byte evaluation) throws JRException {
        JRCrosstabBucket bucket = group.getBucket();
        Comparator comparator = null;
        JRExpression comparatorExpression = bucket.getComparatorExpression();
        if (comparatorExpression != null) {
            comparator = (Comparator)this.evaluateExpression(comparatorExpression, evaluation);
        }
        return new BucketDefinition(bucket.getValueClass(), bucket.getOrderByExpression(), comparator, bucket.getOrderValue(), group.getTotalPositionValue());
    }

    private MeasureDefinition createServiceMeasure(JRFillCrosstabMeasure measure) {
        return new MeasureDefinition(measure.getValueClass(), measure.getCalculationValue(), measure.getIncrementerFactory());
    }

    public Object evaluateExpression(JRExpression expression, MeasureDefinition.MeasureValue[] measureValues) throws JRException {
        for (int i2 = 0; i2 < this.measures.length; ++i2) {
            Object value = measureValues[i2].getValue();
            this.measures[i2].getFillVariable().setValue(value);
        }
        return this.crosstabEvaluator.evaluate(expression, (byte)3);
    }

    @Override
    protected void reset() {
        super.reset();
        for (int i2 = 0; i2 < this.variables.length; ++i2) {
            this.variables[i2].setValue(null);
            this.variables[i2].setInitialized(true);
        }
        this.printFrames = null;
    }

    @Override
    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        this.evaluateProperties(evaluation);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.dataset.evaluateDatasetRun(evaluation);
            this.initEvaluator(evaluation);
            this.bucketingService.processData();
            this.hasData = this.bucketingService.hasData();
            if (this.hasData) {
                this.columnHeadersData = this.bucketingService.getColumnHeaders();
                this.rowHeadersData = this.bucketingService.getRowHeaders();
                this.cellData = this.bucketingService.getCrosstabCells();
                if (this.percentage) {
                    this.grandTotals = this.bucketingService.getGrandTotals();
                }
                this.crosstabFiller.initCrosstab();
            }
            this.overflowStartPage = 0;
            this.ignoreWidth = this.isIgnoreWidth(this.filler, this.parentCrosstab);
        }
    }

    protected void initEvaluator(byte evaluation) throws JRException {
        Map<String, Object> parameterValues = JRFillSubreport.getParameterValues(this.filler, this.getParametersMapExpression(), this.getParameters(), evaluation, true, false, false);
        ResourceBundle resBdl = (ResourceBundle)parameterValues.get("REPORT_RESOURCE_BUNDLE");
        if (resBdl == null) {
            JRFillParameter resourceBundleParam = this.filler.getParametersMap().get("REPORT_RESOURCE_BUNDLE");
            parameterValues.put("REPORT_RESOURCE_BUNDLE", resourceBundleParam.getValue());
        }
        parameterValues.put("REPORT_PARAMETERS_MAP", parameterValues);
        for (int i2 = 0; i2 < this.parameters.length; ++i2) {
            Object value = parameterValues.get(this.parameters[i2].getName());
            this.parameters[i2].setValue(value);
        }
        this.crosstabEvaluator.init(this.parametersMap, this.variablesMap, this.filler.getWhenResourceMissingType());
    }

    protected void initBucketingService() {
        if (this.bucketingService == null) {
            try {
                this.bucketingService = this.createService((byte)3);
            }
            catch (JRException e2) {
                throw new JRRuntimeException("Could not create bucketing service", e2);
            }
        } else {
            this.bucketingService.clear();
        }
    }

    @Override
    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        super.prepare(availableHeight, isOverflow);
        if (!this.isToPrint()) {
            return false;
        }
        if (availableHeight < this.getRelativeY() + this.getHeight()) {
            this.setToPrint(false);
            return true;
        }
        if (isOverflow && this.crosstabFiller.ended() && this.isAlreadyPrinted()) {
            if (this.isPrintWhenDetailOverflows()) {
                this.rewind();
                this.setReprinted(true);
            } else {
                this.setStretchHeight(this.getHeight());
                this.setToPrint(false);
                return false;
            }
        }
        if (isOverflow && this.isPrintWhenDetailOverflows()) {
            this.setReprinted(true);
        }
        this.printFrames = new ArrayList<JRTemplatePrintFrame>();
        this.crosstabFiller.fill(availableHeight - this.getRelativeY());
        if (!this.printFrames.isEmpty()) {
            this.overflowStartPage = 0;
        } else {
            int pageCount = this.filler.getCurrentPageCount();
            if (this.overflowStartPage == 0) {
                this.overflowStartPage = pageCount;
            } else if (pageCount >= this.overflowStartPage + 2) {
                throw new JRRuntimeException("Crosstab has not printed anything on 3 consecutive pages, likely infinite loop");
            }
        }
        boolean willOverflow = this.crosstabFiller.willOverflow();
        if (willOverflow) {
            this.setStretchHeight(availableHeight - this.getRelativeY());
        } else if (!this.printFrames.isEmpty()) {
            JRTemplatePrintFrame lastFrame = this.printFrames.get(this.printFrames.size() - 1);
            int usedHeight = lastFrame.getY() + lastFrame.getHeight();
            this.setStretchHeight(usedHeight);
        }
        return willOverflow;
    }

    protected void addCrosstabChunk(List<JRPrintElement> elements, int yOffset) {
        JRTemplatePrintFrame printFrame = new JRTemplatePrintFrame(this.getTemplateFrame(), this.elementId);
        printFrame.setX(0);
        printFrame.setY(yOffset);
        Collections.sort(elements, new JRYXComparator());
        int xLimit = Integer.MIN_VALUE;
        int yLimit = Integer.MIN_VALUE;
        for (JRPrintElement element : elements) {
            if (element.getX() + element.getWidth() > xLimit) {
                xLimit = element.getX() + element.getWidth();
            }
            if (element.getY() + element.getHeight() <= yLimit) continue;
            yLimit = element.getY() + element.getHeight();
        }
        JRLineBox lineBox = this.getLineBox();
        int width = xLimit + lineBox.getLeftPadding() + lineBox.getRightPadding();
        printFrame.setWidth(width);
        if (this.getRunDirectionValue() == RunDirectionEnum.RTL) {
            printFrame.setX(this.getWidth() - width);
        }
        int height = yLimit + lineBox.getTopPadding() + lineBox.getBottomPadding();
        printFrame.setHeight(height);
        if (this.getRunDirectionValue() == RunDirectionEnum.RTL) {
            this.mirrorPrintElements(elements, xLimit);
        }
        printFrame.addElements(elements);
        this.printFrames.add(printFrame);
    }

    @Override
    protected JRPrintElement fill() {
        return null;
    }

    protected JRTemplateFrame getTemplateFrame() {
        return (JRTemplateFrame)this.getElementTemplate();
    }

    @Override
    protected JRTemplateElement createElementTemplate() {
        JRTemplateFrame template = new JRTemplateFrame(this.getElementOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider());
        template.setElement(this);
        template.copyBox(this.getLineBox());
        return template;
    }

    @Override
    protected void rewind() {
        this.crosstabFiller.initCrosstab();
        this.overflowStartPage = 0;
    }

    protected List<? extends JRPrintElement> getPrintElements() {
        return this.printFrames;
    }

    protected void mirrorPrintElements(List<JRPrintElement> printElements, int width) {
        for (JRPrintElement element : printElements) {
            int mirrorX = width - element.getX() - element.getWidth();
            element.setX(mirrorX);
        }
    }

    @Override
    protected void resolveElement(JRPrintElement element, byte evaluation) {
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitCrosstab(this);
    }

    @Override
    public int getId() {
        return this.parentCrosstab.getId();
    }

    @Override
    public JRCrosstabDataset getDataset() {
        return this.dataset;
    }

    @Override
    public JRCrosstabRowGroup[] getRowGroups() {
        return this.rowGroups;
    }

    @Override
    public JRCrosstabColumnGroup[] getColumnGroups() {
        return this.columnGroups;
    }

    @Override
    public JRCrosstabMeasure[] getMeasures() {
        return this.measures;
    }

    @Override
    public int getColumnBreakOffset() {
        return this.parentCrosstab.getColumnBreakOffset();
    }

    @Override
    public boolean isRepeatColumnHeaders() {
        return this.parentCrosstab.isRepeatColumnHeaders();
    }

    @Override
    public boolean isRepeatRowHeaders() {
        return this.parentCrosstab.isRepeatRowHeaders();
    }

    @Override
    public JRCrosstabCell[][] getCells() {
        return this.crossCells;
    }

    @Override
    public JRCellContents getWhenNoDataCell() {
        return this.whenNoDataCell;
    }

    @Override
    public JRCrosstabParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public JRExpression getParametersMapExpression() {
        return this.parentCrosstab.getParametersMapExpression();
    }

    @Override
    public JRElement getElementByKey(String elementKey) {
        return JRBaseCrosstab.getElementByKey(this, elementKey);
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return null;
    }

    @Override
    public JRCellContents getHeaderCell() {
        return this.headerCell;
    }

    @Override
    public JRVariable[] getVariables() {
        return this.variables;
    }

    @Override
    public RunDirectionEnum getRunDirectionValue() {
        return this.parentCrosstab.getRunDirectionValue();
    }

    @Override
    public void setRunDirection(RunDirectionEnum runDirection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JROrigin getOrigin() {
        return this.getElementOrigin();
    }

    @Override
    public Boolean getIgnoreWidth() {
        return this.parentCrosstab.getIgnoreWidth();
    }

    @Override
    public void setIgnoreWidth(Boolean ignoreWidth) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIgnoreWidth(boolean ignoreWidth) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Color getDefaultLineColor() {
        return this.parentCrosstab.getDefaultLineColor();
    }

    @Override
    public JRLineBox getLineBox() {
        return this.parentCrosstab.getLineBox();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CrosstabFiller {
        private int yOffset;
        private int yChunkOffset;
        private boolean willOverflow;
        private int[] rowHeadersXOffsets;
        private boolean[] columnBreakable;
        private boolean[] rowBreakable;
        private int[] columnCount;
        private int[] rowCount;
        private int[] columnXOffsets;
        private boolean noDataCellPrinted;
        private int startRowIndex;
        private int startColumnIndex;
        private int lastColumnIndex;
        private List<HeaderCell[]> columnHeaders;
        private List<List<JRPrintElement>> printRows;
        private HeaderCell[] spanHeaders;
        private int[] spanHeadersStart;
        private List<Integer> rowYs = new ArrayList<Integer>();
        private int rowIdx;
        private List<JRFillCellContents> preparedRow = new ArrayList<JRFillCellContents>();
        private int preparedRowHeight;
        private boolean printRowHeaders;
        private boolean printColumnHeaders;
        private JRFillVariable rowCountVar;
        private JRFillVariable colCountVar;

        protected CrosstabFiller() {
            this.setRowHeadersXOffsets();
            this.printRows = new ArrayList<List<JRPrintElement>>();
            this.rowCountVar = JRFillCrosstab.this.variablesMap.get("ROW_COUNT");
            this.colCountVar = JRFillCrosstab.this.variablesMap.get("COLUMN_COUNT");
        }

        protected void initCrosstab() {
            this.columnXOffsets = this.computeOffsets(JRFillCrosstab.this.columnHeadersData, JRFillCrosstab.this.columnGroups, true);
            this.columnBreakable = this.computeBreakableHeaders(JRFillCrosstab.this.columnHeadersData, JRFillCrosstab.this.columnGroups, this.columnXOffsets, true, true);
            this.columnCount = this.computeCounts(JRFillCrosstab.this.columnHeadersData);
            int[] rowYOffsets = this.computeOffsets(JRFillCrosstab.this.rowHeadersData, JRFillCrosstab.this.rowGroups, false);
            this.rowBreakable = this.computeBreakableHeaders(JRFillCrosstab.this.rowHeadersData, JRFillCrosstab.this.rowGroups, rowYOffsets, false, false);
            this.rowCount = this.computeCounts(JRFillCrosstab.this.rowHeadersData);
            this.spanHeaders = new HeaderCell[JRFillCrosstab.this.rowGroups.length - 1];
            this.spanHeadersStart = new int[JRFillCrosstab.this.rowGroups.length - 1];
            this.startRowIndex = 0;
            this.startColumnIndex = 0;
            this.lastColumnIndex = 0;
            this.noDataCellPrinted = false;
        }

        protected void setRowHeadersXOffsets() {
            this.rowHeadersXOffsets = new int[JRFillCrosstab.this.rowGroups.length + 1];
            this.rowHeadersXOffsets[0] = 0;
            for (int i2 = 0; i2 < JRFillCrosstab.this.rowGroups.length; ++i2) {
                this.rowHeadersXOffsets[i2 + 1] = this.rowHeadersXOffsets[i2] + JRFillCrosstab.this.rowGroups[i2].getWidth();
            }
        }

        protected int[] computeOffsets(HeaderCell[][] headersData, JRFillCrosstabGroup[] groups, boolean width) {
            int[] offsets = new int[headersData[0].length + 1];
            offsets[0] = 0;
            for (int i2 = 0; i2 < headersData[0].length; ++i2) {
                int size = 0;
                for (int j2 = groups.length - 1; j2 >= 0; --j2) {
                    JRFillCellContents cell;
                    if (headersData[j2][i2] == null) continue;
                    JRFillCellContents jRFillCellContents = cell = headersData[j2][i2].isTotal() ? groups[j2].getFillTotalHeader() : groups[j2].getFillHeader();
                    size = cell == null ? 0 : (width ? cell.getWidth() : cell.getHeight());
                    break;
                }
                offsets[i2 + 1] = offsets[i2] + size;
            }
            return offsets;
        }

        protected boolean[] computeBreakableHeaders(HeaderCell[][] headersData, JRFillCrosstabGroup[] groups, int[] offsets, boolean width, boolean startHeaders) {
            boolean[] breakable = new boolean[headersData[0].length];
            for (int i2 = 0; i2 < breakable.length; ++i2) {
                breakable[i2] = true;
            }
            for (int j2 = 0; j2 < groups.length; ++j2) {
                JRFillCellContents fillHeader = groups[j2].getFillHeader();
                if (fillHeader == null) continue;
                int size = width ? fillHeader.getWidth() : fillHeader.getHeight();
                for (int i3 = 0; i3 < headersData[0].length; ++i3) {
                    int k2;
                    HeaderCell header = headersData[j2][i3];
                    if (header == null || header.isTotal() || header.getLevelSpan() <= 1) continue;
                    int span = header.getLevelSpan();
                    if (startHeaders) {
                        for (k2 = i3 + 1; k2 < i3 + span && offsets[k2] - offsets[i3] < size; ++k2) {
                            breakable[k2] = false;
                        }
                    }
                    for (k2 = i3 + span - 1; k2 > i3 && offsets[i3 + span] - offsets[k2] < size; --k2) {
                        breakable[k2] = false;
                    }
                }
            }
            return breakable;
        }

        private int[] computeCounts(HeaderCell[][] headersData) {
            int[] counts = new int[headersData[0].length];
            HeaderCell[] lastHeaders = headersData[headersData.length - 1];
            int c2 = 0;
            for (int i2 = 0; i2 < counts.length; ++i2) {
                HeaderCell lastHeader = lastHeaders[i2];
                if (lastHeader == null || !lastHeader.isTotal()) {
                    // empty if block
                }
                counts[i2] = ++c2;
            }
            return counts;
        }

        protected void fill(int availableHeight) throws JRException {
            this.printRows.clear();
            this.yOffset = 0;
            this.yChunkOffset = 0;
            this.willOverflow = false;
            this.fillVerticalCrosstab(availableHeight);
        }

        protected boolean willOverflow() {
            return this.willOverflow;
        }

        protected boolean ended() {
            return JRFillCrosstab.this.hasData ? this.startRowIndex >= JRFillCrosstab.this.rowHeadersData[0].length && this.startColumnIndex >= JRFillCrosstab.this.columnHeadersData[0].length : this.noDataCellPrinted;
        }

        protected void fillVerticalCrosstab(int availableHeight) throws JRException {
            boolean fillEnded;
            int lastRowIndex;
            int rowHeadersXOffset;
            JRLineBox lineBox = JRFillCrosstab.this.getLineBox();
            int padding = lineBox.getTopPadding() + lineBox.getBottomPadding();
            int contentsHeight = availableHeight - padding;
            if (contentsHeight < 0) {
                this.willOverflow = true;
                return;
            }
            if (!JRFillCrosstab.this.hasData) {
                this.fillNoDataCell(contentsHeight);
                if (!this.printRows.isEmpty()) {
                    this.addFilledRows();
                }
                return;
            }
            this.printRowHeaders = this.startColumnIndex == 0 || JRFillCrosstab.this.isRepeatRowHeaders();
            int n2 = rowHeadersXOffset = this.printRowHeaders ? this.rowHeadersXOffsets[JRFillCrosstab.this.rowGroups.length] : 0;
            if (this.startColumnIndex == this.lastColumnIndex) {
                int availableWidth = JRFillCrosstab.this.getWidth() - lineBox.getLeftPadding() - lineBox.getRightPadding();
                this.columnHeaders = this.getGroupHeaders(availableWidth - rowHeadersXOffset, this.columnXOffsets, this.columnBreakable, this.startColumnIndex, JRFillCrosstab.this.columnHeadersData, JRFillCrosstab.this.columnGroups);
                this.lastColumnIndex = this.startColumnIndex + this.columnHeaders.size();
                if (this.startColumnIndex == this.lastColumnIndex) {
                    throw new JRRuntimeException("Not enough space to render the crosstab.");
                }
            }
            this.printColumnHeaders = this.startRowIndex == 0 || JRFillCrosstab.this.isRepeatColumnHeaders();
            List<List<JRPrintElement>> columnHeaderRows = null;
            if (this.printColumnHeaders) {
                columnHeaderRows = this.fillColumnHeaders(rowHeadersXOffset, contentsHeight - this.yOffset);
                if (this.willOverflow) {
                    return;
                }
            }
            if ((lastRowIndex = this.fillRows(rowHeadersXOffset, contentsHeight - this.yOffset)) == this.startRowIndex) {
                this.willOverflow = true;
                return;
            }
            if (columnHeaderRows != null) {
                this.printRows.addAll(columnHeaderRows);
            }
            if (!this.printRows.isEmpty()) {
                this.addFilledRows();
            }
            if (lastRowIndex >= JRFillCrosstab.this.rowHeadersData[0].length) {
                this.startColumnIndex = this.lastColumnIndex;
                if (this.startColumnIndex < JRFillCrosstab.this.columnHeadersData[0].length) {
                    lastRowIndex = 0;
                    this.startRowIndex = 0;
                    int yAdvance = this.yOffset + JRFillCrosstab.this.getColumnBreakOffset() + padding;
                    this.yChunkOffset += yAdvance;
                    int remainingHeight = availableHeight - yAdvance;
                    this.yOffset = 0;
                    this.fillVerticalCrosstab(remainingHeight);
                    return;
                }
            }
            boolean bl = fillEnded = lastRowIndex >= JRFillCrosstab.this.rowHeadersData[0].length && this.lastColumnIndex >= JRFillCrosstab.this.columnHeadersData[0].length;
            if (fillEnded) {
                JRFillCrosstab.this.setStretchHeight(this.yOffset);
            } else {
                JRFillCrosstab.this.setStretchHeight(availableHeight);
            }
            this.startRowIndex = lastRowIndex;
            this.willOverflow = !fillEnded;
        }

        protected void addFilledRows() {
            ArrayList<JRPrintElement> prints = new ArrayList<JRPrintElement>();
            for (List<JRPrintElement> rowPrints : this.printRows) {
                prints.addAll(rowPrints);
            }
            JRFillCrosstab.this.addCrosstabChunk(prints, this.yChunkOffset);
            this.printRows.clear();
        }

        protected List<HeaderCell[]> getGroupHeaders(int available, int[] offsets, boolean[] breakable, int firstIndex, HeaderCell[][] headersData, JRFillCrosstabGroup[] groups) {
            int j2;
            int lastIndex;
            ArrayList<HeaderCell[]> headers = new ArrayList<HeaderCell[]>();
            int maxOffset = available + offsets[firstIndex];
            for (lastIndex = firstIndex; lastIndex < headersData[0].length && (JRFillCrosstab.this.ignoreWidth || offsets[lastIndex + 1] <= maxOffset); ++lastIndex) {
                HeaderCell[] groupHeaders = new HeaderCell[groups.length];
                for (j2 = 0; j2 < groups.length; ++j2) {
                    groupHeaders[j2] = headersData[j2][lastIndex];
                }
                headers.add(groupHeaders);
            }
            if (lastIndex < headersData[0].length) {
                while (lastIndex > firstIndex && !breakable[lastIndex]) {
                    --lastIndex;
                    headers.remove(headers.size() - 1);
                }
            }
            if (lastIndex > firstIndex) {
                if (firstIndex > 0) {
                    HeaderCell[] firstHeaders = (HeaderCell[])headers.get(0);
                    for (j2 = 0; j2 < groups.length; ++j2) {
                        int spanIndex;
                        HeaderCell header = headersData[j2][firstIndex];
                        if (header != null || (spanIndex = this.getSpanIndex(firstIndex, j2, headersData)) < 0) continue;
                        HeaderCell spanCell = headersData[j2][spanIndex];
                        int headerEndIdx = spanCell.getLevelSpan() + spanIndex;
                        if (headerEndIdx > lastIndex) {
                            headerEndIdx = lastIndex;
                        }
                        firstHeaders[j2] = HeaderCell.createLevelSpanCopy(spanCell, headerEndIdx - firstIndex);
                    }
                }
                if (lastIndex < headersData[0].length) {
                    for (int j3 = 0; j3 < groups.length; ++j3) {
                        int spanIndex;
                        HeaderCell header = headersData[j3][lastIndex];
                        if (header != null || (spanIndex = this.getSpanIndex(lastIndex, j3, headersData)) < firstIndex) continue;
                        HeaderCell spanCell = headersData[j3][spanIndex];
                        HeaderCell[] headerCells = (HeaderCell[])headers.get(spanIndex - firstIndex);
                        headerCells[j3] = HeaderCell.createLevelSpanCopy(spanCell, lastIndex - spanIndex);
                    }
                }
            }
            return headers;
        }

        protected int getSpanIndex(int i2, int j2, HeaderCell[][] headersData) {
            HeaderCell spanCell;
            int span;
            int spanIndex;
            for (spanIndex = i2 - 1; spanIndex >= 0 && headersData[j2][spanIndex] == null; --spanIndex) {
            }
            if (spanIndex >= 0 && (span = (spanCell = headersData[j2][spanIndex]).getLevelSpan()) > i2 - spanIndex) {
                return spanIndex;
            }
            return -1;
        }

        protected void fillNoDataCell(int availableHeight) throws JRException {
            if (JRFillCrosstab.this.whenNoDataCell == null) {
                this.noDataCellPrinted = true;
            } else if (availableHeight < JRFillCrosstab.this.whenNoDataCell.getHeight()) {
                this.willOverflow = true;
            } else {
                JRFillCrosstab.this.whenNoDataCell.evaluate((byte)3);
                JRFillCrosstab.this.whenNoDataCell.prepare(availableHeight);
                this.willOverflow = JRFillCrosstab.this.whenNoDataCell.willOverflow();
                if (!this.willOverflow) {
                    JRFillCrosstab.this.whenNoDataCell.setX(0);
                    JRFillCrosstab.this.whenNoDataCell.setY(0);
                    JRPrintFrame printCell = JRFillCrosstab.this.whenNoDataCell.fill();
                    ArrayList<JRPrintElement> noDataRow = new ArrayList<JRPrintElement>(1);
                    noDataRow.add(printCell);
                    this.addPrintRow(noDataRow);
                    this.yOffset += JRFillCrosstab.this.whenNoDataCell.getPrintHeight();
                    this.noDataCellPrinted = true;
                }
            }
        }

        protected List<List<JRPrintElement>> fillColumnHeaders(int rowHeadersXOffset, int availableHeight) throws JRException {
            List<List<JRPrintElement>> headerRows;
            JRFillCellContents[][] columnHeaderRows = new JRFillCellContents[JRFillCrosstab.this.columnGroups.length][this.lastColumnIndex - this.startColumnIndex + 1];
            this.rowYs.clear();
            this.rowYs.add(0);
            if (this.printRowHeaders && JRFillCrosstab.this.headerCell != null) {
                JRFillCellContents contents = this.fillHeader(availableHeight);
                if (this.willOverflow) {
                    return null;
                }
                columnHeaderRows[JRFillCrosstab.this.columnGroups.length - 1][0] = contents;
            }
            this.rowIdx = 0;
            block0: while (this.rowIdx < JRFillCrosstab.this.columnGroups.length) {
                for (int columnIdx = this.startColumnIndex; columnIdx < this.lastColumnIndex; ++columnIdx) {
                    JRFillCellContents contents;
                    HeaderCell[] headers = this.columnHeaders.get(columnIdx - this.startColumnIndex);
                    HeaderCell cell = headers[this.rowIdx];
                    if (cell == null) continue;
                    columnHeaderRows[this.rowIdx + cell.getDepthSpan() - 1][columnIdx - this.startColumnIndex + 1] = contents = this.prepareColumnHeader(cell, columnIdx, rowHeadersXOffset, availableHeight);
                    if (this.willOverflow) break block0;
                }
                int rowStretchHeight = this.stretchColumnHeadersRow(columnHeaderRows[this.rowIdx]);
                this.rowYs.add(this.rowYs.get(this.rowIdx) + rowStretchHeight);
                ++this.rowIdx;
            }
            if (this.willOverflow) {
                headerRows = null;
                this.releaseColumnHeaderCells(columnHeaderRows);
            } else {
                headerRows = this.fillColumnHeaders(columnHeaderRows);
                this.yOffset += this.rowYs.get(JRFillCrosstab.this.columnGroups.length).intValue();
            }
            this.resetVariables();
            return headerRows;
        }

        private void setCountVars(int rowIdx, int colIdx) {
            if (rowIdx == -1) {
                this.rowCountVar.setValue(null);
            } else {
                this.rowCountVar.setValue(this.rowCount[rowIdx]);
            }
            if (colIdx == -1) {
                this.colCountVar.setValue(null);
            } else {
                this.colCountVar.setValue(this.columnCount[colIdx]);
            }
        }

        private JRFillCellContents fillHeader(int availableHeight) throws JRException {
            this.setCountVars(-1, -1);
            JRFillCellContents contents = JRFillCrosstab.this.headerCell.getWorkingClone();
            contents.evaluate((byte)3);
            contents.prepare(availableHeight);
            this.willOverflow = contents.willOverflow();
            if (!this.willOverflow) {
                contents.setX(0);
                contents.setY(this.yOffset);
                contents.setVerticalSpan(JRFillCrosstab.this.columnGroups.length);
                contents.setHorizontalSpan(JRFillCrosstab.this.rowGroups.length);
            }
            return contents;
        }

        private JRFillCellContents prepareColumnHeader(HeaderCell cell, int columnIdx, int xOffset, int availableHeight) throws JRException {
            JRFillCrosstabColumnGroup group = JRFillCrosstab.this.columnGroups[this.rowIdx];
            JRFillCellContents contents = cell.isTotal() ? group.getFillTotalHeader() : group.getFillHeader();
            int width = this.columnXOffsets[columnIdx + cell.getLevelSpan()] - this.columnXOffsets[columnIdx];
            int height = contents.getHeight();
            if (width <= 0 || height <= 0) {
                return null;
            }
            JRFillCellContents preparedContents = null;
            int rowY = this.rowYs.get(this.rowIdx);
            if (availableHeight >= rowY + height) {
                this.setCountVars(-1, columnIdx);
                this.setGroupVariables(JRFillCrosstab.this.columnGroups, cell.getBucketValues());
                this.setGroupMeasureVariables(cell, false);
                contents = contents.getTransformedContents(width, height, group.getPositionValue(), CrosstabRowPositionEnum.TOP);
                boolean firstOnRow = columnIdx == this.startColumnIndex && (!this.printRowHeaders || JRFillCrosstab.this.headerCell == null);
                contents = contents.getBoxContents(firstOnRow && JRFillCrosstab.this.getRunDirectionValue() == RunDirectionEnum.LTR, firstOnRow && JRFillCrosstab.this.getRunDirectionValue() == RunDirectionEnum.RTL, false);
                contents = contents.getWorkingClone();
                contents.evaluate((byte)3);
                contents.prepare(availableHeight - rowY);
                if (contents.willOverflow()) {
                    this.willOverflow = true;
                } else {
                    contents.setX(this.columnXOffsets[columnIdx] - this.columnXOffsets[this.startColumnIndex] + xOffset);
                    contents.setY(rowY + this.yOffset);
                    contents.setVerticalSpan(cell.getDepthSpan());
                    contents.setHorizontalSpan(cell.getLevelSpan());
                    preparedContents = contents;
                }
            } else {
                this.willOverflow = true;
            }
            return preparedContents;
        }

        private int stretchColumnHeadersRow(JRFillCellContents[] headers) {
            int startRowY;
            JRFillCellContents contents;
            int j2;
            int rowY = this.rowYs.get(this.rowIdx);
            int rowStretchHeight = 0;
            for (j2 = 0; j2 < headers.length; ++j2) {
                int height;
                contents = headers[j2];
                if (contents == null) continue;
                startRowY = rowY;
                if (contents.getVerticalSpan() > 1) {
                    startRowY = this.rowYs.get(this.rowIdx - contents.getVerticalSpan() + 1);
                }
                if ((height = contents.getPrintHeight() - rowY + startRowY) <= rowStretchHeight) continue;
                rowStretchHeight = height;
            }
            for (j2 = 0; j2 < headers.length; ++j2) {
                contents = headers[j2];
                if (contents == null) continue;
                startRowY = rowY;
                if (contents.getVerticalSpan() > 1) {
                    startRowY = this.rowYs.get(this.rowIdx - contents.getVerticalSpan() + 1);
                }
                contents.stretchTo(rowStretchHeight + rowY - startRowY);
            }
            return rowStretchHeight;
        }

        private List<List<JRPrintElement>> fillColumnHeaders(JRFillCellContents[][] columnHeaderRows) throws JRException {
            ArrayList<List<JRPrintElement>> headerRows = new ArrayList<List<JRPrintElement>>(JRFillCrosstab.this.columnGroups.length);
            for (int i2 = 0; i2 < columnHeaderRows.length; ++i2) {
                ArrayList<JRPrintFrame> headerRow = new ArrayList<JRPrintFrame>(this.lastColumnIndex - this.startColumnIndex);
                headerRows.add(headerRow);
                for (int j2 = 0; j2 < columnHeaderRows[i2].length; ++j2) {
                    JRFillCellContents contents = columnHeaderRows[i2][j2];
                    if (contents == null) continue;
                    headerRow.add(contents.fill());
                    contents.releaseWorkingClone();
                }
            }
            return headerRows;
        }

        private void releaseColumnHeaderCells(JRFillCellContents[][] columnHeaderRows) throws JRException {
            for (int i2 = 0; i2 < columnHeaderRows.length; ++i2) {
                for (int j2 = 0; j2 < columnHeaderRows[i2].length; ++j2) {
                    JRFillCellContents contents = columnHeaderRows[i2][j2];
                    if (contents == null) continue;
                    contents.rewind();
                    contents.releaseWorkingClone();
                }
            }
        }

        protected int fillRows(int xOffset, int availableHeight) throws JRException {
            this.rowYs.clear();
            this.rowYs.add(0);
            this.rowIdx = 0;
            while (this.rowIdx < JRFillCrosstab.this.cellData.length - this.startRowIndex) {
                this.initPreparedRow();
                this.prepareRow(xOffset, availableHeight);
                if (this.willOverflow) break;
                this.fillRow();
                this.rowYs.add(this.rowYs.get(this.rowIdx) + this.preparedRowHeight);
                ++this.rowIdx;
            }
            if (this.rowIdx < JRFillCrosstab.this.cellData.length - this.startRowIndex) {
                this.releasePreparedRow();
                if (this.printRowHeaders) {
                    this.fillContinuingRowHeaders(xOffset, availableHeight);
                }
            }
            this.yOffset += this.rowYs.get(this.rowIdx).intValue();
            return this.rowIdx + this.startRowIndex;
        }

        private void initPreparedRow() {
            this.preparedRow.clear();
            this.preparedRowHeight = 0;
        }

        private void removeFilledRows(int rowsToRemove) {
            if (rowsToRemove > 0) {
                for (int i2 = 0; i2 < rowsToRemove; ++i2) {
                    this.printRows.remove(this.printRows.size() - 1);
                    this.rowYs.remove(this.rowYs.size() - 1);
                }
                this.rowIdx -= rowsToRemove;
            }
        }

        private void releasePreparedRow() throws JRException {
            for (JRFillCellContents cell : this.preparedRow) {
                cell.rewind();
                cell.releaseWorkingClone();
            }
            this.preparedRow.clear();
        }

        private void fillRow() throws JRException {
            int rowY = this.rowYs.get(this.rowIdx);
            ArrayList<JRPrintElement> rowPrints = new ArrayList<JRPrintElement>(this.preparedRow.size());
            for (JRFillCellContents cell : this.preparedRow) {
                int spanHeight = 0;
                if (cell.getVerticalSpan() > 1) {
                    spanHeight = rowY - this.rowYs.get(this.rowIdx - cell.getVerticalSpan() + 1);
                }
                cell.stretchTo(this.preparedRowHeight + spanHeight);
                rowPrints.add(cell.fill());
                cell.releaseWorkingClone();
            }
            this.addPrintRow(rowPrints);
        }

        private void prepareRow(int xOffset, int availableHeight) throws JRException {
            for (int col = this.startColumnIndex; col < this.lastColumnIndex; ++col) {
                CrosstabCell data = JRFillCrosstab.this.cellData[this.rowIdx + this.startRowIndex][col];
                boolean overflow = this.prepareDataCell(data, col, availableHeight, xOffset);
                if (!overflow) continue;
                this.willOverflow = true;
                return;
            }
            this.resetVariables();
            if (this.printRowHeaders) {
                int j2;
                for (j2 = 0; j2 < JRFillCrosstab.this.rowGroups.length; ++j2) {
                    boolean overflow;
                    HeaderCell cell = JRFillCrosstab.this.rowHeadersData[j2][this.rowIdx + this.startRowIndex];
                    int vSpan = 0;
                    if (cell == null) {
                        if (this.toCloseRowHeader(j2)) {
                            cell = this.spanHeaders[j2];
                            vSpan = cell.getLevelSpan();
                            if (this.spanHeadersStart[j2] < this.startRowIndex) {
                                vSpan += this.spanHeadersStart[j2] - this.startRowIndex;
                            }
                        }
                    } else {
                        if (cell.getLevelSpan() > 1) {
                            this.spanHeaders[j2] = cell;
                            this.spanHeadersStart[j2] = this.rowIdx + this.startRowIndex;
                            continue;
                        }
                        vSpan = 1;
                    }
                    if (cell == null || !(overflow = this.prepareRowHeader(j2, cell, vSpan, availableHeight))) continue;
                    this.willOverflow = true;
                    return;
                }
                for (j2 = 0; j2 < JRFillCrosstab.this.rowGroups.length; ++j2) {
                    if (JRFillCrosstab.this.rowHeadersData[j2][this.rowIdx + this.startRowIndex] != null || !this.toCloseRowHeader(j2)) continue;
                    this.spanHeaders[j2] = null;
                }
                this.resetVariables();
            }
        }

        private boolean prepareDataCell(CrosstabCell data, int column, int availableHeight, int xOffset) throws JRException {
            boolean overflow;
            JRFillCellContents contents;
            int rowY = this.rowYs.get(this.rowIdx);
            JRFillCrosstabCell cell = JRFillCrosstab.this.crossCells[data.getRowTotalGroupIndex()][data.getColumnTotalGroupIndex()];
            JRFillCellContents jRFillCellContents = contents = cell == null ? null : cell.getFillContents();
            if (contents == null || contents.getWidth() <= 0 || contents.getHeight() <= 0) {
                return false;
            }
            boolean bl = overflow = availableHeight < rowY + contents.getHeight();
            if (!overflow) {
                boolean leftEmpty = this.startColumnIndex != 0 && !JRFillCrosstab.this.isRepeatRowHeaders();
                boolean topEmpty = this.startRowIndex != 0 && !JRFillCrosstab.this.isRepeatColumnHeaders();
                this.setCountVars(this.rowIdx + this.startRowIndex, column);
                this.setGroupVariables(JRFillCrosstab.this.rowGroups, data.getRowBucketValues());
                this.setGroupVariables(JRFillCrosstab.this.columnGroups, data.getColumnBucketValues());
                this.setMeasureVariables(data);
                boolean firstOnRow = leftEmpty && column == this.startColumnIndex;
                contents = contents.getBoxContents(firstOnRow && JRFillCrosstab.this.getRunDirectionValue() == RunDirectionEnum.LTR, firstOnRow && JRFillCrosstab.this.getRunDirectionValue() == RunDirectionEnum.RTL, topEmpty && this.rowIdx == 0);
                contents = contents.getWorkingClone();
                contents.evaluate((byte)3);
                contents.prepare(availableHeight - rowY);
                this.preparedRow.add(contents);
                overflow = contents.willOverflow();
                if (!overflow) {
                    contents.setX(this.columnXOffsets[column] - this.columnXOffsets[this.startColumnIndex] + xOffset);
                    contents.setY(rowY + this.yOffset);
                    int rowCellHeight = contents.getPrintHeight();
                    if (rowCellHeight > this.preparedRowHeight) {
                        this.preparedRowHeight = rowCellHeight;
                    }
                }
            }
            return overflow;
        }

        private boolean prepareRowHeader(int rowGroup, HeaderCell cell, int vSpan, int availableHeight) throws JRException {
            boolean headerOverflow;
            JRFillCellContents contents;
            JRFillCrosstabRowGroup group = JRFillCrosstab.this.rowGroups[rowGroup];
            JRFillCellContents jRFillCellContents = contents = cell.isTotal() ? group.getFillTotalHeader() : group.getFillHeader();
            if (contents.getWidth() <= 0 || contents.getHeight() <= 0) {
                return false;
            }
            int spanHeight = 0;
            int headerY = this.rowYs.get(this.rowIdx - vSpan + 1);
            if (vSpan > 1) {
                spanHeight += this.rowYs.get(this.rowIdx) - headerY;
            }
            int rowHeight = spanHeight + this.preparedRowHeight;
            boolean stretchContents = group.getPositionValue() == CrosstabRowPositionEnum.STRETCH;
            int contentsHeight = stretchContents ? rowHeight : contents.getHeight();
            boolean bl = headerOverflow = availableHeight < headerY + contentsHeight || rowHeight < contents.getHeight();
            if (!headerOverflow) {
                this.setCountVars(this.rowIdx + this.startRowIndex - vSpan + 1, -1);
                this.setGroupVariables(JRFillCrosstab.this.rowGroups, cell.getBucketValues());
                this.setGroupMeasureVariables(cell, true);
                if (stretchContents) {
                    contents = contents.getTransformedContents(contents.getWidth(), rowHeight, CrosstabColumnPositionEnum.LEFT, CrosstabRowPositionEnum.STRETCH);
                }
                contents = contents.getBoxContents(false, false, this.rowIdx + 1 == vSpan && (!this.printColumnHeaders || JRFillCrosstab.this.headerCell == null));
                contents.getWorkingClone();
                contents.evaluate((byte)3);
                contents.prepare(availableHeight - headerY);
                this.preparedRow.add(contents);
                headerOverflow = contents.willOverflow();
                if (!headerOverflow) {
                    contents.setX(this.rowHeadersXOffsets[rowGroup]);
                    contents.setY(headerY + this.yOffset);
                    contents.setVerticalSpan(vSpan);
                    contents.setHorizontalSpan(cell.getDepthSpan());
                    int rowCellHeight = contents.getPrintHeight() - spanHeight;
                    if (rowCellHeight > this.preparedRowHeight) {
                        this.preparedRowHeight = rowCellHeight;
                    }
                }
            }
            if (headerOverflow) {
                this.removeFilledRows(vSpan - 1);
            }
            return headerOverflow;
        }

        protected boolean toCloseRowHeader(int rowGroup) {
            return rowGroup < JRFillCrosstab.this.rowGroups.length - 1 && this.spanHeaders[rowGroup] != null && this.spanHeaders[rowGroup].getLevelSpan() + this.spanHeadersStart[rowGroup] == this.rowIdx + this.startRowIndex + 1;
        }

        private void removeExceedingSpanHeaders() {
            for (int j2 = JRFillCrosstab.this.rowGroups.length - 2; j2 >= 0; --j2) {
                if (this.spanHeaders[j2] == null || this.spanHeadersStart[j2] < this.rowIdx + this.startRowIndex) continue;
                this.spanHeaders[j2] = null;
            }
        }

        private void setBackSpanHeaders() {
            for (int j2 = JRFillCrosstab.this.rowGroups.length - 2; j2 >= 0 && this.spanHeaders[j2] == null; --j2) {
                int spanIndex = this.getSpanIndex(this.rowIdx + this.startRowIndex, j2, JRFillCrosstab.this.rowHeadersData);
                if (spanIndex < 0) continue;
                this.spanHeaders[j2] = JRFillCrosstab.this.rowHeadersData[j2][spanIndex];
                this.spanHeadersStart[j2] = spanIndex;
            }
        }

        private void fillContinuingRowHeaders(int xOffset, int availableHeight) throws JRException {
            boolean done = false;
            block0: do {
                this.removeExceedingSpanHeaders();
                if (!this.rowBreakable[this.rowIdx + this.startRowIndex]) {
                    this.removeFilledRows(1);
                    this.setBackSpanHeaders();
                    continue;
                }
                this.initPreparedRow();
                for (int j2 = 0; j2 < JRFillCrosstab.this.rowGroups.length - 1; ++j2) {
                    boolean headerOverflow;
                    if (this.spanHeaders[j2] == null || !(headerOverflow = this.prepareContinuingRowHeader(j2, availableHeight))) continue;
                    this.releasePreparedRow();
                    continue block0;
                }
                if (!this.preparedRow.isEmpty()) {
                    int lastRowHeight = this.rowYs.get(this.rowIdx) - this.rowYs.get(this.rowIdx - 1);
                    if (this.preparedRowHeight > lastRowHeight) {
                        this.refillLastRow(xOffset, availableHeight);
                    } else {
                        this.fillContinuingHeaders(lastRowHeight);
                    }
                }
                done = true;
            } while (!done && this.rowIdx > 0);
        }

        private void fillContinuingHeaders(int lastRowHeight) throws JRException {
            int nextToLastHeaderY = this.rowYs.get(this.rowIdx - 1);
            List<JRPrintElement> lastPrintRow = this.getLastPrintRow();
            for (int j2 = 0; j2 < this.preparedRow.size(); ++j2) {
                JRFillCellContents contents = this.preparedRow.get(j2);
                int headerY = this.rowYs.get(this.rowIdx - contents.getVerticalSpan());
                contents.stretchTo(nextToLastHeaderY - headerY + lastRowHeight);
                lastPrintRow.add(contents.fill());
                contents.releaseWorkingClone();
            }
        }

        private void refillLastRow(int xOffset, int availableHeight) throws JRException {
            this.removeFilledRows(1);
            this.setBackSpanHeaders();
            this.prepareRow(xOffset, availableHeight);
            this.fillRow();
            this.rowYs.add(this.rowYs.get(this.rowIdx) + this.preparedRowHeight);
            ++this.rowIdx;
        }

        private boolean prepareContinuingRowHeader(int rowGroup, int availableHeight) throws JRException {
            boolean headerOverflow;
            HeaderCell cell = this.spanHeaders[rowGroup];
            int vSpan = this.rowIdx + this.startRowIndex - this.spanHeadersStart[rowGroup];
            if (this.spanHeadersStart[rowGroup] < this.startRowIndex) {
                vSpan += this.spanHeadersStart[rowGroup] - this.startRowIndex;
            }
            int headerY = this.rowYs.get(this.rowIdx - vSpan);
            int lastHeaderY = this.rowYs.get(this.rowIdx);
            int headerHeight = lastHeaderY - headerY;
            int nextToLastHeaderY = this.rowYs.get(this.rowIdx - 1);
            int stretchHeight = nextToLastHeaderY - headerY;
            JRFillCrosstabRowGroup group = JRFillCrosstab.this.rowGroups[rowGroup];
            JRFillCellContents contents = cell.isTotal() ? group.getFillTotalHeader() : group.getFillHeader();
            boolean stretchContents = group.getPositionValue() == CrosstabRowPositionEnum.STRETCH;
            int contentsHeight = stretchContents ? headerHeight : contents.getHeight();
            boolean bl = headerOverflow = availableHeight < headerY + contentsHeight || headerHeight < contents.getHeight();
            if (!headerOverflow) {
                this.setCountVars(this.rowIdx + this.startRowIndex - vSpan, -1);
                this.setGroupVariables(JRFillCrosstab.this.rowGroups, cell.getBucketValues());
                this.setGroupMeasureVariables(cell, true);
                if (stretchContents) {
                    contents = contents.getTransformedContents(contents.getWidth(), headerHeight, CrosstabColumnPositionEnum.LEFT, CrosstabRowPositionEnum.STRETCH);
                }
                contents = contents.getBoxContents(false, false, this.rowIdx == vSpan && (!this.printColumnHeaders || JRFillCrosstab.this.headerCell == null));
                contents.getWorkingClone();
                contents.evaluate((byte)3);
                contents.prepare(availableHeight - headerY);
                this.preparedRow.add(contents);
                headerOverflow = contents.willOverflow();
                if (!headerOverflow) {
                    contents.setX(this.rowHeadersXOffsets[rowGroup]);
                    contents.setY(headerY + this.yOffset);
                    contents.setVerticalSpan(vSpan);
                    contents.setHorizontalSpan(cell.getDepthSpan());
                    int rowHeight = contents.getPrintHeight() - stretchHeight;
                    if (rowHeight > this.preparedRowHeight) {
                        this.preparedRowHeight = rowHeight;
                    }
                }
            }
            if (headerOverflow) {
                this.removeFilledRows(vSpan);
            }
            return headerOverflow;
        }

        protected void addPrintRow(List<JRPrintElement> printRow) {
            this.printRows.add(printRow);
        }

        protected List<JRPrintElement> getLastPrintRow() {
            return this.printRows.get(this.printRows.size() - 1);
        }

        protected void setGroupVariables(JRFillCrosstabGroup[] groups, BucketDefinition.Bucket[] bucketValues) {
            for (int i2 = 0; i2 < groups.length; ++i2) {
                Object value = null;
                if (bucketValues[i2] != null && !bucketValues[i2].isTotal()) {
                    value = bucketValues[i2].getValue();
                }
                groups[i2].getFillVariable().setValue(value);
            }
        }

        protected void setGroupMeasureVariables(HeaderCell cell, boolean rowGroup) {
            MeasureDefinition.MeasureValue[][] totals = cell.getTotals();
            for (int m2 = 0; m2 < JRFillCrosstab.this.measures.length; ++m2) {
                for (int row = 0; row <= JRFillCrosstab.this.rowGroups.length; ++row) {
                    for (int col = 0; col <= JRFillCrosstab.this.columnGroups.length; ++col) {
                        MeasureDefinition.MeasureValue[] vals;
                        MeasureDefinition.MeasureValue[] measureValueArray = vals = rowGroup ? totals[row] : totals[col];
                        if (row == JRFillCrosstab.this.rowGroups.length && col == JRFillCrosstab.this.columnGroups.length) {
                            Object value = this.measureValue(vals, m2);
                            JRFillCrosstab.this.measures[m2].getFillVariable().setValue(value);
                            continue;
                        }
                        if (!JRFillCrosstab.this.retrieveTotal[row][col]) continue;
                        JRFillVariable totalVar = JRFillCrosstab.this.totalVariables[row][col][m2];
                        Object value = this.measureValue(vals, m2);
                        totalVar.setValue(value);
                    }
                }
            }
        }

        protected void setMeasureVariables(CrosstabCell cell) {
            MeasureDefinition.MeasureValue[] values = cell.getMesureValues();
            for (int i2 = 0; i2 < JRFillCrosstab.this.measures.length; ++i2) {
                Object value = this.measureValue(values, i2);
                JRFillCrosstab.this.measures[i2].getFillVariable().setValue(value);
            }
            MeasureDefinition.MeasureValue[][][] totals = cell.getTotals();
            for (int row = 0; row <= JRFillCrosstab.this.rowGroups.length; ++row) {
                for (int col = 0; col <= JRFillCrosstab.this.columnGroups.length; ++col) {
                    MeasureDefinition.MeasureValue[] vals = totals[row][col];
                    if (!JRFillCrosstab.this.retrieveTotal[row][col]) continue;
                    for (int m2 = 0; m2 < JRFillCrosstab.this.measures.length; ++m2) {
                        JRFillVariable totalVar = JRFillCrosstab.this.totalVariables[row][col][m2];
                        Object value = this.measureValue(vals, m2);
                        totalVar.setValue(value);
                    }
                }
            }
        }

        protected Object measureValue(MeasureDefinition.MeasureValue[] values, int measureIdx) {
            if (values == null) {
                return null;
            }
            Object value = JRFillCrosstab.this.measures[measureIdx].getPercentageType() == CrosstabPercentageEnum.GRAND_TOTAL ? (values[measureIdx].isInitialized() ? values[measureIdx].getValue() : JRFillCrosstab.this.measures[measureIdx].getPercentageCalculator().calculatePercentage(values[measureIdx], JRFillCrosstab.this.grandTotals[measureIdx])) : values[measureIdx].getValue();
            return value;
        }

        protected void resetVariables() {
            int i2;
            for (i2 = 0; i2 < JRFillCrosstab.this.rowGroups.length; ++i2) {
                JRFillCrosstab.this.rowGroups[i2].getFillVariable().setValue(null);
            }
            for (i2 = 0; i2 < JRFillCrosstab.this.columnGroups.length; ++i2) {
                JRFillCrosstab.this.columnGroups[i2].getFillVariable().setValue(null);
            }
            for (i2 = 0; i2 < JRFillCrosstab.this.measures.length; ++i2) {
                JRFillCrosstab.this.measures[i2].getFillVariable().setValue(null);
            }
            for (int row = 0; row <= JRFillCrosstab.this.rowGroups.length; ++row) {
                for (int col = 0; col <= JRFillCrosstab.this.columnGroups.length; ++col) {
                    if (!JRFillCrosstab.this.retrieveTotal[row][col]) continue;
                    for (int i3 = 0; i3 < JRFillCrosstab.this.measures.length; ++i3) {
                        JRFillCrosstab.this.totalVariables[row][col][i3].setValue(null);
                    }
                }
            }
        }
    }

    public class JRFillCrosstabDataset
    extends JRFillElementDataset
    implements JRCrosstabDataset {
        private Object[] bucketValues;
        private Object[] measureValues;

        public JRFillCrosstabDataset(JRCrosstabDataset dataset, JRFillObjectFactory factory) {
            super(dataset, factory);
            this.bucketValues = new Object[JRFillCrosstab.this.rowGroups.length + JRFillCrosstab.this.columnGroups.length];
            this.measureValues = new Object[JRFillCrosstab.this.measures.length];
        }

        protected void customInitialize() {
            JRFillCrosstab.this.initBucketingService();
        }

        protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
            int i2;
            for (i2 = 0; i2 < JRFillCrosstab.this.rowGroups.length; ++i2) {
                this.bucketValues[i2] = calculator.evaluate(JRFillCrosstab.this.rowGroups[i2].getBucket().getExpression());
            }
            for (i2 = 0; i2 < JRFillCrosstab.this.columnGroups.length; ++i2) {
                this.bucketValues[i2 + JRFillCrosstab.this.rowGroups.length] = calculator.evaluate(JRFillCrosstab.this.columnGroups[i2].getBucket().getExpression());
            }
            for (i2 = 0; i2 < JRFillCrosstab.this.measures.length; ++i2) {
                this.measureValues[i2] = calculator.evaluate(JRFillCrosstab.this.measures[i2].getValueExpression());
            }
        }

        protected void customIncrement() {
            try {
                JRFillCrosstab.this.bucketingService.addData(this.bucketValues, this.measureValues);
            }
            catch (JRException e2) {
                throw new JRRuntimeException("Error incrementing crosstab dataset", e2);
            }
        }

        protected Dataset getCustomDataset() {
            return null;
        }

        public void collectExpressions(JRExpressionCollector collector) {
        }

        public boolean isDataPreSorted() {
            return ((JRCrosstabDataset)this.parent).isDataPreSorted();
        }
    }
}

