/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TwoKeyHashMap<E, K, V>
extends AbstractMap<String, V> {
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_INITIAL_SIZE = 16;
    static final int DEFAULT_SEC_INITIAL_SIZE = 4;
    private Collection<V> values = new ArrayList<V>();
    private int size;
    private int arrSize;
    private int modCount;
    private HashMap<E, HashMap<K, V>> levelOneMap;
    private float loadFactor;

    public TwoKeyHashMap() {
        this(16, 0.75f);
    }

    public TwoKeyHashMap(int n2) {
        this(n2, 0.75f);
    }

    public TwoKeyHashMap(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity should be >= 0");
        }
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("initialLoadFactor should be > 0");
        }
        this.loadFactor = f2;
        if (n2 == Integer.MAX_VALUE) {
            --n2;
        }
        this.arrSize = TwoKeyHashMap.calculateCapacity(n2);
        this.levelOneMap = new HashMap(this.arrSize, this.loadFactor);
    }

    private static final int calculateCapacity(int n2) {
        if (n2 >= 0x40000000) {
            return 0x40000000;
        }
        if (n2 == 0) {
            return 16;
        }
        if (n2 == 1) {
            return 2;
        }
        --n2;
        n2 |= n2 >> 1;
        n2 |= n2 >> 2;
        n2 |= n2 >> 4;
        n2 |= n2 >> 8;
        n2 |= n2 >> 16;
        return n2 + 1;
    }

    @Override
    public Collection<V> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.levelOneMap.clear();
        this.values.clear();
    }

    public V remove(Object object, Object object2) {
        HashMap<K, V> hashMap = this.levelOneMap.get(object);
        V v2 = null;
        if (hashMap != null && (v2 = (V)hashMap.remove(object2)) != null) {
            this.values.remove(v2);
            --this.size;
        }
        return v2;
    }

    public V put(E e2, K k2, V v2) {
        V v3;
        HashMap<K, V> hashMap = this.levelOneMap.get(e2);
        if (hashMap == null) {
            hashMap = new HashMap(4);
            this.levelOneMap.put(e2, hashMap);
        }
        if ((v3 = hashMap.put(k2, v2)) == null) {
            this.values.add(v2);
            ++this.size;
        } else {
            this.values.remove(v3);
            this.values.add(v2);
        }
        return v3;
    }

    public boolean containsKey(Object object, Object object2) {
        HashMap<K, V> hashMap = this.levelOneMap.get(object);
        Object var4_4 = null;
        if (hashMap != null) {
            var4_4 = hashMap.get(object2);
        }
        return var4_4 != null;
    }

    public V get(Object object, Object object2) {
        HashMap<K, V> hashMap = this.levelOneMap.get(object);
        V v2 = null;
        if (hashMap != null) {
            v2 = hashMap.get(object2);
        }
        return v2;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }
}

