/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import org.apache.harmony.security.asn1.ASN1Primitive;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;
import org.apache.harmony.security.asn1.ObjectIdentifier;

public class ASN1Oid
extends ASN1Primitive {
    private static final ASN1Oid ASN1 = new ASN1Oid();
    private static final ASN1Oid STRING_OID = new ASN1Oid(){

        @Override
        public Object getDecodedObject(BerInputStream berInputStream) throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            byte by = berInputStream.buffer[berInputStream.contentOffset];
            int n2 = by & 0x7F;
            int n3 = 0;
            while ((by & 0x80) != 0) {
                by = berInputStream.buffer[berInputStream.contentOffset + ++n3];
                n2 = n2 << 7 | by & 0x7F;
            }
            if (n2 > 79) {
                stringBuffer.append('2');
                stringBuffer.append('.');
                stringBuffer.append(n2 - 80);
            } else {
                stringBuffer.append(n2 / 40);
                stringBuffer.append('.');
                stringBuffer.append(n2 % 40);
            }
            for (int i2 = 2; i2 < berInputStream.oidElement; ++i2) {
                stringBuffer.append('.');
                by = berInputStream.buffer[berInputStream.contentOffset + ++n3];
                n2 = by & 0x7F;
                while ((by & 0x80) != 0) {
                    by = berInputStream.buffer[berInputStream.contentOffset + ++n3];
                    n2 = n2 << 7 | by & 0x7F;
                }
                stringBuffer.append(n2);
            }
            return stringBuffer.toString();
        }

        @Override
        public void setEncodingContent(BerOutputStream berOutputStream) {
            berOutputStream.content = ObjectIdentifier.toIntArray((String)berOutputStream.content);
            super.setEncodingContent(berOutputStream);
        }
    };

    public ASN1Oid() {
        super(6);
    }

    public static ASN1Oid getInstance() {
        return ASN1;
    }

    @Override
    public Object decode(BerInputStream berInputStream) throws IOException {
        berInputStream.readOID();
        if (berInputStream.isVerify) {
            return null;
        }
        return this.getDecodedObject(berInputStream);
    }

    @Override
    public Object getDecodedObject(BerInputStream berInputStream) throws IOException {
        int n2 = berInputStream.oidElement;
        int[] nArray = new int[n2];
        int n3 = 1;
        int n4 = 0;
        while (n3 < nArray.length) {
            byte by = berInputStream.buffer[berInputStream.contentOffset + n4];
            n2 = by & 0x7F;
            while ((by & 0x80) != 0) {
                by = berInputStream.buffer[berInputStream.contentOffset + ++n4];
                n2 = n2 << 7 | by & 0x7F;
            }
            nArray[n3] = n2;
            ++n3;
            ++n4;
        }
        if (nArray[1] > 79) {
            nArray[0] = 2;
            nArray[1] = nArray[1] - 80;
        } else {
            nArray[0] = nArray[1] / 40;
            nArray[1] = nArray[1] % 40;
        }
        return nArray;
    }

    @Override
    public void encodeContent(BerOutputStream berOutputStream) {
        berOutputStream.encodeOID();
    }

    @Override
    public void setEncodingContent(BerOutputStream berOutputStream) {
        int[] nArray = (int[])berOutputStream.content;
        int n2 = 0;
        int n3 = nArray[0] * 40 + nArray[1];
        if (n3 == 0) {
            n2 = 1;
        } else {
            while (n3 > 0) {
                ++n2;
                n3 >>= 7;
            }
        }
        for (int i2 = 2; i2 < nArray.length; ++i2) {
            if (nArray[i2] == 0) {
                ++n2;
                continue;
            }
            for (n3 = nArray[i2]; n3 > 0; n3 >>= 7) {
                ++n2;
            }
        }
        berOutputStream.length = n2;
    }

    public static ASN1Oid getInstanceForString() {
        return STRING_OID;
    }
}

