/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.security.tools.dumpASN1;
import com.ibm.security.tools.dumpASN1Atom;
import com.ibm.security.tools.dumpASN1OidListItem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;

public final class dumpASN1OidList {
    public ArrayList listOfOids;

    public dumpASN1OidList() throws IOException {
        InputStream ocfIS;
        String ocfURLname = "http://steroids/JavaSecurity/PKCS/current/tools/dumpasn1.cfg";
        dumpASN1OidListItem currOLI = null;
        String trimmedStr = new String();
        String tagOID = "OID = ";
        String tagDesc = "Description = ";
        String tagComment = "Comment = ";
        String tagWarn = "Warning";
        this.listOfOids = new ArrayList();
        URL ocfURL = new URL(ocfURLname);
        try {
            ocfIS = ocfURL.openStream();
        }
        catch (FileNotFoundException fnfe) {
            dumpASN1.ps.print("Error: OID definition file " + ocfURLname + " not found. ");
            throw new IOException("Error: OID definition file " + ocfURLname + " not found. ");
        }
        InputStreamReader ocfISR = new InputStreamReader(ocfIS);
        LineNumberReader lnr = new LineNumberReader(ocfISR);
        String str = lnr.readLine();
        while (str != null) {
            int strLen = (str = str.trim()).length();
            if (strLen != 0 && !str.startsWith("#")) {
                if (tagOID.compareToIgnoreCase(str.substring(0, tagOID.length())) == 0) {
                    if (currOLI != null) {
                        if (currOLI.description == null) {
                            throw new IOException("\nOID ending on config file line " + (lnr.getLineNumber() - 1) + " has no description attribute.");
                        }
                        this.listOfOids.add(currOLI);
                    }
                    currOLI = new dumpASN1OidListItem(str.substring(tagOID.length()));
                } else if (strLen >= tagComment.length() && tagComment.compareToIgnoreCase(str.substring(0, tagComment.length())) == 0) {
                    if (currOLI.comment != null) {
                        throw new IOException("\nDuplicate OID comment in config file line " + lnr.getLineNumber());
                    }
                    currOLI.addComment(str.substring(tagComment.length()));
                } else if (strLen >= tagDesc.length() && tagDesc.compareToIgnoreCase(str.substring(0, tagDesc.length())) == 0) {
                    if (currOLI.description != null) {
                        throw new IOException("\nDuplicate OID description in config file line " + lnr.getLineNumber());
                    }
                    currOLI.addDesc(str.substring(tagDesc.length()));
                } else if (strLen >= tagWarn.length() && tagWarn.compareToIgnoreCase(str.substring(0, tagWarn.length())) == 0) {
                    if (currOLI.warning) {
                        throw new IOException("\nDuplicate OID warning in config file line " + lnr.getLineNumber());
                    }
                    currOLI.addWarning();
                }
            }
            str = lnr.readLine();
        }
    }

    public dumpASN1OidListItem getOIDinfo(byte[] oidHexBytes, int oidHexBytesLen) {
        int x;
        dumpASN1OidListItem retOLI = null;
        String oidStr = "";
        String OLIstrSkip2 = "";
        for (x = 0; x < oidHexBytesLen; ++x) {
            if (x != 0) {
                oidStr = oidStr + " ";
            }
            oidStr = oidStr + dumpASN1Atom.hexDigit(oidHexBytes[x]);
        }
        for (x = 0; x < this.listOfOids.size(); ++x) {
            retOLI = (dumpASN1OidListItem)this.listOfOids.get(x);
            OLIstrSkip2 = retOLI.oidString.substring(6);
            if (!OLIstrSkip2.equals(oidStr)) continue;
            return retOLI;
        }
        return null;
    }
}

