/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.ImgJBIG2;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.JBIG2SegmentReader;

public class JBIG2Image {
    public static byte[] getGlobalSegment(RandomAccessFileOrArray randomAccessFileOrArray) {
        try {
            JBIG2SegmentReader jBIG2SegmentReader = new JBIG2SegmentReader(randomAccessFileOrArray);
            jBIG2SegmentReader.read();
            return jBIG2SegmentReader.getGlobal(true);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Image getJbig2Image(RandomAccessFileOrArray randomAccessFileOrArray, int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("The page number must be >= 1.");
        }
        try {
            JBIG2SegmentReader jBIG2SegmentReader = new JBIG2SegmentReader(randomAccessFileOrArray);
            jBIG2SegmentReader.read();
            JBIG2SegmentReader.JBIG2Page jBIG2Page = jBIG2SegmentReader.getPage(n2);
            ImgJBIG2 imgJBIG2 = new ImgJBIG2(jBIG2Page.pageBitmapWidth, jBIG2Page.pageBitmapHeight, jBIG2Page.getData(true), jBIG2SegmentReader.getGlobal(true));
            return imgJBIG2;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static int getNumberOfPages(RandomAccessFileOrArray randomAccessFileOrArray) {
        try {
            JBIG2SegmentReader jBIG2SegmentReader = new JBIG2SegmentReader(randomAccessFileOrArray);
            jBIG2SegmentReader.read();
            return jBIG2SegmentReader.numberOfPages();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }
}

