/*
 * Decompiled with CFR 0.152.
 */
package in.gov.tds.exporter.impl;

import in.gov.tds.beans.FormRequest;
import in.gov.tds.beans.FormResponse;
import in.gov.tds.exception.PDFCreationException;
import in.gov.tds.parser.Form27DParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.util.JRLoader;

public class Form27DExporter {
    public static FormResponse exportForm(FormRequest formRequest, FormResponse formResponse, boolean withDigitalSignature) throws PDFCreationException {
        String generatedFileName = "";
        String footer = null;
        String body = null;
        String outputFileLocation = null;
        Object[] form27DBean = null;
        String assessmentYear = null;
        String deducteePAN = null;
        String periodicity = null;
        StringBuffer sb = null;
        JRBeanArrayDataSource dataSource = null;
        JasperPrint jasperPrint = null;
        URL compiledPathURL = null;
        JarURLConnection jarurl = null;
        InputStream is = null;
        File currentDir = null;
        FileOutputStream outputStream = null;
        String currentPath = null;
        String compiledPath = null;
        File file = null;
        StringBuffer finalOutputfile = null;
        JRPdfExporter pdfExporter = null;
        try {
            footer = formRequest.getFooter();
            body = formRequest.getBody();
            outputFileLocation = formRequest.getOutputFolderPath();
            form27DBean = Form27DParser.parse(body, footer, withDigitalSignature);
            assessmentYear = form27DBean[0].getAssessmentYear();
            deducteePAN = form27DBean[0].getCollecteePAN();
            periodicity = form27DBean[0].getPeriodicity();
            sb = new StringBuffer();
            sb.append(deducteePAN).append("_").append(periodicity).append("_").append(assessmentYear).append(".pdf");
            generatedFileName = sb.toString();
            if (deducteePAN == null || deducteePAN.equalsIgnoreCase("") || deducteePAN.length() == 0) {
                formResponse.setOutputFileName("");
            } else {
                dataSource = new JRBeanArrayDataSource(form27DBean);
                jasperPrint = null;
                compiledPathURL = ClassLoader.class.getResource("/resources/Form-27D.jasper");
                if (compiledPathURL.getPath().lastIndexOf("!") > 0) {
                    System.out.println("in if");
                    jarurl = (JarURLConnection)compiledPathURL.openConnection();
                    is = jarurl.getInputStream();
                    file = new File(String.valueOf(outputFileLocation) + "/resources/Form-27D.jrprint");
                    if (!file.exists()) {
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        file.createNewFile();
                    }
                    outputStream = new FileOutputStream(file);
                    JasperFillManager.fillReportToStream(is, (OutputStream)outputStream, new HashMap<String, Object>(), (JRDataSource)dataSource);
                    if (outputStream != null) {
                        ((OutputStream)outputStream).close();
                    }
                    if (is != null) {
                        is.close();
                    }
                    jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                } else {
                    currentDir = new File("");
                    currentPath = currentDir.getAbsolutePath();
                    compiledPath = String.valueOf(currentPath) + "/resources/Form-27D.jasper";
                    file = new File(String.valueOf(outputFileLocation) + "/resources/Form-27D.jrprint");
                    if (!file.exists()) {
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        file.createNewFile();
                    }
                    JasperFillManager.fillReportToFile(compiledPath, file.getPath(), new HashMap<String, Object>(), (JRDataSource)dataSource);
                    jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                }
                finalOutputfile = new StringBuffer();
                finalOutputfile.append(outputFileLocation);
                finalOutputfile.append("\\");
                finalOutputfile.append(deducteePAN);
                finalOutputfile.append("_");
                finalOutputfile.append(periodicity);
                finalOutputfile.append("_");
                finalOutputfile.append(assessmentYear);
                finalOutputfile.append(".pdf");
                pdfExporter = new JRPdfExporter();
                pdfExporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
                pdfExporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, finalOutputfile.toString());
                pdfExporter.exportReport();
                formResponse.setOutputFileName(generatedFileName);
            }
            FormResponse formResponse2 = formResponse;
            return formResponse2;
        }
        catch (JRException e2) {
            e2.printStackTrace();
            throw new PDFCreationException("JRPrint Creation - Error in creating setting data of PDF");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new PDFCreationException("Error while creating/deleting files");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new PDFCreationException("Error occured due to " + ex.getLocalizedMessage());
        }
        finally {
            generatedFileName = "";
            footer = null;
            body = null;
            outputFileLocation = null;
            if (form27DBean != null && form27DBean.length > 0) {
                form27DBean[0].initializeProperties();
            }
            form27DBean = null;
            assessmentYear = null;
            deducteePAN = null;
            periodicity = null;
            sb = null;
            dataSource = null;
            jasperPrint = null;
            compiledPathURL = null;
            jarurl = null;
            is = null;
            currentDir = null;
            outputStream = null;
            currentPath = null;
            compiledPath = null;
            file = null;
            finalOutputfile = null;
            pdfExporter = null;
        }
    }
}

