/*
 * Decompiled with CFR 0.152.
 */
package in.gov.tds.pdfgenerator;

import emascertviewer.CertViewer;
import in.gov.tds.pdfgenerator.CreatePDFTask;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import util.DialogBox;
import util.GUIUtils;
import util.KeyStoreTable;
import util.KeyStoreUtils;

public class PDFSigner
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String PUBLIC_KEY_STRING = "30819f300d06092a864886f70d010101050003818d0030818902818100c046c160d003f25d428411c8ca56f7ab15b125be9d586f3386ad67913b5bd85193f2211d4409bddc2071f5e44ffa9bdaccec168f184fa14a19fe753f1e78e384215dbebeb4c09f29dac859b84ab2ae85b488aaf102593f71e64d43ba3d16784990dd7cd99b530c78d72131598e0c0885f310c1c948d30d1d9d049818c817da730203010001";
    private String certificateName = null;
    private String validity = null;
    private String issuerName = null;
    private String selectedCertificate = null;
    private String subjectName = null;
    private String imagePath = null;
    private File outputTargetDirectory = null;
    JLabel labelImage;
    String signerType = null;
    private JButton jButtonCancel;
    private JButton jButtonProceed;
    private JLabel jLabelCertName;
    private JLabel jLabelDefaultOutputFolder;
    private JLabel jLabelIssuerName;
    private JLabel jLabelValidity;
    private JPanel jPanelDisplayImage;
    private JPanel jPanelImage;
    private JTextField jTextFieldInputFile;
    private JTextField jTextFieldOutputFolder;
    private JLabel jLabelProgressBar;
    ImageIcon cancelIcon;
    ImageIcon saveIcon;
    private JPasswordField jinputFilePasswordField;
    private JTextField targetField;
    private JPanel wizardPanel;
    private JComponent panel2 = null;
    private JPanel panel = null;
    private KeyStore keyStore = null;
    private KeyStoreTable storeTable;
    private KeyStoreTable softTokenstoreTable;
    private JPanel softTokenCertificatePanel;
    private CertViewer me = null;
    private String certSelected = null;
    PrivateKey privateKey = null;
    Certificate[] certificateChain = null;
    private JLabel jLabelProgressBarStatus;
    String destinationFilePath = "";
    boolean withDigitalSignature = true;
    List<String> filesCreated;

    public PDFSigner() {
        super("TRACES PDF Generation Utility V1.4L");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initComponents();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(GUIUtils.class.getClassLoader().getResource("images/cpctds-logo.jpg")));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w2 = this.getWidth();
        int h2 = this.getHeight() + 75;
        this.setLocation((screenSize.width - w2) / 2, (screenSize.height + 50 - h2) / 2);
        GridLayout imagesLayout = new GridLayout(1, 2);
        this.jPanelImage.setLayout(imagesLayout);
        this.jPanelImage.setBackground(Color.WHITE);
        Dimension verticalLogoDim = new Dimension(100, 75);
        ImageIcon icon1 = GUIUtils.getImageIcon("images/tds-logo.png", "logo");
        JLabel logoLabel = new JLabel();
        logoLabel.setIcon(icon1);
        logoLabel.setPreferredSize(verticalLogoDim);
        ImageIcon icon2 = GUIUtils.getImageIcon("images/blank.gif", "logo");
        JLabel othersLabel = new JLabel();
        othersLabel.setIcon(icon2);
        othersLabel.setPreferredSize(verticalLogoDim);
        this.jPanelImage.add((Component)logoLabel, "Center");
        this.jPanelImage.add((Component)othersLabel, "West");
        if (this.imagePath != null && new File(this.imagePath).exists()) {
            ImageIcon icon = new ImageIcon(this.imagePath);
            this.labelImage = new JLabel();
            Dimension labelDim = new Dimension(223, 100);
            this.labelImage.setIcon(icon);
            this.labelImage.setPreferredSize(labelDim);
            this.jPanelDisplayImage.setLayout(new GridLayout(1, 0));
            this.jPanelDisplayImage.setBackground(Color.WHITE);
            this.jPanelDisplayImage.add((Component)this.labelImage, "Center");
            icon = null;
            labelDim = null;
        }
        this.saveIcon = GUIUtils.getImageIcon("images/greentrans2.jpg", "Proceed");
        this.cancelIcon = GUIUtils.getImageIcon("images/critical.png", "Cancel");
        this.jButtonCancel.setIcon(this.cancelIcon);
        this.jButtonProceed.setIcon(this.saveIcon);
        this.jLabelCertName.setText(this.subjectName);
        this.jLabelValidity.setText(this.validity);
        this.jLabelIssuerName.setText(this.issuerName);
        this.setResizable(false);
        verticalLogoDim = null;
        logoLabel = null;
        icon2 = null;
        othersLabel = null;
        imagesLayout = null;
        screenSize = null;
    }

    private void jButtonInputFolderActionPerformed(ActionEvent evt) {
        File[] inputTargetDirectories = null;
        File inputTargetDirectory = null;
        File inputDirectoryName = null;
        String inputFileListNames = null;
        try {
            inputTargetDirectories = this.InputFileChooser();
            inputTargetDirectory = inputTargetDirectories[0];
            if (inputTargetDirectory != null && !(inputDirectoryName = new File(inputTargetDirectory.getAbsolutePath())).exists()) {
                JOptionPane.showMessageDialog(this, "The input file does not exists");
                return;
            }
            try {
                inputFileListNames = "";
                if (inputTargetDirectories != null && inputTargetDirectories.length > 0) {
                    inputFileListNames = inputTargetDirectories[0].getAbsolutePath();
                    int i2 = 1;
                    while (i2 < inputTargetDirectories.length) {
                        inputFileListNames = String.valueOf(inputFileListNames) + "," + inputTargetDirectories[i2].getAbsolutePath();
                        ++i2;
                    }
                }
                this.jTextFieldInputFile.setText(inputFileListNames);
            }
            catch (Exception exception) {}
        }
        finally {
            inputTargetDirectory = null;
            inputDirectoryName = null;
            inputFileListNames = null;
            inputTargetDirectories = null;
        }
    }

    public File P12Chooser() {
        try {
            JFileChooser jfc = new JFileChooser();
            jfc.setDialogTitle("Select a File ");
            jfc.setDialogType(0);
            jfc.setFileFilter(new P12Filter());
            jfc.setMultiSelectionEnabled(false);
            jfc.setFileSelectionMode(0);
            int status = jfc.showDialog(this.wizardPanel, "OK");
            if (status == 0) {
                return jfc.getSelectedFile();
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private void softTokenBrowseButtonActionPerformed(ActionEvent evt) {
        this.keyStore = null;
        File targetDirectory = this.P12Chooser();
        if (targetDirectory == null) {
            return;
        }
        if (this.keyStore == null) {
            try {
                boolean firstAsk = true;
                char[] pass = DialogBox.askPassword(this, "Enter the token Password.", firstAsk);
                if (pass == null) {
                    return;
                }
                firstAsk = false;
                this.keyStore = KeyStoreUtils.getPKCS12Store(targetDirectory, pass);
                while (this.keyStore == null) {
                    pass = DialogBox.askPassword(this, "Enter the correct token password.", true);
                    if (pass == null) {
                        JOptionPane.showMessageDialog(this, "The operation is cancelled");
                        return;
                    }
                    this.keyStore = KeyStoreUtils.getPKCS12Store(targetDirectory, pass);
                    if (this.keyStore != null) continue;
                }
                String alias = null;
                try {
                    Enumeration<String> it = this.keyStore.aliases();
                    while (it.hasMoreElements()) {
                        alias = it.nextElement();
                    }
                    this.privateKey = (PrivateKey)this.keyStore.getKey(alias, pass);
                    this.certificateChain = this.keyStore.getCertificateChain(alias);
                }
                catch (KeyStoreException it) {
                }
                catch (UnrecoverableKeyException it) {
                }
                catch (NoSuchAlgorithmException it) {
                    // empty catch block
                }
                try {
                    this.softTokenstoreTable = new KeyStoreTable(this.keyStore);
                }
                catch (CertificateException e2) {
                    DialogBox.showWarningBox(this, "This is not a valid certificate. There is no private key associated with this certificate.");
                    targetDirectory = null;
                    return;
                }
                try {
                    this.targetField.setText(targetDirectory.getAbsolutePath());
                    this.softTokenCertificatePanel.removeAll();
                    JScrollPane pkcsPane = new JScrollPane(this.softTokenstoreTable);
                    pkcsPane.setVerticalScrollBarPolicy(20);
                    pkcsPane.setHorizontalScrollBarPolicy(30);
                    pkcsPane.getViewport().setPreferredSize(new Dimension(500, 20));
                    pkcsPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10), BorderFactory.createBevelBorder(1)));
                    this.softTokenCertificatePanel.add(pkcsPane);
                    this.softTokenCertificatePanel.revalidate();
                    this.softTokenCertificatePanel.repaint();
                }
                catch (KeyStoreException keyStoreException) {}
            }
            finally {
                targetDirectory = null;
            }
        }
    }

    private void jButtonOutputFolderActionPerformed(ActionEvent evt) {
        this.outputTargetDirectory = this.targetDirectoryChooser();
        if (this.outputTargetDirectory == null) {
            this.jLabelDefaultOutputFolder.setVisible(true);
            this.jTextFieldOutputFolder.setText("");
        } else {
            File outputDirectoryName = null;
            outputDirectoryName = new File(this.outputTargetDirectory.getAbsolutePath());
            if (!outputDirectoryName.exists() || !outputDirectoryName.isDirectory()) {
                JOptionPane.showMessageDialog(this, "The destination folder you are selecting does not exists or the destination selected is not a folder");
                return;
            }
            this.jTextFieldOutputFolder.setText(this.outputTargetDirectory.getAbsolutePath());
            if (!this.jTextFieldOutputFolder.getText().equals("")) {
                this.jLabelDefaultOutputFolder.setVisible(false);
            }
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        int result = JOptionPane.showConfirmDialog(this, "Do you want to exit from TRACES-PDF Generation Utility?", "Cancel", 0, 3);
        if (result == 0) {
            System.exit(0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void jButtonProceedActionPerformed(ActionEvent evt) {
        this.destinationFilePath = "";
        this.withDigitalSignature = true;
        errorList = new ArrayList<String>();
        if (this.jTextFieldInputFile.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Please select the input file");
            this.jTextFieldInputFile.requestFocusInWindow();
            return;
        }
        if (this.jinputFilePasswordField.getPassword() == null || this.jinputFilePasswordField.getPassword().length <= 0) {
            JOptionPane.showMessageDialog(this, "Please provide the password for the input file");
            this.jinputFilePasswordField.setText("");
            this.jinputFilePasswordField.requestFocusInWindow();
            return;
        }
        if (this.jTextFieldOutputFolder.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Please select the output folder");
            this.jTextFieldOutputFolder.requestFocusInWindow();
            return;
        }
        if (!(this.softTokenstoreTable != null && this.softTokenstoreTable.getRowCount() >= 0 || this.storeTable != null && this.storeTable.getSelectedRow() >= 0 && this.storeTable.getSelectedEntry() != null)) {
            continueSigning = JOptionPane.showConfirmDialog(this, "Do you want to continue without Digital Signature?", "", 0);
            if (continueSigning == 1) {
                return;
            }
            this.withDigitalSignature = false;
        }
        inputFileList = this.jTextFieldInputFile.getText().split(",");
        inputFileListCount = inputFileList.length;
        totalFilesCounter = 0;
        isValidVersion = false;
        verified = false;
        zipFile = null;
        password = new String(this.jinputFilePasswordField.getPassword());
        destination = String.valueOf(this.outputTargetDirectory.getAbsolutePath()) + File.separator + "temp";
        testPwd = new File(destination);
        if (!testPwd.exists()) {
            testPwd.mkdirs();
        }
        zipcounter = 0;
        while (zipcounter < inputFileListCount) {
            block42: {
                block46: {
                    block45: {
                        block43: {
                            block44: {
                                block41: {
                                    sourceFilePath = new File(inputFileList[zipcounter]);
                                    zipFileName = sourceFilePath.getName();
                                    if (!sourceFilePath.exists()) {
                                        if (testPwd.exists() && testPwd.isDirectory()) {
                                            CreatePDFTask.removeFiles(testPwd);
                                        }
                                        errorList.add("The input file " + zipFileName + " does not exists");
                                    } else {
                                        block40: {
                                            zipFile = new ZipFile(sourceFilePath.getAbsolutePath());
                                            if (zipFile.isValidZipFile()) break block40;
                                            if (testPwd.exists() && testPwd.isDirectory()) {
                                                CreatePDFTask.removeFiles(testPwd);
                                            }
                                            errorList.add("Please select the ZIP file downloaded from TRACES");
                                            zipFile = null;
                                        }
                                        try {
                                            try {
                                                if (zipFile.isEncrypted()) {
                                                    zipFile.setPassword(password);
                                                }
                                                zipFile.extractAll(destination);
                                                break block41;
                                            }
                                            catch (ZipException e) {
                                                if (testPwd.exists() && testPwd.isDirectory()) {
                                                    CreatePDFTask.removeFiles(testPwd);
                                                }
                                                errorList.add("Incorrect Password of the file " + zipFileName);
                                                if (testPwd.exists() && testPwd.isDirectory()) {
                                                    CreatePDFTask.removeFiles(testPwd);
                                                }
                                                zipFile = null;
                                            }
                                        }
                                        catch (Throwable var16_22) {
                                            zipFile = null;
                                            throw var16_22;
                                        }
                                    }
                                    break block42;
                                }
                                zipFile = null;
                                if (!this.jTextFieldOutputFolder.getText().equals("") && !(destinationDirectoryPath = new File(this.jTextFieldOutputFolder.getText())).exists()) {
                                    if (testPwd.exists() && testPwd.isDirectory()) {
                                        CreatePDFTask.removeFiles(testPwd);
                                    }
                                    errorList.add("The destination folder you are selecting does not exists");
                                    this.jTextFieldOutputFolder.setText("");
                                    this.jTextFieldOutputFolder.requestFocusInWindow();
                                    this.jLabelDefaultOutputFolder.setVisible(true);
                                    return;
                                }
                                if (!testPwd.exists() || !testPwd.isDirectory()) break block43;
                                if (testPwd.list().length == 1) break block44;
                                if (testPwd.exists() && testPwd.isDirectory()) {
                                    CreatePDFTask.removeFiles(testPwd);
                                }
                                errorList.add("Error while uncompressing the ZIP file" + zipFileName);
                                break block42;
                            }
                            this.destinationFilePath = String.valueOf(destination) + File.separator + testPwd.list()[0];
                        }
                        if (isValidVersion = this.checkFileVersion(this.destinationFilePath)) break block45;
                        if (testPwd.exists() && testPwd.isDirectory()) {
                            CreatePDFTask.removeFiles(testPwd);
                        }
                        errorList.add("Please place a download request again for the file " + zipFileName + " as this version is not compatible with the PDF Converter Utility");
                        sourceFilePath = null;
                        this.destinationFilePath = null;
                        break block42;
                    }
                    verified = this.checkSignature(this.destinationFilePath);
                    if (verified) break block46;
                    if (testPwd.exists() && testPwd.isDirectory()) {
                        CreatePDFTask.removeFiles(testPwd);
                    }
                    errorList.add("The input file " + zipFileName + " is tampered");
                    sourceFilePath = null;
                    this.destinationFilePath = null;
                    this.withDigitalSignature = false;
                    break block42;
                }
                if (zipcounter == 0) {
                    this.jButtonProceed.setEnabled(false);
                    this.jButtonCancel.setEnabled(false);
                    this.jLabelProgressBar.setText("PDF creation in progress");
                    continueworking = JOptionPane.showConfirmDialog(this, "Starting PDF Generation", "", 2);
                    if (continueworking == 2) {
                        this.jLabelProgressBar.setText("");
                        this.jButtonProceed.setEnabled(true);
                        this.jButtonCancel.setEnabled(true);
                        f1 = new File(String.valueOf(this.outputTargetDirectory.getAbsolutePath()) + File.separator + "temp");
                        if (f1.exists() && f1.isDirectory()) {
                            var20_29 = f1.listFiles();
                            var19_30 = var20_29.length;
                            var18_31 = 0;
                            while (var18_31 < var19_30) {
                                del = var20_29[var18_31];
                                del.delete();
                                ++var18_31;
                            }
                            f1.delete();
                        }
                        return;
                    }
                }
                task = new CreatePDFTask(this.destinationFilePath, this.withDigitalSignature, this.outputTargetDirectory, this.privateKey, this.certificateChain, this);
                task.execute();
                taskDone = task.isDone();
                try {
                    this.filesCreated = (List)task.get();
                    if (true) ** GOTO lbl166
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break block42;
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    break block42;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block42;
                }
                do {
                    taskDone = task.isDone();
lbl166:
                    // 2 sources

                } while (!taskDone);
                taskDone = task.isDone();
                if (this.filesCreated != null) {
                    count = this.filesCreated.size();
                    totalFilesCounter += count;
                }
                zipFileName = null;
                if (testPwd.exists() && testPwd.isDirectory()) {
                    CreatePDFTask.removeFiles(testPwd);
                }
                this.deleteTempFiles();
            }
            ++zipcounter;
        }
        errorMessages = new StringBuilder();
        i = 0;
        while (i < errorList.size()) {
            errorMessages.append((String)errorList.get(i));
            errorMessages.append("\n");
            ++i;
        }
        if (totalFilesCounter == 1) {
            JOptionPane.showMessageDialog(this, errorMessages.append(String.valueOf(totalFilesCounter) + " PDF is generated sucessfully.").toString());
        } else {
            JOptionPane.showMessageDialog(this, errorMessages.append(String.valueOf(totalFilesCounter) + " PDFs are generated sucessfully.").toString());
        }
        this.deleteTempFiles();
        this.jButtonProceed.setEnabled(true);
        this.jButtonCancel.setEnabled(true);
        this.jLabelProgressBar.setText("");
        this.jTextFieldInputFile.setText("");
        sourceFilePath = null;
        this.jTextFieldOutputFolder.setText("");
        this.jinputFilePasswordField.setText("");
        this.withDigitalSignature = false;
        if (this.softTokenstoreTable != null && this.softTokenstoreTable.getRowCount() > 0) {
            this.softTokenstoreTable.removeAll();
            this.softTokenstoreTable.clearSelection();
            this.softTokenstoreTable = null;
        }
        this.softTokenCertificatePanel.removeAll();
        this.targetField.setText("");
        password = null;
        if (this.storeTable != null && this.storeTable.getSelectedRow() >= 0) {
            this.storeTable.clearSelection();
        }
        this.validate();
        this.repaint();
    }

    private void deleteTempFiles() {
        int n2;
        File f1 = new File(String.valueOf(this.outputTargetDirectory.getAbsolutePath()) + File.separator + "temp");
        if (f1.exists() && f1.isDirectory()) {
            File[] fileArray = f1.listFiles();
            int n3 = fileArray.length;
            int n4 = 0;
            while (n4 < n3) {
                File del = fileArray[n4];
                if (del.isDirectory()) {
                    File[] fileArray2 = del.listFiles();
                    int n5 = fileArray2.length;
                    n2 = 0;
                    while (n2 < n5) {
                        File delf = fileArray2[n2];
                        delf.delete();
                        ++n2;
                    }
                }
                del.delete();
                ++n4;
            }
            f1.delete();
        }
        String outputTargetPath = this.outputTargetDirectory.getAbsolutePath();
        File currentDir = new File(outputTargetPath);
        String currentPath = currentDir.getAbsolutePath();
        if ((currentDir = new File(String.valueOf(currentPath) + File.separator + "resources")).exists() && currentDir.isDirectory()) {
            File[] fileArray = currentDir.listFiles();
            n2 = fileArray.length;
            int n6 = 0;
            while (n6 < n2) {
                File ff = fileArray[n6];
                if (ff.isFile() && ff.getAbsolutePath().endsWith(".jrprint")) {
                    ff.delete();
                }
                ++n6;
            }
            currentDir.delete();
        }
    }

    private boolean checkSignature(String destinationFilePath2) {
        boolean verified = false;
        StringBuffer fileData = new StringBuffer(1000);
        File file = new File(destinationFilePath2);
        BufferedReader reader = null;
        String readData = null;
        Signature sign = null;
        PublicKey publicKey = null;
        MessageDigest messageDigest = null;
        String fileContents = null;
        byte[] totalBytes = null;
        byte[] bytesWithoutSignature = null;
        byte[] signatureBytes = null;
        byte[] digestedBytes = null;
        byte[] publicKeyBytes = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                char[] buf = new char[1024];
                int numRead = 0;
                while ((numRead = reader.read(buf)) != -1) {
                    readData = String.valueOf(buf, 0, numRead);
                    fileData.append(readData);
                    buf = new char[1024];
                }
                reader.close();
                totalBytes = fileData.toString().getBytes();
                bytesWithoutSignature = Arrays.copyOfRange(totalBytes, 0, totalBytes.length - 256);
                signatureBytes = Arrays.copyOfRange(totalBytes, totalBytes.length - 256, totalBytes.length);
                fileContents = new String(bytesWithoutSignature);
                fileContents = fileContents.trim();
                messageDigest = MessageDigest.getInstance("SHA-1");
                digestedBytes = messageDigest.digest(fileContents.toString().getBytes());
                publicKeyBytes = PDFSigner.hexToBytes(PUBLIC_KEY_STRING);
                publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKeyBytes));
                sign = Signature.getInstance("SHA1withRSA");
                sign.initVerify(publicKey);
                sign.update(digestedBytes);
                verified = sign.verify(PDFSigner.hexToBytes(new String(signatureBytes)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileData = null;
                reader = null;
                readData = null;
                sign = null;
                publicKey = null;
                fileContents = null;
                messageDigest = null;
                totalBytes = null;
                totalBytes = null;
                bytesWithoutSignature = null;
                signatureBytes = null;
                digestedBytes = null;
                publicKeyBytes = null;
            }
            catch (IOException iOException) {
                fileData = null;
                reader = null;
                readData = null;
                sign = null;
                publicKey = null;
                fileContents = null;
                messageDigest = null;
                totalBytes = null;
                totalBytes = null;
                bytesWithoutSignature = null;
                signatureBytes = null;
                digestedBytes = null;
                publicKeyBytes = null;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                fileData = null;
                reader = null;
                readData = null;
                sign = null;
                publicKey = null;
                fileContents = null;
                messageDigest = null;
                totalBytes = null;
                totalBytes = null;
                bytesWithoutSignature = null;
                signatureBytes = null;
                digestedBytes = null;
                publicKeyBytes = null;
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                fileData = null;
                reader = null;
                readData = null;
                sign = null;
                publicKey = null;
                fileContents = null;
                messageDigest = null;
                totalBytes = null;
                totalBytes = null;
                bytesWithoutSignature = null;
                signatureBytes = null;
                digestedBytes = null;
                publicKeyBytes = null;
            }
            catch (InvalidKeyException invalidKeyException) {
                fileData = null;
                reader = null;
                readData = null;
                sign = null;
                publicKey = null;
                fileContents = null;
                messageDigest = null;
                totalBytes = null;
                totalBytes = null;
                bytesWithoutSignature = null;
                signatureBytes = null;
                digestedBytes = null;
                publicKeyBytes = null;
            }
            catch (SignatureException signatureException) {
                fileData = null;
                reader = null;
                readData = null;
                sign = null;
                publicKey = null;
                fileContents = null;
                messageDigest = null;
                totalBytes = null;
                totalBytes = null;
                bytesWithoutSignature = null;
                signatureBytes = null;
                digestedBytes = null;
                publicKeyBytes = null;
            }
        }
        finally {
            fileData = null;
            reader = null;
            readData = null;
            sign = null;
            publicKey = null;
            fileContents = null;
            messageDigest = null;
            totalBytes = null;
            totalBytes = null;
            bytesWithoutSignature = null;
            signatureBytes = null;
            digestedBytes = null;
            publicKeyBytes = null;
        }
        return verified;
    }

    private static byte[] hexToBytes(String hex) {
        return PDFSigner.hexToBytes(hex.toCharArray());
    }

    private static byte[] hexToBytes(char[] hex) {
        int length = hex.length / 2;
        byte[] raw = new byte[length];
        int i2 = 0;
        while (i2 < length) {
            int low;
            int high = Character.digit(hex[i2 * 2], 16);
            int value = high << 4 | (low = Character.digit(hex[i2 * 2 + 1], 16));
            if (value > 127) {
                value -= 256;
            }
            raw[i2] = (byte)value;
            ++i2;
        }
        return raw;
    }

    private void jTextFieldOutputFolderKeyReleased(KeyEvent evt) {
        if (this.jTextFieldOutputFolder.getText().isEmpty()) {
            this.jLabelDefaultOutputFolder.setVisible(true);
            this.outputTargetDirectory = null;
        } else {
            this.jLabelDefaultOutputFolder.setVisible(false);
        }
    }

    public File[] InputFileChooser() {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Select a File");
        jfc.setDialogType(0);
        jfc.setMultiSelectionEnabled(true);
        jfc.setFileFilter(new ZipFilter());
        jfc.setFileSelectionMode(0);
        int status = jfc.showDialog(this, "OK");
        if (status == 0) {
            return jfc.getSelectedFiles();
        }
        return null;
    }

    public File targetDirectoryChooser() {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Select a Folder");
        jfc.setDialogType(0);
        jfc.setMultiSelectionEnabled(false);
        jfc.setFileSelectionMode(1);
        int status = jfc.showDialog(this, "OK");
        if (status == 0) {
            return jfc.getSelectedFile();
        }
        return null;
    }

    public void setCertificateName(String certName, String aliasName) {
        this.certificateName = aliasName.trim();
        this.jLabelCertName.setText(certName);
    }

    public void setValidity(String validDate) {
        this.validity = validDate;
        this.jLabelValidity.setText(validDate);
    }

    public void setIssuerName(String issuerName) {
        this.issuerName = issuerName;
        this.jLabelIssuerName.setText(issuerName);
    }

    public void setSelectedcertificate(String cert) {
        this.selectedCertificate = cert;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
        if (imagePath.equals("")) {
            this.jPanelDisplayImage.setVisible(false);
        } else {
            this.jPanelDisplayImage.setVisible(true);
            if (this.labelImage != null) {
                this.jPanelDisplayImage.remove(this.labelImage);
            }
            this.jPanelDisplayImage.revalidate();
            this.jPanelDisplayImage.repaint();
            ImageIcon icon = new ImageIcon(imagePath);
            this.labelImage = new JLabel();
            Dimension labelDim = new Dimension(233, 100);
            this.labelImage.setIcon(icon);
            this.labelImage.setPreferredSize(labelDim);
            this.jPanelDisplayImage.setLayout(new GridLayout(1, 0));
            this.jPanelDisplayImage.setBackground(Color.WHITE);
            this.jPanelDisplayImage.add((Component)this.labelImage, "Center");
            this.jPanelDisplayImage.revalidate();
            this.jPanelDisplayImage.repaint();
        }
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public String getSignerType() {
        return this.signerType;
    }

    public void setSignerType(String signerType) {
        this.signerType = signerType;
    }

    public static void main(String[] args) {
        PDFSigner pdfSigner = new PDFSigner();
        pdfSigner.setSignerType("EVAL");
        pdfSigner.setVisible(true);
    }

    public KeyStoreTable getStoreTable() {
        return this.storeTable;
    }

    public KeyStoreTable getSoftTokenstoreTable() {
        return this.softTokenstoreTable;
    }

    private void initComponents() {
        JPanel jPanelPDFSigner = new JPanel();
        this.jPanelImage = new JPanel();
        JPanel jPanelFolderSelection = new JPanel();
        JLabel folderSelectionHeaderLabel = new JLabel();
        JLabel inputfileLabel = new JLabel();
        JLabel outputfilderLabel = new JLabel();
        this.jTextFieldInputFile = new JTextField(20);
        JButton jButtonInputFolder = new JButton();
        this.jTextFieldOutputFolder = new JTextField();
        JButton jButtonOutputFolder = new JButton();
        this.jLabelDefaultOutputFolder = new JLabel();
        JSeparator jSeparator2 = new JSeparator();
        this.jLabelCertName = new JLabel();
        this.jLabelIssuerName = new JLabel();
        this.jLabelValidity = new JLabel();
        this.jPanelDisplayImage = new JPanel();
        JSeparator jSeparator5 = new JSeparator();
        JPanel jPanelButton = new JPanel();
        this.jButtonProceed = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabelProgressBar = new JLabel();
        JLabel inputfilePasswordLabel = new JLabel();
        this.jinputFilePasswordField = new JPasswordField(5);
        JPanel jPanelSoftTokenCertificate = new JPanel();
        JPanel jPanelCertificateStore = new JPanel();
        JLabel jLabelsoftToken = new JLabel();
        JLabel jLabelcertificateStore = new JLabel();
        this.targetField = new JTextField(20);
        JButton softTokenBrowseButton = new JButton();
        JLabel softTokenInputFile = new JLabel();
        CardLayout wizardCardLayout = new CardLayout();
        this.wizardPanel = new JPanel(wizardCardLayout);
        JPanel fileBrowsepanel = new JPanel();
        this.softTokenCertificatePanel = new JPanel();
        JLabel orLabel = new JLabel();
        JButton viewCertButton = new JButton("View Certificate");
        this.jLabelProgressBarStatus = new JLabel();
        this.setDefaultCloseOperation(3);
        GroupLayout jPanelImageLayout = new GroupLayout(this.jPanelImage);
        this.jPanelImage.setLayout(jPanelImageLayout);
        jPanelImageLayout.setHorizontalGroup(jPanelImageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 608, Short.MAX_VALUE));
        jPanelImageLayout.setVerticalGroup(jPanelImageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 65, Short.MAX_VALUE));
        jPanelImageLayout = null;
        folderSelectionHeaderLabel.setFont(new Font("Tahoma", 1, 11));
        folderSelectionHeaderLabel.setText("File / Folder Selection");
        inputfileLabel.setText("Select Form 27D ZIP file");
        this.jTextFieldInputFile.setColumns(40);
        outputfilderLabel.setText("Save to folder");
        this.jTextFieldOutputFolder.setColumns(40);
        inputfilePasswordLabel.setText("Password for input file");
        this.jinputFilePasswordField.setColumns(10);
        jButtonInputFolder.setText("Browse");
        try {
            try {
                jButtonInputFolder.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        PDFSigner.this.jButtonInputFolderActionPerformed(evt);
                    }
                });
                this.jTextFieldOutputFolder.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent evt) {
                        PDFSigner.this.jTextFieldOutputFolderKeyReleased(evt);
                    }
                });
                jButtonOutputFolder.setText("Browse");
                jButtonOutputFolder.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        PDFSigner.this.jButtonOutputFolderActionPerformed(evt);
                    }
                });
                GroupLayout jPanelFolderSelectionLayout = new GroupLayout(jPanelFolderSelection);
                jPanelFolderSelection.setLayout(jPanelFolderSelectionLayout);
                jPanelFolderSelectionLayout.setHorizontalGroup(jPanelFolderSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFolderSelectionLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFolderSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFolderSelectionLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanelFolderSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(inputfileLabel).addComponent(inputfilePasswordLabel).addComponent(outputfilderLabel)).addGap(10, 10, 10).addGroup(jPanelFolderSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.jTextFieldInputFile, -2, -2, -2).addComponent(this.jinputFilePasswordField, -2, -2, -2).addComponent(this.jTextFieldOutputFolder, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelFolderSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jButtonInputFolder).addComponent(jButtonOutputFolder))).addComponent(folderSelectionHeaderLabel)).addContainerGap(46, Short.MAX_VALUE)));
                jPanelFolderSelectionLayout.setVerticalGroup(jPanelFolderSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFolderSelectionLayout.createSequentialGroup().addComponent(folderSelectionHeaderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelFolderSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(inputfileLabel).addComponent(this.jTextFieldInputFile, -2, -1, -2).addComponent(jButtonInputFolder)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelFolderSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(inputfilePasswordLabel).addComponent(this.jinputFilePasswordField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelFolderSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(outputfilderLabel).addComponent(this.jTextFieldOutputFolder, -2, -1, -2).addComponent(jButtonOutputFolder)).addContainerGap(-1, Short.MAX_VALUE)));
                jPanelFolderSelectionLayout = null;
                jLabelsoftToken.setFont(new Font("Tahoma", 1, 11));
                jLabelsoftToken.setText("Soft Token (Digital Signature Details)");
                softTokenInputFile.setText("Select P12 file");
                softTokenBrowseButton.setText("Browse");
                softTokenBrowseButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        PDFSigner.this.softTokenBrowseButtonActionPerformed(evt);
                    }
                });
                fileBrowsepanel.add(softTokenInputFile);
                fileBrowsepanel.add(this.targetField);
                fileBrowsepanel.add(softTokenBrowseButton);
                fileBrowsepanel.add(orLabel);
                orLabel.setFont(new Font("Tahoma", 1, 11));
                orLabel.setText("OR Select from Certificate Store below");
                GroupLayout jPanelSoftTokenCertificateLayout = new GroupLayout(jPanelSoftTokenCertificate);
                jPanelSoftTokenCertificate.setLayout(jPanelSoftTokenCertificateLayout);
                jPanelSoftTokenCertificateLayout.setHorizontalGroup(jPanelSoftTokenCertificateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSoftTokenCertificateLayout.createSequentialGroup().addContainerGap().addGroup(jPanelSoftTokenCertificateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSoftTokenCertificateLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(jPanelSoftTokenCertificateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(fileBrowsepanel, -2, -1, -2).addComponent(this.softTokenCertificatePanel, -2, -1, -2))).addComponent(jLabelsoftToken)).addContainerGap(6, Short.MAX_VALUE)));
                jPanelSoftTokenCertificateLayout.setVerticalGroup(jPanelSoftTokenCertificateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSoftTokenCertificateLayout.createSequentialGroup().addComponent(jLabelsoftToken).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(fileBrowsepanel, -2, -1, -2).addComponent(this.softTokenCertificatePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelSoftTokenCertificateLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)).addContainerGap(-1, Short.MAX_VALUE)));
                jPanelSoftTokenCertificateLayout = null;
                String osName = System.getProperty("os.name");
                if (osName.contains("Windows")) {
                    this.panel2 = this.displayCertificateStore();
                }
                jLabelcertificateStore.setFont(new Font("Tahoma", 1, 11));
                jLabelcertificateStore.setText("Certificate Store");
                viewCertButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        PDFSigner.this.viewActionPerformed(evt);
                    }
                });
                GroupLayout jPanelCertificateStoreLayout = new GroupLayout(jPanelCertificateStore);
                jPanelCertificateStore.setLayout(jPanelCertificateStoreLayout);
                jPanelCertificateStoreLayout.setHorizontalGroup(jPanelCertificateStoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelCertificateStoreLayout.createSequentialGroup().addContainerGap().addGroup(jPanelCertificateStoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelCertificateStoreLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(jPanelCertificateStoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.panel2, -2, -2, -2).addGap(5, 5, 5).addComponent(viewCertButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addComponent(jLabelcertificateStore)).addContainerGap(46, Short.MAX_VALUE)));
                jPanelCertificateStoreLayout.setVerticalGroup(jPanelCertificateStoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelCertificateStoreLayout.createSequentialGroup().addComponent(jLabelcertificateStore).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelCertificateStoreLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.panel2, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelCertificateStoreLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(viewCertButton, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addContainerGap(-1, Short.MAX_VALUE)));
                jPanelCertificateStoreLayout = null;
                this.jPanelDisplayImage.setMaximumSize(new Dimension(233, 100));
                GroupLayout jPanelDisplayImageLayout = new GroupLayout(this.jPanelDisplayImage);
                this.jPanelDisplayImage.setLayout(jPanelDisplayImageLayout);
                jPanelDisplayImageLayout.setHorizontalGroup(jPanelDisplayImageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 233, Short.MAX_VALUE));
                jPanelDisplayImageLayout.setVerticalGroup(jPanelDisplayImageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
                this.jButtonProceed.setText("Proceed");
                this.jButtonProceed.setHorizontalAlignment(4);
                this.jButtonProceed.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        PDFSigner.this.jButtonProceedActionPerformed(evt);
                    }
                });
                this.jButtonCancel.setText("Cancel");
                this.jButtonCancel.setHorizontalAlignment(4);
                this.jButtonCancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        PDFSigner.this.jButtonCancelActionPerformed(evt);
                    }
                });
                this.jLabelProgressBar.setFont(new Font("Tahoma", 1, 11));
                this.jLabelProgressBarStatus.setFont(new Font("Tahoma", 1, 11));
                GroupLayout jPanelButtonLayout = new GroupLayout(jPanelButton);
                jPanelButton.setLayout(jPanelButtonLayout);
                jPanelButtonLayout.setHorizontalGroup(jPanelButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelButtonLayout.createSequentialGroup().addGap(188, 188, 188).addComponent(this.jLabelProgressBar, -2, 150, -2).addGap(5, 5, 5).addComponent(this.jLabelProgressBarStatus, -2, 20, -2).addGap(5, 5, 5).addComponent(this.jButtonProceed).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addContainerGap(10, Short.MAX_VALUE)));
                jPanelButtonLayout.setVerticalGroup(jPanelButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelButtonLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanelButtonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelButtonLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonProceed).addComponent(this.jButtonCancel)).addComponent(this.jLabelProgressBar, -2, 18, -2).addComponent(this.jLabelProgressBarStatus, -2, 18, -2))));
                jPanelButtonLayout = null;
                GroupLayout jPanelPDFSignerLayout = new GroupLayout(jPanelPDFSigner);
                jPanelPDFSigner.setLayout(jPanelPDFSignerLayout);
                jPanelPDFSignerLayout.setHorizontalGroup(jPanelPDFSignerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPDFSignerLayout.createSequentialGroup().addContainerGap().addComponent(jSeparator5, -2, 640, -2).addContainerGap(10, Short.MAX_VALUE)).addComponent(this.jPanelImage, -1, -1, Short.MAX_VALUE).addGroup(jPanelPDFSignerLayout.createSequentialGroup().addGroup(jPanelPDFSignerLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jPanelButton, -2, -1, -2).addGroup(GroupLayout.Alignment.LEADING, jPanelPDFSignerLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jPanelSoftTokenCertificate).addGroup(jPanelPDFSignerLayout.createSequentialGroup().addContainerGap().addComponent(jSeparator2, -2, 640, -2)).addComponent(jPanelCertificateStore).addGroup(jPanelPDFSignerLayout.createSequentialGroup().addContainerGap()).addComponent(jPanelFolderSelection, -1, -1, Short.MAX_VALUE).addGroup(jPanelPDFSignerLayout.createSequentialGroup().addContainerGap()))).addContainerGap(-1, Short.MAX_VALUE)));
                jPanelPDFSignerLayout.setVerticalGroup(jPanelPDFSignerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPDFSignerLayout.createSequentialGroup().addComponent(this.jPanelImage, -2, -1, -2).addGap(4, 4, 4).addComponent(jPanelFolderSelection, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanelSoftTokenCertificate, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanelCertificateStore, -2, 180, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jSeparator5, -2, -1, -2).addComponent(jPanelButton, -2, -1, -2).addContainerGap()));
                jPanelPDFSignerLayout = null;
                GroupLayout layout = new GroupLayout(this.getContentPane());
                this.getContentPane().setLayout(layout);
                layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanelPDFSigner, -2, -1, -2));
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanelPDFSigner, -2, 560, -2));
                layout = null;
                this.pack();
            }
            catch (Exception exception) {
                jPanelPDFSigner = null;
                jPanelFolderSelection = null;
                folderSelectionHeaderLabel = null;
                inputfileLabel = null;
                outputfilderLabel = null;
                jButtonInputFolder = null;
                jButtonOutputFolder = null;
                jSeparator2 = null;
                jSeparator5 = null;
                jPanelButton = null;
                inputfilePasswordLabel = null;
                jPanelSoftTokenCertificate = null;
                jPanelCertificateStore = null;
                jLabelsoftToken = null;
                jLabelcertificateStore = null;
                softTokenBrowseButton = null;
                softTokenInputFile = null;
                wizardCardLayout = null;
                fileBrowsepanel = null;
                orLabel = null;
                viewCertButton = null;
            }
        }
        finally {
            jPanelPDFSigner = null;
            jPanelFolderSelection = null;
            folderSelectionHeaderLabel = null;
            inputfileLabel = null;
            outputfilderLabel = null;
            jButtonInputFolder = null;
            jButtonOutputFolder = null;
            jSeparator2 = null;
            jSeparator5 = null;
            jPanelButton = null;
            inputfilePasswordLabel = null;
            jPanelSoftTokenCertificate = null;
            jPanelCertificateStore = null;
            jLabelsoftToken = null;
            jLabelcertificateStore = null;
            softTokenBrowseButton = null;
            softTokenInputFile = null;
            wizardCardLayout = null;
            fileBrowsepanel = null;
            orLabel = null;
            viewCertButton = null;
        }
    }

    private JComponent displayCertificateStore() {
        this.panel2 = new JPanel();
        this.panel = new JPanel();
        try {
            this.keyStore = KeyStore.getInstance("WINDOWS-MY", "SunMSCAPI");
            this.keyStore.load(null, null);
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (CertificateException certificateException) {
        }
        catch (IOException iOException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        try {
            this.storeTable = new KeyStoreTable(this.keyStore);
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (CertificateException e1) {
            DialogBox.showWarningBox(this, "This is not a valid certificate. There is no private key associated with this certificate.");
            return null;
        }
        JScrollPane licensePane = new JScrollPane(this.storeTable);
        licensePane.setVerticalScrollBarPolicy(22);
        licensePane.getViewport().setPreferredSize(new Dimension(520, 75));
        licensePane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20), BorderFactory.createBevelBorder(1)));
        this.panel.removeAll();
        this.panel.add(licensePane);
        return this.panel;
    }

    private void viewActionPerformed(ActionEvent evt) {
        block21: {
            if (this.softTokenstoreTable != null && this.softTokenstoreTable.getRowCount() != 0) {
                if (this.targetField.getText().equals("") || this.targetField.getText() == null) {
                    DialogBox.showMessageBox(this, "Please select the certificate");
                    return;
                }
                String alias = null;
                try {
                    Enumeration<String> it = this.keyStore.aliases();
                    while (it.hasMoreElements()) {
                        alias = it.nextElement();
                    }
                }
                catch (KeyStoreException it) {
                    // empty catch block
                }
                try {
                    try {
                        X509Certificate certificate2 = (X509Certificate)this.keyStore.getCertificate(alias);
                        this.me = new CertViewer((Frame)this, certificate2);
                        this.me.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e2) {
                                PDFSigner.this.me.setVisible(false);
                                PDFSigner.this.me = null;
                            }
                        });
                        this.me.setVisible(true);
                    }
                    catch (KeyStoreException certificate2) {
                        alias = null;
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    alias = null;
                    throw throwable;
                }
                alias = null;
            } else if (this.storeTable != null && this.storeTable.getRowCount() != 0) {
                if (this.storeTable.getSelectedEntry() == null) {
                    DialogBox.showMessageBox(this, "Please select the certificate");
                    return;
                }
                this.certSelected = this.storeTable.getSelectedEntry().getAlias();
                X509Certificate certificate = null;
                try {
                    try {
                        certificate = (X509Certificate)this.keyStore.getCertificate(this.certSelected);
                        this.me = new CertViewer((Frame)this, certificate);
                        this.me.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e2) {
                                PDFSigner.this.me.setVisible(false);
                                PDFSigner.this.me = null;
                            }
                        });
                        this.me.setVisible(true);
                    }
                    catch (KeyStoreException certificate2) {
                        certificate = null;
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    certificate = null;
                    throw throwable;
                }
                certificate = null;
            }
        }
        String fileName = "";
        if (!this.targetField.getText().equals("")) {
            StringTokenizer st = new StringTokenizer(this.targetField.getText(), "\\");
            StringBuilder sbuf = new StringBuilder();
            while (st.hasMoreElements()) {
                sbuf.append(st.nextElement()).append("\\\\");
            }
            fileName = sbuf.toString().substring(0, sbuf.toString().length() - 2);
        }
        if (fileName != "" && fileName.length() > 0) {
            this.setSelectedcertificate(fileName);
        } else {
            this.setSelectedcertificate("Windows Store");
        }
        fileName = null;
    }

    public File GetTempDirectory() {
        File tempDir = null;
        if (this.outputTargetDirectory != null && this.outputTargetDirectory.exists()) {
            String outputTargetPath = this.outputTargetDirectory.getAbsolutePath();
            outputTargetPath = String.valueOf(this.outputTargetDirectory.getAbsolutePath()) + File.separator + "temp";
            tempDir = new File(outputTargetPath);
        }
        return tempDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkFileVersion(String destFilePath) {
        boolean isCorrectVersion = false;
        BufferedReader reader = null;
        String FTRow = null;
        String[] FTRowSplitArray = null;
        String fileVersion = null;
        String reqFileVersion = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(destFilePath));
                reader.readLine().trim();
                FTRow = reader.readLine().trim();
                FTRowSplitArray = FTRow.split("\\^");
                reader.close();
                fileVersion = FTRowSplitArray[1];
                reqFileVersion = "V1.4";
                if (!fileVersion.equalsIgnoreCase(reqFileVersion)) return isCorrectVersion;
                isCorrectVersion = true;
                return isCorrectVersion;
            }
            catch (FileNotFoundException e2) {
                isCorrectVersion = false;
                reader = null;
                FTRow = null;
                FTRowSplitArray = null;
                fileVersion = null;
                reqFileVersion = null;
                return isCorrectVersion;
            }
            catch (IOException e2) {
                isCorrectVersion = false;
                reader = null;
                FTRow = null;
                FTRowSplitArray = null;
                fileVersion = null;
                reqFileVersion = null;
                return isCorrectVersion;
            }
            catch (Exception e3) {
                isCorrectVersion = false;
                reader = null;
                FTRow = null;
                FTRowSplitArray = null;
                fileVersion = null;
                reqFileVersion = null;
                return isCorrectVersion;
            }
        }
        finally {
            reader = null;
            FTRow = null;
            FTRowSplitArray = null;
            fileVersion = null;
            reqFileVersion = null;
        }
    }

    private static class P12Filter
    extends FileFilter {
        private P12Filter() {
        }

        @Override
        public boolean accept(File f2) {
            return f2.getName().endsWith(".p12") || f2.getName().endsWith(".pfx");
        }

        @Override
        public String getDescription() {
            return "P12 File";
        }
    }

    private static class ZipFilter
    extends FileFilter {
        private ZipFilter() {
        }

        @Override
        public boolean accept(File f2) {
            return f2.getName().endsWith(".zip");
        }

        @Override
        public String getDescription() {
            return "ZIP File";
        }
    }
}

