/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.PrivilegedAction;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.harmony.security.fortress.PolicyUtils;
import org.apache.harmony.security.internal.nls.Messages;

public class CodeSource
implements Serializable {
    private static final long serialVersionUID = 4977541819976013951L;
    private URL location;
    private transient Certificate[] certs;
    private transient CodeSigner[] signers;
    private transient SocketPermission sp;
    private transient CertificateFactory factory;
    private boolean translated = false;

    public CodeSource(URL uRL, Certificate[] certificateArray) {
        this.location = uRL;
        if (certificateArray != null) {
            this.certs = new Certificate[certificateArray.length];
            System.arraycopy(certificateArray, 0, this.certs, 0, certificateArray.length);
        }
    }

    public CodeSource(URL uRL, CodeSigner[] codeSignerArray) {
        this.location = uRL;
        if (codeSignerArray != null) {
            this.signers = new CodeSigner[codeSignerArray.length];
            System.arraycopy(codeSignerArray, 0, this.signers, 0, codeSignerArray.length);
        }
    }

    public boolean equals(Object object) {
        Object[] objectArray;
        Object[] objectArray2;
        if (object == this) {
            return true;
        }
        if (!(object instanceof CodeSource)) {
            return false;
        }
        CodeSource codeSource = (CodeSource)object;
        if (this.location != null) {
            if (codeSource.location == null) {
                return false;
            }
            if (!this.location.equals(codeSource.location)) {
                return false;
            }
        } else if (codeSource.location != null) {
            return false;
        }
        if (!PolicyUtils.matchSubset(objectArray2 = this.getCertificatesNoClone(), objectArray = codeSource.getCertificatesNoClone())) {
            return false;
        }
        return PolicyUtils.matchSubset(objectArray, objectArray2);
    }

    public final Certificate[] getCertificates() {
        this.getCertificatesNoClone();
        if (this.certs == null) {
            return null;
        }
        Certificate[] certificateArray = new Certificate[this.certs.length];
        System.arraycopy(this.certs, 0, certificateArray, 0, this.certs.length);
        return certificateArray;
    }

    private Certificate[] getCertificatesNoClone() {
        if (this.certs != null) {
            return this.certs;
        }
        if (this.signers == null) {
            return null;
        }
        ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
        for (int i2 = 0; i2 < this.signers.length; ++i2) {
            arrayList.addAll(this.signers[i2].getSignerCertPath().getCertificates());
        }
        this.certs = arrayList.toArray(new Certificate[arrayList.size()]);
        return this.certs;
    }

    private Certificate[] getCertificatesForImply() {
        if (this.certs != null) {
            return this.certs;
        }
        if (this.signers == null) {
            return null;
        }
        ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
        for (int i2 = 0; i2 < this.signers.length; ++i2) {
            CodeSigner codeSigner = this.signers[i2];
            if (codeSigner == null) continue;
            arrayList.addAll(codeSigner.getSignerCertPath().getCertificates());
        }
        this.certs = arrayList.toArray(new Certificate[arrayList.size()]);
        return this.certs;
    }

    public final CodeSigner[] getCodeSigners() {
        CertPath certPath;
        if (this.signers != null) {
            CodeSigner[] codeSignerArray = new CodeSigner[this.signers.length];
            System.arraycopy(this.signers, 0, codeSignerArray, 0, codeSignerArray.length);
            return codeSignerArray;
        }
        if (this.certs == null || this.factory != null) {
            return null;
        }
        X500Principal x500Principal = null;
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(this.certs.length);
        ArrayList<CodeSigner> arrayList2 = new ArrayList<CodeSigner>();
        for (int i2 = 0; i2 < this.certs.length; ++i2) {
            if (!(this.certs[i2] instanceof X509Certificate)) continue;
            X509Certificate x509Certificate = (X509Certificate)this.certs[i2];
            if (x500Principal == null) {
                x500Principal = x509Certificate.getIssuerX500Principal();
                arrayList.add(x509Certificate);
                continue;
            }
            X500Principal x500Principal2 = x509Certificate.getSubjectX500Principal();
            if (!x500Principal.equals(x500Principal2)) {
                CertPath certPath2 = this.makeCertPath(arrayList);
                if (certPath2 != null) {
                    arrayList2.add(new CodeSigner(certPath2, null));
                }
                arrayList.clear();
            }
            x500Principal = x509Certificate.getSubjectX500Principal();
            arrayList.add(x509Certificate);
        }
        if (!arrayList.isEmpty() && (certPath = this.makeCertPath(arrayList)) != null) {
            arrayList2.add(new CodeSigner(certPath, null));
        }
        if (arrayList2.isEmpty()) {
            return null;
        }
        this.signers = new CodeSigner[arrayList2.size()];
        arrayList2.toArray(this.signers);
        CodeSigner[] codeSignerArray = new CodeSigner[arrayList2.size()];
        System.arraycopy(this.signers, 0, codeSignerArray, 0, codeSignerArray.length);
        return codeSignerArray;
    }

    private CertPath makeCertPath(List<? extends Certificate> list) {
        if (this.factory == null) {
            try {
                this.factory = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException certificateException) {
                return null;
            }
        }
        try {
            return this.factory.generateCertPath(list);
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    public final URL getLocation() {
        return this.location;
    }

    public int hashCode() {
        return this.location == null ? 0 : this.location.hashCode();
    }

    public boolean implies(CodeSource codeSource) {
        Object object;
        if (codeSource == null) {
            return false;
        }
        Object[] objectArray = this.getCertificatesForImply();
        if (!(objectArray == null || (object = codeSource.getCertificatesForImply()) != null && PolicyUtils.matchSubset(objectArray, (Object[])object))) {
            return false;
        }
        if (this.location != null) {
            if (codeSource.location == null) {
                return false;
            }
            object = this.location;
            URL uRL = codeSource.location;
            Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>((URL)object, uRL){
                final /* synthetic */ URL val$u1;
                final /* synthetic */ URL val$u2;
                {
                    this.val$u1 = uRL;
                    this.val$u2 = uRL2;
                }

                @Override
                public Boolean run() {
                    if (this.val$u1.equals(this.val$u2)) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
            if (bl.booleanValue()) {
                return true;
            }
            if (!this.location.getProtocol().equals(codeSource.location.getProtocol())) {
                return false;
            }
            if (!this.matchHost(((URL)object).getHost(), uRL.getHost(), codeSource) && !this.matchHost(this.decodeUTF8(((URL)object).getHost()), this.decodeUTF8(uRL.getHost()), codeSource)) {
                return false;
            }
            if (this.location.getPort() != -1 && this.location.getPort() != codeSource.location.getPort()) {
                return false;
            }
            if (!this.matchFile(((URL)object).getFile(), uRL.getFile()) && !this.matchFile(this.decodeUTF8(((URL)object).getFile()), this.decodeUTF8(uRL.getFile()))) {
                return false;
            }
            if (this.location.getRef() != null && !this.location.getRef().equals(codeSource.location.getRef())) {
                return false;
            }
        }
        return true;
    }

    private String decodeUTF8(String string) {
        String string2 = null;
        try {
            if (string != null) {
                string2 = URLDecoder.decode(string, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    private boolean matchHost(String string, String string2, CodeSource codeSource) {
        if (string != null) {
            if (string2 == null) {
                return false;
            }
            if ((string.length() != 0 && !"localhost".equals(string) || string2.length() != 0 && !"localhost".equals(string2)) && !string.equals(string2)) {
                if (this.sp == null) {
                    this.sp = new SocketPermission(string, "resolve");
                }
                if (codeSource.sp == null) {
                    codeSource.sp = new SocketPermission(string2, "resolve");
                }
                if (!this.sp.implies(codeSource.sp)) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean matchFile(String string, String string2) {
        if (string.endsWith("/-")) {
            if (!string2.startsWith(string.substring(0, string.length() - 2))) {
                return false;
            }
        } else if (string.endsWith("/*")) {
            if (!string2.startsWith(string.substring(0, string.length() - 2))) {
                return false;
            }
            if (string2.indexOf("/", string.length() - 1) != -1) {
                return false;
            }
        } else if (!string.equals(string2)) {
            if (!string.endsWith("/")) {
                if (!string2.equals(string + "/")) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CodeSource, url=");
        stringBuilder.append(this.location == null ? "<null>" : this.location.toString());
        if (this.certs == null) {
            stringBuilder.append(", <no certificates>");
        } else {
            stringBuilder.append("\nCertificates [\n");
            for (n2 = 0; n2 < this.certs.length; ++n2) {
                stringBuilder.append(n2 + 1).append(") ").append(this.certs[n2]).append("\n");
            }
            stringBuilder.append("]\n");
        }
        if (this.signers != null) {
            stringBuilder.append("\nCodeSigners [\n");
            for (n2 = 0; n2 < this.signers.length; ++n2) {
                stringBuilder.append(n2 + 1).append(") ").append(this.signers[n2]).append("\n");
            }
            stringBuilder.append("]\n");
        }
        return stringBuilder.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.certs == null || this.certs.length == 0) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.certs.length);
            for (int i2 = 0; i2 < this.certs.length; ++i2) {
                try {
                    objectOutputStream.writeUTF(this.certs[i2].getType());
                    byte[] byArray = this.certs[i2].getEncoded();
                    objectOutputStream.writeInt(byArray.length);
                    objectOutputStream.write(byArray);
                    continue;
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw (IOException)new IOException(Messages.getString("security.18")).initCause(certificateEncodingException);
                }
            }
        }
        if (this.signers != null && this.signers.length != 0) {
            objectOutputStream.writeObject(this.signers);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        block8: {
            objectInputStream.defaultReadObject();
            int n2 = objectInputStream.readInt();
            this.certs = null;
            if (n2 != 0) {
                this.certs = new Certificate[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    CertificateFactory certificateFactory;
                    String string = objectInputStream.readUTF();
                    try {
                        certificateFactory = CertificateFactory.getInstance(string);
                    }
                    catch (CertificateException certificateException) {
                        throw new ClassNotFoundException(Messages.getString("security.19", string), certificateException);
                    }
                    int n3 = objectInputStream.readInt();
                    byte[] byArray = new byte[n3];
                    objectInputStream.readFully(byArray);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    try {
                        this.certs[i2] = certificateFactory.generateCertificate(byteArrayInputStream);
                        continue;
                    }
                    catch (CertificateException certificateException) {
                        throw (IOException)new IOException(Messages.getString("security.1A")).initCause(certificateException);
                    }
                }
            }
            try {
                this.signers = (CodeSigner[])objectInputStream.readObject();
            }
            catch (OptionalDataException optionalDataException) {
                if (optionalDataException.eof) break block8;
                throw optionalDataException;
            }
        }
    }
}

