/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.DigestException;
import org.apache.harmony.security.internal.nls.Messages;

public abstract class MessageDigestSpi {
    protected int engineGetDigestLength() {
        return 0;
    }

    protected abstract void engineUpdate(byte var1);

    protected abstract void engineUpdate(byte[] var1, int var2, int var3);

    protected void engineUpdate(ByteBuffer byteBuffer) {
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset();
            int n3 = byteBuffer.position();
            int n4 = byteBuffer.limit();
            this.engineUpdate(byArray, n2 + n3, n4 - n3);
            byteBuffer.position(n4);
        } else {
            byte[] byArray = new byte[byteBuffer.limit() - byteBuffer.position()];
            byteBuffer.get(byArray);
            this.engineUpdate(byArray, 0, byArray.length);
        }
    }

    protected abstract byte[] engineDigest();

    protected int engineDigest(byte[] byArray, int n2, int n3) throws DigestException {
        if (n3 < this.engineGetDigestLength()) {
            this.engineReset();
            throw new DigestException(Messages.getString("security.1B"));
        }
        if (n2 < 0) {
            this.engineReset();
            throw new DigestException(Messages.getString("security.1C"));
        }
        if (n2 + n3 > byArray.length) {
            this.engineReset();
            throw new DigestException(Messages.getString("security.1D"));
        }
        byte[] byArray2 = this.engineDigest();
        if (n3 < byArray2.length) {
            throw new DigestException(Messages.getString("security.1B"));
        }
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    protected abstract void engineReset();

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

