/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PermissionsHash;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.harmony.security.internal.nls.Messages;

final class UnresolvedPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = -7176153071733132400L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Hashtable.class)};
    private transient Map klasses = new HashMap();

    UnresolvedPermissionCollection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw new SecurityException(Messages.getString("security.15"));
        }
        if (permission == null || permission.getClass() != UnresolvedPermission.class) {
            throw new IllegalArgumentException(Messages.getString("security.16", permission));
        }
        Map map = this.klasses;
        synchronized (map) {
            String string = permission.getName();
            HashSet<Permission> hashSet = (HashSet<Permission>)this.klasses.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<Permission>();
                this.klasses.put(string, hashSet);
            }
            hashSet.add(permission);
        }
    }

    public Enumeration elements() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.klasses.values().iterator();
        while (iterator.hasNext()) {
            arrayList.addAll((Collection)iterator.next());
        }
        return Collections.enumeration(arrayList);
    }

    @Override
    public boolean implies(Permission permission) {
        return false;
    }

    boolean hasUnresolved(Permission permission) {
        return this.klasses.containsKey(permission.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PermissionCollection resolveCollection(Permission permission, PermissionCollection permissionCollection) {
        String string = permission.getClass().getName();
        if (this.klasses.containsKey(string)) {
            Map map = this.klasses;
            synchronized (map) {
                Collection collection = (Collection)this.klasses.get(string);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    UnresolvedPermission unresolvedPermission = (UnresolvedPermission)iterator.next();
                    Permission permission2 = unresolvedPermission.resolve(permission.getClass());
                    if (permission2 == null) continue;
                    if (permissionCollection == null && (permissionCollection = permission.newPermissionCollection()) == null) {
                        permissionCollection = new PermissionsHash();
                    }
                    permissionCollection.add(permission2);
                    iterator.remove();
                }
                if (collection.size() == 0) {
                    this.klasses.remove(string);
                }
            }
        }
        return permissionCollection;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable hashtable = new Hashtable();
        for (Map.Entry entry : this.klasses.entrySet()) {
            String string = (String)entry.getKey();
            hashtable.put(string, new Vector((Collection)entry.getValue()));
        }
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("permissions", hashtable);
        objectOutputStream.writeFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Map map = (Map)getField.get("permissions", null);
        this.klasses = new HashMap();
        Map map2 = this.klasses;
        synchronized (map2) {
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                Collection collection = (Collection)entry.getValue();
                for (UnresolvedPermission unresolvedPermission : collection) {
                    if (unresolvedPermission.getName().equals(string)) continue;
                    throw new InvalidObjectException(Messages.getString("security.22"));
                }
                this.klasses.put(string, new HashSet(collection));
            }
        }
    }
}

