/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.awt.Color;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.jasperreports.components.BaseElementHtmlHandler;
import net.sf.jasperreports.components.sort.FieldFilter;
import net.sf.jasperreports.components.sort.FilterTypeDateOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypeNumericOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypeTextOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypesEnum;
import net.sf.jasperreports.components.sort.SortElementUtils;
import net.sf.jasperreports.engine.CompositeDatasetFilter;
import net.sf.jasperreports.engine.DatasetFilter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBasePrintHyperlink;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.export.JRXhtmlExporter;
import net.sf.jasperreports.engine.type.JREnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.web.util.VelocityUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortElementHtmlHandler
extends BaseElementHtmlHandler {
    private static final Log log = LogFactory.getLog(SortElementHtmlHandler.class);
    private static final String RESOURCE_SORT_JS = "net/sf/jasperreports/components/sort/resources/sort.js";
    private static final String RESOURCE_IMAGE_CLOSE = "net/sf/jasperreports/components/sort/resources/images/delete_edit.gif";
    private static final String RESOURCE_TRANSPARENT_PIXEL = "net/sf/jasperreports/engine/images/pixel.GIF";
    private static final String RESOURCE_FILTER_SYMBOL = "net/sf/jasperreports/components/sort/resources/images/filter.png";
    private static final String RESOURCE_WRONG_FILTER_SYMBOL = "net/sf/jasperreports/components/sort/resources/images/filter_wrong.png";
    private static final String RESOURCE_SORT_SYMBOL_ASC = "net/sf/jasperreports/components/sort/resources/images/sort_asc.png";
    private static final String RESOURCE_SORT_SYMBOL_ASC_HOVER = "net/sf/jasperreports/components/sort/resources/images/sort_asc_over.png";
    private static final String RESOURCE_SORT_SYMBOL_DESC = "net/sf/jasperreports/components/sort/resources/images/sort_desc.png";
    private static final String RESOURCE_SORT_SYMBOL_DESC_OVER = "net/sf/jasperreports/components/sort/resources/images/sort_desc_over.png";
    private static final String SORT_ELEMENT_HTML_TEMPLATE = "net/sf/jasperreports/components/sort/resources/SortElementHtmlTemplate.vm";
    protected static final String HTML_VERTICAL_ALIGN_TOP = "top";
    protected static final String CSS_TEXT_ALIGN_LEFT = "left";
    protected static final String SORT_SYMBOL_ASCENDING = "&#9650;";
    protected static final String SORT_SYMBOL_DESCENDING = "&#9660;";
    protected static final String FILTER_SYMBOL_ACTIVE = "Active";
    protected static final String FILTER_SYMBOL_INACTIVE = "Inactive";

    @Override
    public String getHtmlFragment(JRHtmlExporterContext context, JRGenericPrintElement element) {
        String htmlFragment = null;
        ReportContext reportContext = context.getExporter().getReportContext();
        if (reportContext != null) {
            String sortField;
            FilterTypesEnum filterType;
            Color sortHandlerColor;
            String sortColumnName = (String)element.getParameterValue("sortColumnName");
            String sortColumnLabel = (String)element.getParameterValue("sortColumnLabel");
            String sortColumnType = (String)element.getParameterValue("sortColumnType");
            String sortHandlerVAlign = (String)element.getParameterValue("sortHandlerVerticalAlign");
            String sortHandlerHAlign = (String)element.getParameterValue("sortHandlerHorizontalAlign");
            String sortDatasetName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.jr.dsr");
            JRBaseFont sortHandlerFont = (JRBaseFont)element.getParameterValue("sortHandlerFont");
            if (sortHandlerFont == null) {
                sortHandlerFont = new JRBaseFont(element);
            }
            if ((sortHandlerColor = (Color)element.getParameterValue("sortHandlerColor")) == null) {
                sortHandlerColor = Color.WHITE;
            }
            if ((filterType = FilterTypesEnum.getByName(element.getPropertiesMap().getProperty("net.sf.jasperreports.export.jr.fltrTp"))) == null) {
                return null;
            }
            String filterPattern = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.jr.fltrPtrn");
            Locale locale = (Locale)reportContext.getParameterValue("REPORT_LOCALE");
            if (log.isDebugEnabled()) {
                log.debug("report locale: " + locale);
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            Map<String, String> translatedOperators = null;
            switch (filterType) {
                case NUMERIC: {
                    translatedOperators = this.getTranslatedOperators(FilterTypeNumericOperatorsEnum.class.getName(), FilterTypeNumericOperatorsEnum.values(), locale);
                    break;
                }
                case DATE: {
                    translatedOperators = this.getTranslatedOperators(FilterTypeDateOperatorsEnum.class.getName(), FilterTypeDateOperatorsEnum.values(), locale);
                    break;
                }
                case TEXT: {
                    translatedOperators = this.getTranslatedOperators(FilterTypeTextOperatorsEnum.class.getName(), FilterTypeTextOperatorsEnum.values(), locale);
                }
            }
            String appContextPath = (String)reportContext.getParameterValue("net.sf.jasperreports.web.app.context.path");
            VelocityContext velocityContext = new VelocityContext();
            String webResourcesBasePath = JRProperties.getProperty("net.sf.jasperreports.web.resources.base.path");
            if (webResourcesBasePath == null) {
                webResourcesBasePath = "/servlets/resource?resource.uri=";
            }
            String imagesResourcePath = (appContextPath == null ? "" : appContextPath) + webResourcesBasePath;
            velocityContext.put("resourceSortJs", (Object)(webResourcesBasePath + RESOURCE_SORT_JS));
            velocityContext.put("elementX", (Object)((JRXhtmlExporter)context.getExporter()).toSizeUnit(element.getX()));
            velocityContext.put("elementY", (Object)((JRXhtmlExporter)context.getExporter()).toSizeUnit(element.getY()));
            velocityContext.put("elementWidth", (Object)element.getWidth());
            velocityContext.put("elementHeight", (Object)element.getHeight());
            velocityContext.put("sortLinkClass", (Object)sortDatasetName);
            velocityContext.put("sortHandlerHAlign", (Object)(sortHandlerHAlign != null ? sortHandlerHAlign : CSS_TEXT_ALIGN_LEFT));
            velocityContext.put("sortHandlerVAlign", (Object)(sortHandlerVAlign != null ? sortHandlerVAlign : HTML_VERTICAL_ALIGN_TOP));
            velocityContext.put("sortHandlerColor", (Object)JRColorUtil.getColorHexa(sortHandlerColor));
            velocityContext.put("sortHandlerFontSize", (Object)sortHandlerFont.getFontSize());
            velocityContext.put("transparentPixelSrc", (Object)(imagesResourcePath + RESOURCE_TRANSPARENT_PIXEL));
            velocityContext.put("isFilterable", (Object)(filterType != null ? 1 : 0));
            velocityContext.put("filterDivId", (Object)("filter_" + sortDatasetName + "_" + sortColumnName));
            velocityContext.put("filterFormAction", (Object)this.getFilterFormActionLink(context));
            velocityContext.put("filterReportUriParamName", (Object)"jr.uri");
            velocityContext.put("filterReportUriParamValue", reportContext.getParameterValue("jr.uri"));
            velocityContext.put("filterFieldParamName", (Object)"jr.fltrFld");
            velocityContext.put("filterColumnName", (Object)sortColumnName);
            velocityContext.put("filterColumnNameLabel", (Object)(sortColumnLabel != null ? sortColumnLabel : ""));
            velocityContext.put("filterTableNameParam", (Object)"jr.dsr");
            velocityContext.put("filterTableNameValue", (Object)sortDatasetName);
            velocityContext.put("filterCloseDialogImageResource", (Object)(imagesResourcePath + RESOURCE_IMAGE_CLOSE));
            velocityContext.put("filterTypeParamName", (Object)"jr.fltrTp");
            velocityContext.put("filterTypeParamNameValue", (Object)filterType.getName());
            velocityContext.put("filterTypeOperatorParamName", (Object)"jr.fltrTpOprtr");
            velocityContext.put("filterPatternParamName", (Object)"jr.fltrPtrn");
            velocityContext.put("filterPatternParamValue", (Object)filterPattern);
            velocityContext.put("filterTypeValuesMap", translatedOperators);
            velocityContext.put("filterValueStartParamName", (Object)"jr.fltrVlStrt");
            velocityContext.put("filterValueEndParamName", (Object)"jr.fltrVlEnd");
            if (element.getModeValue() == ModeEnum.OPAQUE) {
                velocityContext.put("backgroundColor", (Object)JRColorUtil.getColorHexa(element.getBackcolor()));
            }
            if ((sortField = this.getCurrentSortField(reportContext, sortDatasetName, sortColumnName, sortColumnType)) == null) {
                velocityContext.put("sortHref", (Object)this.getSortLink(context, sortColumnName, sortColumnType, "Asc", sortDatasetName));
                velocityContext.put("isSorted", (Object)false);
            } else {
                String[] sortActionData = SortElementUtils.extractColumnInfo(sortField);
                boolean isAscending = "Asc".equals(sortActionData[2]);
                String sortOrder = !isAscending ? "None" : "Dsc";
                velocityContext.put("sortHref", (Object)this.getSortLink(context, sortColumnName, sortColumnType, sortOrder, sortDatasetName));
                velocityContext.put("isSorted", (Object)true);
                velocityContext.put("sortSymbolResource", (Object)(isAscending ? imagesResourcePath + RESOURCE_SORT_SYMBOL_ASC : imagesResourcePath + RESOURCE_SORT_SYMBOL_DESC));
                velocityContext.put("sortSymbolHoverResource", (Object)(isAscending ? imagesResourcePath + RESOURCE_SORT_SYMBOL_ASC_HOVER : imagesResourcePath + RESOURCE_SORT_SYMBOL_DESC_OVER));
            }
            String currentDataset = (String)reportContext.getParameterValue("jr.dsr");
            String filterValueStart = "";
            String filterValueEnd = "";
            String filterTypeOperatorValue = "";
            String filterActiveInactive = FILTER_SYMBOL_INACTIVE;
            boolean isFiltered = false;
            boolean enableFilterEndParameter = false;
            ArrayList<FieldFilter> fieldFilters = new ArrayList<FieldFilter>();
            String filterSymbolImageResource = imagesResourcePath + RESOURCE_FILTER_SYMBOL;
            if (sortDatasetName != null && sortDatasetName.equals(currentDataset)) {
                String currentTableFiltersParam = currentDataset + ".FILTER";
                DatasetFilter existingFilter = (DatasetFilter)reportContext.getParameterValue(currentTableFiltersParam);
                this.getFieldFilters(existingFilter, fieldFilters, sortColumnName);
                if (fieldFilters.size() > 0) {
                    FieldFilter ff = (FieldFilter)fieldFilters.get(0);
                    if (ff.getFilterValueStart() != null) {
                        filterValueStart = ff.getFilterValueStart();
                    }
                    if (ff.getFilterValueEnd() != null) {
                        filterValueEnd = ff.getFilterValueEnd();
                    }
                    filterTypeOperatorValue = ff.getFilterTypeOperator();
                    filterActiveInactive = FILTER_SYMBOL_ACTIVE;
                    isFiltered = true;
                    if (filterTypeOperatorValue != null && filterTypeOperatorValue.toLowerCase().contains("between")) {
                        enableFilterEndParameter = true;
                    }
                    if (!ff.getIsValid().booleanValue()) {
                        filterSymbolImageResource = imagesResourcePath + RESOURCE_WRONG_FILTER_SYMBOL;
                    }
                }
            }
            velocityContext.put("isFiltered", (Object)isFiltered);
            velocityContext.put("filterSymbolImageResource", (Object)filterSymbolImageResource);
            velocityContext.put("filterToRemoveParamName", (Object)"jr.rmvFltr");
            velocityContext.put("filterToRemoveParamvalue", (Object)sortColumnName);
            String filtersJsonString = this.getJsonString(fieldFilters).replaceAll("\\\"", "\\\\\\\"");
            if (log.isDebugEnabled()) {
                log.debug("filtersJsonString: " + filtersJsonString);
            }
            velocityContext.put("filtersJsonString", (Object)filtersJsonString);
            velocityContext.put("filterValueStartParamValue", (Object)filterValueStart);
            velocityContext.put("filterValueEndParamValue", (Object)filterValueEnd);
            velocityContext.put("filterTypeOperatorParamValue", (Object)filterTypeOperatorValue);
            velocityContext.put("filterActiveInactive", (Object)filterActiveInactive);
            velocityContext.put("enableFilterEndParameter", (Object)enableFilterEndParameter);
            htmlFragment = VelocityUtil.processTemplate(SORT_ELEMENT_HTML_TEMPLATE, velocityContext);
        }
        return htmlFragment;
    }

    private String getSortLink(JRHtmlExporterContext context, String sortColumnName, String sortColumnType, String sortOrder, String sortTableName) {
        JRBasePrintHyperlink hyperlink = new JRBasePrintHyperlink();
        hyperlink.setLinkType("ReportExecution");
        JRPrintHyperlinkParameters parameters = new JRPrintHyperlinkParameters();
        parameters.addParameter(new JRPrintHyperlinkParameter("jr.sort", String.class.getName(), SortElementUtils.packSortColumnInfo(sortColumnName, sortColumnType, sortOrder)));
        parameters.addParameter(new JRPrintHyperlinkParameter("jr.dsr", String.class.getName(), sortTableName));
        ReportContext reportContext = context.getExporter().getReportContext();
        parameters.addParameter(new JRPrintHyperlinkParameter("jr.ctxid", String.class.getName(), reportContext.getId()));
        parameters.addParameter(new JRPrintHyperlinkParameter("jr.run", String.class.getName(), "true"));
        hyperlink.setHyperlinkParameters(parameters);
        return context.getHyperlinkURL(hyperlink);
    }

    private String getFilterFormActionLink(JRHtmlExporterContext context) {
        JRBasePrintHyperlink hyperlink = new JRBasePrintHyperlink();
        hyperlink.setLinkType("ReportExecution");
        JRPrintHyperlinkParameters parameters = new JRPrintHyperlinkParameters();
        ReportContext reportContext = context.getExporter().getReportContext();
        parameters.addParameter(new JRPrintHyperlinkParameter("jr.ctxid", String.class.getName(), reportContext.getId()));
        parameters.addParameter(new JRPrintHyperlinkParameter("jr.run", String.class.getName(), "true"));
        hyperlink.setHyperlinkParameters(parameters);
        return context.getHyperlinkURL(hyperlink);
    }

    private String getCurrentSortField(ReportContext reportContext, String sortDatasetName, String sortColumnName, String sortColumnType) {
        String currentSortDataset = (String)reportContext.getParameterValue("jr.dsr");
        if (sortDatasetName == null || !sortDatasetName.equals(currentSortDataset)) {
            return null;
        }
        String currentTableSortFieldsParam = currentSortDataset + ".SORT_FIELDS";
        List existingFields = (List)reportContext.getParameterValue(currentTableSortFieldsParam);
        String sortField = null;
        if (existingFields != null && existingFields.size() > 0) {
            for (JRSortField field : existingFields) {
                if (!field.getName().equals(sortColumnName) || !field.getType().getName().equals(sortColumnType)) continue;
                sortField = sortColumnName + ":" + sortColumnType + ":";
                switch (field.getOrderValue()) {
                    case ASCENDING: {
                        sortField = sortField + "Asc";
                        break;
                    }
                    case DESCENDING: {
                        sortField = sortField + "Dsc";
                    }
                }
                break;
            }
        }
        return sortField;
    }

    @Override
    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }

    private Map<String, String> getTranslatedOperators(String bundleName, JREnum[] operators, Locale locale) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        ResourceBundle rb = ResourceBundle.getBundle(bundleName, locale);
        for (JREnum operator : operators) {
            result.put(((Enum)((Object)operator)).name(), rb.getString(((Enum)((Object)operator)).name()));
        }
        return result;
    }

    private void getFieldFilters(DatasetFilter existingFilter, List<FieldFilter> fieldFilters, String fieldName) {
        if (existingFilter instanceof FieldFilter) {
            if (fieldName == null || fieldName != null && ((FieldFilter)existingFilter).getField().equals(fieldName)) {
                fieldFilters.add((FieldFilter)existingFilter);
            }
        } else if (existingFilter instanceof CompositeDatasetFilter) {
            for (DatasetFilter filter : ((CompositeDatasetFilter)existingFilter).getFilters()) {
                this.getFieldFilters(filter, fieldFilters, fieldName);
            }
        }
    }

    private String getJsonString(List<FieldFilter> fieldFilters) {
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter(128);
        try {
            mapper.writeValue((Writer)writer, fieldFilters);
            writer.flush();
            writer.close();
        }
        catch (Exception e2) {
            throw new JRRuntimeException(e2);
        }
        return writer.getBuffer().toString();
    }
}

