/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;

public abstract class ASN1StringType
extends ASN1Type {
    public static final ASN1StringType BMPSTRING = new ASN1StringType(30){};
    public static final ASN1StringType IA5STRING = new ASN1StringType(22){};
    public static final ASN1StringType GENERALSTRING = new ASN1StringType(27){};
    public static final ASN1StringType PRINTABLESTRING = new ASN1StringType(19){};
    public static final ASN1StringType TELETEXSTRING = new ASN1StringType(20){};
    public static final ASN1StringType UNIVERSALSTRING = new ASN1StringType(28){};
    public static final ASN1StringType UTF8STRING = new ASN1StringType(12){

        @Override
        public Object getDecodedObject(BerInputStream berInputStream) throws IOException {
            return new String(berInputStream.buffer, berInputStream.contentOffset, berInputStream.length, "UTF-8");
        }

        @Override
        public void setEncodingContent(BerOutputStream berOutputStream) {
            try {
                byte[] byArray = ((String)berOutputStream.content).getBytes("UTF-8");
                berOutputStream.content = byArray;
                berOutputStream.length = byArray.length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException.getMessage());
            }
        }
    };

    public ASN1StringType(int n2) {
        super(n2);
    }

    @Override
    public final boolean checkTag(int n2) {
        return this.id == n2 || this.constrId == n2;
    }

    @Override
    public Object decode(BerInputStream berInputStream) throws IOException {
        berInputStream.readString(this);
        if (berInputStream.isVerify) {
            return null;
        }
        return this.getDecodedObject(berInputStream);
    }

    @Override
    public Object getDecodedObject(BerInputStream berInputStream) throws IOException {
        return new String(berInputStream.buffer, berInputStream.contentOffset, berInputStream.length);
    }

    @Override
    public void encodeASN(BerOutputStream berOutputStream) {
        berOutputStream.encodeTag(this.id);
        this.encodeContent(berOutputStream);
    }

    @Override
    public void encodeContent(BerOutputStream berOutputStream) {
        berOutputStream.encodeString();
    }

    @Override
    public void setEncodingContent(BerOutputStream berOutputStream) {
        byte[] byArray = ((String)berOutputStream.content).getBytes();
        berOutputStream.content = byArray;
        berOutputStream.length = byArray.length;
    }
}

