/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Longs;

abstract class AsconBaseDigest
implements ExtendedDigest {
    protected long x0;
    protected long x1;
    protected long x2;
    protected long x3;
    protected long x4;
    protected final int CRYPTO_BYTES = 32;
    protected final int ASCON_HASH_RATE = 8;
    protected int ASCON_PB_ROUNDS = 12;
    protected final byte[] m_buf = new byte[8];
    protected int m_bufPos = 0;

    AsconBaseDigest() {
    }

    private void round(long C) {
        long t0 = this.x0 ^ this.x1 ^ this.x2 ^ this.x3 ^ C ^ this.x1 & (this.x0 ^ this.x2 ^ this.x4 ^ C);
        long t1 = this.x0 ^ this.x2 ^ this.x3 ^ this.x4 ^ C ^ (this.x1 ^ this.x2 ^ C) & (this.x1 ^ this.x3);
        long t2 = this.x1 ^ this.x2 ^ this.x4 ^ C ^ this.x3 & this.x4;
        long t3 = this.x0 ^ this.x1 ^ this.x2 ^ C ^ (this.x0 ^ 0xFFFFFFFFFFFFFFFFL) & (this.x3 ^ this.x4);
        long t4 = this.x1 ^ this.x3 ^ this.x4 ^ (this.x0 ^ this.x4) & this.x1;
        this.x0 = t0 ^ Longs.rotateRight(t0, 19) ^ Longs.rotateRight(t0, 28);
        this.x1 = t1 ^ Longs.rotateRight(t1, 39) ^ Longs.rotateRight(t1, 61);
        this.x2 = t2 ^ Longs.rotateRight(t2, 1) ^ Longs.rotateRight(t2, 6) ^ 0xFFFFFFFFFFFFFFFFL;
        this.x3 = t3 ^ Longs.rotateRight(t3, 10) ^ Longs.rotateRight(t3, 17);
        this.x4 = t4 ^ Longs.rotateRight(t4, 7) ^ Longs.rotateRight(t4, 41);
    }

    protected void p(int nr) {
        if (nr == 12) {
            this.round(240L);
            this.round(225L);
            this.round(210L);
            this.round(195L);
        }
        if (nr >= 8) {
            this.round(180L);
            this.round(165L);
        }
        this.round(150L);
        this.round(135L);
        this.round(120L);
        this.round(105L);
        this.round(90L);
        this.round(75L);
    }

    protected abstract long pad(int var1);

    protected abstract long loadBytes(byte[] var1, int var2);

    protected abstract long loadBytes(byte[] var1, int var2, int var3);

    protected abstract void setBytes(long var1, byte[] var3, int var4);

    protected abstract void setBytes(long var1, byte[] var3, int var4, int var5);

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public int getByteLength() {
        return 8;
    }

    @Override
    public void update(byte in) {
        this.m_buf[this.m_bufPos] = in;
        if (++this.m_bufPos == 8) {
            this.x0 ^= this.loadBytes(this.m_buf, 0);
            this.p(this.ASCON_PB_ROUNDS);
            this.m_bufPos = 0;
        }
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        int remaining;
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        int available = 8 - this.m_bufPos;
        if (len < available) {
            System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, len);
            this.m_bufPos += len;
            return;
        }
        int inPos = 0;
        if (this.m_bufPos > 0) {
            System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, available);
            inPos += available;
            this.x0 ^= this.loadBytes(this.m_buf, 0);
            this.p(this.ASCON_PB_ROUNDS);
        }
        while ((remaining = len - inPos) >= 8) {
            this.x0 ^= this.loadBytes(input, inOff + inPos);
            this.p(this.ASCON_PB_ROUNDS);
            inPos += 8;
        }
        System.arraycopy(input, inOff + inPos, this.m_buf, 0, remaining);
        this.m_bufPos = remaining;
    }

    @Override
    public int doFinal(byte[] output, int outOff) {
        return this.hash(output, outOff, 32);
    }

    protected void padAndAbsorb() {
        this.x0 ^= this.loadBytes(this.m_buf, 0, this.m_bufPos);
        this.x0 ^= this.pad(this.m_bufPos);
        this.p(12);
    }

    protected void squeeze(byte[] output, int outOff, int len) {
        while (len > 8) {
            this.setBytes(this.x0, output, outOff);
            this.p(this.ASCON_PB_ROUNDS);
            outOff += 8;
            len -= 8;
        }
        this.setBytes(this.x0, output, outOff, len);
        this.reset();
    }

    protected int hash(byte[] output, int outOff, int outLen) {
        if (32 + outOff > output.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        this.padAndAbsorb();
        this.squeeze(output, outOff, outLen);
        return outLen;
    }

    @Override
    public void reset() {
        Arrays.clear(this.m_buf);
        this.m_bufPos = 0;
    }
}

