/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.Xof;
import org.bouncycastle.crypto.digests.AsconBaseDigest;
import org.bouncycastle.util.Pack;

public class AsconXof
extends AsconBaseDigest
implements Xof {
    AsconParameters asconParameters;
    private final String algorithmName;
    private boolean m_squeezing = false;

    public AsconXof(AsconParameters parameters) {
        this.asconParameters = parameters;
        switch (parameters) {
            case AsconXof: {
                this.ASCON_PB_ROUNDS = 12;
                this.algorithmName = "Ascon-Xof";
                break;
            }
            case AsconXofA: {
                this.ASCON_PB_ROUNDS = 8;
                this.algorithmName = "Ascon-XofA";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid parameter settings for Ascon Hash");
            }
        }
        this.reset();
    }

    @Override
    public void update(byte in) {
        if (this.m_squeezing) {
            throw new IllegalArgumentException("attempt to absorb while squeezing");
        }
        super.update(in);
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        if (this.m_squeezing) {
            throw new IllegalArgumentException("attempt to absorb while squeezing");
        }
        super.update(input, inOff, len);
    }

    @Override
    protected void padAndAbsorb() {
        this.m_squeezing = true;
        super.padAndAbsorb();
    }

    @Override
    protected long pad(int i) {
        return 128L << 56 - (i << 3);
    }

    @Override
    protected long loadBytes(byte[] bytes, int inOff) {
        return Pack.bigEndianToLong(bytes, inOff);
    }

    @Override
    protected long loadBytes(byte[] bytes, int inOff, int n) {
        return Pack.bigEndianToLong(bytes, inOff, n);
    }

    @Override
    protected void setBytes(long w, byte[] bytes, int inOff) {
        Pack.longToBigEndian(w, bytes, inOff);
    }

    @Override
    protected void setBytes(long w, byte[] bytes, int inOff, int n) {
        Pack.longToBigEndian(w, bytes, inOff, n);
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public int doOutput(byte[] output, int outOff, int outLen) {
        return this.hash(output, outOff, outLen);
    }

    @Override
    public int doFinal(byte[] output, int outOff, int outLen) {
        int rlt = this.doOutput(output, outOff, outLen);
        this.reset();
        return rlt;
    }

    @Override
    public int getByteLength() {
        return 8;
    }

    @Override
    public void reset() {
        super.reset();
        this.m_squeezing = false;
        switch (this.asconParameters) {
            case AsconXof: {
                this.x0 = -5368810569253202922L;
                this.x1 = 3121280575360345120L;
                this.x2 = 7395939140700676632L;
                this.x3 = 6533890155656471820L;
                this.x4 = 5710016986865767350L;
                break;
            }
            case AsconXofA: {
                this.x0 = 4940560291654768690L;
                this.x1 = -3635129828240960206L;
                this.x2 = -597534922722107095L;
                this.x3 = 2623493988082852443L;
                this.x4 = -6283826724160825537L;
            }
        }
    }

    public static enum AsconParameters {
        AsconXof,
        AsconXofA;

    }
}

