/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.digests.Utils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Pack;

public class Blake2sDigest
implements ExtendedDigest {
    private static final int[] blake2s_IV = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final byte[][] blake2s_sigma;
    private static final int ROUNDS = 10;
    private static final int BLOCK_LENGTH_BYTES = 64;
    private int digestLength = 32;
    private int keyLength = 0;
    private byte[] salt = null;
    private byte[] personalization = null;
    private byte[] key = null;
    private int fanout = 1;
    private int depth = 1;
    private int leafLength = 0;
    private long nodeOffset = 0L;
    private int nodeDepth = 0;
    private int innerHashLength = 0;
    private boolean isLastNode = false;
    private byte[] buffer = null;
    private int bufferPos = 0;
    private int[] internalState = new int[16];
    private int[] chainValue = null;
    private int t0 = 0;
    private int t1 = 0;
    private int f0 = 0;
    private int f1 = 0;
    private final CryptoServicePurpose purpose;

    static {
        byte[][] byArrayArray = new byte[10][];
        byte[] byArray = new byte[16];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[0] = 14;
        byArray2[1] = 10;
        byArray2[2] = 4;
        byArray2[3] = 8;
        byArray2[4] = 9;
        byArray2[5] = 15;
        byArray2[6] = 13;
        byArray2[7] = 6;
        byArray2[8] = 1;
        byArray2[9] = 12;
        byArray2[11] = 2;
        byArray2[12] = 11;
        byArray2[13] = 7;
        byArray2[14] = 5;
        byArray2[15] = 3;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[16];
        byArray3[0] = 11;
        byArray3[1] = 8;
        byArray3[2] = 12;
        byArray3[4] = 5;
        byArray3[5] = 2;
        byArray3[6] = 15;
        byArray3[7] = 13;
        byArray3[8] = 10;
        byArray3[9] = 14;
        byArray3[10] = 3;
        byArray3[11] = 6;
        byArray3[12] = 7;
        byArray3[13] = 1;
        byArray3[14] = 9;
        byArray3[15] = 4;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[16];
        byArray4[0] = 7;
        byArray4[1] = 9;
        byArray4[2] = 3;
        byArray4[3] = 1;
        byArray4[4] = 13;
        byArray4[5] = 12;
        byArray4[6] = 11;
        byArray4[7] = 14;
        byArray4[8] = 2;
        byArray4[9] = 6;
        byArray4[10] = 5;
        byArray4[11] = 10;
        byArray4[12] = 4;
        byArray4[14] = 15;
        byArray4[15] = 8;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[16];
        byArray5[0] = 9;
        byArray5[2] = 5;
        byArray5[3] = 7;
        byArray5[4] = 2;
        byArray5[5] = 4;
        byArray5[6] = 10;
        byArray5[7] = 15;
        byArray5[8] = 14;
        byArray5[9] = 1;
        byArray5[10] = 11;
        byArray5[11] = 12;
        byArray5[12] = 6;
        byArray5[13] = 8;
        byArray5[14] = 3;
        byArray5[15] = 13;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[16];
        byArray6[0] = 2;
        byArray6[1] = 12;
        byArray6[2] = 6;
        byArray6[3] = 10;
        byArray6[5] = 11;
        byArray6[6] = 8;
        byArray6[7] = 3;
        byArray6[8] = 4;
        byArray6[9] = 13;
        byArray6[10] = 7;
        byArray6[11] = 5;
        byArray6[12] = 15;
        byArray6[13] = 14;
        byArray6[14] = 1;
        byArray6[15] = 9;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[16];
        byArray7[0] = 12;
        byArray7[1] = 5;
        byArray7[2] = 1;
        byArray7[3] = 15;
        byArray7[4] = 14;
        byArray7[5] = 13;
        byArray7[6] = 4;
        byArray7[7] = 10;
        byArray7[9] = 7;
        byArray7[10] = 6;
        byArray7[11] = 3;
        byArray7[12] = 9;
        byArray7[13] = 2;
        byArray7[14] = 8;
        byArray7[15] = 11;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[16];
        byArray8[0] = 13;
        byArray8[1] = 11;
        byArray8[2] = 7;
        byArray8[3] = 14;
        byArray8[4] = 12;
        byArray8[5] = 1;
        byArray8[6] = 3;
        byArray8[7] = 9;
        byArray8[8] = 5;
        byArray8[10] = 15;
        byArray8[11] = 4;
        byArray8[12] = 8;
        byArray8[13] = 6;
        byArray8[14] = 2;
        byArray8[15] = 10;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[16];
        byArray9[0] = 6;
        byArray9[1] = 15;
        byArray9[2] = 14;
        byArray9[3] = 9;
        byArray9[4] = 11;
        byArray9[5] = 3;
        byArray9[7] = 8;
        byArray9[8] = 12;
        byArray9[9] = 2;
        byArray9[10] = 13;
        byArray9[11] = 7;
        byArray9[12] = 1;
        byArray9[13] = 4;
        byArray9[14] = 10;
        byArray9[15] = 5;
        byArrayArray[8] = byArray9;
        byte[] byArray10 = new byte[16];
        byArray10[0] = 10;
        byArray10[1] = 2;
        byArray10[2] = 8;
        byArray10[3] = 4;
        byArray10[4] = 7;
        byArray10[5] = 6;
        byArray10[6] = 1;
        byArray10[7] = 5;
        byArray10[8] = 15;
        byArray10[9] = 11;
        byArray10[10] = 9;
        byArray10[11] = 14;
        byArray10[12] = 3;
        byArray10[13] = 12;
        byArray10[14] = 13;
        byArrayArray[9] = byArray10;
        blake2s_sigma = byArrayArray;
    }

    public Blake2sDigest() {
        this(256, CryptoServicePurpose.ANY);
    }

    public Blake2sDigest(int digestSize) {
        this(digestSize, CryptoServicePurpose.ANY);
    }

    public Blake2sDigest(Blake2sDigest digest) {
        this.bufferPos = digest.bufferPos;
        this.buffer = Arrays.clone(digest.buffer);
        this.keyLength = digest.keyLength;
        this.key = Arrays.clone(digest.key);
        this.digestLength = digest.digestLength;
        this.internalState = Arrays.clone(digest.internalState);
        this.chainValue = Arrays.clone(digest.chainValue);
        this.t0 = digest.t0;
        this.t1 = digest.t1;
        this.f0 = digest.f0;
        this.salt = Arrays.clone(digest.salt);
        this.personalization = Arrays.clone(digest.personalization);
        this.fanout = digest.fanout;
        this.depth = digest.depth;
        this.leafLength = digest.leafLength;
        this.nodeOffset = digest.nodeOffset;
        this.nodeDepth = digest.nodeDepth;
        this.innerHashLength = digest.innerHashLength;
        this.purpose = digest.purpose;
    }

    public Blake2sDigest(int digestBits, CryptoServicePurpose purpose) {
        if (digestBits < 8 || digestBits > 256 || digestBits % 8 != 0) {
            throw new IllegalArgumentException("BLAKE2s digest bit length must be a multiple of 8 and not greater than 256");
        }
        this.digestLength = digestBits / 8;
        this.purpose = purpose;
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties(this, digestBits, purpose));
        this.init(null, null, null);
    }

    public Blake2sDigest(byte[] key) {
        this(key, CryptoServicePurpose.ANY);
    }

    public Blake2sDigest(byte[] key, CryptoServicePurpose purpose) {
        this.purpose = purpose;
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties(this, key.length * 8, purpose));
        this.init(null, null, key);
    }

    public Blake2sDigest(byte[] key, int digestBytes, byte[] salt, byte[] personalization) {
        this(key, digestBytes, salt, personalization, CryptoServicePurpose.ANY);
    }

    public Blake2sDigest(byte[] key, int digestBytes, byte[] salt, byte[] personalization, CryptoServicePurpose purpose) {
        if (digestBytes < 1 || digestBytes > 32) {
            throw new IllegalArgumentException("Invalid digest length (required: 1 - 32)");
        }
        this.digestLength = digestBytes;
        this.purpose = purpose;
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties(this, digestBytes * 8, purpose));
        this.init(salt, personalization, key);
    }

    Blake2sDigest(int digestBytes, byte[] key, byte[] salt, byte[] personalization, long offset, CryptoServicePurpose purpose) {
        this.digestLength = digestBytes;
        this.nodeOffset = offset;
        this.purpose = purpose;
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties(this, digestBytes * 8, purpose));
        this.init(salt, personalization, key);
    }

    Blake2sDigest(int digestBytes, int hashLength, long offset) {
        this(digestBytes, hashLength, offset, CryptoServicePurpose.ANY);
    }

    Blake2sDigest(int digestBytes, int hashLength, long offset, CryptoServicePurpose purpose) {
        this.digestLength = digestBytes;
        this.nodeOffset = offset;
        this.fanout = 0;
        this.depth = 0;
        this.leafLength = hashLength;
        this.innerHashLength = hashLength;
        this.nodeDepth = 0;
        this.purpose = purpose;
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties(this, digestBytes * 8, purpose));
        this.init(null, null, null);
    }

    Blake2sDigest(byte[] key, byte[] param) {
        this.purpose = CryptoServicePurpose.ANY;
        this.digestLength = param[0];
        this.keyLength = param[1];
        this.fanout = param[2];
        this.depth = param[3];
        this.leafLength = Pack.littleEndianToInt(param, 4);
        this.nodeOffset |= (long)Pack.littleEndianToInt(param, 8);
        this.nodeDepth = param[14];
        this.innerHashLength = param[15];
        byte[] salt = new byte[8];
        byte[] personalization = new byte[8];
        System.arraycopy(param, 16, salt, 0, 8);
        System.arraycopy(param, 24, personalization, 0, 8);
        this.init(salt, personalization, key);
    }

    private void init(byte[] salt, byte[] personalization, byte[] key) {
        this.buffer = new byte[64];
        if (key != null && key.length > 0) {
            this.keyLength = key.length;
            if (this.keyLength > 32) {
                throw new IllegalArgumentException("Keys > 32 bytes are not supported");
            }
            this.key = new byte[this.keyLength];
            System.arraycopy(key, 0, this.key, 0, this.keyLength);
            System.arraycopy(key, 0, this.buffer, 0, this.keyLength);
            this.bufferPos = 64;
        }
        if (this.chainValue == null) {
            this.chainValue = new int[8];
            this.chainValue[0] = blake2s_IV[0] ^ (this.digestLength | this.keyLength << 8 | (this.fanout << 16 | this.depth << 24));
            this.chainValue[1] = blake2s_IV[1] ^ this.leafLength;
            int nofHi = (int)(this.nodeOffset >> 32);
            int nofLo = (int)this.nodeOffset;
            this.chainValue[2] = blake2s_IV[2] ^ nofLo;
            this.chainValue[3] = blake2s_IV[3] ^ (nofHi | this.nodeDepth << 16 | this.innerHashLength << 24);
            this.chainValue[4] = blake2s_IV[4];
            this.chainValue[5] = blake2s_IV[5];
            if (salt != null) {
                if (salt.length != 8) {
                    throw new IllegalArgumentException("Salt length must be exactly 8 bytes");
                }
                this.salt = new byte[8];
                System.arraycopy(salt, 0, this.salt, 0, salt.length);
                this.chainValue[4] = this.chainValue[4] ^ Pack.littleEndianToInt(salt, 0);
                this.chainValue[5] = this.chainValue[5] ^ Pack.littleEndianToInt(salt, 4);
            }
            this.chainValue[6] = blake2s_IV[6];
            this.chainValue[7] = blake2s_IV[7];
            if (personalization != null) {
                if (personalization.length != 8) {
                    throw new IllegalArgumentException("Personalization length must be exactly 8 bytes");
                }
                this.personalization = new byte[8];
                System.arraycopy(personalization, 0, this.personalization, 0, personalization.length);
                this.chainValue[6] = this.chainValue[6] ^ Pack.littleEndianToInt(personalization, 0);
                this.chainValue[7] = this.chainValue[7] ^ Pack.littleEndianToInt(personalization, 4);
            }
        }
    }

    private void initializeInternalState() {
        System.arraycopy(this.chainValue, 0, this.internalState, 0, this.chainValue.length);
        System.arraycopy(blake2s_IV, 0, this.internalState, this.chainValue.length, 4);
        this.internalState[12] = this.t0 ^ blake2s_IV[4];
        this.internalState[13] = this.t1 ^ blake2s_IV[5];
        this.internalState[14] = this.f0 ^ blake2s_IV[6];
        this.internalState[15] = this.f1 ^ blake2s_IV[7];
    }

    @Override
    public void update(byte b) {
        int remainingLength = 64 - this.bufferPos;
        if (remainingLength == 0) {
            this.t0 += 64;
            if (this.t0 == 0) {
                ++this.t1;
            }
            this.compress(this.buffer, 0);
            Arrays.fill(this.buffer, (byte)0);
            this.buffer[0] = b;
            this.bufferPos = 1;
        } else {
            this.buffer[this.bufferPos] = b;
            ++this.bufferPos;
        }
    }

    @Override
    public void update(byte[] message, int offset, int len) {
        if (message == null || len == 0) {
            return;
        }
        int remainingLength = 0;
        if (this.bufferPos != 0) {
            remainingLength = 64 - this.bufferPos;
            if (remainingLength < len) {
                System.arraycopy(message, offset, this.buffer, this.bufferPos, remainingLength);
                this.t0 += 64;
                if (this.t0 == 0) {
                    ++this.t1;
                }
                this.compress(this.buffer, 0);
                this.bufferPos = 0;
                Arrays.fill(this.buffer, (byte)0);
            } else {
                System.arraycopy(message, offset, this.buffer, this.bufferPos, len);
                this.bufferPos += len;
                return;
            }
        }
        int blockWiseLastPos = offset + len - 64;
        int messagePos = offset + remainingLength;
        while (messagePos < blockWiseLastPos) {
            this.t0 += 64;
            if (this.t0 == 0) {
                ++this.t1;
            }
            this.compress(message, messagePos);
            messagePos += 64;
        }
        System.arraycopy(message, messagePos, this.buffer, 0, offset + len - messagePos);
        this.bufferPos += offset + len - messagePos;
    }

    @Override
    public int doFinal(byte[] out, int outOffset) {
        if (outOffset > out.length - this.digestLength) {
            throw new OutputLengthException("output buffer too short");
        }
        this.f0 = -1;
        if (this.isLastNode) {
            this.f1 = -1;
        }
        this.t0 += this.bufferPos;
        if (this.t0 < 0 && this.bufferPos > -this.t0) {
            ++this.t1;
        }
        this.compress(this.buffer, 0);
        Arrays.fill(this.buffer, (byte)0);
        Arrays.fill(this.internalState, 0);
        int full = this.digestLength >>> 2;
        int partial = this.digestLength & 3;
        Pack.intToLittleEndian(this.chainValue, 0, full, out, outOffset);
        if (partial > 0) {
            byte[] bytes = new byte[4];
            Pack.intToLittleEndian(this.chainValue[full], bytes, 0);
            System.arraycopy(bytes, 0, out, outOffset + this.digestLength - partial, partial);
        }
        Arrays.fill(this.chainValue, 0);
        this.reset();
        return this.digestLength;
    }

    @Override
    public void reset() {
        this.bufferPos = 0;
        this.f0 = 0;
        this.f1 = 0;
        this.t0 = 0;
        this.t1 = 0;
        this.isLastNode = false;
        this.chainValue = null;
        Arrays.fill(this.buffer, (byte)0);
        if (this.key != null) {
            System.arraycopy(this.key, 0, this.buffer, 0, this.key.length);
            this.bufferPos = 64;
        }
        this.init(this.salt, this.personalization, this.key);
    }

    private void compress(byte[] message, int messagePos) {
        this.initializeInternalState();
        int[] m = new int[16];
        Pack.littleEndianToInt(message, messagePos, m);
        int round = 0;
        while (round < 10) {
            this.G(m[blake2s_sigma[round][0]], m[blake2s_sigma[round][1]], 0, 4, 8, 12);
            this.G(m[blake2s_sigma[round][2]], m[blake2s_sigma[round][3]], 1, 5, 9, 13);
            this.G(m[blake2s_sigma[round][4]], m[blake2s_sigma[round][5]], 2, 6, 10, 14);
            this.G(m[blake2s_sigma[round][6]], m[blake2s_sigma[round][7]], 3, 7, 11, 15);
            this.G(m[blake2s_sigma[round][8]], m[blake2s_sigma[round][9]], 0, 5, 10, 15);
            this.G(m[blake2s_sigma[round][10]], m[blake2s_sigma[round][11]], 1, 6, 11, 12);
            this.G(m[blake2s_sigma[round][12]], m[blake2s_sigma[round][13]], 2, 7, 8, 13);
            this.G(m[blake2s_sigma[round][14]], m[blake2s_sigma[round][15]], 3, 4, 9, 14);
            ++round;
        }
        int offset = 0;
        while (offset < this.chainValue.length) {
            this.chainValue[offset] = this.chainValue[offset] ^ this.internalState[offset] ^ this.internalState[offset + 8];
            ++offset;
        }
    }

    private void G(int m1, int m2, int posA, int posB, int posC, int posD) {
        this.internalState[posA] = this.internalState[posA] + this.internalState[posB] + m1;
        this.internalState[posD] = Integers.rotateRight(this.internalState[posD] ^ this.internalState[posA], 16);
        this.internalState[posC] = this.internalState[posC] + this.internalState[posD];
        this.internalState[posB] = Integers.rotateRight(this.internalState[posB] ^ this.internalState[posC], 12);
        this.internalState[posA] = this.internalState[posA] + this.internalState[posB] + m2;
        this.internalState[posD] = Integers.rotateRight(this.internalState[posD] ^ this.internalState[posA], 8);
        this.internalState[posC] = this.internalState[posC] + this.internalState[posD];
        this.internalState[posB] = Integers.rotateRight(this.internalState[posB] ^ this.internalState[posC], 7);
    }

    protected void setAsLastNode() {
        this.isLastNode = true;
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE2s";
    }

    @Override
    public int getDigestSize() {
        return this.digestLength;
    }

    @Override
    public int getByteLength() {
        return 64;
    }

    public void clearKey() {
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            Arrays.fill(this.buffer, (byte)0);
        }
    }

    public void clearSalt() {
        if (this.salt != null) {
            Arrays.fill(this.salt, (byte)0);
        }
    }
}

