/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.util.Pack;

public class ISAPDigest
implements Digest {
    private long x0;
    private long x1;
    private long x2;
    private long x3;
    private long x4;
    private long t0;
    private long t1;
    private long t2;
    private long t3;
    private long t4;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    private void ROUND(long C) {
        this.t0 = this.x0 ^ this.x1 ^ this.x2 ^ this.x3 ^ C ^ this.x1 & (this.x0 ^ this.x2 ^ this.x4 ^ C);
        this.t1 = this.x0 ^ this.x2 ^ this.x3 ^ this.x4 ^ C ^ (this.x1 ^ this.x2 ^ C) & (this.x1 ^ this.x3);
        this.t2 = this.x1 ^ this.x2 ^ this.x4 ^ C ^ this.x3 & this.x4;
        this.t3 = this.x0 ^ this.x1 ^ this.x2 ^ C ^ (this.x0 ^ 0xFFFFFFFFFFFFFFFFL) & (this.x3 ^ this.x4);
        this.t4 = this.x1 ^ this.x3 ^ this.x4 ^ (this.x0 ^ this.x4) & this.x1;
        this.x0 = this.t0 ^ this.ROTR(this.t0, 19L) ^ this.ROTR(this.t0, 28L);
        this.x1 = this.t1 ^ this.ROTR(this.t1, 39L) ^ this.ROTR(this.t1, 61L);
        this.x2 = this.t2 ^ this.ROTR(this.t2, 1L) ^ this.ROTR(this.t2, 6L) ^ 0xFFFFFFFFFFFFFFFFL;
        this.x3 = this.t3 ^ this.ROTR(this.t3, 10L) ^ this.ROTR(this.t3, 17L);
        this.x4 = this.t4 ^ this.ROTR(this.t4, 7L) ^ this.ROTR(this.t4, 41L);
    }

    private void P12() {
        this.ROUND(240L);
        this.ROUND(225L);
        this.ROUND(210L);
        this.ROUND(195L);
        this.ROUND(180L);
        this.ROUND(165L);
        this.ROUND(150L);
        this.ROUND(135L);
        this.ROUND(120L);
        this.ROUND(105L);
        this.ROUND(90L);
        this.ROUND(75L);
    }

    private long ROTR(long x, long n) {
        return x >>> (int)n | x << (int)(64L - n);
    }

    protected long U64BIG(long x) {
        return this.ROTR(x, 8L) & 0xFF000000FF000000L | this.ROTR(x, 24L) & 0xFF000000FF0000L | this.ROTR(x, 40L) & 0xFF000000FF00L | this.ROTR(x, 56L) & 0xFF000000FFL;
    }

    @Override
    public String getAlgorithmName() {
        return "ISAP Hash";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public void update(byte input) {
        this.buffer.write(input);
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.buffer.write(input, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        if (32 + outOff > out.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        this.t4 = 0L;
        this.t3 = 0L;
        this.t2 = 0L;
        this.t1 = 0L;
        this.t0 = 0L;
        this.x0 = -1255492011513352131L;
        this.x1 = -8380609354527731710L;
        this.x2 = -5437372128236807582L;
        this.x3 = 4834782570098516968L;
        this.x4 = 3787428097924915520L;
        byte[] input = this.buffer.toByteArray();
        int len = input.length;
        long[] in64 = new long[len >> 3];
        Pack.littleEndianToLong(input, 0, in64, 0, in64.length);
        int idx = 0;
        while (len >= 8) {
            this.x0 ^= this.U64BIG(in64[idx++]);
            this.P12();
            len -= 8;
        }
        this.x0 ^= 128L << (7 - len << 3);
        while (len > 0) {
            this.x0 ^= ((long)input[(idx << 3) + --len] & 0xFFL) << (7 - len << 3);
        }
        this.P12();
        long[] out64 = new long[4];
        idx = 0;
        while (idx < 3) {
            out64[idx] = this.U64BIG(this.x0);
            this.P12();
            ++idx;
        }
        out64[idx] = this.U64BIG(this.x0);
        Pack.longToLittleEndian(out64, out, outOff);
        this.buffer.reset();
        return 32;
    }

    @Override
    public void reset() {
        this.buffer.reset();
    }
}

