/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.engines.AEADBufferBaseEngine;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class ISAPEngine
extends AEADBufferBaseEngine {
    final int ISAP_STATE_SZ = 40;
    private byte[] k;
    private byte[] npub;
    private int ISAP_rH;
    private ISAP_AEAD ISAPAEAD;

    public ISAPEngine(IsapType isapType) {
        this.KEY_SIZE = 16;
        this.IV_SIZE = 16;
        this.MAC_SIZE = 16;
        switch (isapType) {
            case ISAP_A_128A: {
                this.ISAPAEAD = new ISAPAEAD_A_128A();
                this.algorithmName = "ISAP-A-128A AEAD";
                break;
            }
            case ISAP_K_128A: {
                this.ISAPAEAD = new ISAPAEAD_K_128A();
                this.algorithmName = "ISAP-K-128A AEAD";
                break;
            }
            case ISAP_A_128: {
                this.ISAPAEAD = new ISAPAEAD_A_128();
                this.algorithmName = "ISAP-A-128 AEAD";
                break;
            }
            case ISAP_K_128: {
                this.ISAPAEAD = new ISAPAEAD_K_128();
                this.algorithmName = "ISAP-K-128 AEAD";
            }
        }
        this.AADBufferSize = this.BlockSize;
        this.m_aad = new byte[this.AADBufferSize];
    }

    @Override
    protected void init(byte[] key, byte[] iv) throws IllegalArgumentException {
        this.npub = iv;
        this.k = key;
        this.m_buf = new byte[this.BlockSize + (this.forEncryption ? 0 : this.MAC_SIZE)];
        this.ISAPAEAD.init();
        this.initialised = true;
        this.m_state = this.forEncryption ? AEADBufferBaseEngine.State.EncInit : AEADBufferBaseEngine.State.DecInit;
        this.reset();
    }

    @Override
    protected void processBufferAAD(byte[] input, int inOff) {
        this.ISAPAEAD.absorbMacBlock(input, inOff);
    }

    @Override
    protected void processFinalAAD() {
        if (!this.aadFinished) {
            this.ISAPAEAD.absorbFinalAADBlock();
            this.ISAPAEAD.swapInternalState();
            this.m_aadPos = 0;
            this.aadFinished = true;
        }
    }

    @Override
    protected void processBuffer(byte[] input, int inOff, byte[] output, int outOff) {
        this.processFinalAAD();
        this.ISAPAEAD.processEncBlock(input, inOff, output, outOff);
        this.ISAPAEAD.swapInternalState();
        if (this.forEncryption) {
            this.ISAPAEAD.absorbMacBlock(output, outOff);
        } else {
            this.ISAPAEAD.absorbMacBlock(input, inOff);
        }
        this.ISAPAEAD.swapInternalState();
    }

    @Override
    protected void processFinalBlock(byte[] output, int outOff) {
        this.processFinalAAD();
        int len = this.m_bufPos;
        this.mac = new byte[this.MAC_SIZE];
        this.ISAPAEAD.processEncFinalBlock(output, outOff);
        this.ISAPAEAD.swapInternalState();
        if (this.forEncryption) {
            this.ISAPAEAD.processMACFinal(output, outOff, len, this.mac);
        } else {
            this.ISAPAEAD.processMACFinal(this.m_buf, 0, len, this.mac);
        }
    }

    @Override
    protected void reset(boolean clearMac) {
        if (!this.initialised) {
            throw new IllegalStateException("Need call init function before encryption/decryption");
        }
        Arrays.fill(this.m_buf, (byte)0);
        Arrays.fill(this.m_aad, (byte)0);
        this.ISAPAEAD.reset();
        this.m_bufPos = 0;
        this.m_aadPos = 0;
        this.aadFinished = false;
        super.reset(clearMac);
    }

    private abstract class ISAPAEAD_A
    implements ISAP_AEAD {
        protected long[] k64;
        protected long[] npub64;
        protected long ISAP_IV1_64;
        protected long ISAP_IV2_64;
        protected long ISAP_IV3_64;
        protected long x0;
        protected long x1;
        protected long x2;
        protected long x3;
        protected long x4;
        protected long t0;
        protected long t1;
        protected long t2;
        protected long t3;
        protected long t4;
        protected long macx0;
        protected long macx1;
        protected long macx2;
        protected long macx3;
        protected long macx4;

        public ISAPAEAD_A() {
            ISAPEngine.this.ISAP_rH = 64;
            ISAPEngine.this.BlockSize = ISAPEngine.this.ISAP_rH + 7 >> 3;
        }

        @Override
        public void init() {
            this.npub64 = new long[this.getLongSize(ISAPEngine.this.npub.length)];
            this.k64 = new long[this.getLongSize(ISAPEngine.this.k.length)];
            Pack.bigEndianToLong(ISAPEngine.this.npub, 0, this.npub64);
            Pack.bigEndianToLong(ISAPEngine.this.k, 0, this.k64);
        }

        protected abstract void PX1();

        protected abstract void PX2();

        @Override
        public void swapInternalState() {
            this.t0 = this.x0;
            this.t1 = this.x1;
            this.t2 = this.x2;
            this.t3 = this.x3;
            this.t4 = this.x4;
            this.x0 = this.macx0;
            this.x1 = this.macx1;
            this.x2 = this.macx2;
            this.x3 = this.macx3;
            this.x4 = this.macx4;
            this.macx0 = this.t0;
            this.macx1 = this.t1;
            this.macx2 = this.t2;
            this.macx3 = this.t3;
            this.macx4 = this.t4;
        }

        @Override
        public void absorbMacBlock(byte[] input, int inOff) {
            this.x0 ^= Pack.bigEndianToLong(input, inOff);
            this.P12();
        }

        @Override
        public void absorbFinalAADBlock() {
            if (ISAPEngine.this.m_aadPos == ISAPEngine.this.AADBufferSize) {
                this.absorbMacBlock(ISAPEngine.this.m_aad, 0);
                ISAPEngine.this.m_aadPos = 0;
            } else {
                int i = 0;
                while (i < ISAPEngine.this.m_aadPos) {
                    this.x0 ^= ((long)ISAPEngine.this.m_aad[i] & 0xFFL) << (7 - i << 3);
                    ++i;
                }
            }
            this.x0 ^= 128L << (7 - ISAPEngine.this.m_aadPos << 3);
            this.P12();
            this.x4 ^= 1L;
        }

        @Override
        public void processMACFinal(byte[] input, int inOff, int len, byte[] tag) {
            if (len == ISAPEngine.this.BlockSize) {
                this.absorbMacBlock(input, inOff);
                len = 0;
            } else {
                int i = 0;
                while (i < len) {
                    this.x0 ^= ((long)input[inOff++] & 0xFFL) << (7 - i << 3);
                    ++i;
                }
            }
            this.x0 ^= 128L << (7 - len << 3);
            this.P12();
            Pack.longToBigEndian(this.x0, tag, 0);
            Pack.longToBigEndian(this.x1, tag, 8);
            long tmp_x2 = this.x2;
            long tmp_x3 = this.x3;
            long tmp_x4 = this.x4;
            this.isap_rk(this.ISAP_IV2_64, tag, ISAPEngine.this.KEY_SIZE);
            this.x2 = tmp_x2;
            this.x3 = tmp_x3;
            this.x4 = tmp_x4;
            this.P12();
            Pack.longToBigEndian(this.x0, tag, 0);
            Pack.longToBigEndian(this.x1, tag, 8);
        }

        public void isap_rk(long iv64, byte[] y, int ylen) {
            this.x0 = this.k64[0];
            this.x1 = this.k64[1];
            this.x2 = iv64;
            this.x4 = 0L;
            this.x3 = 0L;
            this.P12();
            int i = 0;
            while (i < (ylen << 3) - 1) {
                this.x0 ^= ((long)((y[i >>> 3] >>> 7 - (i & 7) & 1) << 7) & 0xFFL) << 56;
                this.PX2();
                ++i;
            }
            this.x0 ^= ((long)y[ylen - 1] & 1L) << 7 << 56;
            this.P12();
        }

        @Override
        public void processEncBlock(byte[] input, int inOff, byte[] output, int outOff) {
            long m64 = Pack.littleEndianToLong(input, inOff);
            long c64 = this.U64BIG(this.x0) ^ m64;
            this.PX1();
            Pack.longToLittleEndian(c64, output, outOff);
        }

        @Override
        public void processEncFinalBlock(byte[] output, int outOff) {
            if (ISAPEngine.this.m_bufPos == ISAPEngine.this.BlockSize) {
                this.processEncBlock(ISAPEngine.this.m_buf, 0, output, outOff);
            } else {
                byte[] xo = Pack.longToLittleEndian(this.x0);
                int mlen = ISAPEngine.this.m_bufPos;
                while (mlen > 0) {
                    output[outOff + mlen - 1] = (byte)(xo[ISAPEngine.this.BlockSize - mlen] ^ ISAPEngine.this.m_buf[--mlen]);
                }
            }
        }

        @Override
        public void reset() {
            this.isap_rk(this.ISAP_IV3_64, ISAPEngine.this.npub, ISAPEngine.this.IV_SIZE);
            this.x3 = this.npub64[0];
            this.x4 = this.npub64[1];
            this.PX1();
            this.swapInternalState();
            this.x0 = this.npub64[0];
            this.x1 = this.npub64[1];
            this.x2 = this.ISAP_IV1_64;
            this.x4 = 0L;
            this.x3 = 0L;
            this.P12();
        }

        private int getLongSize(int x) {
            return (x >>> 3) + ((x & 7) != 0 ? 1 : 0);
        }

        private long ROTR(long x, long n) {
            return x >>> (int)n | x << (int)(64L - n);
        }

        protected long U64BIG(long x) {
            return this.ROTR(x, 8L) & 0xFF000000FF000000L | this.ROTR(x, 24L) & 0xFF000000FF0000L | this.ROTR(x, 40L) & 0xFF000000FF00L | this.ROTR(x, 56L) & 0xFF000000FFL;
        }

        protected void ROUND(long C) {
            this.t0 = this.x0 ^ this.x1 ^ this.x2 ^ this.x3 ^ C ^ this.x1 & (this.x0 ^ this.x2 ^ this.x4 ^ C);
            this.t1 = this.x0 ^ this.x2 ^ this.x3 ^ this.x4 ^ C ^ (this.x1 ^ this.x2 ^ C) & (this.x1 ^ this.x3);
            this.t2 = this.x1 ^ this.x2 ^ this.x4 ^ C ^ this.x3 & this.x4;
            this.t3 = this.x0 ^ this.x1 ^ this.x2 ^ C ^ (this.x0 ^ 0xFFFFFFFFFFFFFFFFL) & (this.x3 ^ this.x4);
            this.t4 = this.x1 ^ this.x3 ^ this.x4 ^ (this.x0 ^ this.x4) & this.x1;
            this.x0 = this.t0 ^ this.ROTR(this.t0, 19L) ^ this.ROTR(this.t0, 28L);
            this.x1 = this.t1 ^ this.ROTR(this.t1, 39L) ^ this.ROTR(this.t1, 61L);
            this.x2 = this.t2 ^ this.ROTR(this.t2, 1L) ^ this.ROTR(this.t2, 6L) ^ 0xFFFFFFFFFFFFFFFFL;
            this.x3 = this.t3 ^ this.ROTR(this.t3, 10L) ^ this.ROTR(this.t3, 17L);
            this.x4 = this.t4 ^ this.ROTR(this.t4, 7L) ^ this.ROTR(this.t4, 41L);
        }

        public void P12() {
            this.ROUND(240L);
            this.ROUND(225L);
            this.ROUND(210L);
            this.ROUND(195L);
            this.ROUND(180L);
            this.ROUND(165L);
            this.P6();
        }

        protected void P6() {
            this.ROUND(150L);
            this.ROUND(135L);
            this.ROUND(120L);
            this.ROUND(105L);
            this.ROUND(90L);
            this.ROUND(75L);
        }
    }

    private class ISAPAEAD_A_128
    extends ISAPAEAD_A {
        public ISAPAEAD_A_128() {
            this.ISAP_IV1_64 = 108156764298152972L;
            this.ISAP_IV2_64 = 180214358336080908L;
            this.ISAP_IV3_64 = 252271952374008844L;
        }

        @Override
        protected void PX1() {
            this.P12();
        }

        @Override
        protected void PX2() {
            this.P12();
        }
    }

    private class ISAPAEAD_A_128A
    extends ISAPAEAD_A {
        public ISAPAEAD_A_128A() {
            this.ISAP_IV1_64 = 108156764297430540L;
            this.ISAP_IV2_64 = 180214358335358476L;
            this.ISAP_IV3_64 = 252271952373286412L;
        }

        @Override
        protected void PX1() {
            this.P6();
        }

        @Override
        protected void PX2() {
            this.ROUND(75L);
        }
    }

    private abstract class ISAPAEAD_K
    implements ISAP_AEAD {
        final int ISAP_STATE_SZ_CRYPTO_NPUBBYTES;
        protected short[] ISAP_IV1_16;
        protected short[] ISAP_IV2_16;
        protected short[] ISAP_IV3_16;
        protected short[] k16;
        protected short[] iv16;
        private final int[] KeccakF400RoundConstants;
        protected short[] SX;
        protected short[] macSX;
        protected short[] E;
        protected short[] C;
        protected short[] macE;
        protected short[] macC;

        public ISAPAEAD_K() {
            this.ISAP_STATE_SZ_CRYPTO_NPUBBYTES = 40 - ISAPEngine.this.IV_SIZE;
            this.KeccakF400RoundConstants = new int[]{1, 32898, 32906, 32768, 32907, 1, 32897, 32777, 138, 136, 32777, 10, 32907, 139, 32905, 32771, 32770, 128, 32778, 10};
            this.SX = new short[25];
            this.macSX = new short[25];
            this.E = new short[25];
            this.C = new short[5];
            this.macE = new short[25];
            this.macC = new short[5];
            ISAPEngine.this.ISAP_rH = 144;
            ISAPEngine.this.BlockSize = ISAPEngine.this.ISAP_rH + 7 >> 3;
        }

        @Override
        public void init() {
            this.k16 = new short[ISAPEngine.this.k.length >> 1];
            this.byteToShort(ISAPEngine.this.k, this.k16, this.k16.length);
            this.iv16 = new short[ISAPEngine.this.npub.length >> 1];
            this.byteToShort(ISAPEngine.this.npub, this.iv16, this.iv16.length);
        }

        @Override
        public void reset() {
            Arrays.fill(this.SX, (short)0);
            this.isap_rk(this.ISAP_IV3_16, ISAPEngine.this.npub, ISAPEngine.this.IV_SIZE, this.SX, this.ISAP_STATE_SZ_CRYPTO_NPUBBYTES, this.C);
            System.arraycopy(this.iv16, 0, this.SX, 17, 8);
            this.PermuteRoundsKX(this.SX, this.E, this.C);
            this.swapInternalState();
            Arrays.fill(this.SX, 12, 25, (short)0);
            System.arraycopy(this.iv16, 0, this.SX, 0, 8);
            System.arraycopy(this.ISAP_IV1_16, 0, this.SX, 8, 4);
            this.PermuteRoundsHX(this.SX, this.E, this.C);
        }

        @Override
        public void swapInternalState() {
            short[] tmp = this.SX;
            this.SX = this.macSX;
            this.macSX = tmp;
            tmp = this.E;
            this.E = this.macE;
            this.macE = tmp;
            tmp = this.C;
            this.C = this.macC;
            this.macC = tmp;
        }

        protected abstract void PermuteRoundsHX(short[] var1, short[] var2, short[] var3);

        protected abstract void PermuteRoundsKX(short[] var1, short[] var2, short[] var3);

        protected abstract void PermuteRoundsBX(short[] var1, short[] var2, short[] var3);

        @Override
        public void absorbMacBlock(byte[] input, int inOff) {
            this.byteToShortXor(input, inOff, this.SX, ISAPEngine.this.BlockSize >> 1);
            this.PermuteRoundsHX(this.SX, this.E, this.C);
        }

        @Override
        public void absorbFinalAADBlock() {
            if (ISAPEngine.this.m_aadPos == ISAPEngine.this.AADBufferSize) {
                this.absorbMacBlock(ISAPEngine.this.m_aad, 0);
                ISAPEngine.this.m_aadPos = 0;
            } else {
                int i = 0;
                while (i < ISAPEngine.this.m_aadPos) {
                    int n = i >> 1;
                    this.SX[n] = (short)(this.SX[n] ^ (ISAPEngine.this.m_aad[i] & 0xFF) << ((i & 1) << 3));
                    ++i;
                }
            }
            int n = ISAPEngine.this.m_aadPos >> 1;
            this.SX[n] = (short)(this.SX[n] ^ 128 << ((ISAPEngine.this.m_aadPos & 1) << 3));
            this.PermuteRoundsHX(this.SX, this.E, this.C);
            this.SX[24] = (short)(this.SX[24] ^ 0x100);
        }

        public void isap_rk(short[] iv16, byte[] y, int ylen, short[] out16, int outlen, short[] C) {
            short[] SX = new short[25];
            short[] E = new short[25];
            System.arraycopy(this.k16, 0, SX, 0, 8);
            System.arraycopy(iv16, 0, SX, 8, 4);
            this.PermuteRoundsKX(SX, E, C);
            int i = 0;
            while (i < (ylen << 3) - 1) {
                SX[0] = (short)(SX[0] ^ (y[i >> 3] >>> 7 - (i & 7) & 1) << 7);
                this.PermuteRoundsBX(SX, E, C);
                ++i;
            }
            SX[0] = (short)(SX[0] ^ (y[ylen - 1] & 1) << 7);
            this.PermuteRoundsKX(SX, E, C);
            System.arraycopy(SX, 0, out16, 0, outlen == this.ISAP_STATE_SZ_CRYPTO_NPUBBYTES ? 17 : 8);
        }

        @Override
        public void processMACFinal(byte[] input, int inOff, int len, byte[] tag) {
            if (len == ISAPEngine.this.BlockSize) {
                this.absorbMacBlock(input, inOff);
                len = 0;
            } else {
                int i = 0;
                while (i < len) {
                    int n = i >> 1;
                    this.SX[n] = (short)(this.SX[n] ^ (input[inOff++] & 0xFF) << ((i & 1) << 3));
                    ++i;
                }
            }
            int n = len >> 1;
            this.SX[n] = (short)(this.SX[n] ^ 128 << ((len & 1) << 3));
            this.PermuteRoundsHX(this.SX, this.E, this.C);
            this.shortToByte(this.SX, tag);
            this.isap_rk(this.ISAP_IV2_16, tag, ISAPEngine.this.KEY_SIZE, this.SX, ISAPEngine.this.KEY_SIZE, this.C);
            this.PermuteRoundsHX(this.SX, this.E, this.C);
            this.shortToByte(this.SX, tag);
        }

        @Override
        public void processEncBlock(byte[] input, int inOff, byte[] output, int outOff) {
            int i = 0;
            while (i < ISAPEngine.this.BlockSize) {
                output[outOff++] = (byte)(this.SX[i >> 1] >>> ((i & 1) << 3) ^ input[inOff++]);
                ++i;
            }
            this.PermuteRoundsKX(this.SX, this.E, this.C);
        }

        @Override
        public void processEncFinalBlock(byte[] output, int outOff) {
            int len = ISAPEngine.this.m_bufPos;
            int i = 0;
            while (i < len) {
                output[outOff++] = (byte)(this.SX[i >> 1] >>> ((i & 1) << 3) ^ ISAPEngine.this.m_buf[i]);
                ++i;
            }
        }

        private void byteToShortXor(byte[] input, int inOff, short[] output, int outLen) {
            int i = 0;
            while (i < outLen) {
                int n = i;
                output[n] = (short)(output[n] ^ Pack.littleEndianToShort(input, inOff + (i << 1)));
                ++i;
            }
        }

        private void byteToShort(byte[] input, short[] output, int outLen) {
            int i = 0;
            while (i < outLen) {
                output[i] = Pack.littleEndianToShort(input, i << 1);
                ++i;
            }
        }

        private void shortToByte(short[] input, byte[] output) {
            int i = 0;
            while (i < 8) {
                Pack.shortToLittleEndian(input[i], output, i << 1);
                ++i;
            }
        }

        protected void rounds12X(short[] SX, short[] E, short[] C) {
            this.prepareThetaX(SX, C);
            this.rounds_8_18(SX, E, C);
        }

        protected void rounds_4_18(short[] SX, short[] E, short[] C) {
            this.thetaRhoPiChiIotaPrepareTheta(4, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(5, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(6, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(7, E, SX, C);
            this.rounds_8_18(SX, E, C);
        }

        protected void rounds_8_18(short[] SX, short[] E, short[] C) {
            this.thetaRhoPiChiIotaPrepareTheta(8, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(9, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(10, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(11, E, SX, C);
            this.rounds_12_18(SX, E, C);
        }

        protected void rounds_12_18(short[] SX, short[] E, short[] C) {
            this.thetaRhoPiChiIotaPrepareTheta(12, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(13, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(14, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(15, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(16, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(17, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(18, SX, E, C);
            this.thetaRhoPiChiIota(E, SX, C);
        }

        protected void prepareThetaX(short[] SX, short[] C) {
            C[0] = (short)(SX[0] ^ SX[5] ^ SX[10] ^ SX[15] ^ SX[20]);
            C[1] = (short)(SX[1] ^ SX[6] ^ SX[11] ^ SX[16] ^ SX[21]);
            C[2] = (short)(SX[2] ^ SX[7] ^ SX[12] ^ SX[17] ^ SX[22]);
            C[3] = (short)(SX[3] ^ SX[8] ^ SX[13] ^ SX[18] ^ SX[23]);
            C[4] = (short)(SX[4] ^ SX[9] ^ SX[14] ^ SX[19] ^ SX[24]);
        }

        private short ROL16(short a, int offset) {
            return (short)((a & 0xFFFF) << offset ^ (a & 0xFFFF) >>> 16 - offset);
        }

        protected void thetaRhoPiChiIotaPrepareTheta(int i, short[] A, short[] E, short[] C) {
            short Da = (short)(C[4] ^ this.ROL16(C[1], 1));
            short De = (short)(C[0] ^ this.ROL16(C[2], 1));
            short Di = (short)(C[1] ^ this.ROL16(C[3], 1));
            short Do = (short)(C[2] ^ this.ROL16(C[4], 1));
            short Du = (short)(C[3] ^ this.ROL16(C[0], 1));
            short Ba = A[0] = (short)(A[0] ^ Da);
            A[6] = (short)(A[6] ^ De);
            short Be = this.ROL16(A[6], 12);
            A[12] = (short)(A[12] ^ Di);
            short Bi = this.ROL16(A[12], 11);
            A[18] = (short)(A[18] ^ Do);
            short Bo = this.ROL16(A[18], 5);
            A[24] = (short)(A[24] ^ Du);
            short Bu = this.ROL16(A[24], 14);
            C[0] = E[0] = (short)(Ba ^ ~Be & Bi ^ this.KeccakF400RoundConstants[i]);
            C[1] = E[1] = (short)(Be ^ ~Bi & Bo);
            C[2] = E[2] = (short)(Bi ^ ~Bo & Bu);
            C[3] = E[3] = (short)(Bo ^ ~Bu & Ba);
            C[4] = E[4] = (short)(Bu ^ ~Ba & Be);
            A[3] = (short)(A[3] ^ Do);
            Ba = this.ROL16(A[3], 12);
            A[9] = (short)(A[9] ^ Du);
            Be = this.ROL16(A[9], 4);
            A[10] = (short)(A[10] ^ Da);
            Bi = this.ROL16(A[10], 3);
            A[16] = (short)(A[16] ^ De);
            Bo = this.ROL16(A[16], 13);
            A[22] = (short)(A[22] ^ Di);
            Bu = this.ROL16(A[22], 13);
            E[5] = (short)(Ba ^ ~Be & Bi);
            C[0] = (short)(C[0] ^ E[5]);
            E[6] = (short)(Be ^ ~Bi & Bo);
            C[1] = (short)(C[1] ^ E[6]);
            E[7] = (short)(Bi ^ ~Bo & Bu);
            C[2] = (short)(C[2] ^ E[7]);
            E[8] = (short)(Bo ^ ~Bu & Ba);
            C[3] = (short)(C[3] ^ E[8]);
            E[9] = (short)(Bu ^ ~Ba & Be);
            C[4] = (short)(C[4] ^ E[9]);
            A[1] = (short)(A[1] ^ De);
            Ba = this.ROL16(A[1], 1);
            A[7] = (short)(A[7] ^ Di);
            Be = this.ROL16(A[7], 6);
            A[13] = (short)(A[13] ^ Do);
            Bi = this.ROL16(A[13], 9);
            A[19] = (short)(A[19] ^ Du);
            Bo = this.ROL16(A[19], 8);
            A[20] = (short)(A[20] ^ Da);
            Bu = this.ROL16(A[20], 2);
            E[10] = (short)(Ba ^ ~Be & Bi);
            C[0] = (short)(C[0] ^ E[10]);
            E[11] = (short)(Be ^ ~Bi & Bo);
            C[1] = (short)(C[1] ^ E[11]);
            E[12] = (short)(Bi ^ ~Bo & Bu);
            C[2] = (short)(C[2] ^ E[12]);
            E[13] = (short)(Bo ^ ~Bu & Ba);
            C[3] = (short)(C[3] ^ E[13]);
            E[14] = (short)(Bu ^ ~Ba & Be);
            C[4] = (short)(C[4] ^ E[14]);
            A[4] = (short)(A[4] ^ Du);
            Ba = this.ROL16(A[4], 11);
            A[5] = (short)(A[5] ^ Da);
            Be = this.ROL16(A[5], 4);
            A[11] = (short)(A[11] ^ De);
            Bi = this.ROL16(A[11], 10);
            A[17] = (short)(A[17] ^ Di);
            Bo = this.ROL16(A[17], 15);
            A[23] = (short)(A[23] ^ Do);
            Bu = this.ROL16(A[23], 8);
            E[15] = (short)(Ba ^ ~Be & Bi);
            C[0] = (short)(C[0] ^ E[15]);
            E[16] = (short)(Be ^ ~Bi & Bo);
            C[1] = (short)(C[1] ^ E[16]);
            E[17] = (short)(Bi ^ ~Bo & Bu);
            C[2] = (short)(C[2] ^ E[17]);
            E[18] = (short)(Bo ^ ~Bu & Ba);
            C[3] = (short)(C[3] ^ E[18]);
            E[19] = (short)(Bu ^ ~Ba & Be);
            C[4] = (short)(C[4] ^ E[19]);
            A[2] = (short)(A[2] ^ Di);
            Ba = this.ROL16(A[2], 14);
            A[8] = (short)(A[8] ^ Do);
            Be = this.ROL16(A[8], 7);
            A[14] = (short)(A[14] ^ Du);
            Bi = this.ROL16(A[14], 7);
            A[15] = (short)(A[15] ^ Da);
            Bo = this.ROL16(A[15], 9);
            A[21] = (short)(A[21] ^ De);
            Bu = this.ROL16(A[21], 2);
            E[20] = (short)(Ba ^ ~Be & Bi);
            C[0] = (short)(C[0] ^ E[20]);
            E[21] = (short)(Be ^ ~Bi & Bo);
            C[1] = (short)(C[1] ^ E[21]);
            E[22] = (short)(Bi ^ ~Bo & Bu);
            C[2] = (short)(C[2] ^ E[22]);
            E[23] = (short)(Bo ^ ~Bu & Ba);
            C[3] = (short)(C[3] ^ E[23]);
            E[24] = (short)(Bu ^ ~Ba & Be);
            C[4] = (short)(C[4] ^ E[24]);
        }

        protected void thetaRhoPiChiIota(short[] A, short[] E, short[] C) {
            short Da = (short)(C[4] ^ this.ROL16(C[1], 1));
            short De = (short)(C[0] ^ this.ROL16(C[2], 1));
            short Di = (short)(C[1] ^ this.ROL16(C[3], 1));
            short Do = (short)(C[2] ^ this.ROL16(C[4], 1));
            short Du = (short)(C[3] ^ this.ROL16(C[0], 1));
            short Ba = A[0] = (short)(A[0] ^ Da);
            A[6] = (short)(A[6] ^ De);
            short Be = this.ROL16(A[6], 12);
            A[12] = (short)(A[12] ^ Di);
            short Bi = this.ROL16(A[12], 11);
            A[18] = (short)(A[18] ^ Do);
            short Bo = this.ROL16(A[18], 5);
            A[24] = (short)(A[24] ^ Du);
            short Bu = this.ROL16(A[24], 14);
            E[0] = (short)(Ba ^ ~Be & Bi ^ this.KeccakF400RoundConstants[19]);
            E[1] = (short)(Be ^ ~Bi & Bo);
            E[2] = (short)(Bi ^ ~Bo & Bu);
            E[3] = (short)(Bo ^ ~Bu & Ba);
            E[4] = (short)(Bu ^ ~Ba & Be);
            A[3] = (short)(A[3] ^ Do);
            Ba = this.ROL16(A[3], 12);
            A[9] = (short)(A[9] ^ Du);
            Be = this.ROL16(A[9], 4);
            A[10] = (short)(A[10] ^ Da);
            Bi = this.ROL16(A[10], 3);
            A[16] = (short)(A[16] ^ De);
            Bo = this.ROL16(A[16], 13);
            A[22] = (short)(A[22] ^ Di);
            Bu = this.ROL16(A[22], 13);
            E[5] = (short)(Ba ^ ~Be & Bi);
            E[6] = (short)(Be ^ ~Bi & Bo);
            E[7] = (short)(Bi ^ ~Bo & Bu);
            E[8] = (short)(Bo ^ ~Bu & Ba);
            E[9] = (short)(Bu ^ ~Ba & Be);
            A[1] = (short)(A[1] ^ De);
            Ba = this.ROL16(A[1], 1);
            A[7] = (short)(A[7] ^ Di);
            Be = this.ROL16(A[7], 6);
            A[13] = (short)(A[13] ^ Do);
            Bi = this.ROL16(A[13], 9);
            A[19] = (short)(A[19] ^ Du);
            Bo = this.ROL16(A[19], 8);
            A[20] = (short)(A[20] ^ Da);
            Bu = this.ROL16(A[20], 2);
            E[10] = (short)(Ba ^ ~Be & Bi);
            E[11] = (short)(Be ^ ~Bi & Bo);
            E[12] = (short)(Bi ^ ~Bo & Bu);
            E[13] = (short)(Bo ^ ~Bu & Ba);
            E[14] = (short)(Bu ^ ~Ba & Be);
            A[4] = (short)(A[4] ^ Du);
            Ba = this.ROL16(A[4], 11);
            A[5] = (short)(A[5] ^ Da);
            Be = this.ROL16(A[5], 4);
            A[11] = (short)(A[11] ^ De);
            Bi = this.ROL16(A[11], 10);
            A[17] = (short)(A[17] ^ Di);
            Bo = this.ROL16(A[17], 15);
            A[23] = (short)(A[23] ^ Do);
            Bu = this.ROL16(A[23], 8);
            E[15] = (short)(Ba ^ ~Be & Bi);
            E[16] = (short)(Be ^ ~Bi & Bo);
            E[17] = (short)(Bi ^ ~Bo & Bu);
            E[18] = (short)(Bo ^ ~Bu & Ba);
            E[19] = (short)(Bu ^ ~Ba & Be);
            A[2] = (short)(A[2] ^ Di);
            Ba = this.ROL16(A[2], 14);
            A[8] = (short)(A[8] ^ Do);
            Be = this.ROL16(A[8], 7);
            A[14] = (short)(A[14] ^ Du);
            Bi = this.ROL16(A[14], 7);
            A[15] = (short)(A[15] ^ Da);
            Bo = this.ROL16(A[15], 9);
            A[21] = (short)(A[21] ^ De);
            Bu = this.ROL16(A[21], 2);
            E[20] = (short)(Ba ^ ~Be & Bi);
            E[21] = (short)(Be ^ ~Bi & Bo);
            E[22] = (short)(Bi ^ ~Bo & Bu);
            E[23] = (short)(Bo ^ ~Bu & Ba);
            E[24] = (short)(Bu ^ ~Ba & Be);
        }
    }

    private class ISAPAEAD_K_128
    extends ISAPAEAD_K {
        public ISAPAEAD_K_128() {
            this.ISAP_IV1_16 = new short[]{-32767, 400, 3092, 3084};
            this.ISAP_IV2_16 = new short[]{-32766, 400, 3092, 3084};
            this.ISAP_IV3_16 = new short[]{-32765, 400, 3092, 3084};
        }

        @Override
        protected void PermuteRoundsHX(short[] SX, short[] E, short[] C) {
            this.prepareThetaX(SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(0, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(1, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(2, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(3, E, SX, C);
            this.rounds_4_18(SX, E, C);
        }

        @Override
        protected void PermuteRoundsKX(short[] SX, short[] E, short[] C) {
            this.rounds12X(SX, E, C);
        }

        @Override
        protected void PermuteRoundsBX(short[] SX, short[] E, short[] C) {
            this.rounds12X(SX, E, C);
        }
    }

    private class ISAPAEAD_K_128A
    extends ISAPAEAD_K {
        public ISAPAEAD_K_128A() {
            this.ISAP_IV1_16 = new short[]{-32767, 400, 272, 2056};
            this.ISAP_IV2_16 = new short[]{-32766, 400, 272, 2056};
            this.ISAP_IV3_16 = new short[]{-32765, 400, 272, 2056};
        }

        @Override
        protected void PermuteRoundsHX(short[] SX, short[] E, short[] C) {
            this.prepareThetaX(SX, C);
            this.rounds_4_18(SX, E, C);
        }

        @Override
        protected void PermuteRoundsKX(short[] SX, short[] E, short[] C) {
            this.prepareThetaX(SX, C);
            this.rounds_12_18(SX, E, C);
        }

        @Override
        protected void PermuteRoundsBX(short[] SX, short[] E, short[] C) {
            this.prepareThetaX(SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(19, SX, E, C);
            System.arraycopy(E, 0, SX, 0, E.length);
        }
    }

    private static interface ISAP_AEAD {
        public void init();

        public void reset();

        public void absorbMacBlock(byte[] var1, int var2);

        public void absorbFinalAADBlock();

        public void swapInternalState();

        public void processEncBlock(byte[] var1, int var2, byte[] var3, int var4);

        public void processEncFinalBlock(byte[] var1, int var2);

        public void processMACFinal(byte[] var1, int var2, int var3, byte[] var4);
    }

    public static enum IsapType {
        ISAP_A_128A,
        ISAP_K_128A,
        ISAP_A_128,
        ISAP_K_128;

    }
}

