/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Memoable;

public class Zuc128CoreEngine
implements StreamCipher,
Memoable {
    private static final byte[] S0;
    private static final byte[] S1;
    private static final short[] EK_d;
    private final int[] LFSR = new int[16];
    private final int[] F = new int[2];
    private final int[] BRC = new int[4];
    private int theIndex;
    private final byte[] keyStream = new byte[4];
    private int theIterations;
    private Zuc128CoreEngine theResetState;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = 62;
        byArray[1] = 114;
        byArray[2] = 91;
        byArray[3] = 71;
        byArray[4] = -54;
        byArray[5] = -32;
        byArray[7] = 51;
        byArray[8] = 4;
        byArray[9] = -47;
        byArray[10] = 84;
        byArray[11] = -104;
        byArray[12] = 9;
        byArray[13] = -71;
        byArray[14] = 109;
        byArray[15] = -53;
        byArray[16] = 123;
        byArray[17] = 27;
        byArray[18] = -7;
        byArray[19] = 50;
        byArray[20] = -81;
        byArray[21] = -99;
        byArray[22] = 106;
        byArray[23] = -91;
        byArray[24] = -72;
        byArray[25] = 45;
        byArray[26] = -4;
        byArray[27] = 29;
        byArray[28] = 8;
        byArray[29] = 83;
        byArray[30] = 3;
        byArray[31] = -112;
        byArray[32] = 77;
        byArray[33] = 78;
        byArray[34] = -124;
        byArray[35] = -103;
        byArray[36] = -28;
        byArray[37] = -50;
        byArray[38] = -39;
        byArray[39] = -111;
        byArray[40] = -35;
        byArray[41] = -74;
        byArray[42] = -123;
        byArray[43] = 72;
        byArray[44] = -117;
        byArray[45] = 41;
        byArray[46] = 110;
        byArray[47] = -84;
        byArray[48] = -51;
        byArray[49] = -63;
        byArray[50] = -8;
        byArray[51] = 30;
        byArray[52] = 115;
        byArray[53] = 67;
        byArray[54] = 105;
        byArray[55] = -58;
        byArray[56] = -75;
        byArray[57] = -67;
        byArray[58] = -3;
        byArray[59] = 57;
        byArray[60] = 99;
        byArray[61] = 32;
        byArray[62] = -44;
        byArray[63] = 56;
        byArray[64] = 118;
        byArray[65] = 125;
        byArray[66] = -78;
        byArray[67] = -89;
        byArray[68] = -49;
        byArray[69] = -19;
        byArray[70] = 87;
        byArray[71] = -59;
        byArray[72] = -13;
        byArray[73] = 44;
        byArray[74] = -69;
        byArray[75] = 20;
        byArray[76] = 33;
        byArray[77] = 6;
        byArray[78] = 85;
        byArray[79] = -101;
        byArray[80] = -29;
        byArray[81] = -17;
        byArray[82] = 94;
        byArray[83] = 49;
        byArray[84] = 79;
        byArray[85] = 127;
        byArray[86] = 90;
        byArray[87] = -92;
        byArray[88] = 13;
        byArray[89] = -126;
        byArray[90] = 81;
        byArray[91] = 73;
        byArray[92] = 95;
        byArray[93] = -70;
        byArray[94] = 88;
        byArray[95] = 28;
        byArray[96] = 74;
        byArray[97] = 22;
        byArray[98] = -43;
        byArray[99] = 23;
        byArray[100] = -88;
        byArray[101] = -110;
        byArray[102] = 36;
        byArray[103] = 31;
        byArray[104] = -116;
        byArray[105] = -1;
        byArray[106] = -40;
        byArray[107] = -82;
        byArray[108] = 46;
        byArray[109] = 1;
        byArray[110] = -45;
        byArray[111] = -83;
        byArray[112] = 59;
        byArray[113] = 75;
        byArray[114] = -38;
        byArray[115] = 70;
        byArray[116] = -21;
        byArray[117] = -55;
        byArray[118] = -34;
        byArray[119] = -102;
        byArray[120] = -113;
        byArray[121] = -121;
        byArray[122] = -41;
        byArray[123] = 58;
        byArray[124] = -128;
        byArray[125] = 111;
        byArray[126] = 47;
        byArray[127] = -56;
        byArray[128] = -79;
        byArray[129] = -76;
        byArray[130] = 55;
        byArray[131] = -9;
        byArray[132] = 10;
        byArray[133] = 34;
        byArray[134] = 19;
        byArray[135] = 40;
        byArray[136] = 124;
        byArray[137] = -52;
        byArray[138] = 60;
        byArray[139] = -119;
        byArray[140] = -57;
        byArray[141] = -61;
        byArray[142] = -106;
        byArray[143] = 86;
        byArray[144] = 7;
        byArray[145] = -65;
        byArray[146] = 126;
        byArray[147] = -16;
        byArray[148] = 11;
        byArray[149] = 43;
        byArray[150] = -105;
        byArray[151] = 82;
        byArray[152] = 53;
        byArray[153] = 65;
        byArray[154] = 121;
        byArray[155] = 97;
        byArray[156] = -90;
        byArray[157] = 76;
        byArray[158] = 16;
        byArray[159] = -2;
        byArray[160] = -68;
        byArray[161] = 38;
        byArray[162] = -107;
        byArray[163] = -120;
        byArray[164] = -118;
        byArray[165] = -80;
        byArray[166] = -93;
        byArray[167] = -5;
        byArray[168] = -64;
        byArray[169] = 24;
        byArray[170] = -108;
        byArray[171] = -14;
        byArray[172] = -31;
        byArray[173] = -27;
        byArray[174] = -23;
        byArray[175] = 93;
        byArray[176] = -48;
        byArray[177] = -36;
        byArray[178] = 17;
        byArray[179] = 102;
        byArray[180] = 100;
        byArray[181] = 92;
        byArray[182] = -20;
        byArray[183] = 89;
        byArray[184] = 66;
        byArray[185] = 117;
        byArray[186] = 18;
        byArray[187] = -11;
        byArray[188] = 116;
        byArray[189] = -100;
        byArray[190] = -86;
        byArray[191] = 35;
        byArray[192] = 14;
        byArray[193] = -122;
        byArray[194] = -85;
        byArray[195] = -66;
        byArray[196] = 42;
        byArray[197] = 2;
        byArray[198] = -25;
        byArray[199] = 103;
        byArray[200] = -26;
        byArray[201] = 68;
        byArray[202] = -94;
        byArray[203] = 108;
        byArray[204] = -62;
        byArray[205] = -109;
        byArray[206] = -97;
        byArray[207] = -15;
        byArray[208] = -10;
        byArray[209] = -6;
        byArray[210] = 54;
        byArray[211] = -46;
        byArray[212] = 80;
        byArray[213] = 104;
        byArray[214] = -98;
        byArray[215] = 98;
        byArray[216] = 113;
        byArray[217] = 21;
        byArray[218] = 61;
        byArray[219] = -42;
        byArray[220] = 64;
        byArray[221] = -60;
        byArray[222] = -30;
        byArray[223] = 15;
        byArray[224] = -114;
        byArray[225] = -125;
        byArray[226] = 119;
        byArray[227] = 107;
        byArray[228] = 37;
        byArray[229] = 5;
        byArray[230] = 63;
        byArray[231] = 12;
        byArray[232] = 48;
        byArray[233] = -22;
        byArray[234] = 112;
        byArray[235] = -73;
        byArray[236] = -95;
        byArray[237] = -24;
        byArray[238] = -87;
        byArray[239] = 101;
        byArray[240] = -115;
        byArray[241] = 39;
        byArray[242] = 26;
        byArray[243] = -37;
        byArray[244] = -127;
        byArray[245] = -77;
        byArray[246] = -96;
        byArray[247] = -12;
        byArray[248] = 69;
        byArray[249] = 122;
        byArray[250] = 25;
        byArray[251] = -33;
        byArray[252] = -18;
        byArray[253] = 120;
        byArray[254] = 52;
        byArray[255] = 96;
        S0 = byArray;
        byte[] byArray2 = new byte[256];
        byArray2[0] = 85;
        byArray2[1] = -62;
        byArray2[2] = 99;
        byArray2[3] = 113;
        byArray2[4] = 59;
        byArray2[5] = -56;
        byArray2[6] = 71;
        byArray2[7] = -122;
        byArray2[8] = -97;
        byArray2[9] = 60;
        byArray2[10] = -38;
        byArray2[11] = 91;
        byArray2[12] = 41;
        byArray2[13] = -86;
        byArray2[14] = -3;
        byArray2[15] = 119;
        byArray2[16] = -116;
        byArray2[17] = -59;
        byArray2[18] = -108;
        byArray2[19] = 12;
        byArray2[20] = -90;
        byArray2[21] = 26;
        byArray2[22] = 19;
        byArray2[24] = -29;
        byArray2[25] = -88;
        byArray2[26] = 22;
        byArray2[27] = 114;
        byArray2[28] = 64;
        byArray2[29] = -7;
        byArray2[30] = -8;
        byArray2[31] = 66;
        byArray2[32] = 68;
        byArray2[33] = 38;
        byArray2[34] = 104;
        byArray2[35] = -106;
        byArray2[36] = -127;
        byArray2[37] = -39;
        byArray2[38] = 69;
        byArray2[39] = 62;
        byArray2[40] = 16;
        byArray2[41] = 118;
        byArray2[42] = -58;
        byArray2[43] = -89;
        byArray2[44] = -117;
        byArray2[45] = 57;
        byArray2[46] = 67;
        byArray2[47] = -31;
        byArray2[48] = 58;
        byArray2[49] = -75;
        byArray2[50] = 86;
        byArray2[51] = 42;
        byArray2[52] = -64;
        byArray2[53] = 109;
        byArray2[54] = -77;
        byArray2[55] = 5;
        byArray2[56] = 34;
        byArray2[57] = 102;
        byArray2[58] = -65;
        byArray2[59] = -36;
        byArray2[60] = 11;
        byArray2[61] = -6;
        byArray2[62] = 98;
        byArray2[63] = 72;
        byArray2[64] = -35;
        byArray2[65] = 32;
        byArray2[66] = 17;
        byArray2[67] = 6;
        byArray2[68] = 54;
        byArray2[69] = -55;
        byArray2[70] = -63;
        byArray2[71] = -49;
        byArray2[72] = -10;
        byArray2[73] = 39;
        byArray2[74] = 82;
        byArray2[75] = -69;
        byArray2[76] = 105;
        byArray2[77] = -11;
        byArray2[78] = -44;
        byArray2[79] = -121;
        byArray2[80] = 127;
        byArray2[81] = -124;
        byArray2[82] = 76;
        byArray2[83] = -46;
        byArray2[84] = -100;
        byArray2[85] = 87;
        byArray2[86] = -92;
        byArray2[87] = -68;
        byArray2[88] = 79;
        byArray2[89] = -102;
        byArray2[90] = -33;
        byArray2[91] = -2;
        byArray2[92] = -42;
        byArray2[93] = -115;
        byArray2[94] = 122;
        byArray2[95] = -21;
        byArray2[96] = 43;
        byArray2[97] = 83;
        byArray2[98] = -40;
        byArray2[99] = 92;
        byArray2[100] = -95;
        byArray2[101] = 20;
        byArray2[102] = 23;
        byArray2[103] = -5;
        byArray2[104] = 35;
        byArray2[105] = -43;
        byArray2[106] = 125;
        byArray2[107] = 48;
        byArray2[108] = 103;
        byArray2[109] = 115;
        byArray2[110] = 8;
        byArray2[111] = 9;
        byArray2[112] = -18;
        byArray2[113] = -73;
        byArray2[114] = 112;
        byArray2[115] = 63;
        byArray2[116] = 97;
        byArray2[117] = -78;
        byArray2[118] = 25;
        byArray2[119] = -114;
        byArray2[120] = 78;
        byArray2[121] = -27;
        byArray2[122] = 75;
        byArray2[123] = -109;
        byArray2[124] = -113;
        byArray2[125] = 93;
        byArray2[126] = -37;
        byArray2[127] = -87;
        byArray2[128] = -83;
        byArray2[129] = -15;
        byArray2[130] = -82;
        byArray2[131] = 46;
        byArray2[132] = -53;
        byArray2[133] = 13;
        byArray2[134] = -4;
        byArray2[135] = -12;
        byArray2[136] = 45;
        byArray2[137] = 70;
        byArray2[138] = 110;
        byArray2[139] = 29;
        byArray2[140] = -105;
        byArray2[141] = -24;
        byArray2[142] = -47;
        byArray2[143] = -23;
        byArray2[144] = 77;
        byArray2[145] = 55;
        byArray2[146] = -91;
        byArray2[147] = 117;
        byArray2[148] = 94;
        byArray2[149] = -125;
        byArray2[150] = -98;
        byArray2[151] = -85;
        byArray2[152] = -126;
        byArray2[153] = -99;
        byArray2[154] = -71;
        byArray2[155] = 28;
        byArray2[156] = -32;
        byArray2[157] = -51;
        byArray2[158] = 73;
        byArray2[159] = -119;
        byArray2[160] = 1;
        byArray2[161] = -74;
        byArray2[162] = -67;
        byArray2[163] = 88;
        byArray2[164] = 36;
        byArray2[165] = -94;
        byArray2[166] = 95;
        byArray2[167] = 56;
        byArray2[168] = 120;
        byArray2[169] = -103;
        byArray2[170] = 21;
        byArray2[171] = -112;
        byArray2[172] = 80;
        byArray2[173] = -72;
        byArray2[174] = -107;
        byArray2[175] = -28;
        byArray2[176] = -48;
        byArray2[177] = -111;
        byArray2[178] = -57;
        byArray2[179] = -50;
        byArray2[180] = -19;
        byArray2[181] = 15;
        byArray2[182] = -76;
        byArray2[183] = 111;
        byArray2[184] = -96;
        byArray2[185] = -52;
        byArray2[186] = -16;
        byArray2[187] = 2;
        byArray2[188] = 74;
        byArray2[189] = 121;
        byArray2[190] = -61;
        byArray2[191] = -34;
        byArray2[192] = -93;
        byArray2[193] = -17;
        byArray2[194] = -22;
        byArray2[195] = 81;
        byArray2[196] = -26;
        byArray2[197] = 107;
        byArray2[198] = 24;
        byArray2[199] = -20;
        byArray2[200] = 27;
        byArray2[201] = 44;
        byArray2[202] = -128;
        byArray2[203] = -9;
        byArray2[204] = 116;
        byArray2[205] = -25;
        byArray2[206] = -1;
        byArray2[207] = 33;
        byArray2[208] = 90;
        byArray2[209] = 106;
        byArray2[210] = 84;
        byArray2[211] = 30;
        byArray2[212] = 65;
        byArray2[213] = 49;
        byArray2[214] = -110;
        byArray2[215] = 53;
        byArray2[216] = -60;
        byArray2[217] = 51;
        byArray2[218] = 7;
        byArray2[219] = 10;
        byArray2[220] = -70;
        byArray2[221] = 126;
        byArray2[222] = 14;
        byArray2[223] = 52;
        byArray2[224] = -120;
        byArray2[225] = -79;
        byArray2[226] = -104;
        byArray2[227] = 124;
        byArray2[228] = -13;
        byArray2[229] = 61;
        byArray2[230] = 96;
        byArray2[231] = 108;
        byArray2[232] = 123;
        byArray2[233] = -54;
        byArray2[234] = -45;
        byArray2[235] = 31;
        byArray2[236] = 50;
        byArray2[237] = 101;
        byArray2[238] = 4;
        byArray2[239] = 40;
        byArray2[240] = 100;
        byArray2[241] = -66;
        byArray2[242] = -123;
        byArray2[243] = -101;
        byArray2[244] = 47;
        byArray2[245] = 89;
        byArray2[246] = -118;
        byArray2[247] = -41;
        byArray2[248] = -80;
        byArray2[249] = 37;
        byArray2[250] = -84;
        byArray2[251] = -81;
        byArray2[252] = 18;
        byArray2[253] = 3;
        byArray2[254] = -30;
        byArray2[255] = -14;
        S1 = byArray2;
        EK_d = new short[]{17623, 9916, 25195, 4958, 22409, 13794, 28981, 2479, 19832, 12051, 27588, 6897, 24102, 15437, 30874, 18348};
    }

    protected Zuc128CoreEngine() {
    }

    protected Zuc128CoreEngine(Zuc128CoreEngine pSource) {
        this.reset(pSource);
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) {
        CipherParameters myParams = params;
        byte[] newKey = null;
        byte[] newIV = null;
        if (myParams instanceof ParametersWithIV) {
            ParametersWithIV ivParams = (ParametersWithIV)myParams;
            newIV = ivParams.getIV();
            myParams = ivParams.getParameters();
        }
        if (myParams instanceof KeyParameter) {
            KeyParameter keyParam = (KeyParameter)myParams;
            newKey = keyParam.getKey();
        }
        this.theIndex = 0;
        this.theIterations = 0;
        this.setKeyAndIV(newKey, newIV);
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), newKey.length * 8, params, forEncryption ? CryptoServicePurpose.ENCRYPTION : CryptoServicePurpose.DECRYPTION));
        this.theResetState = (Zuc128CoreEngine)this.copy();
    }

    protected int getMaxIterations() {
        return 2047;
    }

    @Override
    public String getAlgorithmName() {
        return "Zuc-128";
    }

    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) {
        if (this.theResetState == null) {
            throw new IllegalStateException(String.valueOf(this.getAlgorithmName()) + " not initialised");
        }
        if (inOff + len > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + len > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        int i = 0;
        while (i < len) {
            out[i + outOff] = this.returnByte(in[i + inOff]);
            ++i;
        }
        return len;
    }

    @Override
    public void reset() {
        if (this.theResetState != null) {
            this.reset(this.theResetState);
        }
    }

    @Override
    public byte returnByte(byte in) {
        if (this.theIndex == 0) {
            this.makeKeyStream();
        }
        byte out = (byte)(this.keyStream[this.theIndex] ^ in);
        this.theIndex = (this.theIndex + 1) % 4;
        return out;
    }

    public static void encode32be(int val, byte[] buf, int off) {
        buf[off] = (byte)(val >> 24);
        buf[off + 1] = (byte)(val >> 16);
        buf[off + 2] = (byte)(val >> 8);
        buf[off + 3] = (byte)val;
    }

    private int AddM(int a, int b) {
        int c = a + b;
        return (c & Integer.MAX_VALUE) + (c >>> 31);
    }

    private static int MulByPow2(int x, int k) {
        return (x << k | x >>> 31 - k) & Integer.MAX_VALUE;
    }

    private void LFSRWithInitialisationMode(int u) {
        int f = this.LFSR[0];
        int v = Zuc128CoreEngine.MulByPow2(this.LFSR[0], 8);
        f = this.AddM(f, v);
        v = Zuc128CoreEngine.MulByPow2(this.LFSR[4], 20);
        f = this.AddM(f, v);
        v = Zuc128CoreEngine.MulByPow2(this.LFSR[10], 21);
        f = this.AddM(f, v);
        v = Zuc128CoreEngine.MulByPow2(this.LFSR[13], 17);
        f = this.AddM(f, v);
        v = Zuc128CoreEngine.MulByPow2(this.LFSR[15], 15);
        f = this.AddM(f, v);
        f = this.AddM(f, u);
        this.LFSR[0] = this.LFSR[1];
        this.LFSR[1] = this.LFSR[2];
        this.LFSR[2] = this.LFSR[3];
        this.LFSR[3] = this.LFSR[4];
        this.LFSR[4] = this.LFSR[5];
        this.LFSR[5] = this.LFSR[6];
        this.LFSR[6] = this.LFSR[7];
        this.LFSR[7] = this.LFSR[8];
        this.LFSR[8] = this.LFSR[9];
        this.LFSR[9] = this.LFSR[10];
        this.LFSR[10] = this.LFSR[11];
        this.LFSR[11] = this.LFSR[12];
        this.LFSR[12] = this.LFSR[13];
        this.LFSR[13] = this.LFSR[14];
        this.LFSR[14] = this.LFSR[15];
        this.LFSR[15] = f;
    }

    private void LFSRWithWorkMode() {
        int f = this.LFSR[0];
        int v = Zuc128CoreEngine.MulByPow2(this.LFSR[0], 8);
        f = this.AddM(f, v);
        v = Zuc128CoreEngine.MulByPow2(this.LFSR[4], 20);
        f = this.AddM(f, v);
        v = Zuc128CoreEngine.MulByPow2(this.LFSR[10], 21);
        f = this.AddM(f, v);
        v = Zuc128CoreEngine.MulByPow2(this.LFSR[13], 17);
        f = this.AddM(f, v);
        v = Zuc128CoreEngine.MulByPow2(this.LFSR[15], 15);
        f = this.AddM(f, v);
        this.LFSR[0] = this.LFSR[1];
        this.LFSR[1] = this.LFSR[2];
        this.LFSR[2] = this.LFSR[3];
        this.LFSR[3] = this.LFSR[4];
        this.LFSR[4] = this.LFSR[5];
        this.LFSR[5] = this.LFSR[6];
        this.LFSR[6] = this.LFSR[7];
        this.LFSR[7] = this.LFSR[8];
        this.LFSR[8] = this.LFSR[9];
        this.LFSR[9] = this.LFSR[10];
        this.LFSR[10] = this.LFSR[11];
        this.LFSR[11] = this.LFSR[12];
        this.LFSR[12] = this.LFSR[13];
        this.LFSR[13] = this.LFSR[14];
        this.LFSR[14] = this.LFSR[15];
        this.LFSR[15] = f;
    }

    private void BitReorganization() {
        this.BRC[0] = (this.LFSR[15] & 0x7FFF8000) << 1 | this.LFSR[14] & 0xFFFF;
        this.BRC[1] = (this.LFSR[11] & 0xFFFF) << 16 | this.LFSR[9] >>> 15;
        this.BRC[2] = (this.LFSR[7] & 0xFFFF) << 16 | this.LFSR[5] >>> 15;
        this.BRC[3] = (this.LFSR[2] & 0xFFFF) << 16 | this.LFSR[0] >>> 15;
    }

    static int ROT(int a, int k) {
        return a << k | a >>> 32 - k;
    }

    private static int L1(int X) {
        return X ^ Zuc128CoreEngine.ROT(X, 2) ^ Zuc128CoreEngine.ROT(X, 10) ^ Zuc128CoreEngine.ROT(X, 18) ^ Zuc128CoreEngine.ROT(X, 24);
    }

    private static int L2(int X) {
        return X ^ Zuc128CoreEngine.ROT(X, 8) ^ Zuc128CoreEngine.ROT(X, 14) ^ Zuc128CoreEngine.ROT(X, 22) ^ Zuc128CoreEngine.ROT(X, 30);
    }

    private static int MAKEU32(byte a, byte b, byte c, byte d) {
        return (a & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF;
    }

    int F() {
        int W = (this.BRC[0] ^ this.F[0]) + this.F[1];
        int W1 = this.F[0] + this.BRC[1];
        int W2 = this.F[1] ^ this.BRC[2];
        int u = Zuc128CoreEngine.L1(W1 << 16 | W2 >>> 16);
        int v = Zuc128CoreEngine.L2(W2 << 16 | W1 >>> 16);
        this.F[0] = Zuc128CoreEngine.MAKEU32(S0[u >>> 24], S1[u >>> 16 & 0xFF], S0[u >>> 8 & 0xFF], S1[u & 0xFF]);
        this.F[1] = Zuc128CoreEngine.MAKEU32(S0[v >>> 24], S1[v >>> 16 & 0xFF], S0[v >>> 8 & 0xFF], S1[v & 0xFF]);
        return W;
    }

    private static int MAKEU31(byte a, short b, byte c) {
        return (a & 0xFF) << 23 | (b & 0xFFFF) << 8 | c & 0xFF;
    }

    protected void setKeyAndIV(int[] pLFSR, byte[] k, byte[] iv) {
        if (k == null || k.length != 16) {
            throw new IllegalArgumentException("A key of 16 bytes is needed");
        }
        if (iv == null || iv.length != 16) {
            throw new IllegalArgumentException("An IV of 16 bytes is needed");
        }
        this.LFSR[0] = Zuc128CoreEngine.MAKEU31(k[0], EK_d[0], iv[0]);
        this.LFSR[1] = Zuc128CoreEngine.MAKEU31(k[1], EK_d[1], iv[1]);
        this.LFSR[2] = Zuc128CoreEngine.MAKEU31(k[2], EK_d[2], iv[2]);
        this.LFSR[3] = Zuc128CoreEngine.MAKEU31(k[3], EK_d[3], iv[3]);
        this.LFSR[4] = Zuc128CoreEngine.MAKEU31(k[4], EK_d[4], iv[4]);
        this.LFSR[5] = Zuc128CoreEngine.MAKEU31(k[5], EK_d[5], iv[5]);
        this.LFSR[6] = Zuc128CoreEngine.MAKEU31(k[6], EK_d[6], iv[6]);
        this.LFSR[7] = Zuc128CoreEngine.MAKEU31(k[7], EK_d[7], iv[7]);
        this.LFSR[8] = Zuc128CoreEngine.MAKEU31(k[8], EK_d[8], iv[8]);
        this.LFSR[9] = Zuc128CoreEngine.MAKEU31(k[9], EK_d[9], iv[9]);
        this.LFSR[10] = Zuc128CoreEngine.MAKEU31(k[10], EK_d[10], iv[10]);
        this.LFSR[11] = Zuc128CoreEngine.MAKEU31(k[11], EK_d[11], iv[11]);
        this.LFSR[12] = Zuc128CoreEngine.MAKEU31(k[12], EK_d[12], iv[12]);
        this.LFSR[13] = Zuc128CoreEngine.MAKEU31(k[13], EK_d[13], iv[13]);
        this.LFSR[14] = Zuc128CoreEngine.MAKEU31(k[14], EK_d[14], iv[14]);
        this.LFSR[15] = Zuc128CoreEngine.MAKEU31(k[15], EK_d[15], iv[15]);
    }

    private void setKeyAndIV(byte[] k, byte[] iv) {
        this.setKeyAndIV(this.LFSR, k, iv);
        this.F[0] = 0;
        this.F[1] = 0;
        int nCount = 32;
        while (nCount > 0) {
            this.BitReorganization();
            int w = this.F();
            this.LFSRWithInitialisationMode(w >>> 1);
            --nCount;
        }
        this.BitReorganization();
        this.F();
        this.LFSRWithWorkMode();
    }

    private void makeKeyStream() {
        Zuc128CoreEngine.encode32be(this.makeKeyStreamWord(), this.keyStream, 0);
    }

    protected int makeKeyStreamWord() {
        if (this.theIterations++ >= this.getMaxIterations()) {
            throw new IllegalStateException("Too much data processed by singleKey/IV");
        }
        this.BitReorganization();
        int result = this.F() ^ this.BRC[3];
        this.LFSRWithWorkMode();
        return result;
    }

    @Override
    public Memoable copy() {
        return new Zuc128CoreEngine(this);
    }

    @Override
    public void reset(Memoable pState) {
        Zuc128CoreEngine e = (Zuc128CoreEngine)pState;
        System.arraycopy(e.LFSR, 0, this.LFSR, 0, this.LFSR.length);
        System.arraycopy(e.F, 0, this.F, 0, this.F.length);
        System.arraycopy(e.BRC, 0, this.BRC, 0, this.BRC.length);
        System.arraycopy(e.keyStream, 0, this.keyStream, 0, this.keyStream.length);
        this.theIndex = e.theIndex;
        this.theIterations = e.theIterations;
        this.theResetState = e;
    }
}

