/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.threshold;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.threshold.Polynomial;
import org.bouncycastle.crypto.threshold.SecretShare;
import org.bouncycastle.crypto.threshold.SecretSplitter;
import org.bouncycastle.crypto.threshold.ShamirSplitSecret;
import org.bouncycastle.crypto.threshold.ShamirSplitSecretShare;
import org.bouncycastle.util.Arrays;

public class ShamirSecretSplitter
implements SecretSplitter {
    private final Polynomial poly;
    protected int l;
    protected SecureRandom random;

    public ShamirSecretSplitter(Algorithm algorithm, Mode mode, int l, SecureRandom random) {
        if (l < 0 || l > 65534) {
            throw new IllegalArgumentException("Invalid input: l ranges from 0 to 65534 (2^16-2) bytes.");
        }
        this.poly = Polynomial.newInstance(algorithm, mode);
        this.l = l;
        this.random = random;
    }

    @Override
    public ShamirSplitSecret split(int m, int n) {
        byte[][] p = this.initP(m, n);
        byte[][] sr = new byte[m][this.l];
        ShamirSplitSecretShare[] secretShares = new ShamirSplitSecretShare[this.l];
        int i = 0;
        while (i < m) {
            this.random.nextBytes(sr[i]);
            ++i;
        }
        i = 0;
        while (i < p.length) {
            secretShares[i] = new ShamirSplitSecretShare(this.poly.gfVecMul(p[i], sr), i + 1);
            ++i;
        }
        return new ShamirSplitSecret(this.poly, secretShares);
    }

    @Override
    public ShamirSplitSecret splitAround(SecretShare s, int m, int n) throws IOException {
        byte[][] p = this.initP(m, n);
        byte[][] sr = new byte[m][this.l];
        ShamirSplitSecretShare[] secretShares = new ShamirSplitSecretShare[this.l];
        byte[] ss0 = s.getEncoded();
        secretShares[0] = new ShamirSplitSecretShare(ss0, 1);
        int i = 0;
        while (i < m) {
            this.random.nextBytes(sr[i]);
            ++i;
        }
        i = 0;
        while (i < this.l) {
            byte tmp = sr[1][i];
            int j = 2;
            while (j < m) {
                tmp = (byte)(tmp ^ sr[j][i]);
                ++j;
            }
            sr[0][i] = (byte)(tmp ^ ss0[i]);
            ++i;
        }
        i = 1;
        while (i < p.length) {
            secretShares[i] = new ShamirSplitSecretShare(this.poly.gfVecMul(p[i], sr), i + 1);
            ++i;
        }
        return new ShamirSplitSecret(this.poly, secretShares);
    }

    @Override
    public ShamirSplitSecret resplit(byte[] secret, int m, int n) {
        byte[][] p = this.initP(m, n);
        byte[][] sr = new byte[m][this.l];
        ShamirSplitSecretShare[] secretShares = new ShamirSplitSecretShare[this.l];
        sr[0] = Arrays.clone(secret);
        int i = 1;
        while (i < m) {
            this.random.nextBytes(sr[i]);
            ++i;
        }
        i = 0;
        while (i < p.length) {
            secretShares[i] = new ShamirSplitSecretShare(this.poly.gfVecMul(p[i], sr), i + 1);
            ++i;
        }
        return new ShamirSplitSecret(this.poly, secretShares);
    }

    private byte[][] initP(int m, int n) {
        if (m < 1 || m > 255) {
            throw new IllegalArgumentException("Invalid input: m must be less than 256 and positive.");
        }
        if (n < m || n > 255) {
            throw new IllegalArgumentException("Invalid input: n must be less than 256 and greater than or equal to n.");
        }
        byte[][] p = new byte[n][m];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                p[i][j] = this.poly.gfPow((byte)(i + 1), (byte)j);
                ++j;
            }
            ++i;
        }
        return p;
    }

    public static enum Algorithm {
        AES,
        RSA;

    }

    public static enum Mode {
        Native,
        Table;

    }
}

