/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.rsa;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;

class CustomPKCS1Encoding
implements AsymmetricBlockCipher {
    private static final int HEADER_LENGTH = 10;
    private SecureRandom random;
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private boolean forPrivateKey;
    private boolean useStrictLength;
    private byte[] blockBuffer;

    CustomPKCS1Encoding(AsymmetricBlockCipher cipher) {
        this.engine = cipher;
        this.useStrictLength = this.useStrict();
    }

    private boolean useStrict() {
        if (Properties.isOverrideSetTo("org.bouncycastle.pkcs1.not_strict", true)) {
            return false;
        }
        return !Properties.isOverrideSetTo("org.bouncycastle.pkcs1.strict", false);
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        AsymmetricKeyParameter kParam;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.random = rParam.getRandom();
            kParam = (AsymmetricKeyParameter)rParam.getParameters();
        } else {
            kParam = (AsymmetricKeyParameter)param;
            if (!kParam.isPrivate() && forEncryption) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
        }
        this.engine.init(forEncryption, param);
        this.forPrivateKey = kParam.isPrivate();
        this.forEncryption = forEncryption;
        this.blockBuffer = new byte[this.engine.getOutputBlockSize()];
    }

    @Override
    public int getInputBlockSize() {
        int baseBlockSize = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize - 10;
        }
        return baseBlockSize;
    }

    @Override
    public int getOutputBlockSize() {
        int baseBlockSize = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize;
        }
        return baseBlockSize - 10;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(in, inOff, inLen);
        }
        return this.decodeBlock(in, inOff, inLen);
    }

    /*
     * Unable to fully structure code
     */
    private byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        block5: {
            block4: {
                if (inLen > this.getInputBlockSize()) {
                    throw new IllegalArgumentException("input data too large");
                }
                block = new byte[this.engine.getInputBlockSize()];
                if (!this.forPrivateKey) break block4;
                block[0] = 1;
                i = 1;
                while (i != block.length - inLen - 1) {
                    block[i] = -1;
                    ++i;
                }
                break block5;
            }
            this.random.nextBytes(block);
            block[0] = 2;
            i = 1;
            ** GOTO lbl21
            {
                block[i] = (byte)this.random.nextInt();
                do {
                    if (block[i] == 0) continue block1;
                    ++i;
lbl21:
                    // 2 sources

                } while (i != block.length - inLen - 1);
            }
        }
        block[block.length - inLen - 1] = 0;
        System.arraycopy(in, inOff, block, block.length - inLen, inLen);
        return this.engine.processBlock(block, 0, block.length);
    }

    private static int checkPkcs1Encoding1(byte[] buf) {
        int foundZeroMask = 0;
        int lastPadPos = 0;
        int badPadSign = -(buf[0] & 0xFF ^ 1);
        int i = 1;
        while (i < buf.length) {
            int padByte = buf[i] & 0xFF;
            int is0x00Mask = padByte - 1 >> 31;
            int is0xFFMask = (padByte ^ 0xFF) - 1 >> 31;
            lastPadPos ^= i & ~foundZeroMask & is0x00Mask;
            badPadSign |= ~((foundZeroMask |= is0x00Mask) | is0xFFMask);
            ++i;
        }
        int plaintextLength = buf.length - 1 - lastPadPos;
        return plaintextLength | (badPadSign |= lastPadPos - 9) >> 31;
    }

    private static int checkPkcs1Encoding2(byte[] buf) {
        int foundZeroMask = 0;
        int lastPadPos = 0;
        int badPadSign = -(buf[0] & 0xFF ^ 2);
        int i = 1;
        while (i < buf.length) {
            int padByte = buf[i] & 0xFF;
            int is0x00Mask = padByte - 1 >> 31;
            lastPadPos ^= i & ~foundZeroMask & is0x00Mask;
            foundZeroMask |= is0x00Mask;
            ++i;
        }
        int plaintextLength = buf.length - 1 - lastPadPos;
        return plaintextLength | (badPadSign |= lastPadPos - 9) >> 31;
    }

    private byte[] decodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int strictBlockSize = this.engine.getOutputBlockSize();
        byte[] block = this.engine.processBlock(in, inOff, inLen);
        boolean incorrectLength = this.useStrictLength & block.length != strictBlockSize;
        byte[] data = block;
        if (block.length < strictBlockSize) {
            data = this.blockBuffer;
        }
        int plaintextLength = this.forPrivateKey ? CustomPKCS1Encoding.checkPkcs1Encoding2(data) : CustomPKCS1Encoding.checkPkcs1Encoding1(data);
        try {
            if (plaintextLength < 0 | incorrectLength) {
                return null;
            }
            byte[] result = new byte[plaintextLength];
            System.arraycopy(data, data.length - plaintextLength, result, 0, plaintextLength);
            byte[] byArray = result;
            return byArray;
        }
        finally {
            Arrays.fill(block, (byte)0);
            Arrays.fill(this.blockBuffer, 0, Math.max(0, this.blockBuffer.length - block.length), (byte)0);
        }
    }
}

