/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.math.raw.Nat;
import org.bouncycastle.math.raw.Nat320;

public class SecT283Field {
    private static final long M27 = 0x7FFFFFFL;
    private static final long M57 = 0x1FFFFFFFFFFFFFFL;
    private static final long[] ROOT_Z = new long[]{878416384462358536L, 0x30C30C30C30C30C3L, -9076969306111048948L, 0x820820820820820L, 0x2082082L};

    public static void add(long[] x, long[] y, long[] z) {
        z[0] = x[0] ^ y[0];
        z[1] = x[1] ^ y[1];
        z[2] = x[2] ^ y[2];
        z[3] = x[3] ^ y[3];
        z[4] = x[4] ^ y[4];
    }

    public static void addExt(long[] xx, long[] yy, long[] zz) {
        zz[0] = xx[0] ^ yy[0];
        zz[1] = xx[1] ^ yy[1];
        zz[2] = xx[2] ^ yy[2];
        zz[3] = xx[3] ^ yy[3];
        zz[4] = xx[4] ^ yy[4];
        zz[5] = xx[5] ^ yy[5];
        zz[6] = xx[6] ^ yy[6];
        zz[7] = xx[7] ^ yy[7];
        zz[8] = xx[8] ^ yy[8];
    }

    public static void addOne(long[] x, long[] z) {
        z[0] = x[0] ^ 1L;
        z[1] = x[1];
        z[2] = x[2];
        z[3] = x[3];
        z[4] = x[4];
    }

    private static void addTo(long[] x, long[] z) {
        z[0] = z[0] ^ x[0];
        z[1] = z[1] ^ x[1];
        z[2] = z[2] ^ x[2];
        z[3] = z[3] ^ x[3];
        z[4] = z[4] ^ x[4];
    }

    public static long[] fromBigInteger(BigInteger x) {
        return Nat.fromBigInteger64(283, x);
    }

    public static void halfTrace(long[] x, long[] z) {
        long[] tt = Nat.create64(9);
        Nat320.copy64(x, z);
        int i = 1;
        while (i < 283) {
            SecT283Field.implSquare(z, tt);
            SecT283Field.reduce(tt, z);
            SecT283Field.implSquare(z, tt);
            SecT283Field.reduce(tt, z);
            SecT283Field.addTo(x, z);
            i += 2;
        }
    }

    public static void invert(long[] x, long[] z) {
        if (Nat320.isZero64(x)) {
            throw new IllegalStateException();
        }
        long[] t0 = Nat320.create64();
        long[] t1 = Nat320.create64();
        SecT283Field.square(x, t0);
        SecT283Field.multiply(t0, x, t0);
        SecT283Field.squareN(t0, 2, t1);
        SecT283Field.multiply(t1, t0, t1);
        SecT283Field.squareN(t1, 4, t0);
        SecT283Field.multiply(t0, t1, t0);
        SecT283Field.squareN(t0, 8, t1);
        SecT283Field.multiply(t1, t0, t1);
        SecT283Field.square(t1, t1);
        SecT283Field.multiply(t1, x, t1);
        SecT283Field.squareN(t1, 17, t0);
        SecT283Field.multiply(t0, t1, t0);
        SecT283Field.square(t0, t0);
        SecT283Field.multiply(t0, x, t0);
        SecT283Field.squareN(t0, 35, t1);
        SecT283Field.multiply(t1, t0, t1);
        SecT283Field.squareN(t1, 70, t0);
        SecT283Field.multiply(t0, t1, t0);
        SecT283Field.square(t0, t0);
        SecT283Field.multiply(t0, x, t0);
        SecT283Field.squareN(t0, 141, t1);
        SecT283Field.multiply(t1, t0, t1);
        SecT283Field.square(t1, z);
    }

    public static void multiply(long[] x, long[] y, long[] z) {
        long[] tt = Nat320.createExt64();
        SecT283Field.implMultiply(x, y, tt);
        SecT283Field.reduce(tt, z);
    }

    public static void multiplyAddToExt(long[] x, long[] y, long[] zz) {
        long[] tt = Nat320.createExt64();
        SecT283Field.implMultiply(x, y, tt);
        SecT283Field.addExt(zz, tt, zz);
    }

    public static void reduce(long[] xx, long[] z) {
        long x0 = xx[0];
        long x1 = xx[1];
        long x2 = xx[2];
        long x3 = xx[3];
        long x4 = xx[4];
        long x5 = xx[5];
        long x6 = xx[6];
        long x7 = xx[7];
        long x8 = xx[8];
        x3 ^= x8 << 37 ^ x8 << 42 ^ x8 << 44 ^ x8 << 49;
        x2 ^= x7 << 37 ^ x7 << 42 ^ x7 << 44 ^ x7 << 49;
        x3 ^= x7 >>> 27 ^ x7 >>> 22 ^ x7 >>> 20 ^ x7 >>> 15;
        x1 ^= x6 << 37 ^ x6 << 42 ^ x6 << 44 ^ x6 << 49;
        long t = (x4 ^= x8 >>> 27 ^ x8 >>> 22 ^ x8 >>> 20 ^ x8 >>> 15) >>> 27;
        z[0] = (x0 ^= x5 << 37 ^ x5 << 42 ^ x5 << 44 ^ x5 << 49) ^ t ^ t << 5 ^ t << 7 ^ t << 12;
        z[1] = x1 ^= x5 >>> 27 ^ x5 >>> 22 ^ x5 >>> 20 ^ x5 >>> 15;
        z[2] = x2 ^= x6 >>> 27 ^ x6 >>> 22 ^ x6 >>> 20 ^ x6 >>> 15;
        z[3] = x3;
        z[4] = x4 & 0x7FFFFFFL;
    }

    public static void reduce37(long[] z, int zOff) {
        long z4 = z[zOff + 4];
        long t = z4 >>> 27;
        int n = zOff;
        z[n] = z[n] ^ (t ^ t << 5 ^ t << 7 ^ t << 12);
        z[zOff + 4] = z4 & 0x7FFFFFFL;
    }

    public static void sqrt(long[] x, long[] z) {
        long[] odd = Nat320.create64();
        long u0 = Interleave.unshuffle(x[0]);
        long u1 = Interleave.unshuffle(x[1]);
        long e0 = u0 & 0xFFFFFFFFL | u1 << 32;
        odd[0] = u0 >>> 32 | u1 & 0xFFFFFFFF00000000L;
        u0 = Interleave.unshuffle(x[2]);
        u1 = Interleave.unshuffle(x[3]);
        long e1 = u0 & 0xFFFFFFFFL | u1 << 32;
        odd[1] = u0 >>> 32 | u1 & 0xFFFFFFFF00000000L;
        u0 = Interleave.unshuffle(x[4]);
        long e2 = u0 & 0xFFFFFFFFL;
        odd[2] = u0 >>> 32;
        SecT283Field.multiply(odd, ROOT_Z, z);
        z[0] = z[0] ^ e0;
        z[1] = z[1] ^ e1;
        z[2] = z[2] ^ e2;
    }

    public static void square(long[] x, long[] z) {
        long[] tt = Nat.create64(9);
        SecT283Field.implSquare(x, tt);
        SecT283Field.reduce(tt, z);
    }

    public static void squareAddToExt(long[] x, long[] zz) {
        long[] tt = Nat.create64(9);
        SecT283Field.implSquare(x, tt);
        SecT283Field.addExt(zz, tt, zz);
    }

    public static void squareN(long[] x, int n, long[] z) {
        long[] tt = Nat.create64(9);
        SecT283Field.implSquare(x, tt);
        SecT283Field.reduce(tt, z);
        while (--n > 0) {
            SecT283Field.implSquare(z, tt);
            SecT283Field.reduce(tt, z);
        }
    }

    public static int trace(long[] x) {
        return (int)(x[0] ^ x[4] >>> 15) & 1;
    }

    protected static void implCompactExt(long[] zz) {
        long z0 = zz[0];
        long z1 = zz[1];
        long z2 = zz[2];
        long z3 = zz[3];
        long z4 = zz[4];
        long z5 = zz[5];
        long z6 = zz[6];
        long z7 = zz[7];
        long z8 = zz[8];
        long z9 = zz[9];
        zz[0] = z0 ^ z1 << 57;
        zz[1] = z1 >>> 7 ^ z2 << 50;
        zz[2] = z2 >>> 14 ^ z3 << 43;
        zz[3] = z3 >>> 21 ^ z4 << 36;
        zz[4] = z4 >>> 28 ^ z5 << 29;
        zz[5] = z5 >>> 35 ^ z6 << 22;
        zz[6] = z6 >>> 42 ^ z7 << 15;
        zz[7] = z7 >>> 49 ^ z8 << 8;
        zz[8] = z8 >>> 56 ^ z9 << 1;
        zz[9] = z9 >>> 63;
    }

    protected static void implExpand(long[] x, long[] z) {
        long x0 = x[0];
        long x1 = x[1];
        long x2 = x[2];
        long x3 = x[3];
        long x4 = x[4];
        z[0] = x0 & 0x1FFFFFFFFFFFFFFL;
        z[1] = (x0 >>> 57 ^ x1 << 7) & 0x1FFFFFFFFFFFFFFL;
        z[2] = (x1 >>> 50 ^ x2 << 14) & 0x1FFFFFFFFFFFFFFL;
        z[3] = (x2 >>> 43 ^ x3 << 21) & 0x1FFFFFFFFFFFFFFL;
        z[4] = x3 >>> 36 ^ x4 << 28;
    }

    protected static void implMultiply(long[] x, long[] y, long[] zz) {
        long t39;
        long t33;
        long t29;
        long t22;
        long t19;
        long t16;
        long t7;
        long t3;
        long[] a = new long[5];
        long[] b = new long[5];
        SecT283Field.implExpand(x, a);
        SecT283Field.implExpand(y, b);
        long[] u = zz;
        long[] p = new long[26];
        SecT283Field.implMulw(u, a[0], b[0], p, 0);
        SecT283Field.implMulw(u, a[1], b[1], p, 2);
        SecT283Field.implMulw(u, a[2], b[2], p, 4);
        SecT283Field.implMulw(u, a[3], b[3], p, 6);
        SecT283Field.implMulw(u, a[4], b[4], p, 8);
        long u0 = a[0] ^ a[1];
        long v0 = b[0] ^ b[1];
        long u1 = a[0] ^ a[2];
        long v1 = b[0] ^ b[2];
        long u2 = a[2] ^ a[4];
        long v2 = b[2] ^ b[4];
        long u3 = a[3] ^ a[4];
        long v3 = b[3] ^ b[4];
        SecT283Field.implMulw(u, u1 ^ a[3], v1 ^ b[3], p, 18);
        SecT283Field.implMulw(u, u2 ^ a[1], v2 ^ b[1], p, 20);
        long A4 = u0 ^ u3;
        long B4 = v0 ^ v3;
        long A5 = A4 ^ a[2];
        long B5 = B4 ^ b[2];
        SecT283Field.implMulw(u, A4, B4, p, 22);
        SecT283Field.implMulw(u, A5, B5, p, 24);
        SecT283Field.implMulw(u, u0, v0, p, 10);
        SecT283Field.implMulw(u, u1, v1, p, 12);
        SecT283Field.implMulw(u, u2, v2, p, 14);
        SecT283Field.implMulw(u, u3, v3, p, 16);
        zz[0] = p[0];
        zz[9] = p[9];
        long t1 = p[0] ^ p[1];
        long t2 = t1 ^ p[2];
        zz[1] = t3 = t2 ^ p[10];
        long t4 = p[3] ^ p[4];
        long t5 = p[11] ^ p[12];
        long t6 = t4 ^ t5;
        zz[2] = t7 = t2 ^ t6;
        long t8 = t1 ^ t4;
        long t9 = p[5] ^ p[6];
        long t10 = t8 ^ t9;
        long t11 = t10 ^ p[8];
        long t12 = p[13] ^ p[14];
        long t13 = t11 ^ t12;
        long t14 = p[18] ^ p[22];
        long t15 = t14 ^ p[24];
        zz[3] = t16 = t13 ^ t15;
        long t17 = p[7] ^ p[8];
        long t18 = t17 ^ p[9];
        zz[8] = t19 = t18 ^ p[17];
        long t20 = t18 ^ t9;
        long t21 = p[15] ^ p[16];
        zz[7] = t22 = t20 ^ t21;
        long t23 = t22 ^ t3;
        long t24 = p[19] ^ p[20];
        long t25 = p[25] ^ p[24];
        long t26 = p[18] ^ p[23];
        long t27 = t24 ^ t25;
        long t28 = t27 ^ t26;
        zz[4] = t29 = t28 ^ t23;
        long t30 = t7 ^ t19;
        long t31 = t27 ^ t30;
        long t32 = p[21] ^ p[22];
        zz[5] = t33 = t31 ^ t32;
        long t34 = t11 ^ p[0];
        long t35 = t34 ^ p[9];
        long t36 = t35 ^ t12;
        long t37 = t36 ^ p[21];
        long t38 = t37 ^ p[23];
        zz[6] = t39 = t38 ^ p[25];
        SecT283Field.implCompactExt(zz);
    }

    protected static void implMulw(long[] u, long x, long y, long[] z, int zOff) {
        u[1] = y;
        u[2] = u[1] << 1;
        u[3] = u[2] ^ y;
        u[4] = u[2] << 1;
        u[5] = u[4] ^ y;
        u[6] = u[3] << 1;
        u[7] = u[6] ^ y;
        int j = (int)x;
        long h = 0L;
        long l = u[j & 7];
        int k = 48;
        do {
            j = (int)(x >>> k);
            long g = u[j & 7] ^ u[j >>> 3 & 7] << 3 ^ u[j >>> 6 & 7] << 6;
            l ^= g << k;
            h ^= g >>> -k;
        } while ((k -= 9) > 0);
        z[zOff] = l & 0x1FFFFFFFFFFFFFFL;
        z[zOff + 1] = l >>> 57 ^ (h ^= (x & 0x100804020100800L & y << 7 >> 63) >>> 8) << 7;
    }

    protected static void implSquare(long[] x, long[] zz) {
        Interleave.expand64To128(x, 0, 4, zz, 0);
        zz[8] = Interleave.expand32to64((int)x[4]);
    }
}

