/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.dilithium;

import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumEngine;
import org.bouncycastle.pqc.crypto.crystals.dilithium.PolyVecK;
import org.bouncycastle.pqc.crypto.crystals.dilithium.PolyVecL;
import org.bouncycastle.util.Arrays;

class Packing {
    Packing() {
    }

    static byte[] packPublicKey(PolyVecK t1, DilithiumEngine engine) {
        byte[] out = new byte[engine.getCryptoPublicKeyBytes() - 32];
        int i = 0;
        while (i < engine.getDilithiumK()) {
            System.arraycopy(t1.getVectorIndex(i).polyt1Pack(), 0, out, i * 320, 320);
            ++i;
        }
        return out;
    }

    static PolyVecK unpackPublicKey(PolyVecK t1, byte[] publicKey, DilithiumEngine engine) {
        int i = 0;
        while (i < engine.getDilithiumK()) {
            t1.getVectorIndex(i).polyt1Unpack(Arrays.copyOfRange(publicKey, i * 320, (i + 1) * 320));
            ++i;
        }
        return t1;
    }

    static byte[][] packSecretKey(byte[] rho, byte[] tr, byte[] key, PolyVecK t0, PolyVecL s1, PolyVecK s2, DilithiumEngine engine) {
        byte[][] out = new byte[6][];
        out[0] = rho;
        out[1] = key;
        out[2] = tr;
        out[3] = new byte[engine.getDilithiumL() * engine.getDilithiumPolyEtaPackedBytes()];
        int i = 0;
        while (i < engine.getDilithiumL()) {
            s1.getVectorIndex(i).polyEtaPack(out[3], i * engine.getDilithiumPolyEtaPackedBytes());
            ++i;
        }
        out[4] = new byte[engine.getDilithiumK() * engine.getDilithiumPolyEtaPackedBytes()];
        i = 0;
        while (i < engine.getDilithiumK()) {
            s2.getVectorIndex(i).polyEtaPack(out[4], i * engine.getDilithiumPolyEtaPackedBytes());
            ++i;
        }
        out[5] = new byte[engine.getDilithiumK() * 416];
        i = 0;
        while (i < engine.getDilithiumK()) {
            t0.getVectorIndex(i).polyt0Pack(out[5], i * 416);
            ++i;
        }
        return out;
    }

    static void unpackSecretKey(PolyVecK t0, PolyVecL s1, PolyVecK s2, byte[] t0Enc, byte[] s1Enc, byte[] s2Enc, DilithiumEngine engine) {
        int i = 0;
        while (i < engine.getDilithiumL()) {
            s1.getVectorIndex(i).polyEtaUnpack(s1Enc, i * engine.getDilithiumPolyEtaPackedBytes());
            ++i;
        }
        i = 0;
        while (i < engine.getDilithiumK()) {
            s2.getVectorIndex(i).polyEtaUnpack(s2Enc, i * engine.getDilithiumPolyEtaPackedBytes());
            ++i;
        }
        i = 0;
        while (i < engine.getDilithiumK()) {
            t0.getVectorIndex(i).polyt0Unpack(t0Enc, i * 416);
            ++i;
        }
    }

    static byte[] packSignature(byte[] c, PolyVecL z, PolyVecK h, DilithiumEngine engine) {
        int end = 0;
        byte[] outBytes = new byte[engine.getCryptoBytes()];
        System.arraycopy(c, 0, outBytes, 0, engine.getDilithiumCTilde());
        end += engine.getDilithiumCTilde();
        int i = 0;
        while (i < engine.getDilithiumL()) {
            System.arraycopy(z.getVectorIndex(i).zPack(), 0, outBytes, end + i * engine.getDilithiumPolyZPackedBytes(), engine.getDilithiumPolyZPackedBytes());
            ++i;
        }
        end += engine.getDilithiumL() * engine.getDilithiumPolyZPackedBytes();
        i = 0;
        while (i < engine.getDilithiumOmega() + engine.getDilithiumK()) {
            outBytes[end + i] = 0;
            ++i;
        }
        int k = 0;
        i = 0;
        while (i < engine.getDilithiumK()) {
            int j = 0;
            while (j < 256) {
                if (h.getVectorIndex(i).getCoeffIndex(j) != 0) {
                    outBytes[end + k++] = (byte)j;
                }
                ++j;
            }
            outBytes[end + engine.getDilithiumOmega() + i] = (byte)k;
            ++i;
        }
        return outBytes;
    }

    static boolean unpackSignature(PolyVecL z, PolyVecK h, byte[] sig, DilithiumEngine engine) {
        int j;
        int end = engine.getDilithiumCTilde();
        int i = 0;
        while (i < engine.getDilithiumL()) {
            z.getVectorIndex(i).zUnpack(Arrays.copyOfRange(sig, end + i * engine.getDilithiumPolyZPackedBytes(), end + (i + 1) * engine.getDilithiumPolyZPackedBytes()));
            ++i;
        }
        end += engine.getDilithiumL() * engine.getDilithiumPolyZPackedBytes();
        int k = 0;
        i = 0;
        while (i < engine.getDilithiumK()) {
            j = 0;
            while (j < 256) {
                h.getVectorIndex(i).setCoeffIndex(j, 0);
                ++j;
            }
            if ((sig[end + engine.getDilithiumOmega() + i] & 0xFF) < k || (sig[end + engine.getDilithiumOmega() + i] & 0xFF) > engine.getDilithiumOmega()) {
                return false;
            }
            j = k;
            while (j < (sig[end + engine.getDilithiumOmega() + i] & 0xFF)) {
                if (j > k && (sig[end + j] & 0xFF) <= (sig[end + j - 1] & 0xFF)) {
                    return false;
                }
                h.getVectorIndex(i).setCoeffIndex(sig[end + j] & 0xFF, 1);
                ++j;
            }
            k = sig[end + engine.getDilithiumOmega() + i];
            ++i;
        }
        j = k;
        while (j < engine.getDilithiumOmega()) {
            if ((sig[end + j] & 0xFF) != 0) {
                return false;
            }
            ++j;
        }
        return true;
    }
}

