/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.dilithium;

import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumEngine;
import org.bouncycastle.pqc.crypto.crystals.dilithium.PolyVecK;
import org.bouncycastle.pqc.crypto.crystals.dilithium.PolyVecL;

class PolyVecMatrix {
    private final int dilithiumK;
    private final int dilithiumL;
    private final PolyVecL[] mat;

    public PolyVecMatrix(DilithiumEngine engine) {
        this.dilithiumK = engine.getDilithiumK();
        this.dilithiumL = engine.getDilithiumL();
        this.mat = new PolyVecL[this.dilithiumK];
        int i = 0;
        while (i < this.dilithiumK) {
            this.mat[i] = new PolyVecL(engine);
            ++i;
        }
    }

    public void pointwiseMontgomery(PolyVecK t, PolyVecL v) {
        int i = 0;
        while (i < this.dilithiumK) {
            t.getVectorIndex(i).pointwiseAccountMontgomery(this.mat[i], v);
            ++i;
        }
    }

    public void expandMatrix(byte[] rho) {
        int i = 0;
        while (i < this.dilithiumK) {
            int j = 0;
            while (j < this.dilithiumL) {
                this.mat[i].getVectorIndex(j).uniformBlocks(rho, (short)((i << 8) + j));
                ++j;
            }
            ++i;
        }
    }

    private String addString() {
        String out = "[";
        int i = 0;
        while (i < this.dilithiumK) {
            out = String.valueOf(out) + "Outer Matrix " + i + " [";
            out = String.valueOf(out) + this.mat[i].toString();
            out = i == this.dilithiumK - 1 ? String.valueOf(out) + "]\n" : String.valueOf(out) + "],\n";
            ++i;
        }
        out = String.valueOf(out) + "]\n";
        return out;
    }

    public String toString(String name) {
        return name.concat(": \n" + this.addString());
    }
}

