/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.hqc;

import org.bouncycastle.pqc.crypto.hqc.Utils;
import org.bouncycastle.util.Arrays;

class ReedMuller {
    ReedMuller() {
    }

    static void encodeSub(Codeword codeword, int m) {
        int word1 = ReedMuller.Bit0Mask(m >> 7);
        word1 ^= ReedMuller.Bit0Mask(m >> 0) & 0xAAAAAAAA;
        word1 ^= ReedMuller.Bit0Mask(m >> 1) & 0xCCCCCCCC;
        word1 ^= ReedMuller.Bit0Mask(m >> 2) & 0xF0F0F0F0;
        word1 ^= ReedMuller.Bit0Mask(m >> 3) & 0xFF00FF00;
        codeword.type32[0] = word1 ^= ReedMuller.Bit0Mask(m >> 4) & 0xFFFF0000;
        codeword.type32[1] = word1 ^= ReedMuller.Bit0Mask(m >> 5);
        codeword.type32[3] = word1 ^= ReedMuller.Bit0Mask(m >> 6);
        codeword.type32[2] = word1 ^= ReedMuller.Bit0Mask(m >> 5);
    }

    private static void hadamardTransform(int[] srcCode, int[] desCode) {
        int[] srcCodeCopy = Arrays.clone(srcCode);
        int[] desCodeCopy = Arrays.clone(desCode);
        int i = 0;
        while (i < 7) {
            int j = 0;
            while (j < 64) {
                desCodeCopy[j] = srcCodeCopy[2 * j] + srcCodeCopy[2 * j + 1];
                desCodeCopy[j + 64] = srcCodeCopy[2 * j] - srcCodeCopy[2 * j + 1];
                ++j;
            }
            int[] tmp = srcCodeCopy;
            srcCodeCopy = desCodeCopy;
            desCodeCopy = tmp;
            ++i;
        }
        System.arraycopy(desCodeCopy, 0, srcCode, 0, srcCode.length);
        System.arraycopy(srcCodeCopy, 0, desCode, 0, desCode.length);
    }

    private static void expandThenSum(int[] desCode, Codeword[] srcCode, int off, int mulParam) {
        int j;
        int i = 0;
        while (i < 4) {
            j = 0;
            while (j < 32) {
                long ii = srcCode[0 + off].type32[i] >> j & 1;
                desCode[i * 32 + j] = srcCode[0 + off].type32[i] >> j & 1;
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i < mulParam) {
            j = 0;
            while (j < 4) {
                int k = 0;
                while (k < 32) {
                    int n = j * 32 + k;
                    desCode[n] = desCode[n] + (srcCode[i + off].type32[j] >> k & 1);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private static int findPeaks(int[] input) {
        int peakAbsVal = 0;
        int peakVal = 0;
        int peakPos = 0;
        int i = 0;
        while (i < 128) {
            int t = input[i];
            int posMask = t > 0 ? -1 : 0;
            int abs = posMask & t | ~posMask & -t;
            peakVal = abs > peakAbsVal ? t : peakVal;
            peakPos = abs > peakAbsVal ? i : peakPos;
            peakAbsVal = abs > peakAbsVal ? abs : peakAbsVal;
            ++i;
        }
        int tmp = peakVal > 0 ? 1 : 0;
        return peakPos |= 128 * tmp;
    }

    private static int Bit0Mask(int b) {
        return -(b & 1) & 0xFFFFFFFF;
    }

    public static void encode(long[] codeword, byte[] m, int n1, int mulParam) {
        byte[] mBytes = Arrays.clone(m);
        Codeword[] codewordCopy = new Codeword[n1 * mulParam];
        int i = 0;
        while (i < codewordCopy.length) {
            codewordCopy[i] = new Codeword();
            ++i;
        }
        i = 0;
        while (i < n1) {
            int pos = i * mulParam;
            ReedMuller.encodeSub(codewordCopy[pos], mBytes[i]);
            int j = 1;
            while (j < mulParam) {
                codewordCopy[pos + j] = codewordCopy[pos];
                ++j;
            }
            ++i;
        }
        int[] cwd64 = new int[codewordCopy.length * 4];
        int off = 0;
        int i2 = 0;
        while (i2 < codewordCopy.length) {
            System.arraycopy(codewordCopy[i2].type32, 0, cwd64, off, codewordCopy[i2].type32.length);
            off += 4;
            ++i2;
        }
        Utils.fromByte32ArrayToLongArray(codeword, cwd64);
    }

    public static void decode(byte[] m, long[] codeword, int n1, int mulParam) {
        byte[] mBytes = Arrays.clone(m);
        Codeword[] codewordCopy = new Codeword[codeword.length / 2];
        int[] byteCodeWords = new int[codeword.length * 2];
        Utils.fromLongArrayToByte32Array(byteCodeWords, codeword);
        int i = 0;
        while (i < codewordCopy.length) {
            codewordCopy[i] = new Codeword();
            int j = 0;
            while (j < 4) {
                codewordCopy[i].type32[j] = byteCodeWords[i * 4 + j];
                ++j;
            }
            ++i;
        }
        int[] expandedCodeword = new int[128];
        int i2 = 0;
        while (i2 < n1) {
            ReedMuller.expandThenSum(expandedCodeword, codewordCopy, i2 * mulParam, mulParam);
            int[] tmp = new int[128];
            ReedMuller.hadamardTransform(expandedCodeword, tmp);
            tmp[0] = tmp[0] - 64 * mulParam;
            mBytes[i2] = (byte)ReedMuller.findPeaks(tmp);
            ++i2;
        }
        int[] cwd64 = new int[codewordCopy.length * 4];
        int off = 0;
        int i3 = 0;
        while (i3 < codewordCopy.length) {
            System.arraycopy(codewordCopy[i3].type32, 0, cwd64, off, codewordCopy[i3].type32.length);
            off += 4;
            ++i3;
        }
        Utils.fromByte32ArrayToLongArray(codeword, cwd64);
        System.arraycopy(mBytes, 0, m, 0, m.length);
    }

    static class Codeword {
        int[] type32 = new int[4];
        int[] type8 = new int[16];
    }
}

