/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.rainbow;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.pqc.crypto.rainbow.ComputeInField;
import org.bouncycastle.pqc.crypto.rainbow.RainbowDRBG;
import org.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowUtil;
import org.bouncycastle.pqc.crypto.rainbow.Version;
import org.bouncycastle.util.Arrays;

class RainbowKeyComputation {
    private SecureRandom random;
    private Version version;
    private RainbowParameters rainbowParams;
    ComputeInField cf = new ComputeInField();
    private int v1;
    private int o1;
    private int o2;
    private byte[] sk_seed;
    private byte[] pk_seed;
    private short[][] s1;
    private short[][] t1;
    private short[][] t2;
    private short[][] t3;
    private short[][] t4;
    private short[][][] l1_F1;
    private short[][][] l1_F2;
    private short[][][] l2_F1;
    private short[][][] l2_F2;
    private short[][][] l2_F3;
    private short[][][] l2_F5;
    private short[][][] l2_F6;
    private short[][][] l1_Q1;
    private short[][][] l1_Q2;
    private short[][][] l1_Q3;
    private short[][][] l1_Q5;
    private short[][][] l1_Q6;
    private short[][][] l1_Q9;
    private short[][][] l2_Q1;
    private short[][][] l2_Q2;
    private short[][][] l2_Q3;
    private short[][][] l2_Q5;
    private short[][][] l2_Q6;
    private short[][][] l2_Q9;

    public RainbowKeyComputation(RainbowParameters params, SecureRandom random) {
        this.rainbowParams = params;
        this.random = random;
        this.version = this.rainbowParams.getVersion();
        this.v1 = this.rainbowParams.getV1();
        this.o1 = this.rainbowParams.getO1();
        this.o2 = this.rainbowParams.getO2();
    }

    public RainbowKeyComputation(RainbowParameters params, byte[] pk_seed, byte[] sk_seed) {
        this.rainbowParams = params;
        this.random = null;
        this.version = this.rainbowParams.getVersion();
        this.pk_seed = pk_seed;
        this.sk_seed = sk_seed;
        this.v1 = this.rainbowParams.getV1();
        this.o1 = this.rainbowParams.getO1();
        this.o2 = this.rainbowParams.getO2();
    }

    private void generate_S_and_T(SecureRandom sk_random) {
        this.s1 = RainbowUtil.generate_random_2d(sk_random, this.o1, this.o2);
        this.t1 = RainbowUtil.generate_random_2d(sk_random, this.v1, this.o1);
        this.t2 = RainbowUtil.generate_random_2d(sk_random, this.v1, this.o2);
        this.t3 = RainbowUtil.generate_random_2d(sk_random, this.o1, this.o2);
    }

    private void generate_B1_and_B2(SecureRandom pk_random) {
        this.l1_Q1 = RainbowUtil.generate_random(pk_random, this.o1, this.v1, this.v1, true);
        this.l1_Q2 = RainbowUtil.generate_random(pk_random, this.o1, this.v1, this.o1, false);
        this.l2_Q1 = RainbowUtil.generate_random(pk_random, this.o2, this.v1, this.v1, true);
        this.l2_Q2 = RainbowUtil.generate_random(pk_random, this.o2, this.v1, this.o1, false);
        this.l2_Q3 = RainbowUtil.generate_random(pk_random, this.o2, this.v1, this.o2, false);
        this.l2_Q5 = RainbowUtil.generate_random(pk_random, this.o2, this.o1, this.o1, true);
        this.l2_Q6 = RainbowUtil.generate_random(pk_random, this.o2, this.o1, this.o2, false);
    }

    private void calculate_t4() {
        short[][] temp = this.cf.multiplyMatrix(this.t1, this.t3);
        this.t4 = this.cf.addMatrix(temp, this.t2);
    }

    private void calculate_F_from_Q() {
        this.l1_F1 = RainbowUtil.cloneArray(this.l1_Q1);
        this.l1_F2 = new short[this.o1][][];
        int k = 0;
        while (k < this.o1) {
            this.l1_F2[k] = this.cf.addMatrixTranspose(this.l1_Q1[k]);
            this.l1_F2[k] = this.cf.multiplyMatrix(this.l1_F2[k], this.t1);
            this.l1_F2[k] = this.cf.addMatrix(this.l1_F2[k], this.l1_Q2[k]);
            ++k;
        }
        this.l2_F2 = new short[this.o2][][];
        this.l2_F3 = new short[this.o2][][];
        this.l2_F5 = new short[this.o2][][];
        this.l2_F6 = new short[this.o2][][];
        this.l2_F1 = RainbowUtil.cloneArray(this.l2_Q1);
        k = 0;
        while (k < this.o2) {
            short[][] Q1Q1_t = this.cf.addMatrixTranspose(this.l2_Q1[k]);
            this.l2_F2[k] = this.cf.multiplyMatrix(Q1Q1_t, this.t1);
            this.l2_F2[k] = this.cf.addMatrix(this.l2_F2[k], this.l2_Q2[k]);
            this.l2_F3[k] = this.cf.multiplyMatrix(Q1Q1_t, this.t4);
            short[][] temp = this.cf.multiplyMatrix(this.l2_Q2[k], this.t3);
            this.l2_F3[k] = this.cf.addMatrix(this.l2_F3[k], temp);
            this.l2_F3[k] = this.cf.addMatrix(this.l2_F3[k], this.l2_Q3[k]);
            temp = this.cf.multiplyMatrix(this.l2_Q1[k], this.t1);
            temp = this.cf.addMatrix(temp, this.l2_Q2[k]);
            short[][] T1_trans = this.cf.transpose(this.t1);
            this.l2_F5[k] = this.cf.multiplyMatrix(T1_trans, temp);
            this.l2_F5[k] = this.cf.addMatrix(this.l2_F5[k], this.l2_Q5[k]);
            this.l2_F5[k] = this.cf.to_UT(this.l2_F5[k]);
            this.l2_F6[k] = this.cf.multiplyMatrix(T1_trans, this.l2_F3[k]);
            temp = this.cf.multiplyMatrix(this.cf.transpose(this.l2_Q2[k]), this.t4);
            this.l2_F6[k] = this.cf.addMatrix(this.l2_F6[k], temp);
            temp = this.cf.addMatrixTranspose(this.l2_Q5[k]);
            temp = this.cf.multiplyMatrix(temp, this.t3);
            this.l2_F6[k] = this.cf.addMatrix(this.l2_F6[k], temp);
            this.l2_F6[k] = this.cf.addMatrix(this.l2_F6[k], this.l2_Q6[k]);
            ++k;
        }
    }

    private void calculate_Q_from_F() {
        short[][] T1_trans = this.cf.transpose(this.t1);
        short[][] T2_trans = this.cf.transpose(this.t2);
        this.l1_Q1 = RainbowUtil.cloneArray(this.l1_F1);
        this.l1_Q2 = new short[this.o1][][];
        int k = 0;
        while (k < this.o1) {
            this.l1_Q2[k] = this.cf.addMatrixTranspose(this.l1_F1[k]);
            this.l1_Q2[k] = this.cf.multiplyMatrix(this.l1_Q2[k], this.t1);
            this.l1_Q2[k] = this.cf.addMatrix(this.l1_Q2[k], this.l1_F2[k]);
            ++k;
        }
        this.calculate_l1_Q3569(T1_trans, T2_trans);
        this.l2_Q2 = new short[this.o2][][];
        this.l2_Q3 = new short[this.o2][][];
        this.l2_Q5 = new short[this.o2][][];
        this.l2_Q6 = new short[this.o2][][];
        this.l2_Q1 = RainbowUtil.cloneArray(this.l2_F1);
        int k2 = 0;
        while (k2 < this.o2) {
            short[][] F1F1_t = this.cf.addMatrixTranspose(this.l2_F1[k2]);
            this.l2_Q2[k2] = this.cf.multiplyMatrix(F1F1_t, this.t1);
            this.l2_Q2[k2] = this.cf.addMatrix(this.l2_Q2[k2], this.l2_F2[k2]);
            this.l2_Q3[k2] = this.cf.multiplyMatrix(F1F1_t, this.t2);
            short[][] temp = this.cf.multiplyMatrix(this.l2_F2[k2], this.t3);
            this.l2_Q3[k2] = this.cf.addMatrix(this.l2_Q3[k2], temp);
            this.l2_Q3[k2] = this.cf.addMatrix(this.l2_Q3[k2], this.l2_F3[k2]);
            temp = this.cf.multiplyMatrix(this.l2_F1[k2], this.t1);
            temp = this.cf.addMatrix(temp, this.l2_F2[k2]);
            this.l2_Q5[k2] = this.cf.multiplyMatrix(T1_trans, temp);
            this.l2_Q5[k2] = this.cf.addMatrix(this.l2_Q5[k2], this.l2_F5[k2]);
            this.l2_Q5[k2] = this.cf.to_UT(this.l2_Q5[k2]);
            this.l2_Q6[k2] = this.cf.multiplyMatrix(T1_trans, this.l2_Q3[k2]);
            temp = this.cf.multiplyMatrix(this.cf.transpose(this.l2_F2[k2]), this.t2);
            this.l2_Q6[k2] = this.cf.addMatrix(this.l2_Q6[k2], temp);
            temp = this.cf.addMatrixTranspose(this.l2_F5[k2]);
            temp = this.cf.multiplyMatrix(temp, this.t3);
            this.l2_Q6[k2] = this.cf.addMatrix(this.l2_Q6[k2], temp);
            this.l2_Q6[k2] = this.cf.addMatrix(this.l2_Q6[k2], this.l2_F6[k2]);
            ++k2;
        }
        this.calculate_l2_Q9(T2_trans);
    }

    private void calculate_Q_from_F_cyclic() {
        short[][] T1_trans = this.cf.transpose(this.t1);
        short[][] T2_trans = this.cf.transpose(this.t2);
        this.calculate_l1_Q3569(T1_trans, T2_trans);
        this.calculate_l2_Q9(T2_trans);
    }

    private void calculate_l1_Q3569(short[][] T1_trans, short[][] T2_trans) {
        this.l1_Q3 = new short[this.o1][][];
        this.l1_Q5 = new short[this.o1][][];
        this.l1_Q6 = new short[this.o1][][];
        this.l1_Q9 = new short[this.o1][][];
        int k = 0;
        while (k < this.o1) {
            short[][] F2T3 = this.cf.multiplyMatrix(this.l1_F2[k], this.t3);
            this.l1_Q3[k] = this.cf.addMatrixTranspose(this.l1_F1[k]);
            this.l1_Q3[k] = this.cf.multiplyMatrix(this.l1_Q3[k], this.t2);
            this.l1_Q3[k] = this.cf.addMatrix(this.l1_Q3[k], F2T3);
            this.l1_Q5[k] = this.cf.multiplyMatrix(this.l1_F1[k], this.t1);
            this.l1_Q5[k] = this.cf.addMatrix(this.l1_Q5[k], this.l1_F2[k]);
            this.l1_Q5[k] = this.cf.multiplyMatrix(T1_trans, this.l1_Q5[k]);
            this.l1_Q5[k] = this.cf.to_UT(this.l1_Q5[k]);
            short[][] temp = this.cf.multiplyMatrix(this.cf.transpose(this.l1_F2[k]), this.t2);
            this.l1_Q6[k] = this.cf.multiplyMatrix(T1_trans, this.l1_Q3[k]);
            this.l1_Q6[k] = this.cf.addMatrix(this.l1_Q6[k], temp);
            temp = this.cf.multiplyMatrix(this.l1_F1[k], this.t2);
            this.l1_Q9[k] = this.cf.addMatrix(temp, F2T3);
            this.l1_Q9[k] = this.cf.multiplyMatrix(T2_trans, this.l1_Q9[k]);
            this.l1_Q9[k] = this.cf.to_UT(this.l1_Q9[k]);
            ++k;
        }
    }

    private void calculate_l2_Q9(short[][] T2_trans) {
        this.l2_Q9 = new short[this.o2][][];
        int k = 0;
        while (k < this.o2) {
            this.l2_Q9[k] = this.cf.multiplyMatrix(this.l2_F1[k], this.t2);
            short[][] temp = this.cf.multiplyMatrix(this.l2_F2[k], this.t3);
            this.l2_Q9[k] = this.cf.addMatrix(this.l2_Q9[k], temp);
            this.l2_Q9[k] = this.cf.addMatrix(this.l2_Q9[k], this.l2_F3[k]);
            this.l2_Q9[k] = this.cf.multiplyMatrix(T2_trans, this.l2_Q9[k]);
            temp = this.cf.multiplyMatrix(this.l2_F5[k], this.t3);
            temp = this.cf.addMatrix(temp, this.l2_F6[k]);
            temp = this.cf.multiplyMatrix(this.cf.transpose(this.t3), temp);
            this.l2_Q9[k] = this.cf.addMatrix(this.l2_Q9[k], temp);
            this.l2_Q9[k] = this.cf.to_UT(this.l2_Q9[k]);
            ++k;
        }
    }

    private void genKeyMaterial() {
        this.sk_seed = new byte[this.rainbowParams.getLen_skseed()];
        this.random.nextBytes(this.sk_seed);
        RainbowDRBG sk_random = new RainbowDRBG(this.sk_seed, this.rainbowParams.getHash_algo());
        this.generate_S_and_T(sk_random);
        this.l1_F1 = RainbowUtil.generate_random(sk_random, this.o1, this.v1, this.v1, true);
        this.l1_F2 = RainbowUtil.generate_random(sk_random, this.o1, this.v1, this.o1, false);
        this.l2_F1 = RainbowUtil.generate_random(sk_random, this.o2, this.v1, this.v1, true);
        this.l2_F2 = RainbowUtil.generate_random(sk_random, this.o2, this.v1, this.o1, false);
        this.l2_F3 = RainbowUtil.generate_random(sk_random, this.o2, this.v1, this.o2, false);
        this.l2_F5 = RainbowUtil.generate_random(sk_random, this.o2, this.o1, this.o1, true);
        this.l2_F6 = RainbowUtil.generate_random(sk_random, this.o2, this.o1, this.o2, false);
        this.calculate_Q_from_F();
        this.calculate_t4();
        this.l1_Q1 = this.cf.obfuscate_l1_polys(this.s1, this.l2_Q1, this.l1_Q1);
        this.l1_Q2 = this.cf.obfuscate_l1_polys(this.s1, this.l2_Q2, this.l1_Q2);
        this.l1_Q3 = this.cf.obfuscate_l1_polys(this.s1, this.l2_Q3, this.l1_Q3);
        this.l1_Q5 = this.cf.obfuscate_l1_polys(this.s1, this.l2_Q5, this.l1_Q5);
        this.l1_Q6 = this.cf.obfuscate_l1_polys(this.s1, this.l2_Q6, this.l1_Q6);
        this.l1_Q9 = this.cf.obfuscate_l1_polys(this.s1, this.l2_Q9, this.l1_Q9);
    }

    private void genPrivateKeyMaterial_cyclic() {
        RainbowDRBG sk_random = new RainbowDRBG(this.sk_seed, this.rainbowParams.getHash_algo());
        RainbowDRBG pk_random = new RainbowDRBG(this.pk_seed, this.rainbowParams.getHash_algo());
        this.generate_S_and_T(sk_random);
        this.calculate_t4();
        this.generate_B1_and_B2(pk_random);
        this.l1_Q1 = this.cf.obfuscate_l1_polys(this.s1, this.l2_Q1, this.l1_Q1);
        this.l1_Q2 = this.cf.obfuscate_l1_polys(this.s1, this.l2_Q2, this.l1_Q2);
        this.calculate_F_from_Q();
    }

    private void genKeyMaterial_cyclic() {
        this.sk_seed = new byte[this.rainbowParams.getLen_skseed()];
        this.random.nextBytes(this.sk_seed);
        this.pk_seed = new byte[this.rainbowParams.getLen_pkseed()];
        this.random.nextBytes(this.pk_seed);
        this.genPrivateKeyMaterial_cyclic();
        this.calculate_Q_from_F_cyclic();
        this.l1_Q3 = this.cf.obfuscate_l1_polys(this.s1, this.l2_Q3, this.l1_Q3);
        this.l1_Q5 = this.cf.obfuscate_l1_polys(this.s1, this.l2_Q5, this.l1_Q5);
        this.l1_Q6 = this.cf.obfuscate_l1_polys(this.s1, this.l2_Q6, this.l1_Q6);
        this.l1_Q9 = this.cf.obfuscate_l1_polys(this.s1, this.l2_Q9, this.l1_Q9);
    }

    public AsymmetricCipherKeyPair genKeyPairClassical() {
        this.genKeyMaterial();
        RainbowPublicKeyParameters pubKey = new RainbowPublicKeyParameters(this.rainbowParams, this.l1_Q1, this.l1_Q2, this.l1_Q3, this.l1_Q5, this.l1_Q6, this.l1_Q9, this.l2_Q1, this.l2_Q2, this.l2_Q3, this.l2_Q5, this.l2_Q6, this.l2_Q9);
        RainbowPrivateKeyParameters privKey = new RainbowPrivateKeyParameters(this.rainbowParams, this.sk_seed, this.s1, this.t1, this.t3, this.t4, this.l1_F1, this.l1_F2, this.l2_F1, this.l2_F2, this.l2_F3, this.l2_F5, this.l2_F6, pubKey.getEncoded());
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }

    public AsymmetricCipherKeyPair genKeyPairCircumzenithal() {
        this.genKeyMaterial_cyclic();
        RainbowPublicKeyParameters pubKey = new RainbowPublicKeyParameters(this.rainbowParams, this.pk_seed, this.l1_Q3, this.l1_Q5, this.l1_Q6, this.l1_Q9, this.l2_Q9);
        RainbowPrivateKeyParameters privKey = new RainbowPrivateKeyParameters(this.rainbowParams, this.sk_seed, this.s1, this.t1, this.t3, this.t4, this.l1_F1, this.l1_F2, this.l2_F1, this.l2_F2, this.l2_F3, this.l2_F5, this.l2_F6, pubKey.getEncoded());
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }

    public AsymmetricCipherKeyPair genKeyPairCompressed() {
        this.genKeyMaterial_cyclic();
        RainbowPublicKeyParameters pubKey = new RainbowPublicKeyParameters(this.rainbowParams, this.pk_seed, this.l1_Q3, this.l1_Q5, this.l1_Q6, this.l1_Q9, this.l2_Q9);
        RainbowPrivateKeyParameters privKey = new RainbowPrivateKeyParameters(this.rainbowParams, this.pk_seed, this.sk_seed, pubKey.getEncoded());
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }

    RainbowPrivateKeyParameters generatePrivateKey() {
        this.sk_seed = Arrays.clone(this.sk_seed);
        this.pk_seed = Arrays.clone(this.pk_seed);
        this.genPrivateKeyMaterial_cyclic();
        return new RainbowPrivateKeyParameters(this.rainbowParams, this.sk_seed, this.s1, this.t1, this.t3, this.t4, this.l1_F1, this.l1_F2, this.l2_F1, this.l2_F2, this.l2_F3, this.l2_F5, this.l2_F6, null);
    }
}

