/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.rainbow;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.util.Arrays;

class RainbowUtil {
    RainbowUtil() {
    }

    public static short[] convertArray(byte[] in) {
        short[] out = new short[in.length];
        int i = 0;
        while (i < in.length) {
            out[i] = (short)(in[i] & 0xFF);
            ++i;
        }
        return out;
    }

    public static byte[] convertArray(short[] in) {
        byte[] out = new byte[in.length];
        int i = 0;
        while (i < in.length) {
            out[i] = (byte)in[i];
            ++i;
        }
        return out;
    }

    public static boolean equals(short[] left, short[] right) {
        if (left.length != right.length) {
            return false;
        }
        boolean result = true;
        int i = left.length - 1;
        while (i >= 0) {
            result &= left[i] == right[i];
            --i;
        }
        return result;
    }

    public static boolean equals(short[][] left, short[][] right) {
        if (left.length != right.length) {
            return false;
        }
        boolean result = true;
        int i = left.length - 1;
        while (i >= 0) {
            result &= RainbowUtil.equals(left[i], right[i]);
            --i;
        }
        return result;
    }

    public static boolean equals(short[][][] left, short[][][] right) {
        if (left.length != right.length) {
            return false;
        }
        boolean result = true;
        int i = left.length - 1;
        while (i >= 0) {
            result &= RainbowUtil.equals(left[i], right[i]);
            --i;
        }
        return result;
    }

    public static short[][] cloneArray(short[][] toCopy) {
        short[][] local = new short[toCopy.length][];
        int i = 0;
        while (i < toCopy.length) {
            local[i] = Arrays.clone(toCopy[i]);
            ++i;
        }
        return local;
    }

    public static short[][][] cloneArray(short[][][] toCopy) {
        short[][][] local = new short[toCopy.length][toCopy[0].length][];
        int i = 0;
        while (i < toCopy.length) {
            int j = 0;
            while (j < toCopy[0].length) {
                local[i][j] = Arrays.clone(toCopy[i][j]);
                ++j;
            }
            ++i;
        }
        return local;
    }

    public static byte[] hash(Digest hashAlgo, byte[] partA, byte[] partB, byte[] result) {
        int digest_size = hashAlgo.getDigestSize();
        hashAlgo.update(partA, 0, partA.length);
        hashAlgo.update(partB, 0, partB.length);
        if (result.length == digest_size) {
            hashAlgo.doFinal(result, 0);
            return result;
        }
        byte[] hash = new byte[digest_size];
        hashAlgo.doFinal(hash, 0);
        if (result.length < digest_size) {
            System.arraycopy(hash, 0, result, 0, result.length);
            return result;
        }
        System.arraycopy(hash, 0, result, 0, hash.length);
        int left_to_hash = result.length - digest_size;
        int index = digest_size;
        while (left_to_hash >= hash.length) {
            hashAlgo.update(hash, 0, hash.length);
            hashAlgo.doFinal(hash, 0);
            System.arraycopy(hash, 0, result, index, hash.length);
            left_to_hash -= hash.length;
            index += hash.length;
        }
        if (left_to_hash > 0) {
            hashAlgo.update(hash, 0, hash.length);
            hashAlgo.doFinal(hash, 0);
            System.arraycopy(hash, 0, result, index, left_to_hash);
        }
        return result;
    }

    public static byte[] hash(Digest hashAlgo, byte[] msg, int hash_length) {
        int digest_size = hashAlgo.getDigestSize();
        hashAlgo.update(msg, 0, msg.length);
        byte[] hash = new byte[digest_size];
        hashAlgo.doFinal(hash, 0);
        if (hash_length == digest_size) {
            return hash;
        }
        if (hash_length < digest_size) {
            return Arrays.copyOf(hash, hash_length);
        }
        byte[] final_hash = Arrays.copyOf(hash, digest_size);
        int left_to_hash = hash_length - digest_size;
        while (left_to_hash >= digest_size) {
            hashAlgo.update(hash, 0, digest_size);
            hash = new byte[digest_size];
            hashAlgo.doFinal(hash, 0);
            final_hash = Arrays.concatenate(final_hash, hash);
            left_to_hash -= digest_size;
        }
        if (left_to_hash > 0) {
            hashAlgo.update(hash, 0, digest_size);
            hash = new byte[digest_size];
            hashAlgo.doFinal(hash, 0);
            int current_length = final_hash.length;
            final_hash = Arrays.copyOf(final_hash, current_length + left_to_hash);
            System.arraycopy(hash, 0, final_hash, current_length, left_to_hash);
        }
        return final_hash;
    }

    public static short[][] generate_random_2d(SecureRandom sr, int dim_row, int dim_col) {
        byte[] tmp = new byte[dim_row * dim_col];
        sr.nextBytes(tmp);
        short[][] matrix = new short[dim_row][dim_col];
        int j = 0;
        while (j < dim_col) {
            int i = 0;
            while (i < dim_row) {
                matrix[i][j] = (short)(tmp[j * dim_row + i] & 0xFF);
                ++i;
            }
            ++j;
        }
        return matrix;
    }

    public static short[][][] generate_random(SecureRandom sr, int dim_batch, int dim_row, int dim_col, boolean triangular) {
        int bytes_needed = triangular ? dim_batch * (dim_row * (dim_row + 1) / 2) : dim_batch * dim_row * dim_col;
        byte[] tmp = new byte[bytes_needed];
        sr.nextBytes(tmp);
        int index = 0;
        short[][][] matrix = new short[dim_batch][dim_row][dim_col];
        int i = 0;
        while (i < dim_row) {
            int j = 0;
            while (j < dim_col) {
                int k = 0;
                while (k < dim_batch) {
                    if (!triangular || i <= j) {
                        matrix[k][i][j] = (short)(tmp[index++] & 0xFF);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static byte[] getEncoded(short[][] a) {
        int row = a.length;
        int col = a[0].length;
        byte[] ret = new byte[row * col];
        int j = 0;
        while (j < col) {
            int i = 0;
            while (i < row) {
                ret[j * row + i] = (byte)a[i][j];
                ++i;
            }
            ++j;
        }
        return ret;
    }

    public static byte[] getEncoded(short[][][] a, boolean triangular) {
        int dim = a.length;
        int row = a[0].length;
        int col = a[0][0].length;
        int ret_size = triangular ? dim * (row * (row + 1) / 2) : dim * row * col;
        byte[] ret = new byte[ret_size];
        int cnt = 0;
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                int k = 0;
                while (k < dim) {
                    if (!triangular || i <= j) {
                        ret[cnt] = (byte)a[k][i][j];
                        ++cnt;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static int loadEncoded(short[][] a, byte[] enc, int off) {
        int row = a.length;
        int col = a[0].length;
        int j = 0;
        while (j < col) {
            int i = 0;
            while (i < row) {
                a[i][j] = (short)(enc[off + j * row + i] & 0xFF);
                ++i;
            }
            ++j;
        }
        return row * col;
    }

    public static int loadEncoded(short[][][] a, byte[] enc, int off, boolean triangular) {
        int dim = a.length;
        int row = a[0].length;
        int col = a[0][0].length;
        int cnt = 0;
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                int k = 0;
                while (k < dim) {
                    if (!triangular || i <= j) {
                        a[k][i][j] = (short)(enc[off + cnt++] & 0xFF);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return cnt;
    }
}

