/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.slhdsa;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ParametersWithContext;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.MessageSigner;
import org.bouncycastle.pqc.crypto.slhdsa.ADRS;
import org.bouncycastle.pqc.crypto.slhdsa.Fors;
import org.bouncycastle.pqc.crypto.slhdsa.HT;
import org.bouncycastle.pqc.crypto.slhdsa.IndexedDigest;
import org.bouncycastle.pqc.crypto.slhdsa.SIG;
import org.bouncycastle.pqc.crypto.slhdsa.SIG_FORS;
import org.bouncycastle.pqc.crypto.slhdsa.SIG_XMSS;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAEngine;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPublicKeyParameters;
import org.bouncycastle.util.Arrays;

public class SLHDSASigner
implements MessageSigner {
    private static final byte[] DEFAULT_PREFIX = new byte[2];
    private byte[] msgPrefix;
    private SLHDSAPublicKeyParameters pubKey;
    private SLHDSAPrivateKeyParameters privKey;
    private SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        SLHDSAParameters parameters;
        if (param instanceof ParametersWithContext) {
            ParametersWithContext withContext = (ParametersWithContext)param;
            param = withContext.getParameters();
            int ctxLength = withContext.getContextLength();
            if (ctxLength > 255) {
                throw new IllegalArgumentException("context too long");
            }
            this.msgPrefix = new byte[2 + ctxLength];
            this.msgPrefix[0] = 0;
            this.msgPrefix[1] = (byte)ctxLength;
            withContext.copyContextTo(this.msgPrefix, 2, ctxLength);
        } else {
            this.msgPrefix = DEFAULT_PREFIX;
        }
        if (forSigning) {
            this.pubKey = null;
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom withRandom = (ParametersWithRandom)param;
                this.privKey = (SLHDSAPrivateKeyParameters)withRandom.getParameters();
                this.random = withRandom.getRandom();
            } else {
                this.privKey = (SLHDSAPrivateKeyParameters)param;
                this.random = null;
            }
            parameters = this.privKey.getParameters();
        } else {
            this.pubKey = (SLHDSAPublicKeyParameters)param;
            this.privKey = null;
            this.random = null;
            parameters = this.pubKey.getParameters();
        }
        if (parameters.isPreHash()) {
            throw new IllegalArgumentException("\"pure\" slh-dsa must use non pre-hash parameters");
        }
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        SLHDSAEngine engine = this.privKey.getParameters().getEngine();
        engine.init(this.privKey.pk.seed);
        byte[] optRand = new byte[engine.N];
        if (this.random != null) {
            this.random.nextBytes(optRand);
        } else {
            System.arraycopy(this.privKey.pk.seed, 0, optRand, 0, optRand.length);
        }
        return SLHDSASigner.internalGenerateSignature(this.privKey, this.msgPrefix, message, optRand);
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        return SLHDSASigner.internalVerifySignature(this.pubKey, this.msgPrefix, message, signature);
    }

    protected boolean internalVerifySignature(byte[] message, byte[] signature) {
        return SLHDSASigner.internalVerifySignature(this.pubKey, null, message, signature);
    }

    private static boolean internalVerifySignature(SLHDSAPublicKeyParameters pubKey, byte[] msgPrefix, byte[] msg, byte[] signature) {
        SLHDSAEngine engine = pubKey.getParameters().getEngine();
        engine.init(pubKey.getSeed());
        ADRS adrs = new ADRS();
        if ((1 + engine.K * (1 + engine.A) + engine.H + engine.D * engine.WOTS_LEN) * engine.N != signature.length) {
            return false;
        }
        SIG sig = new SIG(engine.N, engine.K, engine.A, engine.D, engine.H_PRIME, engine.WOTS_LEN, signature);
        byte[] R = sig.getR();
        SIG_FORS[] sig_fors = sig.getSIG_FORS();
        SIG_XMSS[] SIG_HT = sig.getSIG_HT();
        IndexedDigest idxDigest = engine.H_msg(R, pubKey.getSeed(), pubKey.getRoot(), msgPrefix, msg);
        byte[] mHash = idxDigest.digest;
        long idx_tree = idxDigest.idx_tree;
        int idx_leaf = idxDigest.idx_leaf;
        adrs.setTypeAndClear(3);
        adrs.setLayerAddress(0);
        adrs.setTreeAddress(idx_tree);
        adrs.setKeyPairAddress(idx_leaf);
        byte[] PK_FORS = new Fors(engine).pkFromSig(sig_fors, mHash, pubKey.getSeed(), adrs);
        adrs.setTypeAndClear(2);
        adrs.setLayerAddress(0);
        adrs.setTreeAddress(idx_tree);
        adrs.setKeyPairAddress(idx_leaf);
        HT ht = new HT(engine, null, pubKey.getSeed());
        return ht.verify(PK_FORS, SIG_HT, pubKey.getSeed(), idx_tree, idx_leaf, pubKey.getRoot());
    }

    protected byte[] internalGenerateSignature(byte[] message, byte[] optRand) {
        return SLHDSASigner.internalGenerateSignature(this.privKey, null, message, optRand);
    }

    private static byte[] internalGenerateSignature(SLHDSAPrivateKeyParameters privKey, byte[] msgPrefix, byte[] msg, byte[] optRand) {
        SLHDSAEngine engine = privKey.getParameters().getEngine();
        engine.init(privKey.pk.seed);
        Fors fors = new Fors(engine);
        byte[] R = engine.PRF_msg(privKey.sk.prf, optRand, msgPrefix, msg);
        IndexedDigest idxDigest = engine.H_msg(R, privKey.pk.seed, privKey.pk.root, msgPrefix, msg);
        byte[] mHash = idxDigest.digest;
        long idx_tree = idxDigest.idx_tree;
        int idx_leaf = idxDigest.idx_leaf;
        ADRS adrs = new ADRS();
        adrs.setTypeAndClear(3);
        adrs.setTreeAddress(idx_tree);
        adrs.setKeyPairAddress(idx_leaf);
        SIG_FORS[] sig_fors = fors.sign(mHash, privKey.sk.seed, privKey.pk.seed, adrs);
        adrs = new ADRS();
        adrs.setTypeAndClear(3);
        adrs.setTreeAddress(idx_tree);
        adrs.setKeyPairAddress(idx_leaf);
        byte[] PK_FORS = fors.pkFromSig(sig_fors, mHash, privKey.pk.seed, adrs);
        ADRS treeAdrs = new ADRS();
        treeAdrs.setTypeAndClear(2);
        HT ht = new HT(engine, privKey.getSeed(), privKey.getPublicSeed());
        byte[] SIG_HT = ht.sign(PK_FORS, idx_tree, idx_leaf);
        byte[][] sigComponents = new byte[sig_fors.length + 2][];
        sigComponents[0] = R;
        int i = 0;
        while (i != sig_fors.length) {
            sigComponents[1 + i] = Arrays.concatenate(sig_fors[i].sk, Arrays.concatenate(sig_fors[i].authPath));
            ++i;
        }
        sigComponents[sigComponents.length - 1] = SIG_HT;
        return Arrays.concatenate(sigComponents);
    }
}

