/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.math.ntru.polynomial;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.pqc.legacy.math.ntru.polynomial.BigIntPolynomial;
import org.bouncycastle.pqc.legacy.math.ntru.polynomial.IntegerPolynomial;
import org.bouncycastle.pqc.legacy.math.ntru.polynomial.TernaryPolynomial;
import org.bouncycastle.pqc.legacy.math.ntru.util.ArrayEncoder;
import org.bouncycastle.pqc.legacy.math.ntru.util.Util;
import org.bouncycastle.util.Arrays;

public class SparseTernaryPolynomial
implements TernaryPolynomial {
    private static final int BITS_PER_INDEX = 11;
    private int N;
    private int[] ones;
    private int[] negOnes;

    SparseTernaryPolynomial(int N, int[] ones, int[] negOnes) {
        this.N = N;
        this.ones = ones;
        this.negOnes = negOnes;
    }

    public SparseTernaryPolynomial(IntegerPolynomial intPoly) {
        this(intPoly.coeffs);
    }

    public SparseTernaryPolynomial(int[] coeffs) {
        this.N = coeffs.length;
        this.ones = new int[this.N];
        this.negOnes = new int[this.N];
        int onesIdx = 0;
        int negOnesIdx = 0;
        int i = 0;
        while (i < this.N) {
            int c = coeffs[i];
            switch (c) {
                case 1: {
                    this.ones[onesIdx++] = i;
                    break;
                }
                case -1: {
                    this.negOnes[negOnesIdx++] = i;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal value: " + c + ", must be one of {-1, 0, 1}");
                }
            }
            ++i;
        }
        this.ones = Arrays.copyOf(this.ones, onesIdx);
        this.negOnes = Arrays.copyOf(this.negOnes, negOnesIdx);
    }

    public static SparseTernaryPolynomial fromBinary(InputStream is, int N, int numOnes, int numNegOnes) throws IOException {
        int maxIndex = 2048;
        int bitsPerIndex = 32 - Integer.numberOfLeadingZeros(maxIndex - 1);
        int data1Len = (numOnes * bitsPerIndex + 7) / 8;
        byte[] data1 = Util.readFullLength(is, data1Len);
        int[] ones = ArrayEncoder.decodeModQ(data1, numOnes, maxIndex);
        int data2Len = (numNegOnes * bitsPerIndex + 7) / 8;
        byte[] data2 = Util.readFullLength(is, data2Len);
        int[] negOnes = ArrayEncoder.decodeModQ(data2, numNegOnes, maxIndex);
        return new SparseTernaryPolynomial(N, ones, negOnes);
    }

    public static SparseTernaryPolynomial generateRandom(int N, int numOnes, int numNegOnes, SecureRandom random) {
        int[] coeffs = Util.generateRandomTernary(N, numOnes, numNegOnes, random);
        return new SparseTernaryPolynomial(coeffs);
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial poly2) {
        int k;
        int j;
        int i;
        int[] b = poly2.coeffs;
        if (b.length != this.N) {
            throw new IllegalArgumentException("Number of coefficients must be the same");
        }
        int[] c = new int[this.N];
        int idx = 0;
        while (idx != this.ones.length) {
            i = this.ones[idx];
            j = this.N - 1 - i;
            k = this.N - 1;
            while (k >= 0) {
                int n = k;
                c[n] = c[n] + b[j];
                if (--j < 0) {
                    j = this.N - 1;
                }
                --k;
            }
            ++idx;
        }
        idx = 0;
        while (idx != this.negOnes.length) {
            i = this.negOnes[idx];
            j = this.N - 1 - i;
            k = this.N - 1;
            while (k >= 0) {
                int n = k;
                c[n] = c[n] - b[j];
                if (--j < 0) {
                    j = this.N - 1;
                }
                --k;
            }
            ++idx;
        }
        return new IntegerPolynomial(c);
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial poly2, int modulus) {
        IntegerPolynomial c = this.mult(poly2);
        c.mod(modulus);
        return c;
    }

    @Override
    public BigIntPolynomial mult(BigIntPolynomial poly2) {
        int k;
        int j;
        int i;
        BigInteger[] b = poly2.coeffs;
        if (b.length != this.N) {
            throw new IllegalArgumentException("Number of coefficients must be the same");
        }
        BigInteger[] c = new BigInteger[this.N];
        int i2 = 0;
        while (i2 < this.N) {
            c[i2] = BigInteger.ZERO;
            ++i2;
        }
        int idx = 0;
        while (idx != this.ones.length) {
            i = this.ones[idx];
            j = this.N - 1 - i;
            k = this.N - 1;
            while (k >= 0) {
                c[k] = c[k].add(b[j]);
                if (--j < 0) {
                    j = this.N - 1;
                }
                --k;
            }
            ++idx;
        }
        idx = 0;
        while (idx != this.negOnes.length) {
            i = this.negOnes[idx];
            j = this.N - 1 - i;
            k = this.N - 1;
            while (k >= 0) {
                c[k] = c[k].subtract(b[j]);
                if (--j < 0) {
                    j = this.N - 1;
                }
                --k;
            }
            ++idx;
        }
        return new BigIntPolynomial(c);
    }

    @Override
    public int[] getOnes() {
        return this.ones;
    }

    @Override
    public int[] getNegOnes() {
        return this.negOnes;
    }

    public byte[] toBinary() {
        int maxIndex = 2048;
        byte[] bin1 = ArrayEncoder.encodeModQ(this.ones, maxIndex);
        byte[] bin2 = ArrayEncoder.encodeModQ(this.negOnes, maxIndex);
        byte[] bin = Arrays.copyOf(bin1, bin1.length + bin2.length);
        System.arraycopy(bin2, 0, bin, bin1.length, bin2.length);
        return bin;
    }

    @Override
    public IntegerPolynomial toIntegerPolynomial() {
        int i;
        int[] coeffs = new int[this.N];
        int idx = 0;
        while (idx != this.ones.length) {
            i = this.ones[idx];
            coeffs[i] = 1;
            ++idx;
        }
        idx = 0;
        while (idx != this.negOnes.length) {
            i = this.negOnes[idx];
            coeffs[i] = -1;
            ++idx;
        }
        return new IntegerPolynomial(coeffs);
    }

    @Override
    public int size() {
        return this.N;
    }

    @Override
    public void clear() {
        int i = 0;
        while (i < this.ones.length) {
            this.ones[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.negOnes.length) {
            this.negOnes[i] = 0;
            ++i;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.N;
        result = 31 * result + Arrays.hashCode(this.negOnes);
        result = 31 * result + Arrays.hashCode(this.ones);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparseTernaryPolynomial other = (SparseTernaryPolynomial)obj;
        if (this.N != other.N) {
            return false;
        }
        if (!Arrays.areEqual(this.negOnes, other.negOnes)) {
            return false;
        }
        return Arrays.areEqual(this.ones, other.ones);
    }
}

