/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.factories;

public class RomanNumberFactory {
    private static final RomanDigit[] roman = new RomanDigit[]{new RomanDigit('m', 1000, false), new RomanDigit('d', 500, false), new RomanDigit('c', 100, true), new RomanDigit('l', 50, false), new RomanDigit('x', 10, true), new RomanDigit('v', 5, false), new RomanDigit('i', 1, true)};

    public static final String getString(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 < 0) {
            stringBuffer.append('-');
            n2 = -n2;
        }
        if (n2 > 3000) {
            stringBuffer.append('|');
            stringBuffer.append(RomanNumberFactory.getString(n2 / 1000));
            stringBuffer.append('|');
            n2 -= n2 / 1000 * 1000;
        }
        int n3 = 0;
        while (true) {
            RomanDigit romanDigit = roman[n3];
            while (n2 >= romanDigit.value) {
                stringBuffer.append(romanDigit.digit);
                n2 -= romanDigit.value;
            }
            if (n2 <= 0) break;
            int n4 = n3;
            while (!RomanNumberFactory.roman[++n4].pre) {
            }
            if (n2 + RomanNumberFactory.roman[n4].value >= romanDigit.value) {
                stringBuffer.append(RomanNumberFactory.roman[n4].digit).append(romanDigit.digit);
                n2 -= romanDigit.value - RomanNumberFactory.roman[n4].value;
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static final String getLowerCaseString(int n2) {
        return RomanNumberFactory.getString(n2);
    }

    public static final String getUpperCaseString(int n2) {
        return RomanNumberFactory.getString(n2).toUpperCase();
    }

    public static final String getString(int n2, boolean bl) {
        if (bl) {
            return RomanNumberFactory.getLowerCaseString(n2);
        }
        return RomanNumberFactory.getUpperCaseString(n2);
    }

    public static void main(String[] stringArray) {
        for (int i2 = 1; i2 < 2000; ++i2) {
            System.out.println(RomanNumberFactory.getString(i2));
        }
    }

    private static class RomanDigit {
        public char digit;
        public int value;
        public boolean pre;

        RomanDigit(char c2, int n2, boolean bl) {
            this.digit = c2;
            this.value = n2;
            this.pre = bl;
        }
    }
}

