/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDocument;
import java.util.ArrayList;

public class MultiColumnText
implements Element {
    public static final float AUTOMATIC = -1.0f;
    private float desiredHeight;
    private float totalHeight;
    private boolean overflow;
    private float top;
    private ColumnText columnText;
    private ArrayList columnDefs = new ArrayList();
    private boolean simple = true;
    private int currentColumn = 0;
    private float nextY = -1.0f;
    private boolean columnsRightToLeft = false;
    private PdfDocument document;

    public MultiColumnText() {
        this(-1.0f);
    }

    public MultiColumnText(float f2) {
        this.desiredHeight = f2;
        this.top = -1.0f;
        this.columnText = new ColumnText(null);
        this.totalHeight = 0.0f;
    }

    public MultiColumnText(float f2, float f3) {
        this.desiredHeight = f3;
        this.top = f2;
        this.nextY = f2;
        this.columnText = new ColumnText(null);
        this.totalHeight = 0.0f;
    }

    public boolean isOverflow() {
        return this.overflow;
    }

    public void useColumnParams(ColumnText columnText) {
        this.columnText.setSimpleVars(columnText);
    }

    public void addColumn(float[] fArray, float[] fArray2) {
        ColumnDef columnDef = new ColumnDef(fArray, fArray2);
        if (!columnDef.isSimple()) {
            this.simple = false;
        }
        this.columnDefs.add(columnDef);
    }

    public void addSimpleColumn(float f2, float f3) {
        ColumnDef columnDef = new ColumnDef(f2, f3);
        this.columnDefs.add(columnDef);
    }

    public void addRegularColumns(float f2, float f3, float f4, int n2) {
        float f5 = f2;
        float f6 = f3 - f2;
        float f7 = (f6 - f4 * (float)(n2 - 1)) / (float)n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addSimpleColumn(f5, f5 + f7);
            f5 += f7 + f4;
        }
    }

    public void addText(Phrase phrase) {
        this.columnText.addText(phrase);
    }

    public void addText(Chunk chunk) {
        this.columnText.addText(chunk);
    }

    public void addElement(Element element) throws DocumentException {
        if (this.simple) {
            this.columnText.addElement(element);
        } else if (element instanceof Phrase) {
            this.columnText.addText((Phrase)element);
        } else if (element instanceof Chunk) {
            this.columnText.addText((Chunk)element);
        } else {
            throw new DocumentException("Can't add " + element.getClass() + " to MultiColumnText with complex columns");
        }
    }

    public float write(PdfContentByte pdfContentByte, PdfDocument pdfDocument, float f2) throws DocumentException {
        this.document = pdfDocument;
        this.columnText.setCanvas(pdfContentByte);
        if (this.columnDefs.isEmpty()) {
            throw new DocumentException("MultiColumnText has no columns");
        }
        this.overflow = false;
        float f3 = 0.0f;
        boolean bl = false;
        try {
            while (!bl) {
                if (this.top == -1.0f) {
                    this.top = pdfDocument.getVerticalPosition(true);
                } else if (this.nextY == -1.0f) {
                    this.nextY = pdfDocument.getVerticalPosition(true);
                }
                ColumnDef columnDef = (ColumnDef)this.columnDefs.get(this.getCurrentColumn());
                this.columnText.setYLine(this.top);
                float[] fArray = columnDef.resolvePositions(4);
                float[] fArray2 = columnDef.resolvePositions(8);
                if (pdfDocument.isMarginMirroring() && pdfDocument.getPageNumber() % 2 == 0) {
                    int n2;
                    float f4 = pdfDocument.rightMargin() - pdfDocument.left();
                    fArray = (float[])fArray.clone();
                    fArray2 = (float[])fArray2.clone();
                    for (n2 = 0; n2 < fArray.length; n2 += 2) {
                        int n3 = n2;
                        fArray[n3] = fArray[n3] - f4;
                    }
                    for (n2 = 0; n2 < fArray2.length; n2 += 2) {
                        int n4 = n2;
                        fArray2[n4] = fArray2[n4] - f4;
                    }
                }
                f3 = Math.max(f3, this.getHeight(fArray, fArray2));
                if (columnDef.isSimple()) {
                    this.columnText.setSimpleColumn(fArray[2], fArray[3], fArray2[0], fArray2[1]);
                } else {
                    this.columnText.setColumns(fArray, fArray2);
                }
                int n5 = this.columnText.go();
                if ((n5 & 1) != 0) {
                    bl = true;
                    this.top = this.columnText.getYLine();
                    continue;
                }
                if (this.shiftCurrentColumn()) {
                    this.top = this.nextY;
                    continue;
                }
                this.totalHeight += f3;
                if (this.desiredHeight != -1.0f && this.totalHeight >= this.desiredHeight) {
                    this.overflow = true;
                    break;
                }
                f2 = this.nextY;
                this.newPage();
                f3 = 0.0f;
            }
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
            throw documentException;
        }
        if (this.desiredHeight == -1.0f && this.columnDefs.size() == 1) {
            f3 = f2 - this.columnText.getYLine();
        }
        return f3;
    }

    private void newPage() throws DocumentException {
        this.resetCurrentColumn();
        if (this.desiredHeight == -1.0f) {
            this.nextY = -1.0f;
            this.top = -1.0f;
        } else {
            this.top = this.nextY;
        }
        this.totalHeight = 0.0f;
        if (this.document != null) {
            this.document.newPage();
        }
    }

    private float getHeight(float[] fArray, float[] fArray2) {
        int n2;
        float f2 = Float.MIN_VALUE;
        float f3 = Float.MAX_VALUE;
        for (n2 = 0; n2 < fArray.length; n2 += 2) {
            f3 = Math.min(f3, fArray[n2 + 1]);
            f2 = Math.max(f2, fArray[n2 + 1]);
        }
        for (n2 = 0; n2 < fArray2.length; n2 += 2) {
            f3 = Math.min(f3, fArray2[n2 + 1]);
            f2 = Math.max(f2, fArray2[n2 + 1]);
        }
        return f2 - f3;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 40;
    }

    public ArrayList getChunks() {
        return null;
    }

    public boolean isContent() {
        return true;
    }

    public boolean isNestable() {
        return false;
    }

    private float getColumnBottom() {
        if (this.desiredHeight == -1.0f) {
            return this.document.bottom();
        }
        return Math.max(this.top - (this.desiredHeight - this.totalHeight), this.document.bottom());
    }

    public void nextColumn() throws DocumentException {
        this.currentColumn = (this.currentColumn + 1) % this.columnDefs.size();
        this.top = this.nextY;
        if (this.currentColumn == 0) {
            this.newPage();
        }
    }

    public int getCurrentColumn() {
        if (this.columnsRightToLeft) {
            return this.columnDefs.size() - this.currentColumn - 1;
        }
        return this.currentColumn;
    }

    public void resetCurrentColumn() {
        this.currentColumn = 0;
    }

    public boolean shiftCurrentColumn() {
        if (this.currentColumn + 1 < this.columnDefs.size()) {
            ++this.currentColumn;
            return true;
        }
        return false;
    }

    public void setColumnsRightToLeft(boolean bl) {
        this.columnsRightToLeft = bl;
    }

    public void setSpaceCharRatio(float f2) {
        this.columnText.setSpaceCharRatio(f2);
    }

    public void setRunDirection(int n2) {
        this.columnText.setRunDirection(n2);
    }

    public void setArabicOptions(int n2) {
        this.columnText.setArabicOptions(n2);
    }

    public void setAlignment(int n2) {
        this.columnText.setAlignment(n2);
    }

    private class ColumnDef {
        private float[] left;
        private float[] right;

        ColumnDef(float[] fArray, float[] fArray2) {
            this.left = fArray;
            this.right = fArray2;
        }

        ColumnDef(float f2, float f3) {
            this.left = new float[4];
            this.left[0] = f2;
            this.left[1] = MultiColumnText.this.top;
            this.left[2] = f2;
            this.left[3] = MultiColumnText.this.desiredHeight == -1.0f || MultiColumnText.this.top == -1.0f ? -1.0f : MultiColumnText.this.top - MultiColumnText.this.desiredHeight;
            this.right = new float[4];
            this.right[0] = f3;
            this.right[1] = MultiColumnText.this.top;
            this.right[2] = f3;
            this.right[3] = MultiColumnText.this.desiredHeight == -1.0f || MultiColumnText.this.top == -1.0f ? -1.0f : MultiColumnText.this.top - MultiColumnText.this.desiredHeight;
        }

        float[] resolvePositions(int n2) {
            if (n2 == 4) {
                return this.resolvePositions(this.left);
            }
            return this.resolvePositions(this.right);
        }

        private float[] resolvePositions(float[] fArray) {
            if (!this.isSimple()) {
                fArray[1] = MultiColumnText.this.top;
                return fArray;
            }
            if (MultiColumnText.this.top == -1.0f) {
                throw new RuntimeException("resolvePositions called with top=AUTOMATIC (-1).  Top position must be set befure lines can be resolved");
            }
            fArray[1] = MultiColumnText.this.top;
            fArray[3] = MultiColumnText.this.getColumnBottom();
            return fArray;
        }

        private boolean isSimple() {
            return this.left.length == 4 && this.right.length == 4 && this.left[0] == this.left[2] && this.right[0] == this.right[2];
        }
    }
}

