/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.activation.MimeTypeParameterList;
import javax.activation.MimeTypeParseException;

public class MimeType
implements Externalizable {
    private String primaryType;
    private String subType;
    private MimeTypeParameterList parameters;
    private static final String TSPECIALS = "()<>@,;:/[]?=\\\"";

    public MimeType() {
        this.primaryType = "application";
        this.subType = "*";
        this.parameters = new MimeTypeParameterList();
    }

    public MimeType(String string) throws MimeTypeParseException {
        this.parse(string);
    }

    public MimeType(String string, String string2) throws MimeTypeParseException {
        if (!this.isValidToken(string)) {
            throw new MimeTypeParseException("Primary type is invalid.");
        }
        this.primaryType = string.toLowerCase();
        if (!this.isValidToken(string2)) {
            throw new MimeTypeParseException("Sub type is invalid.");
        }
        this.subType = string2.toLowerCase();
        this.parameters = new MimeTypeParameterList();
    }

    public String getBaseType() {
        return String.valueOf(this.primaryType) + "/" + this.subType;
    }

    public String getParameter(String string) {
        return this.parameters.get(string);
    }

    public MimeTypeParameterList getParameters() {
        return this.parameters;
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public String getSubType() {
        return this.subType;
    }

    private static boolean isTokenChar(char c2) {
        return c2 > ' ' && c2 < '\u007f' && TSPECIALS.indexOf(c2) < 0;
    }

    private boolean isValidToken(String string) {
        int n2 = string.length();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                char c2 = string.charAt(n3);
                if (!MimeType.isTokenChar(c2)) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    public boolean match(String string) throws MimeTypeParseException {
        return this.match(new MimeType(string));
    }

    public boolean match(MimeType mimeType) {
        return this.primaryType.equals(mimeType.getPrimaryType()) && (this.subType.equals("*") || mimeType.getSubType().equals("*") || this.subType.equals(mimeType.getSubType()));
    }

    private void parse(String string) throws MimeTypeParseException {
        int n2 = string.indexOf(47);
        int n3 = string.indexOf(59);
        if (n2 < 0 && n3 < 0) {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        if (n2 < 0 && n3 >= 0) {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        if (n2 >= 0 && n3 < 0) {
            this.primaryType = string.substring(0, n2).trim().toLowerCase();
            this.subType = string.substring(n2 + 1).trim().toLowerCase();
            this.parameters = new MimeTypeParameterList();
        } else if (n2 < n3) {
            this.primaryType = string.substring(0, n2).trim().toLowerCase();
            this.subType = string.substring(n2 + 1, n3).trim().toLowerCase();
            this.parameters = new MimeTypeParameterList(string.substring(n3));
        } else {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        if (!this.isValidToken(this.primaryType)) {
            throw new MimeTypeParseException("Primary type is invalid.");
        }
        if (!this.isValidToken(this.subType)) {
            throw new MimeTypeParseException("Sub type is invalid.");
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            this.parse(objectInput.readUTF());
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IOException(mimeTypeParseException.toString());
        }
    }

    public void removeParameter(String string) {
        this.parameters.remove(string);
    }

    public void setParameter(String string, String string2) {
        this.parameters.set(string, string2);
    }

    public void setPrimaryType(String string) throws MimeTypeParseException {
        if (!this.isValidToken(this.primaryType)) {
            throw new MimeTypeParseException("Primary type is invalid.");
        }
        this.primaryType = string.toLowerCase();
    }

    public void setSubType(String string) throws MimeTypeParseException {
        if (!this.isValidToken(this.subType)) {
            throw new MimeTypeParseException("Sub type is invalid.");
        }
        this.subType = string.toLowerCase();
    }

    public String toString() {
        return String.valueOf(this.getBaseType()) + this.parameters.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.toString());
        objectOutput.flush();
    }
}

