/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.compilers.JavaScriptClassLoader;
import net.sf.jasperreports.compilers.JavaScriptCompiledData;
import net.sf.jasperreports.compilers.JavaScriptEvaluatorScope;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;

public class JavaScriptCompiledEvaluator
extends JREvaluator {
    private static final Log log = LogFactory.getLog(JavaScriptCompiledEvaluator.class);
    protected static final String EXPRESSION_ID_VAR = "_jreid";
    private static final ReferenceMap scriptClassLoaders = new ReferenceMap(0, 1);
    private final String unitName;
    private final JavaScriptCompiledData compiledData;
    private Context context;
    private JavaScriptEvaluatorScope evaluatorScope;
    private final Map<Integer, Script> scripts = new HashMap<Integer, Script>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static JavaScriptClassLoader getScriptClassLoader(String unitName) {
        JavaScriptClassLoader loader;
        boolean created = false;
        ReferenceMap referenceMap = scriptClassLoaders;
        synchronized (referenceMap) {
            loader = (JavaScriptClassLoader)((Object)scriptClassLoaders.get(unitName));
            if (loader == null) {
                loader = new JavaScriptClassLoader();
                scriptClassLoaders.put(unitName, (Object)loader);
                created = true;
            }
        }
        if (created && log.isDebugEnabled()) {
            log.debug("created script class loader " + (Object)((Object)loader) + " for " + unitName);
        }
        return loader;
    }

    public JavaScriptCompiledEvaluator(String unitName, JavaScriptCompiledData compiledData) {
        this.unitName = unitName;
        this.compiledData = compiledData;
    }

    @Override
    protected void customizedInit(Map<String, JRFillParameter> parametersMap, Map<String, JRFillField> fieldsMap, Map<String, JRFillVariable> variablesMap) throws JRException {
        this.context = ContextFactory.getGlobal().enterContext();
        this.context.getWrapFactory().setJavaPrimitiveWrap(false);
        this.evaluatorScope = new JavaScriptEvaluatorScope(this.context, this);
        this.evaluatorScope.init(parametersMap, fieldsMap, variablesMap);
    }

    @Override
    protected Object evaluate(int id) throws Throwable {
        JavaScriptCompiledData.ExpressionIndexes expression = this.getExpression(id);
        return this.evaluateExpression(expression.getDefaultExpressionIndex());
    }

    @Override
    protected Object evaluateEstimated(int id) throws Throwable {
        JavaScriptCompiledData.ExpressionIndexes expression = this.getExpression(id);
        return this.evaluateExpression(expression.getEstimatedExpressionIndex());
    }

    @Override
    protected Object evaluateOld(int id) throws Throwable {
        JavaScriptCompiledData.ExpressionIndexes expression = this.getExpression(id);
        return this.evaluateExpression(expression.getOldExpressionIndex());
    }

    protected JavaScriptCompiledData.ExpressionIndexes getExpression(int id) {
        return this.compiledData.getExpression(id);
    }

    protected Object evaluateExpression(int expressionIndex) {
        int scriptIndex = JavaScriptCompiledData.scriptIndex(expressionIndex);
        Script script = this.scripts.get(scriptIndex);
        if (script == null) {
            if (log.isTraceEnabled()) {
                log.trace("creating script for expression index " + expressionIndex + ", script index " + scriptIndex);
            }
            JavaScriptClassLoader scriptClassLoader = JavaScriptCompiledEvaluator.getScriptClassLoader(this.unitName);
            script = scriptClassLoader.createScript(scriptIndex, this.compiledData);
            this.scripts.put(scriptIndex, script);
        }
        int expressionId = JavaScriptCompiledData.expressionId(expressionIndex);
        this.evaluatorScope.setScopeVariable(EXPRESSION_ID_VAR, expressionId);
        Object value = this.evaluatorScope.evaluateExpression(script);
        if (log.isTraceEnabled()) {
            log.trace("expression with index " + expressionIndex + ", id " + expressionId + " evaluated to " + value);
        }
        return value;
    }
}

