/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.hibernate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.hibernate.HibernateDataAdapter;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HibernateDataAdapterService
extends AbstractDataAdapterService {
    private static final Log log = LogFactory.getLog(HibernateDataAdapterService.class);
    private Object session;

    public HibernateDataAdapterService(JasperReportsContext jasperReportsContext, HibernateDataAdapter jsonDataAdapter) {
        super(jasperReportsContext, jsonDataAdapter);
    }

    public HibernateDataAdapterService(HibernateDataAdapter jsonDataAdapter) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), jsonDataAdapter);
    }

    public HibernateDataAdapter getHibernateDataAdapter() {
        return (HibernateDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        block16: {
            HibernateDataAdapter hbmDA = this.getHibernateDataAdapter();
            if (hbmDA != null) {
                try {
                    Object configure;
                    Class<?> clazz = JRClassLoader.loadClassForRealName("org.hibernate.cfg.Configuration");
                    if (clazz == null || (configure = clazz.newInstance()) == null) break block16;
                    String xmlFileName = hbmDA.getXMLFileName();
                    if (xmlFileName != null && !xmlFileName.isEmpty()) {
                        File file = new File(xmlFileName);
                        clazz.getMethod("configure", file.getClass()).invoke(configure, file);
                    } else {
                        clazz.getMethod("configure", new Class[0]).invoke(configure, new Object[0]);
                    }
                    String pFileName = hbmDA.getPropertiesFileName();
                    if (pFileName != null && !pFileName.isEmpty()) {
                        Properties propHibernate = new Properties();
                        propHibernate.load(new FileInputStream(pFileName));
                        clazz.getMethod("setProperties", propHibernate.getClass()).invoke(configure, propHibernate);
                    }
                    if (hbmDA.isUseAnnotation()) {
                        try {
                            Class<?> anclazz = JRClassLoader.loadClassForRealName("org.hibernate.cfg.AnnotationConfiguration");
                            Object conf = anclazz.newInstance();
                            conf.getClass().getMethod("configure", new Class[0]).invoke(conf, new Object[0]);
                            clazz.getMethod("setProperty", String.class, String.class).invoke(configure, "hibernate.connection.provider_class", "com.jaspersoft.ireport.designer.connection.HibernateConnectionProvider");
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    Object bsf = clazz.getMethod("buildSessionFactory", new Class[0]).invoke(configure, new Object[0]);
                    this.session = bsf.getClass().getMethod("openSession", new Class[0]).invoke(bsf, new Object[0]);
                    this.session.getClass().getMethod("beginTransaction", new Class[0]).invoke(this.session, new Object[0]);
                    parameters.put("HIBERNATE_SESSION", this.session);
                }
                catch (IOException e3) {
                    throw new JRException(e3);
                }
                catch (ClassNotFoundException e4) {
                    throw new JRException(e4);
                }
                catch (InstantiationException e5) {
                    throw new JRException(e5);
                }
                catch (IllegalAccessException e6) {
                    throw new JRException(e6);
                }
                catch (IllegalArgumentException e7) {
                    throw new JRException(e7);
                }
                catch (SecurityException e8) {
                    throw new JRException(e8);
                }
                catch (InvocationTargetException e9) {
                    throw new JRException(e9);
                }
                catch (NoSuchMethodException e10) {
                    throw new JRException(e10);
                }
            }
        }
    }

    @Override
    public void dispose() {
        block3: {
            if (this.session != null) {
                try {
                    this.session.getClass().getMethod("close", new Class[0]).invoke(this.session, new Object[0]);
                }
                catch (Exception ex) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error("Error while closing the connection.", ex);
                }
            }
        }
    }
}

