/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.math.BigDecimal;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRBigDecimalIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.util.BigDecimalUtils;

final class JRBigDecimalVarianceIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRBigDecimalVarianceIncrementer mainInstance = new JRBigDecimalVarianceIncrementer();

    private JRBigDecimalVarianceIncrementer() {
    }

    public static JRBigDecimalVarianceIncrementer getInstance() {
        return mainInstance;
    }

    @Override
    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        BigDecimal value = (BigDecimal)variable.getIncrementedValue();
        BigDecimal newValue = JRBigDecimalIncrementerFactory.toBigDecimal(expressionValue);
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            return JRBigDecimalIncrementerFactory.ZERO;
        }
        BigDecimal countValue = (BigDecimal)valueProvider.getValue(variable.getHelperVariable((byte)0));
        BigDecimal sumValue = (BigDecimal)valueProvider.getValue(variable.getHelperVariable((byte)1));
        BigDecimal x1 = BigDecimalUtils.divide(countValue.subtract(JRBigDecimalIncrementerFactory.ONE).multiply(value), countValue);
        BigDecimal avg = BigDecimalUtils.divide(sumValue, countValue);
        BigDecimal avg2 = avg.subtract(newValue);
        return x1.add(BigDecimalUtils.divide(avg2.multiply(avg2), countValue.subtract(JRBigDecimalIncrementerFactory.ONE)));
    }

    @Override
    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) {
        BigDecimal value = (BigDecimal)calculable.getIncrementedValue();
        if (calculableValue.getValue() == null) {
            if (calculable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || calculable.isInitialized()) {
            return calculableValue.getIncrementedValue();
        }
        BigDecimal v1 = value;
        BigDecimal c1 = (BigDecimal)valueProvider.getValue(calculable.getHelperVariable((byte)0));
        BigDecimal s1 = (BigDecimal)valueProvider.getValue(calculable.getHelperVariable((byte)1));
        BigDecimal v2 = (BigDecimal)calculableValue.getIncrementedValue();
        BigDecimal c2 = (BigDecimal)valueProvider.getValue(calculableValue.getHelperVariable((byte)0));
        BigDecimal s2 = (BigDecimal)valueProvider.getValue(calculableValue.getHelperVariable((byte)1));
        c1 = c1.subtract(c2);
        s1 = s1.subtract(s2);
        BigDecimal c3 = c1.add(c2);
        BigDecimal t1 = c1.multiply(c2).multiply(c3).multiply(c1.multiply(v1).add(c2.multiply(v2)));
        BigDecimal t2 = c1.multiply(s2).subtract(c2.multiply(s1));
        BigDecimal t3 = c1.multiply(c2).multiply(c3).multiply(c3);
        return BigDecimalUtils.divide(t1.add(t2.multiply(t2)), t3);
    }

    @Override
    public Object initialValue() {
        return JRBigDecimalIncrementerFactory.ZERO;
    }
}

