/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.cms.KEKIdentifier;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo _info;
    private AlgorithmIdentifier _encAlg;

    public KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, InputStream inputStream) {
        super(algorithmIdentifier, AlgorithmIdentifier.getInstance(kEKRecipientInfo.getKeyEncryptionAlgorithm()), inputStream);
        this._info = kEKRecipientInfo;
        this._encAlg = algorithmIdentifier;
        this._rid = new RecipientId();
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this._rid.setKeyIdentifier(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    public CMSTypedStream getContentStream(Key key, String string) throws CMSException, NoSuchProviderException {
        try {
            byte[] byArray = this._info.getEncryptedKey().getOctets();
            Cipher cipher = Cipher.getInstance(this._keyEncAlg.getObjectId().getId(), string);
            cipher.init(4, key);
            AlgorithmIdentifier algorithmIdentifier = this._encAlg;
            String string2 = algorithmIdentifier.getObjectId().getId();
            Key key2 = cipher.unwrap(byArray, string2, 3);
            return this.getContentFromSessionKey(key2, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
    }
}

