/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import util.Debug;

public class X500Parser {
    X500Principal principal;
    List<X500Element> x500elements;

    public X500Parser(X500Principal principal) {
        this.principal = principal;
        String principalString = principal.toString();
        this.x500elements = new ArrayList<X500Element>();
        int from = 0;
        while (from < principalString.length() - 1) {
            String entry;
            int equalIndex;
            int comaIndex = principalString.indexOf(",", from);
            if (comaIndex < 0) {
                comaIndex = principalString.length();
            }
            if ((equalIndex = (entry = principalString.substring(from, comaIndex).trim()).indexOf("=")) < 0) {
                System.err.println("Warning : X500Principal Parsing : no equal found in X500 entry");
                break;
            }
            String key = entry.substring(0, equalIndex).trim();
            String value = entry.substring(equalIndex + 1).trim();
            this.x500elements.add(new X500Element(key, value));
            from = comaIndex + 1;
        }
    }

    public String getCN() {
        for (X500Element x500el : this.x500elements) {
            if (!x500el.key.toUpperCase().equals("CN")) continue;
            return x500el.value;
        }
        Debug.println("CN not found in " + this.principal.toString());
        return this.principal.toString();
    }

    public String toString() {
        String out = new String();
        for (X500Element x500el : this.x500elements) {
            String key = x500el.key;
            String value = x500el.value;
            out = String.valueOf(out) + key + "=" + value + "\n";
        }
        return out;
    }

    class X500Element {
        public String key;
        public String value;

        public X500Element(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

