/*
 * Decompiled with CFR 0.152.
 */
package in.gov.tds.parser;

import in.gov.tds.beans.Form16ABean;
import in.gov.tds.exception.PDFCreationException;
import in.gov.tds.util.BINDateComparator;
import in.gov.tds.util.CINDateComparator;
import in.gov.tds.util.DateFieldComparator;
import in.gov.tds.util.NumAmtToWordConverter;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.collections.map.MultiValueMap;

public class Form16AParser {
    public static Form16ABean[] parse(String body, String footer, boolean withDigitalSignature) throws PDFCreationException {
        Form16ABean[] form16ABean = null;
        DefaultTableModel paymentSumTableModel = null;
        DefaultTableModel taxDedTableModel = null;
        DefaultTableModel binDedTableModel = null;
        DefaultTableModel cinDedTableModel = null;
        ArrayList<Object[]> paymentSumDataList = null;
        ArrayList<Object[]> taxDedDataList = null;
        ArrayList<Object[]> binDedDataList = null;
        ArrayList<Object[]> cinDedDataList = null;
        Object[] paymentSummColumnNames = new String[]{"Amount paid/credited", "Nature of Payment", "Date of payment", "Status of Booking", "Reference No"};
        Object[] taxDedColumnNames = new String[]{"Quarter", "Reciept Numbers", "Tax Deducted", "Tax Deposited"};
        Object[] binDedColumnNames = new String[]{"Tax Deposited", "Receipt Numbers", "DDO Sequence Number", "Deposit Date", "Booking Status"};
        Object[] cinDedColumnNames = new String[]{"Tax Deposited", "BSR Code", "Deposit Date", "Challan Serial Number", "Booking Status", "Date of payment"};
        String periodicity = "";
        String deducteePAN = "";
        String assessmentYear = "";
        StringBuffer assYearRange = null;
        MultiValueMap dataPANMap = null;
        String newLineString = null;
        String[] dataArray = null;
        String inputLineStr = null;
        String[] rowsData = null;
        String periodFrom = null;
        String periodTo = null;
        String fromPeriod = null;
        String toPeriod = null;
        String nextAssYear = null;
        StringBuffer addressPart1 = null;
        StringBuffer addressPart2 = null;
        StringBuffer telNumber = null;
        String[] splitSummary = null;
        String wordsTotalAmtDeposited = null;
        String wordsTotalAmtDeducted = null;
        StringBuffer dedAdd1 = null;
        StringBuffer dedAdd2 = null;
        String paymentDate = null;
        String referenceNo = "";
        try {
            assYearRange = new StringBuffer();
            int bigDecimalScale = 2;
            form16ABean = new Form16ABean[1];
            dataPANMap = new MultiValueMap();
            newLineString = System.getProperty("line.separator");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(footer);
            stringBuilder.append(newLineString);
            stringBuilder.append(body);
            String consoFile = stringBuilder.toString();
            dataArray = consoFile.split("\\n");
            int arraySize = dataArray.length;
            int count = 0;
            while (count < arraySize) {
                inputLineStr = dataArray[count];
                rowsData = inputLineStr.split("\\^", -1);
                if (rowsData.length >= 2) {
                    if (rowsData[0].equalsIgnoreCase("FH")) {
                        periodFrom = rowsData[26];
                        periodTo = rowsData[27];
                        periodicity = rowsData[16].equalsIgnoreCase("3") ? "Q1" : (rowsData[16].equalsIgnoreCase("4") ? "Q2" : (rowsData[16].equalsIgnoreCase("5") ? "Q3" : (rowsData[16].equalsIgnoreCase("6") ? "Q4" : " ")));
                        fromPeriod = "";
                        toPeriod = "";
                        assessmentYear = rowsData[15];
                        if (assessmentYear != null) {
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy");
                            Date parsedYear = dateFormat.parse(assessmentYear);
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(parsedYear);
                            calendar.add(1, 1);
                            Date nextYear = calendar.getTime();
                            nextAssYear = dateFormat.format(nextYear);
                            assYearRange.append(assessmentYear);
                            assYearRange.append("-");
                            assYearRange.append(nextAssYear.charAt(2));
                            assYearRange.append(nextAssYear.charAt(3));
                        }
                        Calendar cal = Calendar.getInstance();
                        SimpleDateFormat finalDate = new SimpleDateFormat("dd-MMM-yyyy");
                        if (periodFrom != null && !"".equalsIgnoreCase(periodFrom)) {
                            cal.setTime(new SimpleDateFormat("yyyyMMdd").parse(periodFrom));
                            fromPeriod = finalDate.format(cal.getTime());
                        }
                        if (periodTo != null && !"".equalsIgnoreCase(periodTo)) {
                            cal.setTime(new SimpleDateFormat("yyyyMMdd").parse(periodTo));
                            toPeriod = finalDate.format(cal.getTime());
                        }
                        if (form16ABean[0] == null) {
                            form16ABean[0] = new Form16ABean();
                        }
                        addressPart1 = new StringBuffer();
                        addressPart2 = new StringBuffer();
                        telNumber = new StringBuffer();
                        boolean iscommaReq = false;
                        boolean iscommaReqAdd2 = false;
                        if (Form16AParser.isValidField(rowsData[4])) {
                            rowsData[4] = Form16AParser.trimComma(rowsData[4]);
                            addressPart1.append(rowsData[4]);
                            iscommaReq = true;
                        }
                        if (Form16AParser.isValidField(rowsData[5])) {
                            rowsData[5] = Form16AParser.trimComma(rowsData[5]);
                            if (iscommaReq) {
                                addressPart1.append(", ");
                            }
                            addressPart1.append(rowsData[5]);
                            iscommaReq = true;
                        }
                        if (Form16AParser.isValidField(rowsData[6])) {
                            rowsData[6] = Form16AParser.trimComma(rowsData[6]);
                            if (iscommaReq) {
                                addressPart1.append(", ");
                            }
                            addressPart1.append(rowsData[6]);
                            iscommaReq = true;
                        }
                        if (!Form16AParser.isValidField(rowsData[7]) && !Form16AParser.isValidField(rowsData[8])) {
                            if (Form16AParser.isValidField(rowsData[10])) {
                                addressPart1.append(" - ");
                                addressPart1.append(rowsData[10]);
                            }
                        } else {
                            if (Form16AParser.isValidField(rowsData[7])) {
                                rowsData[7] = Form16AParser.trimComma(rowsData[7]);
                                if (iscommaReq) {
                                    addressPart1.append(", ");
                                }
                                addressPart2.append(rowsData[7]);
                                iscommaReqAdd2 = true;
                            }
                            if (Form16AParser.isValidField(rowsData[8])) {
                                rowsData[8] = Form16AParser.trimComma(rowsData[8]);
                                if (iscommaReqAdd2) {
                                    addressPart2.append(", ");
                                } else {
                                    addressPart1.append(", ");
                                }
                                addressPart2.append(rowsData[8]);
                                iscommaReqAdd2 = true;
                            }
                            if (Form16AParser.isValidField(rowsData[10])) {
                                addressPart2.append(" - ");
                                addressPart2.append(rowsData[10]);
                            }
                        }
                        if (Form16AParser.isValidField(rowsData[11])) {
                            telNumber.append("+(91)");
                            telNumber.append(rowsData[11]);
                        }
                        StringBuffer addressCIT1 = new StringBuffer();
                        StringBuffer addressCIT2 = new StringBuffer();
                        iscommaReq = false;
                        iscommaReqAdd2 = false;
                        if (Form16AParser.isValidField(rowsData[19])) {
                            rowsData[19] = Form16AParser.trimComma(rowsData[19]);
                            addressCIT1.append(rowsData[19]);
                            iscommaReq = true;
                        }
                        if (Form16AParser.isValidField(rowsData[20])) {
                            rowsData[20] = Form16AParser.trimComma(rowsData[20]);
                            if (iscommaReq) {
                                addressCIT1.append(", ");
                            }
                            addressCIT1.append(rowsData[20]);
                            iscommaReq = true;
                        }
                        if (Form16AParser.isValidField(rowsData[21])) {
                            rowsData[21] = Form16AParser.trimComma(rowsData[21]);
                            if (iscommaReq) {
                                addressCIT1.append(", ");
                            }
                            addressCIT1.append(rowsData[21]);
                            iscommaReq = true;
                        }
                        if (Form16AParser.isValidField(rowsData[22])) {
                            rowsData[22] = Form16AParser.trimComma(rowsData[22]);
                            if (iscommaReq) {
                                addressCIT1.append(", ");
                            }
                            addressCIT1.append(rowsData[22]);
                            iscommaReqAdd2 = true;
                        }
                        if (Form16AParser.isValidField(rowsData[23])) {
                            rowsData[23] = Form16AParser.trimComma(rowsData[23]);
                            if (iscommaReqAdd2) {
                                addressCIT2.append(", ");
                            } else {
                                addressCIT1.append(", ");
                            }
                            addressCIT2.append(rowsData[23]);
                            iscommaReqAdd2 = true;
                        }
                        if (Form16AParser.isValidField(rowsData[24])) {
                            rowsData[24] = Form16AParser.trimComma(rowsData[24]);
                            if (iscommaReqAdd2) {
                                addressCIT2.append(", ");
                            }
                            addressCIT2.append(rowsData[24]);
                            iscommaReqAdd2 = true;
                        }
                        if (Form16AParser.isValidField(rowsData[25])) {
                            rowsData[25] = Form16AParser.trimComma(rowsData[25]);
                            if (iscommaReqAdd2) {
                                addressCIT2.append(" - ");
                            }
                            addressCIT2.append(rowsData[25]);
                            iscommaReqAdd2 = true;
                        }
                        form16ABean[0] = Form16ABean.fileHeader(form16ABean[0], rowsData[3], addressPart1.toString(), addressPart2.toString(), rowsData[9], telNumber.toString(), rowsData[12], rowsData[13], rowsData[14], assYearRange.toString(), periodicity, rowsData[18], addressCIT1.toString(), addressCIT2.toString(), fromPeriod, toPeriod, rowsData[28]);
                    } else if (rowsData[0].equalsIgnoreCase("FT")) {
                        Date lastUpdateDate = new Date();
                        String formattedUpdateDate = "";
                        String verificationDate = "";
                        String verifFullName = rowsData[2];
                        if (lastUpdateDate != null) {
                            SimpleDateFormat finalDate = new SimpleDateFormat("dd-MMM-yyyy");
                            formattedUpdateDate = finalDate.format(lastUpdateDate);
                        }
                        if (form16ABean[0] == null) {
                            form16ABean[0] = new Form16ABean();
                        }
                        verificationDate = formattedUpdateDate;
                        form16ABean[0] = Form16ABean.verification(form16ABean[0], rowsData[2], rowsData[3], rowsData[4], rowsData[5], verificationDate, formattedUpdateDate, verifFullName);
                    } else if (rowsData[0].equalsIgnoreCase("SP")) {
                        dataPANMap.put(rowsData[1], inputLineStr);
                        boolean isDeducteeDetail = false;
                        boolean isTaxDedSummary = false;
                        splitSummary = inputLineStr.split("\\\\\\\\");
                        int num = 0;
                        while (num < splitSummary.length) {
                            String taxDepDate;
                            String[] splittedData = splitSummary[num].split("\\^", -1);
                            if (!isDeducteeDetail) {
                                deducteePAN = splittedData[1];
                                if (form16ABean[0] == null) {
                                    form16ABean[0] = new Form16ABean();
                                }
                                NumAmtToWordConverter numToWords = new NumAmtToWordConverter();
                                wordsTotalAmtDeposited = numToWords.convert(splittedData[28]);
                                wordsTotalAmtDeducted = numToWords.convert(splittedData[29]);
                                dedAdd1 = new StringBuffer();
                                dedAdd2 = new StringBuffer();
                                boolean isDedComma = false;
                                if (Form16AParser.isValidField(splittedData[3])) {
                                    dedAdd1.append(splittedData[3]);
                                    isDedComma = true;
                                }
                                if (Form16AParser.isValidField(splittedData[4])) {
                                    if (isDedComma) {
                                        dedAdd1.append(", ");
                                    }
                                    dedAdd1.append(splittedData[4]);
                                    isDedComma = true;
                                }
                                if (Form16AParser.isValidField(splittedData[5])) {
                                    if (isDedComma) {
                                        dedAdd1.append(", ");
                                    }
                                    dedAdd1.append(splittedData[5]);
                                    isDedComma = true;
                                }
                                boolean isDedComma2 = false;
                                if (Form16AParser.isValidField(splittedData[6])) {
                                    if (isDedComma) {
                                        dedAdd1.append(", ");
                                    }
                                    dedAdd2.append(splittedData[6]);
                                    isDedComma2 = true;
                                }
                                if (Form16AParser.isValidField(splittedData[7])) {
                                    if (isDedComma2) {
                                        dedAdd2.append(", ");
                                    } else if (isDedComma) {
                                        dedAdd1.append(", ");
                                    }
                                    dedAdd2.append(splittedData[7]);
                                    isDedComma2 = true;
                                }
                                form16ABean[0] = Form16ABean.deducteeDetails(form16ABean[0], splittedData[1], splittedData[2], dedAdd1.toString(), dedAdd2.toString(), splittedData[28], splittedData[29], wordsTotalAmtDeposited, wordsTotalAmtDeducted, splittedData[30]);
                                isDeducteeDetail = true;
                            }
                            if (splittedData[10] != null && !"".equalsIgnoreCase(splittedData[10])) {
                                paymentDate = Form16AParser.getPatternDate(splittedData[10]);
                            }
                            referenceNo = splittedData.length == 32 && splittedData[31] != null ? splittedData[31] : "";
                            if (paymentSumDataList != null) {
                                paymentSumDataList.add(new Object[]{BigDecimal.valueOf(Double.parseDouble(splittedData[8])).setScale(bigDecimalScale), splittedData[9], paymentDate, splittedData[11], referenceNo});
                            } else {
                                paymentSumDataList = new ArrayList<Object[]>();
                                paymentSumDataList.add(new Object[]{BigDecimal.valueOf(Double.parseDouble(splittedData[8])).setScale(bigDecimalScale), splittedData[9], paymentDate, splittedData[11], referenceNo});
                            }
                            if (!isTaxDedSummary) {
                                if (taxDedDataList != null) {
                                    taxDedDataList.add(new Object[]{periodicity, splittedData[15], BigDecimal.valueOf(Double.parseDouble(splittedData[12])).setScale(bigDecimalScale), BigDecimal.valueOf(Double.parseDouble(splittedData[13])).setScale(bigDecimalScale)});
                                } else {
                                    taxDedDataList = new ArrayList<Object[]>();
                                    taxDedDataList.add(new Object[]{periodicity, splittedData[15], BigDecimal.valueOf(Double.parseDouble(splittedData[12])).setScale(bigDecimalScale), BigDecimal.valueOf(Double.parseDouble(splittedData[13])).setScale(bigDecimalScale)});
                                }
                                isTaxDedSummary = true;
                            }
                            if (splittedData[27].equalsIgnoreCase("Y")) {
                                if (binDedDataList != null) {
                                    taxDepDate = "";
                                    if (Form16AParser.isValidField(splittedData[20])) {
                                        taxDepDate = Form16AParser.getPatternDate(splittedData[20]);
                                    }
                                    if (splittedData[17].equalsIgnoreCase("") || splittedData[17] == null) {
                                        splittedData[17] = "0.00";
                                    }
                                    binDedDataList.add(new Object[]{BigDecimal.valueOf(Double.parseDouble(splittedData[17])).setScale(bigDecimalScale), splittedData[18], splittedData[19], taxDepDate, splittedData[21]});
                                } else {
                                    binDedDataList = new ArrayList<Object[]>();
                                    taxDepDate = "";
                                    if (Form16AParser.isValidField(splittedData[20])) {
                                        taxDepDate = Form16AParser.getPatternDate(splittedData[20]);
                                    }
                                    if (splittedData[17].equalsIgnoreCase("") || splittedData[17] == null) {
                                        splittedData[17] = "0.00";
                                    }
                                    binDedDataList.add(new Object[]{BigDecimal.valueOf(Double.parseDouble(splittedData[17])).setScale(bigDecimalScale), splittedData[18], splittedData[19], taxDepDate, splittedData[21]});
                                }
                            } else if (splittedData[27].equalsIgnoreCase("N")) {
                                if (cinDedDataList != null) {
                                    taxDepDate = "";
                                    taxDepDate = Form16AParser.isValidField(splittedData[25]) ? Form16AParser.getPatternDate(splittedData[25]) : "-";
                                    if (splittedData[22].equalsIgnoreCase("") || splittedData[22] == null) {
                                        splittedData[22] = "0.00";
                                    }
                                    if ((double)Float.parseFloat(splittedData[22]) == 0.0) {
                                        splittedData[23] = "-";
                                        splittedData[24] = "-";
                                    }
                                    cinDedDataList.add(new Object[]{BigDecimal.valueOf(Double.parseDouble(splittedData[22])).setScale(bigDecimalScale), splittedData[23], taxDepDate, splittedData[24], splittedData[26], paymentDate});
                                } else {
                                    cinDedDataList = new ArrayList<Object[]>();
                                    taxDepDate = "";
                                    taxDepDate = Form16AParser.isValidField(splittedData[25]) ? Form16AParser.getPatternDate(splittedData[25]) : "-";
                                    if (splittedData[22].equalsIgnoreCase("") || splittedData[22] == null) {
                                        splittedData[22] = "0.00";
                                    }
                                    if ((double)Float.parseFloat(splittedData[22]) == 0.0) {
                                        splittedData[23] = "-";
                                        splittedData[24] = "-";
                                    }
                                    cinDedDataList.add(new Object[]{BigDecimal.valueOf(Double.parseDouble(splittedData[22])).setScale(bigDecimalScale), splittedData[23], taxDepDate, splittedData[24], splittedData[26], paymentDate});
                                }
                            }
                            Collections.sort(paymentSumDataList, new DateFieldComparator());
                            if (binDedDataList != null) {
                                Collections.sort(binDedDataList, new BINDateComparator());
                            }
                            if (cinDedDataList != null) {
                                Collections.sort(cinDedDataList, new CINDateComparator());
                            }
                            if (paymentSumDataList != null) {
                                Object[][] paymentSumDedData = new Object[paymentSumDataList.size()][];
                                int p2 = 0;
                                while (p2 < paymentSumDataList.size()) {
                                    paymentSumDedData[p2] = (Object[])paymentSumDataList.get(p2);
                                    ++p2;
                                }
                                paymentSumTableModel = new DefaultTableModel(paymentSumDedData, paymentSummColumnNames);
                                if (form16ABean[0] == null) {
                                    form16ABean[0] = new Form16ABean();
                                }
                                form16ABean[0] = Form16ABean.paymentSummary(form16ABean[0], paymentSumTableModel);
                            }
                            if (taxDedDataList != null) {
                                Object[][] taxDedData = new Object[taxDedDataList.size()][];
                                int l2 = 0;
                                while (l2 < taxDedDataList.size()) {
                                    taxDedData[l2] = (Object[])taxDedDataList.get(l2);
                                    ++l2;
                                }
                                taxDedTableModel = new DefaultTableModel(taxDedData, taxDedColumnNames);
                                if (form16ABean[0] == null) {
                                    form16ABean[0] = new Form16ABean();
                                }
                                form16ABean[0] = Form16ABean.deductedTax(form16ABean[0], taxDedTableModel);
                            }
                            if (binDedDataList != null) {
                                Object[][] binDedData = new Object[binDedDataList.size()][];
                                int j2 = 0;
                                while (j2 < binDedDataList.size()) {
                                    binDedData[j2] = (Object[])binDedDataList.get(j2);
                                    ++j2;
                                }
                                binDedTableModel = new DefaultTableModel(binDedData, binDedColumnNames);
                                if (form16ABean[0] == null) {
                                    form16ABean[0] = new Form16ABean();
                                }
                                form16ABean[0] = Form16ABean.deductedTax_BIN(form16ABean[0], binDedTableModel);
                            }
                            if (cinDedDataList != null) {
                                Object[][] cinDedData = new Object[cinDedDataList.size()][];
                                int k2 = 0;
                                while (k2 < cinDedDataList.size()) {
                                    cinDedData[k2] = (Object[])cinDedDataList.get(k2);
                                    ++k2;
                                }
                                cinDedTableModel = new DefaultTableModel(cinDedData, cinDedColumnNames);
                                if (form16ABean[0] == null) {
                                    form16ABean[0] = new Form16ABean();
                                }
                                form16ABean[0] = Form16ABean.deductedTax_CIN(form16ABean[0], cinDedTableModel);
                            }
                            ++num;
                        }
                    }
                }
                ++count;
            }
            Form16ABean[] form16ABeanArray = form16ABean;
            return form16ABeanArray;
        }
        catch (ParseException pe) {
            throw new PDFCreationException("Error while converting date into other format");
        }
        finally {
            paymentSumTableModel = null;
            taxDedTableModel = null;
            binDedTableModel = null;
            cinDedTableModel = null;
            paymentSumDataList = null;
            taxDedDataList = null;
            binDedDataList = null;
            cinDedDataList = null;
            paymentSummColumnNames = null;
            taxDedColumnNames = null;
            binDedColumnNames = null;
            cinDedColumnNames = null;
            periodicity = null;
            deducteePAN = null;
            assessmentYear = null;
            assYearRange = null;
            dataPANMap = null;
            newLineString = null;
            dataArray = null;
            inputLineStr = null;
            rowsData = null;
            periodFrom = null;
            periodTo = null;
            fromPeriod = null;
            toPeriod = null;
            nextAssYear = null;
            addressPart1 = null;
            addressPart2 = null;
            telNumber = null;
            splitSummary = null;
            wordsTotalAmtDeposited = null;
            wordsTotalAmtDeducted = null;
            dedAdd1 = null;
            dedAdd2 = null;
            paymentDate = null;
            referenceNo = null;
        }
    }

    private static String getPatternDate(String orginalFormatDate) {
        String convertedDate = "";
        String[] splitDate = orginalFormatDate.split("-");
        int days = Integer.parseInt(splitDate[2]);
        int month = Integer.parseInt(splitDate[1]) - 1;
        int year = Integer.parseInt(splitDate[0]);
        GregorianCalendar dateConverted = new GregorianCalendar(year, month, days);
        SimpleDateFormat fmt = new SimpleDateFormat("dd-MM-yyyy");
        fmt.setCalendar(dateConverted);
        convertedDate = fmt.format(dateConverted.getTime());
        return convertedDate;
    }

    private static boolean isValidField(String field) {
        boolean isValidField = false;
        if (field != null && !field.trim().isEmpty() && !field.trim().equals("-")) {
            isValidField = true;
        }
        return isValidField;
    }

    private static String trimComma(String field) {
        String trimmedField = null;
        if (field.endsWith(",")) {
            trimmedField = field.substring(0, field.length() - 1);
        }
        if (trimmedField != null) {
            return trimmedField;
        }
        return field;
    }
}

