/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.awt.geom.Rectangle2D;
import net.sf.jasperreports.charts.ChartTheme;
import net.sf.jasperreports.charts.util.ChartUtil;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.convert.ConvertChartContext;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import org.jfree.chart.JFreeChart;

public final class ChartConverter
extends ElementConverter {
    private static final ChartConverter INSTANCE = new ChartConverter();

    private ChartConverter() {
    }

    public static ChartConverter getInstance() {
        return INSTANCE;
    }

    @Override
    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRBasePrintImage printImage = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
        JRChart chart = (JRChart)element;
        this.copyElement(reportConverter, chart, printImage);
        printImage.copyBox(chart.getLineBox());
        printImage.setAnchorName(JRExpressionUtil.getExpressionText(chart.getAnchorNameExpression()));
        printImage.setBookmarkLevel(chart.getBookmarkLevel());
        printImage.setLinkType(chart.getLinkType());
        printImage.setOnErrorType(OnErrorTypeEnum.ICON);
        printImage.setRenderable(this.getRenderer(reportConverter, chart));
        printImage.setScaleImage(ScaleImageEnum.CLIP);
        return printImage;
    }

    private Renderable getRenderer(ReportConverter reportConverter, JRChart chart) {
        String themeName;
        String renderType = chart.getRenderType();
        if (renderType == null) {
            renderType = JRPropertiesUtil.getInstance(reportConverter.getJasperReportsContext()).getProperty(reportConverter.getReport(), "net.sf.jasperreports.chart.render.type");
        }
        if ((themeName = chart.getTheme()) == null) {
            themeName = JRPropertiesUtil.getInstance(reportConverter.getJasperReportsContext()).getProperty(reportConverter.getReport(), "net.sf.jasperreports.chart.theme");
        }
        ChartTheme theme = ChartUtil.getInstance(reportConverter.getJasperReportsContext()).getTheme(themeName);
        ConvertChartContext chartContext = new ConvertChartContext(chart);
        JFreeChart jfreeChart = null;
        try {
            jfreeChart = theme.createChart(chartContext);
        }
        catch (JRException e2) {
            throw new JRRuntimeException(e2);
        }
        Rectangle2D.Double rectangle = new Rectangle2D.Double(0.0, 0.0, chart.getWidth(), chart.getHeight());
        return ChartUtil.getInstance(reportConverter.getJasperReportsContext()).getChartRenderableFactory(renderType).getRenderable(reportConverter.getJasperReportsContext(), jfreeChart, null, rectangle);
    }
}

