/*
 * Decompiled with CFR 0.152.
 */
package javax.ejb.deployment;

import java.io.Serializable;
import java.lang.reflect.Method;

class SerializableMethod
implements Serializable {
    private Class cls;
    private String methodSignature;

    SerializableMethod(Method method) {
        if (method != null) {
            this.cls = method.getDeclaringClass();
            this.methodSignature = this.getSignature(method);
        }
    }

    Method getMethod() throws NoSuchMethodException {
        if (this.cls == null) {
            return null;
        }
        Method[] methodArray = this.cls.getMethods();
        int n2 = 0;
        while (n2 < methodArray.length) {
            if (this.getSignature(methodArray[n2]).equals(this.methodSignature)) {
                return methodArray[n2];
            }
            ++n2;
        }
        throw new NoSuchMethodException(String.valueOf(this.cls.getName()) + "(" + this.methodSignature + ")");
    }

    private String getSignature(Method method) {
        String string = method.getName();
        string = String.valueOf(string) + "(";
        Class<?>[] classArray = method.getParameterTypes();
        int n2 = 0;
        while (n2 < classArray.length) {
            string = String.valueOf(string) + classArray[n2].getName();
            if (n2 < classArray.length - 1) {
                string = String.valueOf(string) + ",";
            }
            ++n2;
        }
        string = String.valueOf(string) + ")";
        return string;
    }
}

