/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.util.Map;
import net.sf.jasperreports.compilers.JavaScriptCompiler;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptEvaluatorScope {
    protected static final String EVALUATOR_VAR = "_jreval";
    private Context context;
    private ScriptableObject scope;

    public JavaScriptEvaluatorScope(Context context, JREvaluator evaluator) {
        this.context = context;
        this.scope = context.initStandardObjects();
        this.scope.put(EVALUATOR_VAR, (Scriptable)this.scope, (Object)evaluator);
    }

    public void init(Map<String, JRFillParameter> parametersMap, Map<String, JRFillField> fieldsMap, Map<String, JRFillVariable> variablesMap) {
        String name;
        for (Map.Entry<String, JRFillParameter> entry : parametersMap.entrySet()) {
            name = entry.getKey();
            JRFillParameter param = entry.getValue();
            JSParameter jsParam = new JSParameter(param, this.scope);
            this.scope.put(JavaScriptCompiler.getParameterVar(name), (Scriptable)this.scope, (Object)jsParam);
        }
        for (Map.Entry<String, JRCloneable> entry : variablesMap.entrySet()) {
            name = entry.getKey();
            JRFillVariable var = (JRFillVariable)entry.getValue();
            JSVariable jsVar = new JSVariable(var, this.scope);
            this.scope.put(JavaScriptCompiler.getVariableVar(name), (Scriptable)this.scope, (Object)jsVar);
        }
        if (fieldsMap != null) {
            for (Map.Entry<String, JRCloneable> entry : fieldsMap.entrySet()) {
                name = entry.getKey();
                JRFillField field = (JRFillField)entry.getValue();
                JSField jsField = new JSField(field, this.scope);
                this.scope.put(JavaScriptCompiler.getFieldVar(name), (Scriptable)this.scope, (Object)jsField);
            }
        }
    }

    public Object evaluateExpression(Script expression) {
        Object javaValue;
        Object value = expression.exec(this.context, (Scriptable)this.scope);
        if (value == null || value instanceof Number) {
            javaValue = value;
        } else {
            try {
                javaValue = Context.jsToJava((Object)value, Object.class);
            }
            catch (EvaluatorException e2) {
                throw new JRRuntimeException(e2);
            }
        }
        return javaValue;
    }

    public void setScopeVariable(String name, Object value) {
        this.scope.put(name, (Scriptable)this.scope, value);
    }

    public static class JSVariable
    extends JSValue {
        private final JRFillVariable variable;

        public JSVariable(JRFillVariable variable, ScriptableObject scope) {
            super(scope);
            this.variable = variable;
        }

        public Object getValue() {
            return this.toJSValue(this.variable.getValue());
        }

        public Object getOldValue() {
            return this.toJSValue(this.variable.getOldValue());
        }

        public Object getEstimatedValue() {
            return this.toJSValue(this.variable.getEstimatedValue());
        }
    }

    public static class JSField
    extends JSValue {
        private final JRFillField field;

        public JSField(JRFillField field, ScriptableObject scope) {
            super(scope);
            this.field = field;
        }

        public Object getValue() {
            return this.toJSValue(this.field.getValue());
        }

        public Object getOldValue() {
            return this.toJSValue(this.field.getOldValue());
        }
    }

    public static class JSParameter
    extends JSValue {
        private final JRFillParameter parameter;

        public JSParameter(JRFillParameter parameter, ScriptableObject scope) {
            super(scope);
            this.parameter = parameter;
        }

        public Object getValue() {
            return this.toJSValue(this.parameter.getValue());
        }
    }

    public static abstract class JSValue {
        private final ScriptableObject scope;

        protected JSValue(ScriptableObject scope) {
            this.scope = scope;
        }

        protected final Object toJSValue(Object value) {
            return Context.javaToJS((Object)value, (Scriptable)this.scope);
        }
    }
}

