/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRAbstractTextDataSource;
import net.sf.jasperreports.engine.util.FormatUtils;
import net.sf.jasperreports.repo.RepositoryUtil;

public class JRXlsDataSource
extends JRAbstractTextDataSource
implements JRRewindableDataSource {
    private Workbook workbook;
    private DateFormat dateFormat = new SimpleDateFormat();
    private NumberFormat numberFormat = new DecimalFormat();
    private Map<String, Integer> columnNames = new LinkedHashMap<String, Integer>();
    private boolean useFirstRowAsHeader;
    private int recordIndex = -1;
    private InputStream inputStream;
    private boolean closeWorkbook;
    private boolean closeInputStream;

    public JRXlsDataSource(Workbook workbook) {
        this.workbook = workbook;
        this.closeWorkbook = false;
    }

    public JRXlsDataSource(InputStream is) throws JRException, IOException {
        try {
            this.inputStream = is;
            this.workbook = Workbook.getWorkbook((InputStream)is);
            this.closeWorkbook = true;
            this.closeInputStream = false;
        }
        catch (BiffException e2) {
            throw new JRException(e2);
        }
    }

    public JRXlsDataSource(File file) throws JRException, FileNotFoundException, IOException {
        this(new FileInputStream(file));
        this.closeInputStream = true;
    }

    public JRXlsDataSource(JasperReportsContext jasperReportsContext, String location) throws JRException, IOException {
        this(RepositoryUtil.getInstance(jasperReportsContext).getInputStreamFromLocation(location));
        this.closeInputStream = true;
    }

    public JRXlsDataSource(String location) throws JRException, IOException {
        this(DefaultJasperReportsContext.getInstance(), location);
    }

    @Override
    public boolean next() throws JRException {
        ++this.recordIndex;
        if (this.workbook != null) {
            if (this.recordIndex == 0 && this.useFirstRowAsHeader) {
                this.readHeader();
                ++this.recordIndex;
            }
            if (this.recordIndex < this.workbook.getSheet(0).getRows()) {
                return true;
            }
            if (this.closeWorkbook) {
                this.workbook.close();
            }
        }
        return false;
    }

    @Override
    public void moveFirst() {
        this.recordIndex = -1;
    }

    @Override
    public Object getFieldValue(JRField jrField) throws JRException {
        String fieldName = jrField.getName();
        Integer columnIndex = this.columnNames.get(fieldName);
        if (columnIndex == null && fieldName.startsWith("COLUMN_")) {
            columnIndex = Integer.valueOf(fieldName.substring(7));
        }
        if (columnIndex == null) {
            throw new JRException("Unknown column name : " + fieldName);
        }
        Sheet sheet = this.workbook.getSheet(0);
        Cell cell = sheet.getCell(columnIndex.intValue(), this.recordIndex);
        String fieldValue = cell.getContents();
        Class<?> valueClass = jrField.getValueClass();
        if (valueClass.equals(String.class)) {
            return fieldValue;
        }
        if ((fieldValue = fieldValue.trim()).length() == 0) {
            return null;
        }
        try {
            if (valueClass.equals(Boolean.class)) {
                return fieldValue.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
            }
            if (Number.class.isAssignableFrom(valueClass)) {
                if (this.numberFormat != null) {
                    return FormatUtils.getFormattedNumber(this.numberFormat, fieldValue, valueClass);
                }
                return this.convertStringValue(fieldValue, valueClass);
            }
            if (Date.class.isAssignableFrom(valueClass)) {
                if (this.dateFormat != null) {
                    return FormatUtils.getFormattedDate(this.dateFormat, fieldValue, valueClass);
                }
                return this.convertStringValue(fieldValue, valueClass);
            }
            throw new JRException("Field '" + jrField.getName() + "' is of class '" + valueClass.getName() + "' and can not be converted");
        }
        catch (Exception e2) {
            throw new JRException("Unable to get value for field '" + jrField.getName() + "' of class '" + valueClass.getName() + "'", e2);
        }
    }

    private void readHeader() {
        Sheet sheet = this.workbook.getSheet(0);
        if (this.columnNames.size() == 0) {
            for (int columnIndex = 0; columnIndex < sheet.getColumns(); ++columnIndex) {
                Cell cell = sheet.getCell(columnIndex, this.recordIndex);
                String columnName = cell.getContents();
                if (columnName == null || columnName.trim().length() <= 0) continue;
                this.columnNames.put(columnName, columnIndex);
            }
        } else {
            LinkedHashMap<String, Integer> newColumnNames = new LinkedHashMap<String, Integer>();
            for (Integer columnIndex : this.columnNames.values()) {
                Cell cell = sheet.getCell(columnIndex.intValue(), this.recordIndex);
                String columnName = cell.getContents();
                newColumnNames.put(columnName, columnIndex);
            }
            this.columnNames = newColumnNames;
        }
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.checkReadStarted();
        this.dateFormat = dateFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.checkReadStarted();
        this.numberFormat = numberFormat;
    }

    public void setColumnNames(String[] columnNames) {
        this.checkReadStarted();
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            this.columnNames.put(columnNames[i2], i2);
        }
    }

    public void setColumnNames(String[] columnNames, int[] columnIndexes) {
        this.checkReadStarted();
        if (columnNames.length != columnIndexes.length) {
            throw new JRRuntimeException("The number of column names must be equal to the number of column indexes.");
        }
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            this.columnNames.put(columnNames[i2], columnIndexes[i2]);
        }
    }

    public void setColumnIndexes(Integer[] columnIndexes) {
        this.checkReadStarted();
        for (int i2 = 0; i2 < columnIndexes.length; ++i2) {
            this.columnNames.put("COLUMN_" + i2, columnIndexes[i2]);
        }
    }

    public void setUseFirstRowAsHeader(boolean useFirstRowAsHeader) {
        this.checkReadStarted();
        this.useFirstRowAsHeader = useFirstRowAsHeader;
    }

    public void close() {
        try {
            if (this.closeInputStream) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkReadStarted() {
        if (this.recordIndex > 0) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started.");
        }
    }

    public Map<String, Integer> getColumnNames() {
        return this.columnNames;
    }
}

