/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public class DERNumericString
extends ASN1Object
implements DERString {
    String string;

    public static DERNumericString getInstance(Object object) {
        if (object == null || object instanceof DERNumericString) {
            return (DERNumericString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERNumericString(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERNumericString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERNumericString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERNumericString.getInstance(aSN1TaggedObject.getObject());
    }

    public DERNumericString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i2 = 0; i2 != cArray.length; ++i2) {
            cArray[i2] = (char)(byArray[i2] & 0xFF);
        }
        this.string = new String(cArray);
    }

    public DERNumericString(String string) {
        this(string, false);
    }

    public DERNumericString(String string, boolean bl) {
        if (bl && !DERNumericString.isNumericString(string)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public String toString() {
        return this.string;
    }

    public byte[] getOctets() {
        char[] cArray = this.string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i2 = 0; i2 != cArray.length; ++i2) {
            byArray[i2] = (byte)cArray[i2];
        }
        return byArray;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(18, this.getOctets());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERNumericString)) {
            return false;
        }
        DERNumericString dERNumericString = (DERNumericString)dERObject;
        return this.getString().equals(dERNumericString.getString());
    }

    public static boolean isNumericString(String string) {
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            char c2 = string.charAt(i2);
            if (c2 > '\u007f') {
                return false;
            }
            if ('0' <= c2 && c2 <= '9' || c2 == ' ') continue;
            return false;
        }
        return true;
    }
}

