/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.MultiBlockCipher;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.StreamCipher;

public class DefaultBufferedBlockCipher
extends BufferedBlockCipher {
    protected byte[] buf;
    protected int bufOff;
    protected boolean forEncryption;
    protected BlockCipher cipher;
    protected MultiBlockCipher mbCipher;
    protected boolean partialBlockOkay;
    protected boolean pgpCFB;

    protected DefaultBufferedBlockCipher() {
    }

    public DefaultBufferedBlockCipher(BlockCipher cipher) {
        this.cipher = cipher;
        if (cipher instanceof MultiBlockCipher) {
            this.mbCipher = (MultiBlockCipher)cipher;
            this.buf = new byte[this.mbCipher.getMultiBlockSize()];
        } else {
            this.mbCipher = null;
            this.buf = new byte[cipher.getBlockSize()];
        }
        this.bufOff = 0;
        String name = cipher.getAlgorithmName();
        int idx = name.indexOf(47) + 1;
        boolean bl = this.pgpCFB = idx > 0 && name.startsWith("PGP", idx);
        this.partialBlockOkay = this.pgpCFB || cipher instanceof StreamCipher ? true : idx > 0 && name.startsWith("OpenPGP", idx);
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.forEncryption = forEncryption;
        this.reset();
        this.cipher.init(forEncryption, params);
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int getUpdateOutputSize(int len) {
        int total = len + this.bufOff;
        int leftOver = this.pgpCFB ? (this.forEncryption ? total % this.buf.length - (this.cipher.getBlockSize() + 2) : total % this.buf.length) : total % this.buf.length;
        return total - leftOver;
    }

    @Override
    public int getOutputSize(int length) {
        if (this.pgpCFB && this.forEncryption) {
            return length + this.bufOff + (this.cipher.getBlockSize() + 2);
        }
        return length + this.bufOff;
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        int resultLen = 0;
        this.buf[this.bufOff++] = in;
        if (this.bufOff == this.buf.length) {
            resultLen = this.cipher.processBlock(this.buf, 0, out, outOff);
            this.bufOff = 0;
        }
        return resultLen;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        block7: {
            if (len < 0) {
                throw new IllegalArgumentException("Can't have a negative input length!");
            }
            blockSize = this.getBlockSize();
            length = this.getUpdateOutputSize(len);
            if (length > 0 && outOff + length > out.length) {
                throw new OutputLengthException("output buffer too short");
            }
            resultLen = 0;
            gapLen = this.buf.length - this.bufOff;
            if (len <= gapLen) break block7;
            System.arraycopy(in, inOff, this.buf, this.bufOff, gapLen);
            resultLen += this.cipher.processBlock(this.buf, 0, out, outOff);
            this.bufOff = 0;
            len -= gapLen;
            inOff += gapLen;
            if (this.mbCipher == null) ** GOTO lbl26
            blockCount = len / this.mbCipher.getMultiBlockSize();
            if (blockCount <= 0) break block7;
            resultLen += this.mbCipher.processBlocks(in, inOff, blockCount, out, outOff + resultLen);
            processed = blockCount * this.mbCipher.getMultiBlockSize();
            len -= processed;
            inOff += processed;
            break block7;
lbl-1000:
            // 1 sources

            {
                resultLen += this.cipher.processBlock(in, inOff, out, outOff + resultLen);
                len -= blockSize;
                inOff += blockSize;
lbl26:
                // 2 sources

                ** while (len > this.buf.length)
            }
        }
        System.arraycopy(in, inOff, this.buf, this.bufOff, len);
        this.bufOff += len;
        if (this.bufOff == this.buf.length) {
            resultLen += this.cipher.processBlock(this.buf, 0, out, outOff + resultLen);
            this.bufOff = 0;
        }
        return resultLen;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException, InvalidCipherTextException {
        try {
            int resultLen = 0;
            if (outOff + this.bufOff > out.length) {
                throw new OutputLengthException("output buffer too short for doFinal()");
            }
            if (this.bufOff != 0) {
                if (!this.partialBlockOkay) {
                    throw new DataLengthException("data not block size aligned");
                }
                this.cipher.processBlock(this.buf, 0, this.buf, 0);
                resultLen = this.bufOff;
                this.bufOff = 0;
                System.arraycopy(this.buf, 0, out, outOff, resultLen);
            }
            int n = resultLen;
            return n;
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void reset() {
        int i = 0;
        while (i < this.buf.length) {
            this.buf[i] = 0;
            ++i;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

