/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.agreement.ecjpake;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.agreement.ecjpake.ECSchnorrZKP;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Strings;

public class ECJPAKEUtil {
    static final BigInteger ZERO = BigInteger.valueOf(0L);
    static final BigInteger ONE = BigInteger.valueOf(1L);

    public static BigInteger generateX1(BigInteger n, SecureRandom random) {
        BigInteger min = ONE;
        BigInteger max = n.subtract(ONE);
        return BigIntegers.createRandomInRange(min, max, random);
    }

    public static BigInteger calculateS(BigInteger n, byte[] password) throws CryptoException {
        BigInteger s = new BigInteger(1, password).mod(n);
        if (s.signum() == 0) {
            throw new CryptoException("MUST ensure s is not equal to 0 modulo n");
        }
        return s;
    }

    public static BigInteger calculateS(BigInteger n, char[] password) throws CryptoException {
        return ECJPAKEUtil.calculateS(n, Strings.toUTF8ByteArray(password));
    }

    public static ECPoint calculateGx(ECPoint g, BigInteger x) {
        return g.multiply(x);
    }

    public static ECPoint calculateGA(ECPoint gx1, ECPoint gx3, ECPoint gx4) {
        return gx1.add(gx3).add(gx4);
    }

    public static BigInteger calculateX2s(BigInteger n, BigInteger x2, BigInteger s) {
        return x2.multiply(s).mod(n);
    }

    public static ECPoint calculateA(ECPoint gA, BigInteger x2s) {
        return gA.multiply(x2s);
    }

    public static ECSchnorrZKP calculateZeroKnowledgeProof(ECPoint generator, BigInteger n, BigInteger x, ECPoint X, Digest digest, String userID, SecureRandom random) {
        BigInteger v = BigIntegers.createRandomInRange(BigInteger.ONE, n.subtract(BigInteger.ONE), random);
        ECPoint V = generator.multiply(v);
        BigInteger h = ECJPAKEUtil.calculateHashForZeroKnowledgeProof(generator, V, X, userID, digest);
        return new ECSchnorrZKP(V, v.subtract(x.multiply(h)).mod(n));
    }

    private static BigInteger calculateHashForZeroKnowledgeProof(ECPoint g, ECPoint v, ECPoint x, String participantId, Digest digest) {
        digest.reset();
        ECJPAKEUtil.updateDigestIncludingSize(digest, g);
        ECJPAKEUtil.updateDigestIncludingSize(digest, v);
        ECJPAKEUtil.updateDigestIncludingSize(digest, x);
        ECJPAKEUtil.updateDigestIncludingSize(digest, participantId);
        byte[] output = new byte[digest.getDigestSize()];
        digest.doFinal(output, 0);
        return new BigInteger(output);
    }

    private static void updateDigestIncludingSize(Digest digest, ECPoint ecPoint) {
        byte[] byteArray = ecPoint.getEncoded(true);
        digest.update(ECJPAKEUtil.intToByteArray(byteArray.length), 0, 4);
        digest.update(byteArray, 0, byteArray.length);
        Arrays.fill(byteArray, (byte)0);
    }

    private static void updateDigestIncludingSize(Digest digest, String string) {
        byte[] byteArray = Strings.toUTF8ByteArray(string);
        digest.update(ECJPAKEUtil.intToByteArray(byteArray.length), 0, 4);
        digest.update(byteArray, 0, byteArray.length);
        Arrays.fill(byteArray, (byte)0);
    }

    public static void validateZeroKnowledgeProof(ECPoint generator, ECPoint X, ECSchnorrZKP zkp, BigInteger q, BigInteger n, ECCurve curve, BigInteger coFactor, String userID, Digest digest) throws CryptoException {
        ECPoint V = zkp.getV();
        BigInteger r = zkp.getr();
        BigInteger h = ECJPAKEUtil.calculateHashForZeroKnowledgeProof(generator, V, X, userID, digest);
        if (X.isInfinity()) {
            throw new CryptoException("Zero-knowledge proof validation failed: X cannot equal infinity");
        }
        ECPoint x_normalized = X.normalize();
        if (x_normalized.getAffineXCoord().toBigInteger().compareTo(BigInteger.ZERO) == -1 || x_normalized.getAffineXCoord().toBigInteger().compareTo(q.subtract(BigInteger.ONE)) == 1 || x_normalized.getAffineYCoord().toBigInteger().compareTo(BigInteger.ZERO) == -1 || x_normalized.getAffineYCoord().toBigInteger().compareTo(q.subtract(BigInteger.ONE)) == 1) {
            throw new CryptoException("Zero-knowledge proof validation failed: x and y are not in the field");
        }
        try {
            curve.decodePoint(X.getEncoded(true));
        }
        catch (Exception e) {
            throw new CryptoException("Zero-knowledge proof validation failed: x does not lie on the curve", e);
        }
        if (X.multiply(coFactor).isInfinity()) {
            throw new CryptoException("Zero-knowledge proof validation failed: Nx cannot be infinity");
        }
        if (!V.equals(generator.multiply(r).add(X.multiply(h.mod(n))))) {
            throw new CryptoException("Zero-knowledge proof validation failed: V must be a point on the curve");
        }
    }

    public static void validateParticipantIdsDiffer(String participantId1, String participantId2) throws CryptoException {
        if (participantId1.equals(participantId2)) {
            throw new CryptoException("Both participants are using the same participantId (" + participantId1 + "). This is not allowed. " + "Each participant must use a unique participantId.");
        }
    }

    public static void validateParticipantIdsEqual(String expectedParticipantId, String actualParticipantId) throws CryptoException {
        if (!expectedParticipantId.equals(actualParticipantId)) {
            throw new CryptoException("Received payload from incorrect partner (" + actualParticipantId + "). Expected to receive payload from " + expectedParticipantId + ".");
        }
    }

    public static void validateNotNull(Object object, String description) {
        if (object == null) {
            throw new NullPointerException(String.valueOf(description) + " must not be null");
        }
    }

    public static BigInteger calculateKeyingMaterial(BigInteger n, ECPoint gx4, BigInteger x2, BigInteger s, ECPoint B) {
        ECPoint k = B.subtract(gx4.multiply(x2.multiply(s).mod(n))).multiply(x2);
        k = k.normalize();
        return k.getAffineXCoord().toBigInteger();
    }

    public static BigInteger calculateMacTag(String participantId, String partnerParticipantId, ECPoint gx1, ECPoint gx2, ECPoint gx3, ECPoint gx4, BigInteger keyingMaterial, Digest digest) {
        byte[] macKey = ECJPAKEUtil.calculateMacKey(keyingMaterial, digest);
        HMac mac = new HMac(digest);
        byte[] macOutput = new byte[mac.getMacSize()];
        mac.init(new KeyParameter(macKey));
        ECJPAKEUtil.updateMac((Mac)mac, "KC_1_U");
        ECJPAKEUtil.updateMac((Mac)mac, participantId);
        ECJPAKEUtil.updateMac((Mac)mac, partnerParticipantId);
        ECJPAKEUtil.updateMac((Mac)mac, gx1);
        ECJPAKEUtil.updateMac((Mac)mac, gx2);
        ECJPAKEUtil.updateMac((Mac)mac, gx3);
        ECJPAKEUtil.updateMac((Mac)mac, gx4);
        mac.doFinal(macOutput, 0);
        Arrays.fill(macKey, (byte)0);
        return new BigInteger(macOutput);
    }

    private static byte[] calculateMacKey(BigInteger keyingMaterial, Digest digest) {
        digest.reset();
        ECJPAKEUtil.updateDigest(digest, keyingMaterial);
        ECJPAKEUtil.updateDigest(digest, "ECJPAKE_KC");
        byte[] output = new byte[digest.getDigestSize()];
        digest.doFinal(output, 0);
        return output;
    }

    public static void validateMacTag(String participantId, String partnerParticipantId, ECPoint gx1, ECPoint gx2, ECPoint gx3, ECPoint gx4, BigInteger keyingMaterial, Digest digest, BigInteger partnerMacTag) throws CryptoException {
        BigInteger expectedMacTag = ECJPAKEUtil.calculateMacTag(partnerParticipantId, participantId, gx3, gx4, gx1, gx2, keyingMaterial, digest);
        if (!expectedMacTag.equals(partnerMacTag)) {
            throw new CryptoException("Partner MacTag validation failed. Therefore, the password, MAC, or digest algorithm of each participant does not match.");
        }
    }

    private static void updateMac(Mac mac, ECPoint ecPoint) {
        byte[] byteArray = ecPoint.getEncoded(true);
        mac.update(byteArray, 0, byteArray.length);
        Arrays.fill(byteArray, (byte)0);
    }

    private static void updateMac(Mac mac, String string) {
        byte[] byteArray = Strings.toUTF8ByteArray(string);
        mac.update(byteArray, 0, byteArray.length);
        Arrays.fill(byteArray, (byte)0);
    }

    private static void updateDigest(Digest digest, ECPoint ecPoint) {
        byte[] byteArray = ecPoint.getEncoded(true);
        digest.update(byteArray, 0, byteArray.length);
        Arrays.fill(byteArray, (byte)0);
    }

    private static void updateDigest(Digest digest, String string) {
        byte[] byteArray = Strings.toUTF8ByteArray(string);
        digest.update(byteArray, 0, byteArray.length);
        Arrays.fill(byteArray, (byte)0);
    }

    private static void updateDigest(Digest digest, BigInteger bigInteger) {
        byte[] byteArray = BigIntegers.asUnsignedByteArray(bigInteger);
        digest.update(byteArray, 0, byteArray.length);
        Arrays.fill(byteArray, (byte)0);
    }

    private static byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }
}

