/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Bytes;

public class PhotonBeetleDigest
implements Digest {
    private byte[] state;
    private byte[][] state_2d;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final int INITIAL_RATE_INBYTES = 16;
    private int RATE_INBYTES = 4;
    private int SQUEEZE_RATE_INBYTES = 16;
    private int STATE_INBYTES = 32;
    private int TAG_INBYTES = 32;
    private int LAST_THREE_BITS_OFFSET = 5;
    private int ROUND = 12;
    private int D = 8;
    private int Dq = 3;
    private int Dr = 7;
    private int DSquare = 64;
    private int S = 4;
    private int S_1 = 3;
    private byte[][] RC;
    private byte[][] MixColMatrix;
    private byte[] sbox;

    public PhotonBeetleDigest() {
        byte[][] byArrayArray = new byte[8][];
        byArrayArray[0] = new byte[]{1, 3, 7, 14, 13, 11, 6, 12, 9, 2, 5, 10};
        byte[] byArray = new byte[12];
        byArray[1] = 2;
        byArray[2] = 6;
        byArray[3] = 15;
        byArray[4] = 12;
        byArray[5] = 10;
        byArray[6] = 7;
        byArray[7] = 13;
        byArray[8] = 8;
        byArray[9] = 3;
        byArray[10] = 4;
        byArray[11] = 11;
        byArrayArray[1] = byArray;
        byte[] byArray2 = new byte[12];
        byArray2[0] = 2;
        byArray2[2] = 4;
        byArray2[3] = 13;
        byArray2[4] = 14;
        byArray2[5] = 8;
        byArray2[6] = 5;
        byArray2[7] = 15;
        byArray2[8] = 10;
        byArray2[9] = 1;
        byArray2[10] = 6;
        byArray2[11] = 9;
        byArrayArray[2] = byArray2;
        byte[] byArray3 = new byte[12];
        byArray3[0] = 6;
        byArray3[1] = 4;
        byArray3[3] = 9;
        byArray3[4] = 10;
        byArray3[5] = 12;
        byArray3[6] = 1;
        byArray3[7] = 11;
        byArray3[8] = 14;
        byArray3[9] = 5;
        byArray3[10] = 2;
        byArray3[11] = 13;
        byArrayArray[3] = byArray3;
        byArrayArray[4] = new byte[]{14, 12, 8, 1, 2, 4, 9, 3, 6, 13, 10, 5};
        byte[] byArray4 = new byte[12];
        byArray4[0] = 15;
        byArray4[1] = 13;
        byArray4[2] = 9;
        byArray4[4] = 3;
        byArray4[5] = 5;
        byArray4[6] = 8;
        byArray4[7] = 2;
        byArray4[8] = 7;
        byArray4[9] = 12;
        byArray4[10] = 11;
        byArray4[11] = 4;
        byArrayArray[5] = byArray4;
        byte[] byArray5 = new byte[12];
        byArray5[0] = 13;
        byArray5[1] = 15;
        byArray5[2] = 11;
        byArray5[3] = 2;
        byArray5[4] = 1;
        byArray5[5] = 7;
        byArray5[6] = 10;
        byArray5[8] = 5;
        byArray5[9] = 14;
        byArray5[10] = 9;
        byArray5[11] = 6;
        byArrayArray[6] = byArray5;
        byArrayArray[7] = new byte[]{9, 11, 15, 6, 5, 3, 14, 4, 1, 10, 13, 2};
        this.RC = byArrayArray;
        this.MixColMatrix = new byte[][]{{2, 4, 2, 11, 2, 8, 5, 6}, {12, 9, 8, 13, 7, 7, 5, 2}, {4, 4, 13, 13, 9, 4, 13, 9}, {1, 6, 5, 1, 12, 13, 15, 14}, {15, 12, 9, 13, 14, 5, 14, 13}, {9, 14, 5, 15, 4, 12, 9, 6}, {12, 2, 2, 10, 3, 1, 1, 14}, {15, 1, 13, 10, 5, 10, 2, 3}};
        byte[] byArray6 = new byte[16];
        byArray6[0] = 12;
        byArray6[1] = 5;
        byArray6[2] = 6;
        byArray6[3] = 11;
        byArray6[4] = 9;
        byArray6[6] = 10;
        byArray6[7] = 13;
        byArray6[8] = 3;
        byArray6[9] = 14;
        byArray6[10] = 15;
        byArray6[11] = 8;
        byArray6[12] = 4;
        byArray6[13] = 7;
        byArray6[14] = 1;
        byArray6[15] = 2;
        this.sbox = byArray6;
        this.state = new byte[this.STATE_INBYTES];
        this.state_2d = new byte[this.D][this.D];
    }

    @Override
    public String getAlgorithmName() {
        return "Photon-Beetle Hash";
    }

    @Override
    public int getDigestSize() {
        return this.TAG_INBYTES;
    }

    @Override
    public void update(byte input) {
        this.buffer.write(input);
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.buffer.write(input, inOff, len);
    }

    @Override
    public int doFinal(byte[] output, int outOff) {
        if (32 + outOff > output.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        byte[] input = this.buffer.toByteArray();
        int inlen = input.length;
        if (inlen == 0) {
            int n = this.STATE_INBYTES - 1;
            this.state[n] = (byte)(this.state[n] ^ 1 << this.LAST_THREE_BITS_OFFSET);
        } else if (inlen <= 16) {
            System.arraycopy(input, 0, this.state, 0, inlen);
            if (inlen < 16) {
                int n = inlen;
                this.state[n] = (byte)(this.state[n] ^ 1);
            }
            int n = this.STATE_INBYTES - 1;
            this.state[n] = (byte)(this.state[n] ^ (inlen < 16 ? 1 : 2) << this.LAST_THREE_BITS_OFFSET);
        } else {
            System.arraycopy(input, 0, this.state, 0, 16);
            int Dlen_inblocks = ((inlen -= 16) + this.RATE_INBYTES - 1) / this.RATE_INBYTES;
            int i = 0;
            while (i < Dlen_inblocks - 1) {
                this.PHOTON_Permutation();
                Bytes.xorTo(this.RATE_INBYTES, input, 16 + i * this.RATE_INBYTES, this.state, 0);
                ++i;
            }
            this.PHOTON_Permutation();
            int LastDBlocklen = inlen - i * this.RATE_INBYTES;
            Bytes.xorTo(LastDBlocklen, input, 16 + i * this.RATE_INBYTES, this.state, 0);
            if (LastDBlocklen < this.RATE_INBYTES) {
                int n = LastDBlocklen;
                this.state[n] = (byte)(this.state[n] ^ 1);
            }
            int n = this.STATE_INBYTES - 1;
            this.state[n] = (byte)(this.state[n] ^ (inlen % this.RATE_INBYTES == 0 ? 1 : 2) << this.LAST_THREE_BITS_OFFSET);
        }
        this.PHOTON_Permutation();
        System.arraycopy(this.state, 0, output, outOff, this.SQUEEZE_RATE_INBYTES);
        this.PHOTON_Permutation();
        System.arraycopy(this.state, 0, output, outOff + this.SQUEEZE_RATE_INBYTES, this.TAG_INBYTES - this.SQUEEZE_RATE_INBYTES);
        this.reset();
        return this.TAG_INBYTES;
    }

    @Override
    public void reset() {
        this.buffer.reset();
        Arrays.fill(this.state, (byte)0);
    }

    void PHOTON_Permutation() {
        int i = 0;
        while (i < this.DSquare) {
            this.state_2d[i >>> this.Dq][i & this.Dr] = (byte)((this.state[i >> 1] & 0xFF) >>> 4 * (i & 1) & 0xF);
            ++i;
        }
        int round = 0;
        while (round < this.ROUND) {
            int j;
            i = 0;
            while (i < this.D) {
                byte[] byArray = this.state_2d[i];
                byArray[0] = (byte)(byArray[0] ^ this.RC[i][round]);
                ++i;
            }
            i = 0;
            while (i < this.D) {
                j = 0;
                while (j < this.D) {
                    this.state_2d[i][j] = this.sbox[this.state_2d[i][j]];
                    ++j;
                }
                ++i;
            }
            i = 1;
            while (i < this.D) {
                System.arraycopy(this.state_2d[i], 0, this.state, 0, this.D);
                System.arraycopy(this.state, i, this.state_2d[i], 0, this.D - i);
                System.arraycopy(this.state, 0, this.state_2d[i], this.D - i, i);
                ++i;
            }
            j = 0;
            while (j < this.D) {
                i = 0;
                while (i < this.D) {
                    int sum = 0;
                    int k = 0;
                    while (k < this.D) {
                        byte x = this.MixColMatrix[i][k];
                        byte b = this.state_2d[k][j];
                        sum ^= x * (b & 1);
                        sum ^= x * (b & 2);
                        sum ^= x * (b & 4);
                        sum ^= x * (b & 8);
                        ++k;
                    }
                    int t0 = sum >>> 4;
                    sum = sum & 0xF ^ t0 ^ t0 << 1;
                    int t1 = sum >>> 4;
                    sum = sum & 0xF ^ t1 ^ t1 << 1;
                    this.state[i] = (byte)sum;
                    ++i;
                }
                i = 0;
                while (i < this.D) {
                    this.state_2d[i][j] = this.state[i];
                    ++i;
                }
                ++j;
            }
            ++round;
        }
        i = 0;
        while (i < this.DSquare) {
            this.state[i >>> 1] = (byte)(this.state_2d[i >>> this.Dq][i & this.Dr] & 0xF | (this.state_2d[i >>> this.Dq][i + 1 & this.Dr] & 0xF) << 4);
            i += 2;
        }
    }
}

