/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.threshold;

import org.bouncycastle.crypto.threshold.PolynomialNative;
import org.bouncycastle.crypto.threshold.PolynomialTable;
import org.bouncycastle.crypto.threshold.ShamirSecretSplitter;

abstract class Polynomial {
    Polynomial() {
    }

    public static Polynomial newInstance(ShamirSecretSplitter.Algorithm algorithm, ShamirSecretSplitter.Mode mode) {
        if (mode == ShamirSecretSplitter.Mode.Native) {
            return new PolynomialNative(algorithm);
        }
        return new PolynomialTable(algorithm);
    }

    protected abstract byte gfMul(int var1, int var2);

    protected abstract byte gfDiv(int var1, int var2);

    protected byte gfPow(int n, byte k) {
        int result = 1;
        int i = 0;
        while (i < 8) {
            if ((k & 1 << i) != 0) {
                result = this.gfMul(result & 0xFF, n & 0xFF);
            }
            n = this.gfMul(n & 0xFF, n & 0xFF);
            ++i;
        }
        return (byte)result;
    }

    public byte[] gfVecMul(byte[] xs, byte[][] yss) {
        byte[] result = new byte[yss[0].length];
        int j = 0;
        while (j < yss[0].length) {
            int sum = 0;
            int k = 0;
            while (k < xs.length) {
                sum ^= this.gfMul(xs[k] & 0xFF, yss[k][j] & 0xFF);
                ++k;
            }
            result[j] = (byte)sum;
            ++j;
        }
        return result;
    }
}

