/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce;

import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.internal.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.CompositeIndex;
import org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.KeyFactorySpi;

public class CompositePublicKey
implements PublicKey {
    private final List<PublicKey> keys;
    private final ASN1ObjectIdentifier algorithmIdentifier;

    public CompositePublicKey(PublicKey ... keys) {
        this(MiscObjectIdentifiers.id_composite_key, keys);
    }

    public CompositePublicKey(ASN1ObjectIdentifier algorithmIdentifier, PublicKey ... keys) {
        this.algorithmIdentifier = algorithmIdentifier;
        if (keys == null || keys.length == 0) {
            throw new IllegalArgumentException("at least one public key must be provided for the composite public key");
        }
        ArrayList<PublicKey> keyList = new ArrayList<PublicKey>(keys.length);
        int i = 0;
        while (i < keys.length) {
            keyList.add(keys[i]);
            ++i;
        }
        this.keys = Collections.unmodifiableList(keyList);
    }

    public CompositePublicKey(SubjectPublicKeyInfo keyInfo) {
        ASN1ObjectIdentifier keyInfoIdentifier = keyInfo.getAlgorithm().getAlgorithm();
        CompositePublicKey publicKeyFromFactory = null;
        try {
            if (!CompositeIndex.isAlgorithmSupported(keyInfoIdentifier)) {
                throw new IllegalStateException("unable to create CompositePublicKey from SubjectPublicKeyInfo");
            }
            KeyFactorySpi keyInfoConverter = new KeyFactorySpi();
            publicKeyFromFactory = (CompositePublicKey)keyInfoConverter.generatePublic(keyInfo);
            if (publicKeyFromFactory == null) {
                throw new IllegalStateException("unable to create CompositePublicKey from SubjectPublicKeyInfo");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        this.keys = publicKeyFromFactory.getPublicKeys();
        this.algorithmIdentifier = publicKeyFromFactory.getAlgorithmIdentifier();
    }

    public List<PublicKey> getPublicKeys() {
        return this.keys;
    }

    @Override
    public String getAlgorithm() {
        return CompositeIndex.getAlgorithmName(this.algorithmIdentifier);
    }

    public ASN1ObjectIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i < this.keys.size()) {
            if (this.algorithmIdentifier.equals(MiscObjectIdentifiers.id_composite_key)) {
                v.add(SubjectPublicKeyInfo.getInstance(this.keys.get(i).getEncoded()));
            } else {
                SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance(this.keys.get(i).getEncoded());
                v.add(keyInfo.getPublicKeyData());
            }
            ++i;
        }
        try {
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(this.algorithmIdentifier), new DERSequence(v)).getEncoded("DER");
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode composite public key: " + e.getMessage());
        }
    }

    public int hashCode() {
        return this.keys.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CompositePublicKey) {
            boolean isEqual = true;
            CompositePublicKey comparedKey = (CompositePublicKey)o;
            if (!comparedKey.getAlgorithmIdentifier().equals(this.algorithmIdentifier) || !this.keys.equals(comparedKey.keys)) {
                isEqual = false;
            }
            return isEqual;
        }
        return false;
    }
}

