/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

class FalconCodec {
    final byte[] max_fg_bits;
    final byte[] max_FG_bits;
    final byte[] max_sig_bits;

    FalconCodec() {
        byte[] byArray = new byte[11];
        byArray[1] = 8;
        byArray[2] = 8;
        byArray[3] = 8;
        byArray[4] = 8;
        byArray[5] = 8;
        byArray[6] = 7;
        byArray[7] = 7;
        byArray[8] = 6;
        byArray[9] = 6;
        byArray[10] = 5;
        this.max_fg_bits = byArray;
        byte[] byArray2 = new byte[11];
        byArray2[1] = 8;
        byArray2[2] = 8;
        byArray2[3] = 8;
        byArray2[4] = 8;
        byArray2[5] = 8;
        byArray2[6] = 8;
        byArray2[7] = 8;
        byArray2[8] = 8;
        byArray2[9] = 8;
        byArray2[10] = 8;
        this.max_FG_bits = byArray2;
        byte[] byArray3 = new byte[11];
        byArray3[1] = 10;
        byArray3[2] = 11;
        byArray3[3] = 11;
        byArray3[4] = 12;
        byArray3[5] = 12;
        byArray3[6] = 12;
        byArray3[7] = 12;
        byArray3[8] = 12;
        byArray3[9] = 12;
        byArray3[10] = 12;
        this.max_sig_bits = byArray3;
    }

    int modq_encode(byte[] srcout, int out, int max_out_len, short[] srcx, int x, int logn) {
        int n = 1 << logn;
        int u = 0;
        while (u < n) {
            if ((srcx[x + u] & 0xFFFF) >= 12289) {
                return 0;
            }
            ++u;
        }
        int out_len = n * 14 + 7 >> 3;
        if (srcout == null) {
            return out_len;
        }
        if (out_len > max_out_len) {
            return 0;
        }
        int buf = out;
        int acc = 0;
        int acc_len = 0;
        u = 0;
        while (u < n) {
            acc = acc << 14 | srcx[x + u] & 0xFFFF;
            acc_len += 14;
            while (acc_len >= 8) {
                srcout[buf++] = (byte)(acc >> (acc_len -= 8));
            }
            ++u;
        }
        if (acc_len > 0) {
            srcout[buf] = (byte)(acc << 8 - acc_len);
        }
        return out_len;
    }

    int modq_decode(short[] srcx, int x, int logn, byte[] srcin, int in, int max_in_len) {
        int n = 1 << logn;
        int in_len = n * 14 + 7 >> 3;
        if (in_len > max_in_len) {
            return 0;
        }
        int buf = in;
        int acc = 0;
        int acc_len = 0;
        int u = 0;
        while (u < n) {
            acc = acc << 8 | srcin[buf++] & 0xFF;
            if ((acc_len += 8) < 14) continue;
            int w = acc >>> (acc_len -= 14) & 0x3FFF;
            if (w >= 12289) {
                return 0;
            }
            srcx[x + u] = (short)w;
            ++u;
        }
        if ((acc & (1 << acc_len) - 1) != 0) {
            return 0;
        }
        return in_len;
    }

    int trim_i16_encode(byte[] srcout, int out, int max_out_len, short[] srcx, int x, int logn, int bits) {
        int n = 1 << logn;
        int maxv = (1 << bits - 1) - 1;
        int minv = -maxv;
        int u = 0;
        while (u < n) {
            if (srcx[x + u] < minv || srcx[x + u] > maxv) {
                return 0;
            }
            ++u;
        }
        int out_len = n * bits + 7 >> 3;
        if (srcout == null) {
            return out_len;
        }
        if (out_len > max_out_len) {
            return 0;
        }
        int buf = out;
        int acc = 0;
        int acc_len = 0;
        int mask = (1 << bits) - 1;
        u = 0;
        while (u < n) {
            acc = acc << bits | srcx[x + u] & 0xFFF & mask;
            acc_len += bits;
            while (acc_len >= 8) {
                srcout[buf++] = (byte)(acc >> (acc_len -= 8));
            }
            ++u;
        }
        if (acc_len > 0) {
            srcout[buf++] = (byte)(acc << 8 - acc_len);
        }
        return out_len;
    }

    int trim_i16_decode(short[] srcx, int x, int logn, int bits, byte[] srcin, int in, int max_in_len) {
        int n = 1 << logn;
        int in_len = n * bits + 7 >> 3;
        if (in_len > max_in_len) {
            return 0;
        }
        int buf = in;
        int u = 0;
        int acc = 0;
        int acc_len = 0;
        int mask1 = (1 << bits) - 1;
        int mask2 = 1 << bits - 1;
        while (u < n) {
            acc = acc << 8 | srcin[buf++] & 0xFF;
            acc_len += 8;
            while (acc_len >= bits && u < n) {
                int w = acc >>> (acc_len -= bits) & mask1;
                if ((w |= -(w & mask2)) == -mask2) {
                    return 0;
                }
                w |= -(w & mask2);
                srcx[x + u] = (short)w;
                ++u;
            }
        }
        if ((acc & (1 << acc_len) - 1) != 0) {
            return 0;
        }
        return in_len;
    }

    int trim_i8_encode(byte[] srcout, int out, int max_out_len, byte[] srcx, int x, int logn, int bits) {
        int n = 1 << logn;
        int maxv = (1 << bits - 1) - 1;
        int minv = -maxv;
        int u = 0;
        while (u < n) {
            if (srcx[x + u] < minv || srcx[x + u] > maxv) {
                return 0;
            }
            ++u;
        }
        int out_len = n * bits + 7 >> 3;
        if (srcout == null) {
            return out_len;
        }
        if (out_len > max_out_len) {
            return 0;
        }
        int buf = out;
        int acc = 0;
        int acc_len = 0;
        int mask = (1 << bits) - 1;
        u = 0;
        while (u < n) {
            acc = acc << bits | srcx[x + u] & 0xFFFF & mask;
            acc_len += bits;
            while (acc_len >= 8) {
                srcout[buf++] = (byte)(acc >>> (acc_len -= 8));
            }
            ++u;
        }
        if (acc_len > 0) {
            srcout[buf++] = (byte)(acc << 8 - acc_len);
        }
        return out_len;
    }

    int trim_i8_decode(byte[] srcx, int x, int logn, int bits, byte[] srcin, int in, int max_in_len) {
        int n = 1 << logn;
        int in_len = n * bits + 7 >> 3;
        if (in_len > max_in_len) {
            return 0;
        }
        int buf = in;
        int u = 0;
        int acc = 0;
        int acc_len = 0;
        int mask1 = (1 << bits) - 1;
        int mask2 = 1 << bits - 1;
        while (u < n) {
            acc = acc << 8 | srcin[buf++] & 0xFF;
            acc_len += 8;
            while (acc_len >= bits && u < n) {
                int w = acc >>> (acc_len -= bits) & mask1;
                if ((w |= -(w & mask2)) == -mask2) {
                    return 0;
                }
                srcx[x + u] = (byte)w;
                ++u;
            }
        }
        if ((acc & (1 << acc_len) - 1) != 0) {
            return 0;
        }
        return in_len;
    }

    int comp_encode(byte[] srcout, int out, int max_out_len, short[] srcx, int x, int logn) {
        int n = 1 << logn;
        int buf = out;
        int u = 0;
        while (u < n) {
            if (srcx[x + u] < -2047 || srcx[x + u] > 2047) {
                return 0;
            }
            ++u;
        }
        int acc = 0;
        int acc_len = 0;
        int v = 0;
        u = 0;
        while (u < n) {
            acc <<= 1;
            int t = srcx[x + u];
            if (t < 0) {
                t = -t;
                acc |= 1;
            }
            int w = t;
            acc <<= 7;
            acc |= w & 0x7F;
            acc_len += 8;
            acc <<= (w >>>= 7) + 1;
            acc |= 1;
            acc_len += w + 1;
            while (acc_len >= 8) {
                acc_len -= 8;
                if (srcout != null) {
                    if (v >= max_out_len) {
                        return 0;
                    }
                    srcout[buf + v] = (byte)(acc >>> acc_len);
                }
                ++v;
            }
            ++u;
        }
        if (acc_len > 0) {
            if (srcout != null) {
                if (v >= max_out_len) {
                    return 0;
                }
                srcout[buf + v] = (byte)(acc << 8 - acc_len);
            }
            ++v;
        }
        return v;
    }

    int comp_decode(short[] srcx, int x, int logn, byte[] srcin, int in, int max_in_len) {
        int n = 1 << logn;
        int buf = in;
        int acc = 0;
        int acc_len = 0;
        int v = 0;
        int u = 0;
        while (u < n) {
            int m;
            int s;
            block7: {
                if (v >= max_in_len) {
                    return 0;
                }
                acc = acc << 8 | srcin[buf + v] & 0xFF;
                ++v;
                int b = acc >>> acc_len;
                s = b & 0x80;
                m = b & 0x7F;
                do {
                    if (acc_len == 0) {
                        if (v >= max_in_len) {
                            return 0;
                        }
                        acc = acc << 8 | srcin[buf + v] & 0xFF;
                        ++v;
                        acc_len = 8;
                    }
                    if ((acc >>> --acc_len & 1) != 0) break block7;
                } while ((m += 128) <= 2047);
                return 0;
            }
            if (s != 0 && m == 0) {
                return 0;
            }
            srcx[x + u] = (short)(s != 0 ? -m : m);
            ++u;
        }
        if ((acc & (1 << acc_len) - 1) != 0) {
            return 0;
        }
        return v;
    }
}

